/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsBusinessTransferHisDTO;
import com.els.modules.demand.api.dto.RequestMatchInfomationDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.mapper.PurchaseRequestItemMapper;
import com.els.modules.demand.rpc.ElsBusinessTransferHisLocalRpcService;
import com.els.modules.demand.rpc.ElsTacticsLocalRpcService;
import com.els.modules.demand.rpc.InquiryInvokeOtherService;
import com.els.modules.demand.rpc.InquiryInvokeSubaccountRpcService;
import com.els.modules.demand.rpc.service.PurchaseRequestItemSelfService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeOrderRpcService;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.enumerate.OrderItemSendStatusEnum;
import com.els.modules.order.api.enumerate.OrderItemStatusEnum;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.modules.tactics.api.dto.ElsTacticsHeadDTO;
import com.els.modules.tactics.api.dto.ElsTacticsItemDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRequestItemServiceImpl
extends BaseServiceImpl<PurchaseRequestItemMapper, PurchaseRequestItem>
implements PurchaseRequestItemService {
    @Resource
    private PurchaseRequestItemMapper purchaseRequestItemMapper;
    @Resource
    private ElsBusinessTransferHisLocalRpcService elsBusinessTransferHisLocalRpcService;
    @Resource
    private ElsTacticsLocalRpcService elsTacticsLocalRpcService;
    @Resource
    private InquiryInvokeSubaccountRpcService inquiryInvokeSubaccountRpcService;
    @Resource
    private InquiryInvokeOtherService inquiryInvokeOtherService;
    @Resource
    private InquiryInvokeOrderRpcService inquiryInvokeOrderRpcService;
    @Resource
    private PurchaseRequestItemSelfService purchaseRequestItemSelfService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadRpcService purchaseMaterialHeadRpcService;

    @Override
    public List<PurchaseRequestItem> selectByMainId(String mainId) {
        return this.purchaseRequestItemMapper.selectByMainId(mainId);
    }

    @Override
    public void toDemandPool(PurchaseRequestHeadVO purchaseRequestHeadPage) {
        List<ElsTacticsHeadDTO> list = this.elsTacticsLocalRpcService.getByBusinessType(purchaseRequestHeadPage.getElsAccount(), "demandPool");
        if (!CollectionUtils.isEmpty(list)) {
            for (ElsTacticsHeadDTO elsTacticsHead : list) {
                List<ElsTacticsItemDTO> elsTacticsItems = this.elsTacticsLocalRpcService.listMainId(elsTacticsHead.getId());
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.isNull(PurchaseRequestItem::getTacticsObject);
                updateWrapper.eq(PurchaseRequestItem::getRequestNumber, (Object)purchaseRequestHeadPage.getRequestNumber());
                updateWrapper.in(PurchaseRequestItem::getItemStatus, new Object[]{PurchaseRequestStatusItemEnum.APPROVED.getValue(), PurchaseRequestStatusItemEnum.SEND_BACK.getValue()});
                updateWrapper.eq(BaseEntity::getElsAccount, (Object)purchaseRequestHeadPage.getElsAccount());
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, (Object)elsTacticsHead.getTacticsObject());
                if ("sumit".equals(elsTacticsHead.getTacticsObject())) {
                    LoginUser loginUser = SysUtil.getLoginUser();
                    updateWrapper.set(PurchaseRequestItem::getTacticsEntity, (Object)(loginUser.getSubAccount() + "_" + loginUser.getRealname()));
                } else {
                    updateWrapper.set(PurchaseRequestItem::getTacticsEntity, (Object)elsTacticsHead.getTacticsEntity());
                }
                if (!CollectionUtils.isEmpty(elsTacticsItems)) {
                    String sql = "SELECT a.id FROM ( SELECT id FROM purchase_request_item WHERE 1 = 1 ";
                    for (ElsTacticsItemDTO elsTacticsItem : elsTacticsItems) {
                        String leftBracket = elsTacticsItem.getLeftBracket() == null ? "" : elsTacticsItem.getLeftBracket();
                        String rightBracket = elsTacticsItem.getRightBracket() == null ? "" : elsTacticsItem.getRightBracket();
                        sql = sql + elsTacticsItem.getConnector() + " " + leftBracket + elsTacticsItem.getPropertyCode() + elsTacticsItem.getLogic() + " '" + elsTacticsItem.getPropertyValue() + "' " + rightBracket;
                    }
                    sql = sql + ")a";
                    updateWrapper.inSql(BaseEntity::getId, sql);
                }
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                this.update((Wrapper)updateWrapper);
            }
        }
    }

    @Override
    public void updateStatus(List<PurchaseRequestItem> purchaseRequestItemList, String status) {
        List courseIds = purchaseRequestItemList.parallelStream().map(map -> map.getRequestNumber() + "_" + map.getItemNumber()).collect(Collectors.toList());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().set(PurchaseRequestItem::getItemStatus, (Object)status);
        updateWrapper.in((Object)"concat(request_number,'_',item_number)", courseIds);
        updateWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @SrmTransaction
    public void updateItem(PurchaseRequestItem requestItem) {
        PurchaseRequestItem item = new PurchaseRequestItem();
        BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item));
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(StrUtil.isNotBlank((CharSequence)requestItem.getTacticsEntity()), PurchaseRequestItem::getTacticsEntity, (Object)requestItem.getTacticsEntity()).set(StrUtil.isNotBlank((CharSequence)requestItem.getTacticsObject()), PurchaseRequestItem::getTacticsObject, (Object)requestItem.getTacticsObject());
        wrapper.eq(BaseEntity::getId, (Object)requestItem.getId());
        ((PurchaseRequestItemMapper)this.baseMapper).update(null, (Wrapper)wrapper);
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsBusinessTransferHisDTO elsBusinessTransferHis = requestItem.getElsBusinessTransferHis();
        elsBusinessTransferHis.setTransferBy(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        elsBusinessTransferHis.setTransferTime(new Date());
        this.elsBusinessTransferHisLocalRpcService.add(requestItem.getElsBusinessTransferHis());
    }

    @Override
    @SrmTransaction
    public void returnItem(PurchaseRequestItem head) {
        this.updateStatus(Arrays.asList(head), PurchaseRequestStatusItemEnum.SEND_BACK.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsBusinessTransferHisDTO elsBusinessTransferHis = head.getElsBusinessTransferHis();
        elsBusinessTransferHis.setTransferBy(loginUser.getSubAccount() + "_" + loginUser.getRealname());
        elsBusinessTransferHis.setTransferTime(new Date());
        this.elsBusinessTransferHisLocalRpcService.add(head.getElsBusinessTransferHis());
    }

    @Override
    public boolean queryPermissionById(String id) {
        PurchaseRequestItem byId = (PurchaseRequestItem)((Object)this.getById((Serializable)((Object)id)));
        if (StringUtils.isEmpty((CharSequence)byId.getTacticsEntity())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VKHRvjMdsrSYM_727b0493", (String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u534f\u52a9\u8f6c\u529e\u6216\u9000\u56de"));
        }
        String tacticsObject = byId.getTacticsObject();
        if ("role".equals(tacticsObject)) {
            String tacticsEntity = byId.getTacticsEntity();
            if (tacticsEntity.contains("_")) {
                tacticsEntity = tacticsEntity.split("_")[0];
            }
            List<ElsSubAccountDTO> accountListByRolesCode = this.inquiryInvokeSubaccountRpcService.getAccountListByRolesCode(tacticsEntity);
            List subList = accountListByRolesCode.stream().map(item -> item.getSubAccount() + "_" + item.getRealname()).distinct().collect(Collectors.toList());
            String loginSubAndName = this.getLoginSubAndName();
            return subList.contains(loginSubAndName);
        }
        if ("group".equals(tacticsObject)) {
            return false;
        }
        if ("person".equals(tacticsObject)) {
            String loginSubAndName = this.getLoginSubAndName();
            return loginSubAndName.equals(byId.getTacticsEntity());
        }
        return false;
    }

    @Override
    @SrmTransaction
    public void returnSample(PurchaseRequestItem head) {
        this.updateStatus(Arrays.asList(head), PurchaseRequestStatusItemEnum.SEND_BACK.getValue());
        this.purchaseRequestItemSelfService.updateSampleItem(head.getSourceItemId());
    }

    @Override
    @SrmTransaction
    public void updateStatusById(List<String> idList, String status) {
        if (CollectionUtil.isNotEmpty(idList)) {
            ArrayList<PurchaseRequestItem> itemList = new ArrayList<PurchaseRequestItem>();
            for (String id : idList) {
                PurchaseRequestItem item = new PurchaseRequestItem();
                item.setId(id);
                item.setItemStatus(status);
                itemList.add(item);
            }
            this.updateBatchById(itemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String createOrder(PurchaseRequestHeadVO requestToOrderHeadVO) {
        ArrayList<RequestMatchInfomationDTO> requestMatchInfomationVOList = new ArrayList<RequestMatchInfomationDTO>();
        List<PurchaseRequestItem> requestItemList = requestToOrderHeadVO.getPurchaseRequestItemList();
        for (PurchaseRequestItem item : requestItemList) {
            RequestMatchInfomationDTO requestMatchInfomationVO = new RequestMatchInfomationDTO();
            BeanUtils.copyProperties((Object)((Object)item), (Object)requestMatchInfomationVO);
            requestMatchInfomationVO.setToElsAccount(item.getExpectSupplierEls());
            requestMatchInfomationVO.setSupplierName(item.getExpectSupplierName());
            requestMatchInfomationVO.setToOrderQuantity(item.getQuantity());
            requestMatchInfomationVO.setSourceType(OrderSourceTypeEnum.SAMPLE_APPLICATION.getValue());
            requestMatchInfomationVO.setRequestItemId(item.getId());
            requestMatchInfomationVO.setRequestItemNumber(item.getItemNumber());
            requestMatchInfomationVOList.add(requestMatchInfomationVO);
        }
        String msg = this.sampleToCreateOrder(requestToOrderHeadVO, requestMatchInfomationVOList);
        return msg;
    }

    public String sampleToCreateOrder(PurchaseRequestHeadVO requestToOrderHeadVO, List<RequestMatchInfomationDTO> requestMatchInfomationVOList) {
        String msg = null;
        ArrayList<PurchaseOrderHeadDTO> purchaseOrderHeadVOList = new ArrayList<PurchaseOrderHeadDTO>();
        Assert.notEmpty(requestMatchInfomationVOList, (String)I18nUtil.translate((String)"i18n_alert_TVsItjcxOLVW_b97d5a4c", (String)"\u9700\u6c42\u8f6c\u8ba2\u5355\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a!"));
        Map<String, List<RequestMatchInfomationDTO>> requestMatchInfomationToElsMap = requestMatchInfomationVOList.stream().collect(Collectors.groupingBy(RequestMatchInfomationDTO::getToElsAccount));
        Set<String> keys = requestMatchInfomationToElsMap.keySet();
        for (String key : keys) {
            List<RequestMatchInfomationDTO> RequestMatchInfomationDTOS = requestMatchInfomationToElsMap.get(key);
            HashMap orgRequestInfoMap = new HashMap();
            for (RequestMatchInfomationDTO item2 : RequestMatchInfomationDTOS) {
                List<RequestMatchInfomationDTO> RequestMatchInfomationDTOs;
                String itemKey = item2.getPurchaseOrg() + "_" + item2.getPurchaseGroup() + "_" + item2.getCompany() + "_" + item2.getCurrency();
                if (orgRequestInfoMap.containsKey(itemKey)) {
                    RequestMatchInfomationDTOs = (List)orgRequestInfoMap.get(itemKey);
                    RequestMatchInfomationDTOs.add(item2);
                    continue;
                }
                RequestMatchInfomationDTOs = new ArrayList();
                RequestMatchInfomationDTOs.add(item2);
                orgRequestInfoMap.put(itemKey, RequestMatchInfomationDTOs);
            }
            Set groupAndOrgkeys = orgRequestInfoMap.keySet();
            ArrayList<PurchaseRequestItem> requestItemList = new ArrayList<PurchaseRequestItem>();
            for (String key1 : groupAndOrgkeys) {
                List RequestMatchInfomationDTOS1 = (List)orgRequestInfoMap.get(key1);
                PurchaseOrderHeadDTO purchaseOrderHead = new PurchaseOrderHeadDTO();
                ArrayList<PurchaseOrderItemDTO> purchaseOrderItemList = new ArrayList<PurchaseOrderItemDTO>();
                ArrayList purchaseOrderDeliveryPlanList = new ArrayList();
                int i = 1;
                for (RequestMatchInfomationDTO RequestMatchInfomationDTO2 : RequestMatchInfomationDTOS1) {
                    PurchaseOrderItemDTO purchaseOrderItem = new PurchaseOrderItemDTO();
                    PurchaseRequestItem requestItem = new PurchaseRequestItem();
                    purchaseOrderItem.setItemNumber("" + i++);
                    purchaseOrderItem.setMaterialNumber(RequestMatchInfomationDTO2.getMaterialNumber());
                    purchaseOrderItem.setMaterialDesc(RequestMatchInfomationDTO2.getMaterialDesc());
                    purchaseOrderItem.setQuantity(RequestMatchInfomationDTO2.getToOrderQuantity());
                    purchaseOrderItem.setPrice(RequestMatchInfomationDTO2.getPrice());
                    purchaseOrderItem.setNetPrice(RequestMatchInfomationDTO2.getNetPirce());
                    purchaseOrderItem.setTaxRate(RequestMatchInfomationDTO2.getTaxRate());
                    purchaseOrderItem.setTaxCode(RequestMatchInfomationDTO2.getTaxCode());
                    purchaseOrderItem.setRequireDate(RequestMatchInfomationDTO2.getRequireDate());
                    purchaseOrderItem.setCurrency(RequestMatchInfomationDTO2.getCurrency());
                    purchaseOrderItem.setReceiveQuantity(BigDecimal.ZERO);
                    purchaseOrderItem.setOnWayQuantity(BigDecimal.ZERO);
                    purchaseOrderItem.setDeliveryQuantity(BigDecimal.ZERO);
                    purchaseOrderItem.setClose(Integer.valueOf(Integer.parseInt("0")));
                    purchaseOrderItem.setFreeze(Integer.valueOf(Integer.parseInt("0")));
                    purchaseOrderItem.setItemStatus(OrderItemStatusEnum.UN_CONFIRM.getValue());
                    purchaseOrderItem.setSendStatus(OrderItemSendStatusEnum.NO_PUBLISH.getValue());
                    purchaseOrderItem.setJit(RequestMatchInfomationDTO2.getJit());
                    purchaseOrderItem.setDeleteOrder(Integer.valueOf(Integer.parseInt("0")));
                    purchaseOrderItem.setFactory(RequestMatchInfomationDTO2.getFactory());
                    purchaseOrderItem.setReturned(Integer.valueOf(Integer.parseInt("0")));
                    purchaseOrderItem.setStorageLocation(RequestMatchInfomationDTO2.getStorageLocation());
                    purchaseOrderItem.setSourceType(OrderSourceTypeEnum.SAMPLE_APPLICATION.getValue());
                    purchaseOrderItem.setSourceNumber(RequestMatchInfomationDTO2.getRequestNumber());
                    purchaseOrderItem.setSourceItemNumber(RequestMatchInfomationDTO2.getRequestItemNumber());
                    purchaseOrderItem.setSourceId(RequestMatchInfomationDTO2.getRequestItemId());
                    purchaseOrderItem.setPurchaseUnit(RequestMatchInfomationDTO2.getPurchaseUnit());
                    if (StringUtils.isNotEmpty((CharSequence)purchaseOrderItem.getMaterialNumber())) {
                        purchaseOrderItem.setMaterialGroup(RequestMatchInfomationDTO2.getMaterialGroup());
                        purchaseOrderItem.setJit("4");
                    }
                    requestItem.setRequestNumber(RequestMatchInfomationDTO2.getRequestNumber());
                    requestItem.setItemNumber(RequestMatchInfomationDTO2.getRequestItemNumber());
                    requestItem.setId(RequestMatchInfomationDTO2.getRequestItemId());
                    requestItemList.add(requestItem);
                    purchaseOrderItemList.add(purchaseOrderItem);
                }
                purchaseOrderHead.setSupplierName(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getSupplierName());
                purchaseOrderHead.setToElsAccount(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getToElsAccount());
                purchaseOrderHead.setPurchaseGroup(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getPurchaseGroup());
                purchaseOrderHead.setPurchaseOrg(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getPurchaseOrg());
                purchaseOrderHead.setCompany(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getCompany());
                purchaseOrderHead.setCurrency(((RequestMatchInfomationDTO)RequestMatchInfomationDTOS1.get(0)).getCurrency());
                purchaseOrderHead.setTemplateName(requestToOrderHeadVO.getTemplateName());
                purchaseOrderHead.setTemplateNumber(requestToOrderHeadVO.getTemplateNumber());
                purchaseOrderHead.setTemplateVersion(requestToOrderHeadVO.getTemplateVersion());
                purchaseOrderHead.setTemplateAccount(requestToOrderHeadVO.getTemplateAccount());
                purchaseOrderHead.setSourceType(OrderSourceTypeEnum.SAMPLE_APPLICATION.getValue());
                purchaseOrderHead.setBusAccount(TenantContext.getTenant());
                purchaseOrderHead.setPurchaseOrderItemList(purchaseOrderItemList);
                purchaseOrderHeadVOList.add(purchaseOrderHead);
            }
            msg = this.inquiryInvokeOrderRpcService.requestToCreateOrder(purchaseOrderHeadVOList);
            PurchaseRequestHeadService requestHeadService = (PurchaseRequestHeadService)SpringContextUtils.getBean(PurchaseRequestHeadService.class);
            requestHeadService.syncRequestToOrderQuantity(requestItemList);
            requestHeadService.syncRequestatus(requestItemList);
            List<String> sampleItemList = requestToOrderHeadVO.getPurchaseRequestItemList().stream().filter(item -> "sample".equals(item.getSourceType())).map(PurchaseRequestItem::getSourceItemId).collect(Collectors.toList());
            if (sampleItemList.size() <= 0) continue;
            this.inquiryInvokeOtherService.updateOrderStatusToSample(sampleItemList);
        }
        return msg;
    }

    @Override
    public void replenishMaterial(String id, String materialNumber, String materialDesc, String materialGroup, String materialSpec) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(PurchaseRequestItem::getMaterialNumber, (Object)materialNumber)).set(PurchaseRequestItem::getMaterialDesc, (Object)materialDesc)).set(PurchaseRequestItem::getMaterialGroup, (Object)materialGroup)).set(PurchaseRequestItem::getMaterialSpec, (Object)materialSpec)).eq(BaseEntity::getId, (Object)id));
    }

    @Override
    public void sendPoolMsg(List<PurchaseRequestHead> headList, List<PurchaseRequestItem> purchaseRequestItemList, String opt) {
        if ("transfer".equals(opt)) {
            purchaseRequestItemList.forEach(item -> {
                String urlParam = "id=" + item.getId();
                super.sendMsg(item.getElsAccount(), item.getElsAccount(), item.getTacticsEntity(), (Object)item, urlParam, "demandPool", opt);
            });
        } else if ("refund".equals(opt)) {
            for (PurchaseRequestHead purchaseRequestHead : headList) {
                String urlParam = "id=" + purchaseRequestHead.getId();
                super.sendMsg(purchaseRequestHead.getElsAccount(), purchaseRequestHead.getElsAccount(), purchaseRequestHead.getPurchasePrincipal(), (Object)purchaseRequestHead, urlParam, "demandPool", opt);
            }
        }
    }
}

