/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.forecast.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.modules.forecast.entity.PurchaseForecastHead;
import com.els.modules.forecast.entity.PurchaseForecastMonthItem;
import com.els.modules.forecast.entity.PurchaseForecastWeekItem;
import com.els.modules.forecast.rpc.service.ForecastInvokeOrderRpcService;
import com.els.modules.forecast.service.PurchaseForecastHeadService;
import com.els.modules.forecast.service.PurchaseForecastMonthItemService;
import com.els.modules.forecast.service.PurchaseForecastWeekItemService;
import com.els.modules.forecast.utils.ForecastUtil;
import com.els.modules.forecast.vo.PurchaseForecastHeadVO;
import com.els.modules.forecast.vo.ReportVO;
import com.els.modules.order.api.dto.ForecastReportDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/forecast/purchaseForecastHead"})
@Api(tags={"\u91c7\u8d2d\u9700\u6c42\u9884\u6d4b\u5934"})
public class PurchaseForecastHeadController
extends BaseController<PurchaseForecastHead, PurchaseForecastHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseForecastHeadController.class);
    @Autowired
    private PurchaseForecastMonthItemService purchaseForecastMonthItemService;
    @Autowired
    private PurchaseForecastWeekItemService purchaseForecastWeekItemService;
    @Resource
    private ForecastInvokeOrderRpcService forecastInvokeOrderRpcService;
    @Autowired
    private DictAspect dictAspect;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseForecast")
    public Result<?> queryPageList(PurchaseForecastHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseForecastHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9700\u6c42\u9884\u6d4b\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"purchaseForecast#purchaseForecastHead:publish"})
    @PermissionDataOpt(businessType="purchaseForecast", beanClass=PurchaseForecastHeadService.class)
    public Result<?> publish(@RequestBody PurchaseForecastHeadVO headVO) {
        PurchaseForecastHead head = new PurchaseForecastHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        ((PurchaseForecastHeadService)this.service).publish(head, headVO.getMonthItemList(), headVO.getWeekItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9700\u6c42\u9884\u6d4b\u5934", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publishById"})
    @RequiresPermissions(value={"purchaseForecast#purchaseForecastHead:publish"})
    @PermissionDataOpt(businessType="purchaseForecast", beanClass=PurchaseForecastHeadService.class)
    public Result<?> publishById(@RequestParam(name="id") String id) {
        PurchaseForecastHead head = (PurchaseForecastHead)((Object)((PurchaseForecastHeadService)this.service).getById((Serializable)((Object)id)));
        List<PurchaseForecastMonthItem> monthItemList = this.purchaseForecastMonthItemService.selectByMainId(id);
        List<PurchaseForecastWeekItem> weekItemList = this.purchaseForecastWeekItemService.selectByMainId(id);
        ((PurchaseForecastHeadService)this.service).publish(head, monthItemList, weekItemList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u9700\u6c42\u9884\u6d4b\u5934", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"purchaseForecast#purchaseForecastHead:cancel"})
    @PermissionDataOpt(businessType="purchaseForecast", beanClass=PurchaseForecastHeadService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        ((PurchaseForecastHeadService)this.service).cancel(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseForecastHead head = (PurchaseForecastHead)((Object)((PurchaseForecastHeadService)this.service).getById((Serializable)((Object)id)));
        PurchaseForecastHeadVO headVO = new PurchaseForecastHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        List<PurchaseForecastMonthItem> monthItemList = this.purchaseForecastMonthItemService.selectByMainId(id);
        headVO.setMonthItemList(monthItemList);
        List<PurchaseForecastWeekItem> weekItemList = this.purchaseForecastWeekItemService.selectByMainId(id);
        headVO.setWeekItemList(weekItemList);
        Result result = Result.ok((Object)((Object)headVO));
        this.dictAspect.parseDictText((Object)result);
        JSONObject object = (JSONObject)result.getResult();
        ForecastUtil.assemblyResultData(object);
        return Result.ok((Object)object);
    }

    @ApiOperation(value="\u62a5\u8868\u67e5\u8be2", notes="\u62a5\u8868\u67e5\u8be2")
    @PostMapping(value={"/queryReport"})
    public Result<?> queryReport(@RequestBody ReportVO vo) {
        Assert.notNull((Object)vo.getBeginTime(), (String)I18nUtil.translate((String)"i18n_alert_vKKIxOLV_f095ba59", (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)vo.getEndTime(), (String)I18nUtil.translate((String)"i18n_alert_yWKIxOLV_19b945ba", (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)vo.getBeginYear(), (String)I18nUtil.translate((String)"i18n_alert_vKMzxOLV_38cd6d24", (String)"\u5f00\u59cb\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)vo.getBeginWeek(), (String)I18nUtil.translate((String)"i18n_alert_vKsxOLV_748d108d", (String)"\u5f00\u59cb\u5468\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)vo.getEndYear(), (String)I18nUtil.translate((String)"i18n_alert_yWMzxOLV_61f0f885", (String)"\u7ed3\u675f\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)vo.getEndWeek(), (String)I18nUtil.translate((String)"i18n_alert_yWsxOV_42eff76e", (String)"\u7ed3\u675f\u5468\u4e0d\u80fd\u7a7a"));
        Assert.hasText((String)vo.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLAoxOLV_f1cdd68b", (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        List<PurchaseForecastHead> dbHeadList = ((PurchaseForecastHeadService)this.service).getReportList(vo);
        Assert.notEmpty(dbHeadList, (String)I18nUtil.translate((String)"i18n_alert_vKKIuyWKIMICBjhxUit_f5c2d91a", (String)"\u5f00\u59cb\u65f6\u95f4\u5230\u7ed3\u675f\u65f6\u95f4\u533a\u95f4\u5185\u6ca1\u6709\u53d1\u5e03\u9884\u6d4b\u5355"));
        Map<String, String> headMap = dbHeadList.stream().collect(Collectors.toMap(BaseEntity::getId, head -> DateUtil.format((Date)head.getPublishTime(), (String)"yyyy-MM-dd")));
        List<String> headIdList = dbHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        JSONObject result = new JSONObject();
        JSONArray require = this.purchaseForecastWeekItemService.getReportData(headIdList, headMap, vo);
        result.put("require", (Object)require);
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        LocalDate now = LocalDate.now();
        LocalDate beginDate = now.withYear(vo.getBeginYear()).with(weekFields.weekOfYear(), vo.getBeginWeek().intValue()).with(weekFields.dayOfWeek(), 1L);
        LocalDate endDate = now.withYear(vo.getEndYear()).with(weekFields.weekOfYear(), vo.getEndWeek().intValue()).with(weekFields.dayOfWeek(), 7L);
        ForecastReportDTO dto = new ForecastReportDTO(vo.getFactory(), vo.getMaterialNumber(), vo.getToElsAccount(), this.localDateToDate(beginDate), this.localDateToDate(endDate));
        BigDecimal quantity = this.forecastInvokeOrderRpcService.getOrderQuantity(dto);
        result.put("orderQuantity", (Object)quantity);
        return Result.ok((Object)result);
    }

    private Date localDateToDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"purchaseForecast#purchaseForecastHead:getDataByErp"})
    public Result<?> getDataByErp() {
        ((PurchaseForecastHeadService)this.service).getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"purchaseForecast#purchaseForecastHead:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        ((PurchaseForecastHeadService)this.service).pushDataToErp(ids);
        return Result.ok();
    }
}

