/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.attachment.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPriceRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationPrinciples;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationRegulationInfo;
import com.els.modules.tender.attachment.entity.PurchaseTenderPriceOpeningsTemplate;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentHead;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.enumerate.TenderAttachmentFileStateEnum;
import com.els.modules.tender.attachment.enumerate.TenderAttachmentStateEnum;
import com.els.modules.tender.attachment.enumerate.TenderPricePointsCalFormualEnum;
import com.els.modules.tender.attachment.mapper.PurchaseTenderProjectAttachmentHeadMapper;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterFormatGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPriceRegulationInfoService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationPrinciplesService;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationRegulationInfoService;
import com.els.modules.tender.attachment.service.PurchaseTenderPriceOpeningsTemplateService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderEvaluationGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadVO;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderProjectAttachmentHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectAttachmentHeadMapper, PurchaseTenderProjectAttachmentHead>
implements PurchaseTenderProjectAttachmentHeadService {
    @Autowired
    private PurchaseTenderProjectAttachmentInfoService purchaseTenderProjectAttachmentInfoServiceImpl;
    @Autowired
    private PurchaseTenderBidLetterFormatGroupService purchaseTenderBidLetterFormatGroupServiceImpl;
    @Autowired
    private PurchaseTenderBidLetterService purchaseTenderBidLetterServiceImpl;
    @Autowired
    private PurchaseTenderPriceOpeningsTemplateService purchaseTenderPriceOpeningsTemplateServiceImpl;
    @Autowired
    private PurchaseTenderEvaluationPrinciplesService purchaseTenderEvaluationPrinciplesServiceImpl;
    @Autowired
    private PurchaseTenderEvaluationGroupService purchaseTenderEvaluationGroupServiceImpl;
    @Autowired
    private PurchaseTenderEvaluationRegulationInfoService purchaseTenderEvaluationRegulationInfoServiceImpl;
    @Autowired
    private PurchaseTenderEvaluationPriceRegulationInfoService purchaseTenderEvaluationPriceRegulationInfoServiceImpl;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public PurchaseTenderProjectAttachmentHeadVO queryAll(String subpackageId) {
        PurchaseTenderProjectAttachmentHeadVO headVo = new PurchaseTenderProjectAttachmentHeadVO();
        PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead = this.getPurchaseTenderProjectAttachmentHandBySubpackageId(subpackageId);
        if (null == purchaseTenderProjectAttachmentHead) {
            return headVo;
        }
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectAttachmentHead), (Object)((Object)headVo));
        List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfoList = this.purchaseTenderProjectAttachmentInfoServiceImpl.queryTenderProjectAttachmentInfo(purchaseTenderProjectAttachmentHead);
        headVo.setPurchaseTenderProjectAttachmentInfoList(purchaseTenderProjectAttachmentInfoList);
        PurchaseTenderBidLetterFormatGroupVO purchaseTenderBidLetterFormatGroupVo = this.purchaseTenderBidLetterFormatGroupServiceImpl.queryPurchaseTenderBidLetterFormatGroupVoInfo(purchaseTenderProjectAttachmentHead);
        headVo.setTenderBidLetterFormatGroupVo(purchaseTenderBidLetterFormatGroupVo);
        PurchaseTenderEvaluationPrinciples purchaseTenderEvaluationPrinciples = this.purchaseTenderEvaluationPrinciplesServiceImpl.queryPurchaseTenderEvaluationPrinciples(purchaseTenderProjectAttachmentHead);
        headVo.setPurchaseTenderEvaluationPrinciples(purchaseTenderEvaluationPrinciples);
        List<PurchaseTenderEvaluationGroupVO> purchaseTenderEvaluationInfoVoList = this.purchaseTenderEvaluationGroupServiceImpl.queryPurchaseTenderEvaluationInfoVo(purchaseTenderProjectAttachmentHead);
        headVo.setTenderEvaluationInfoVoList(purchaseTenderEvaluationInfoVoList);
        purchaseTenderEvaluationInfoVoList.stream().forEach(evaluationGroupVO -> {
            PurchaseTenderEvaluationPriceRegulationInfo priceRegulationInfo = evaluationGroupVO.getTenderEvaluationTemplatePriceRegulationInfo();
            if (priceRegulationInfo != null) {
                List<PurchaseTenderBidLetterVO> tenderBidTetterVoList;
                String tenderBidLetterId = priceRegulationInfo.getTenderBidLetterId();
                String tenderBidLetterFieldName = priceRegulationInfo.getQuoteColumnName();
                if (null != purchaseTenderBidLetterFormatGroupVo && CollectionUtil.isNotEmpty(tenderBidTetterVoList = purchaseTenderBidLetterFormatGroupVo.getTenderBidTetterVoList())) {
                    for (PurchaseTenderBidLetterVO tenderBidLetterVO : tenderBidTetterVoList) {
                        if (null == tenderBidLetterId || !tenderBidLetterId.equals(tenderBidLetterVO.getId())) continue;
                        priceRegulationInfo.setBidLetterName(tenderBidLetterVO.getName());
                        String model = tenderBidLetterVO.getCustomizeFieldModel();
                        JSONArray jsonArray = JSONArray.parseArray((String)model);
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            if (!jsonObject.containsValue((Object)tenderBidLetterFieldName)) continue;
                            String title = jsonObject.get((Object)"title").toString();
                            priceRegulationInfo.setBidLetterFieldName(title);
                        }
                    }
                }
            }
        });
        return headVo;
    }

    @Override
    public PurchaseTenderProjectAttachmentHead getPurchaseTenderProjectAttachmentHandBySubpackageId(String subpackageId) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        Assert.hasText((String)checkType, (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<PurchaseTenderProjectAttachmentHead> attachmentHeadList = ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, checkType);
        if (CollectionUtil.isEmpty(attachmentHeadList)) {
            return null;
        }
        return attachmentHeadList.get(0);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void insertMain(PurchaseTenderProjectAttachmentHeadVO headVO) {
        PurchaseTenderProjectAttachmentHead attachmentHead = new PurchaseTenderProjectAttachmentHead();
        headVO.setDeleted(CommonConstant.DEL_FLAG_0);
        headVO.setStatus(TenderAttachmentStateEnum.NEW.getValue());
        headVO.setAttachmentNumber(this.invokeBaseRpcService.getNextCode("tenderAttachmentNumber", (Object)attachmentHead));
        headVO.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
        headVO.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)attachmentHead));
        ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).insert((Object)attachmentHead);
        headVO.setId(attachmentHead.getId());
        this.insertData(attachmentHead, headVO);
    }

    public void insertData(PurchaseTenderProjectAttachmentHead attachmentHead, PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectAttachmentHeadVo) {
        this.purchaseTenderProjectAttachmentInfoServiceImpl.addTenderProjectAttachmentInfo(attachmentHead, purchaseTenderProjectAttachmentHeadVo.getPurchaseTenderProjectAttachmentInfoList());
        this.purchaseTenderBidLetterFormatGroupServiceImpl.addTenderBidLetter(attachmentHead, purchaseTenderProjectAttachmentHeadVo.getTenderBidLetterFormatGroupVo());
        this.purchaseTenderEvaluationPrinciplesServiceImpl.addTenderEvaluationPrinciples(attachmentHead, purchaseTenderProjectAttachmentHeadVo.getPurchaseTenderEvaluationPrinciples());
        this.purchaseTenderEvaluationGroupServiceImpl.addTenderEvaluationInfo(attachmentHead, purchaseTenderProjectAttachmentHeadVo.getTenderEvaluationInfoVoList());
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(attachmentHead.getCheckType());
        String subPackageStatus = hasPreTrial ? TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_EDIT.getValue() + "" : TenderProjectSubpackageStatusEnum.ATTACHMENT_EDIT.getValue() + "";
        this.updateTenderProjectSubpackageInfo(attachmentHead, subPackageStatus);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectAttachmentHeadVo) {
        PurchaseTenderProjectAttachmentHead attachmentHead = new PurchaseTenderProjectAttachmentHead();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectAttachmentHeadVo), (Object)((Object)attachmentHead));
        attachmentHead.setStatus(TenderAttachmentStateEnum.NEW.getValue());
        ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).updateById((Object)attachmentHead);
        this.deleteAll(purchaseTenderProjectAttachmentHeadVo);
        this.insertData(attachmentHead, purchaseTenderProjectAttachmentHeadVo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteAll(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectAttachmentHeadVo) {
        this.purchaseTenderProjectAttachmentInfoServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.purchaseTenderBidLetterFormatGroupServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.purchaseTenderBidLetterServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.purchaseTenderPriceOpeningsTemplateServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.purchaseTenderEvaluationPrinciplesServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.purchaseTenderEvaluationGroupServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.purchaseTenderEvaluationRegulationInfoServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
        this.purchaseTenderEvaluationPriceRegulationInfoServiceImpl.deleteByMainId(purchaseTenderProjectAttachmentHeadVo.getId());
    }

    @Override
    public List<PurchaseTenderBidLetter> queryTenderBidLetterList(String subpackageId) {
        List<PurchaseTenderBidLetter> bidLetterList = this.purchaseTenderBidLetterServiceImpl.queryPurchaseTenderBidLetter(subpackageId);
        return bidLetterList;
    }

    @Override
    public List<CustomColumnModel> queryPriceColumn(String bidLetterId) {
        List<String> bidLetterIdList = Arrays.asList(bidLetterId);
        List<PurchaseTenderPriceOpeningsTemplate> priceOpeningsTemplates = this.purchaseTenderPriceOpeningsTemplateServiceImpl.selectByMainIds(bidLetterIdList);
        ArrayList<CustomColumnModel> tenderCustomColumnList = new ArrayList<CustomColumnModel>();
        for (PurchaseTenderPriceOpeningsTemplate priceOpening : priceOpeningsTemplates) {
            List categoryFieldList;
            String customizeFieldModel = priceOpening.getCustomizeFieldModel();
            List customColumnModel = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            if (customColumnModel.isEmpty() || !CollectionUtils.isNotEmpty(categoryFieldList = customColumnModel.stream().filter(column -> CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(column.getFieldCategory())).collect(Collectors.toList()))) continue;
            tenderCustomColumnList.addAll(categoryFieldList);
        }
        return tenderCustomColumnList;
    }

    @Override
    public PurchaseTenderProjectAttachmentHead queryById(String id) {
        return (PurchaseTenderProjectAttachmentHead)((Object)((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead = (PurchaseTenderProjectAttachmentHead)((Object)this.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTenderProjectAttachmentHead.setFlowId(outputParamVO.getProcessRootId());
        purchaseTenderProjectAttachmentHead.setWorkFlowType(outputParamVO.getBpmnType());
        String auditStatus = outputParamVO.getAuditStatus();
        String status = null;
        String subPackageStatus = null;
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(purchaseTenderProjectAttachmentHead.getCheckType());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            status = TenderAttachmentStateEnum.AUDIT_YES.getValue();
            subPackageStatus = hasPreTrial ? TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_FINISH.getValue() + "" : TenderProjectSubpackageStatusEnum.ATTACHMENT_FINISH.getValue() + "";
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            status = TenderAttachmentStateEnum.NEW.getValue();
            subPackageStatus = hasPreTrial ? TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_REJECT.getValue() + "" : TenderProjectSubpackageStatusEnum.ATTACHMENT_REJECT.getValue() + "";
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            status = TenderAttachmentStateEnum.NEW.getValue();
            subPackageStatus = hasPreTrial ? TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_EDIT.getValue() + "" : TenderProjectSubpackageStatusEnum.ATTACHMENT_EDIT.getValue() + "";
        } else {
            status = TenderAttachmentStateEnum.AUDIT.getValue();
            subPackageStatus = hasPreTrial ? TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_AUDIT.getValue() + "" : TenderProjectSubpackageStatusEnum.ATTACHMENT_AUDIT.getValue() + "";
        }
        purchaseTenderProjectAttachmentHead.setAuditStatus(auditStatus);
        purchaseTenderProjectAttachmentHead.setStatus(status);
        ((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).updateById((Object)purchaseTenderProjectAttachmentHead);
        this.updateTenderProjectSubpackageInfo(purchaseTenderProjectAttachmentHead, subPackageStatus);
    }

    private void updateTenderProjectSubpackageInfo(PurchaseTenderProjectAttachmentHead attachmentHead, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)attachmentHead).subpackageId(attachmentHead.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseTenderProjectAttachmentHeadVO tenderProjectAttachmentInfoVo) {
        Assert.hasText((String)tenderProjectAttachmentInfoVo.getId(), (String)I18nUtil.translate((String)"i18n_alert_VHjS_25c69f34", (String)"\u4fe1\u606f\u6709\u8bef"));
        PurchaseTenderProjectAttachmentHead purchaseTenderProjectAttachmentHead = (PurchaseTenderProjectAttachmentHead)((Object)((PurchaseTenderProjectAttachmentHeadMapper)this.baseMapper).selectById((Serializable)((Object)tenderProjectAttachmentInfoVo.getId())));
        PurchaseTenderProjectAttachmentHeadVO attachmentHeadVO = this.queryAll(purchaseTenderProjectAttachmentHead.getSubpackageId());
        this.checkAndSetParam(attachmentHeadVO);
        purchaseTenderProjectAttachmentHead.setStatus(TenderAttachmentStateEnum.AUDIT_YES.getValue());
        this.updateById((Object)purchaseTenderProjectAttachmentHead);
        List<PurchaseTenderProjectAttachmentInfo> tenderProjectAttachmentInfoList = attachmentHeadVO.getPurchaseTenderProjectAttachmentInfoList();
        List<PurchaseAttachmentDTO> purchaseAttachmentDTOList = this.convertData(purchaseTenderProjectAttachmentHead, tenderProjectAttachmentInfoList);
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOList, attachmentHeadVO.getId(), attachmentHeadVO.getSubpackageId(), attachmentHeadVO.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.PROJECT_ATTACHMENT_PREFIX.getValue());
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(purchaseTenderProjectAttachmentHead.getCheckType());
        String subpackageStatus = hasPreTrial ? TenderProjectSubpackageStatusEnum.PRE_ATTACHMENT_FINISH.getValue() + "" : TenderProjectSubpackageStatusEnum.ATTACHMENT_FINISH.getValue() + "";
        this.updateTenderProjectSubpackageInfo(purchaseTenderProjectAttachmentHead, subpackageStatus);
    }

    public void checkAndSetParam(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead) {
        Assert.hasText((String)purchaseTenderProjectHead.getTenderProjectId(), (String)I18nUtil.translate((String)"i18n_alert_dIAyxOLVW_a6e6f2bb", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)purchaseTenderProjectHead.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsAyxOLVW_ba7b51", (String)"\u5206\u5305\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.hasText((String)purchaseTenderProjectHead.getCheckType(), (String)I18nUtil.translate((String)"", (String)"\u5ba1\u67e5\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        this.checkAndSetParamAttachmentInfo(purchaseTenderProjectHead);
        HashMap<String, String> bidTeeterMap = new HashMap<String, String>();
        HashMap<String, String> bidTeeterMaterialsMap = new HashMap<String, String>();
        this.checkAndSetParamTenderBidTetter(purchaseTenderProjectHead, bidTeeterMap, bidTeeterMaterialsMap);
        PurchaseTenderEvaluationPrinciples tenderEvaluationPrinciples = purchaseTenderProjectHead.getPurchaseTenderEvaluationPrinciples();
        Assert.hasText((String)tenderEvaluationPrinciples.getReviewSummaryRules(), (String)I18nUtil.translate((String)"i18n_alert_UUMkLFxiTLVW_b674dec3", (String)"\u8bc4\u5ba1\u6c47\u603b\u89c4\u5219\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderEvaluationPrinciples.getSummaryCalType(), (String)I18nUtil.translate((String)"i18n_alert_MktdCKxiTLVW_5be8629d", (String)"\u6c47\u603b\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderEvaluationPrinciples.getSummaryScorePrecision(), (String)I18nUtil.translate((String)"i18n_alert_MkzROzxiTLVW_7647f92f", (String)"\u6c47\u603b\u5206\u503c\u7cbe\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        this.checkAndSetParamEvaluationInfo(purchaseTenderProjectHead, bidTeeterMap, bidTeeterMaterialsMap);
    }

    private void checkAndSetParamEvaluationInfo(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead, Map<String, String> bidTeeterMap, Map<String, String> bidTeeterMaterialsMap) {
        List<PurchaseTenderEvaluationGroupVO> tenderEvaluationInfoVoList = purchaseTenderProjectHead.getTenderEvaluationInfoVoList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(tenderEvaluationInfoVoList), (String)I18nUtil.translate((String)"i18n_alert_UBrhsTvVVHxOLVW_4f1530dc", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d\u6761\u4f8b\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!"));
        HashMap priceRegulationMap = new HashMap();
        tenderEvaluationInfoVoList.stream().forEach(evaluationGroupVo -> {
            List<PurchaseTenderEvaluationRegulationInfo> evaluationRegulationInfoList = evaluationGroupVo.getTenderEvaluationTemplateRegulationInfoList();
            PurchaseTenderEvaluationPriceRegulationInfo evaluationPriceRegulationInfo = evaluationGroupVo.getTenderEvaluationTemplatePriceRegulationInfo();
            if (CollectionUtils.isEmpty(evaluationRegulationInfoList) && null == evaluationPriceRegulationInfo) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UBrhsWWWWWWVIlTjITTvWSWzRtdVHW_f7c30523", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u7ec4\u4e0b\u5fc5\u987b\u6709\u4e00\u6761\u6761\u4f8b \u6216 \u5206\u503c\u8ba1\u7b97\u4fe1\u606f!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            if ("0".equals(TenderFlagInjectionContext.getTenderCheckType()) && evaluationPriceRegulationInfo != null) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u62db\u6807\u6587\u4ef6\u4e3a\u9884\u5ba1 \u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u7ec4\u4e0b\u4e0d\u80fd\u4e3a\u8fdb\u884c\u4ef7\u683c\u5206\u8ba1\u7b97!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
            }
            if (evaluationPriceRegulationInfo != null) {
                String tenderBidLetterId = evaluationPriceRegulationInfo.getTenderBidLetterId();
                String quoteColumnName = evaluationPriceRegulationInfo.getQuoteColumnName();
                Object checkExist = bidTeeterMap.get(tenderBidLetterId + "_" + quoteColumnName);
                if (null == checkExist) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UBrhsWWWWWWVIdRKjsuAxMKVImW_eaf3cc78", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u7ec4\u4e0b\u6240\u5173\u8054\u7684\u62a5\u4ef7\u5217\u4e0d\u5b58\u5728\u8bf7\u68c0\u67e5!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
                priceRegulationMap.put(tenderBidLetterId + "_" + quoteColumnName, null);
                String pricePointsCalFormula = evaluationPriceRegulationInfo.getPricePointsCalFormula();
                if ((TenderPricePointsCalFormualEnum.OPERATION_MIN_PRICE_STRATEGY.equals(pricePointsCalFormula) || TenderPricePointsCalFormualEnum.OPERATION_MIN_PRICE_POSITIVE_DEVIATION_STRATEGY.equals(pricePointsCalFormula)) && !"0".equals(evaluationPriceRegulationInfo.getBaseCalRules())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UBrhsWWWWWWVItdRKLenuEltdWenuiOvjWtruROiFenuW_7a60352b", (String)"\u8bc4\u6807\u529e\u6cd5\u4e2d[${0}]\u7ec4\u4e0b\u8ba1\u7b97\u516c\u5f0f\u4e3a\u6700\u4f4e\u4ef7\u7b49\u6bd4\u8ba1\u7b97,\u6700\u4f4e\u4ef7\u8bc1\u504f\u79bb\u7684 \u57fa\u51c6\u4ef7\u53ea\u80fd\u9009\u62e9\u6700\u4f4e\u4ef7!", (String[])new String[]{evaluationGroupVo.getGroupName()}));
                }
            }
        });
        for (String bidTeeterKey : bidTeeterMap.keySet()) {
            boolean flag = false;
            for (String key : priceRegulationMap.keySet()) {
                if (!bidTeeterKey.equals(key)) continue;
                flag = true;
                break;
            }
            String bidLeeterInfo = bidTeeterMap.get(bidTeeterKey);
            String[] infoList = bidLeeterInfo.split("_");
            if (flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6295\u6807\u51fd[${0}]\u4e0b\u7684[${1}]\u4e3a\u62a5\u4ef7\u5217,\u9700\u8981\u5728\u8bc4\u6807\u529e\u6cd5\u4e2d\u4ef7\u683c\u8bc4\u5ba1\u9879\u4e0b\u8fdb\u884c\u7ed1\u5b9a!", (String[])new String[]{infoList[0], infoList[1]}));
        }
        if ("1".equals(purchaseTenderProjectHead.getTenderBidLetterFormatGroupVo().getQuoteType()) && bidTeeterMaterialsMap.size() != 1) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5206\u9879\u62a5\u4ef7\u6295\u6807\u51fd\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u7269\u6599\u5217"));
        }
    }

    private void checkAndSetParamTenderBidTetter(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead, Map<String, String> bidTeeterMap, Map<String, String> bidTeeterMaterialsMap) {
        PurchaseTenderBidLetterFormatGroupVO tenderBidLetterFormatGroupVo = purchaseTenderProjectHead.getTenderBidLetterFormatGroupVo();
        Assert.hasText((String)tenderBidLetterFormatGroupVo.getQuoteType(), (String)I18nUtil.translate((String)"i18n_alert_suAcxiTLV_5d905242", (String)"\u62a5\u4ef7\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        Assert.hasText((String)tenderBidLetterFormatGroupVo.getQuotations(), (String)I18nUtil.translate((String)"i18n_alert_suCKxiTLVW_d4501fa5", (String)"\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        List<PurchaseTenderBidLetterVO> tenderBidTetterVoList = tenderBidLetterFormatGroupVo.getTenderBidTetterVoList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(tenderBidTetterVoList), (String)I18nUtil.translate((String)"i18n_alert_eBxABxiTLVW_14c9a259", (String)"\u6295\u6807\u51fd\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        tenderBidTetterVoList.stream().forEach(bidTetterVo -> {
            bidTetterVo.setCheckType(purchaseTenderProjectHead.getCheckType());
            PurchaseTenderPriceOpeningsTemplate priceOpeningsList = bidTetterVo.getPriceOpenings();
            if (null == priceOpeningsList) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBxiTLVW_1c5045e1", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            String customizeFieldModel = priceOpeningsList.getCustomizeFieldModel();
            if (null == customizeFieldModel || "[]".equals(customizeFieldModel)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBeVHxiTLVW_8065107b", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u5934\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            String customizeFieldData = priceOpeningsList.getCustomizeFieldData();
            if (null == customizeFieldData || "[]".equals(customizeFieldData)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWWWumIBBABVHxiTLVW_31011e40", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}] ,\u4ef7\u683c\u4e00\u89c8\u8868\u5217\u8868\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName()}));
            }
            List customColumnModelList = JSONArray.parseArray((String)customizeFieldModel, CustomColumnModel.class);
            JSONArray dataJsonArray = JSONArray.parseArray((String)customizeFieldData);
            int materialCount = 0;
            int bidTeeterCount = 0;
            for (CustomColumnModel customColumnModel : customColumnModelList) {
                if ("1".equals(customColumnModel.getMust()) && "1".equals(customColumnModel.getInputOrg())) {
                    for (int i = 0; i < dataJsonArray.size(); ++i) {
                        JSONObject jsonObject = dataJsonArray.getJSONObject(i);
                        if (null != jsonObject.get((Object)customColumnModel.getField()) && !"".equals(jsonObject.get((Object)customColumnModel.getField()))) continue;
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eBxmKIWWWWWWsWWWWWWAKYBtLlSdxiTLVW_5c4d8733", (String)"\u6295\u6807\u51fd\u683c\u5f0f\u4e0b[${0}]\u4e2d[${1}]\u5217\u662f\u62db\u6807\u5355\u4f4d\u5fc5\u586b\u9879\u4e0d\u5141\u8bb8\u4e3a\u7a7a!", (String[])new String[]{bidTetterVo.getName(), customColumnModel.getTitle()}));
                    }
                }
                if (CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(customColumnModel.getFieldCategory())) {
                    bidTeeterMap.put(bidTetterVo.getId() + "_" + customColumnModel.getField(), bidTetterVo.getName() + "_" + customColumnModel.getTitle());
                    ++bidTeeterCount;
                }
                if (!CustomerFieldCategoryEnum.MATERIAL_COLUMN.getValue().equals(customColumnModel.getFieldCategory())) continue;
                bidTeeterMaterialsMap.put(bidTetterVo.getName() + "_" + customColumnModel.getTitle(), null);
                ++materialCount;
            }
            if (materialCount > 0 && bidTeeterCount > 1) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6295\u6807\u51fd[${0}]\u4e2d\u5b58\u5728\u7269\u6599\u5217\u65f6\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e\u4e00\u4e2a\u62a5\u4ef7\u5217!", (String[])new String[]{bidTetterVo.getName()}));
            }
        });
    }

    private void checkAndSetParamAttachmentInfo(PurchaseTenderProjectAttachmentHeadVO purchaseTenderProjectHead) {
        List<PurchaseTenderProjectAttachmentInfo> attachmentInfoList = purchaseTenderProjectHead.getPurchaseTenderProjectAttachmentInfoList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(attachmentInfoList), (String)I18nUtil.translate((String)"i18n_alert_YBQIxiTLVW_76c16858", (String)"\u62db\u6807\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a!"));
        long count = attachmentInfoList.parallelStream().filter(info -> TenderAttachmentFileStateEnum.PRE_ATTACHMENT_FILE.getValue().equals(info.getFileType())).count();
        if ("1".equals(TenderFlagInjectionContext.getTenderCheckType())) {
            Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u62db\u6807\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
        } else {
            Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u9884\u5ba1\u6587\u4ef6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a!"));
        }
    }

    private List<PurchaseAttachmentDTO> convertData(PurchaseTenderProjectAttachmentHead attachmentHead, List<PurchaseTenderProjectAttachmentInfo> purchaseTenderProjectAttachmentInfoList) {
        ArrayList<PurchaseAttachmentDTO> purchaseAttachmentDTOList = new ArrayList<PurchaseAttachmentDTO>();
        purchaseTenderProjectAttachmentInfoList.parallelStream().forEach(projectAttachmentInfo -> {
            PurchaseAttachmentDTO purchaseAttachmentDTO = new PurchaseAttachmentDTO();
            purchaseAttachmentDTO.setId(projectAttachmentInfo.getAttachmentId());
            purchaseAttachmentDTO.setHeadId(attachmentHead.getId());
            purchaseAttachmentDTO.setFileName(projectAttachmentInfo.getFileName());
            purchaseAttachmentDTO.setFilePath(projectAttachmentInfo.getFilePath());
            purchaseAttachmentDTO.setFileType(projectAttachmentInfo.getFileType());
            purchaseAttachmentDTO.setUploadElsAccount(TenantContext.getTenant());
            purchaseAttachmentDTO.setUploadSubAccount(SysUtil.getLoginUser().getSubAccount());
            purchaseAttachmentDTO.setBusinessType("attachment");
            purchaseAttachmentDTOList.add(purchaseAttachmentDTO);
        });
        return purchaseAttachmentDTOList;
    }
}

