/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.calibration.entity.BidWinningAffirmHead;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmHeadStatusEnum;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmItemStatusEnum;
import com.els.modules.tender.calibration.mapper.BidWinningAffirmHeadMapper;
import com.els.modules.tender.calibration.service.BidWinningAffirmHeadService;
import com.els.modules.tender.calibration.service.BidWinningAffirmItemService;
import com.els.modules.tender.calibration.vo.BidWinningAffirmHeadVO;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaRegulationResult;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidWinningCandidate;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderProjectBidWinningCandidateStatusEnum;
import com.els.modules.tender.evaluation.enumerate.TenderEvaGroupTypeEnum;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaRegulationResultService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidWinningCandidateService;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BidWinningAffirmHeadServiceImpl
extends BaseServiceImpl<BidWinningAffirmHeadMapper, BidWinningAffirmHead>
implements BidWinningAffirmHeadService {
    private static final Logger log = LoggerFactory.getLogger(BidWinningAffirmHeadServiceImpl.class);
    @Autowired
    private BidWinningAffirmItemService bidWinningAffirmItemService;
    @Autowired
    private PurchaseTenderProjectBidWinningCandidateService bidWinningCandidateService;
    @Autowired
    private PurchaseTenderProjectBidEvaRegulationResultService bidEvaRegulationResultService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItemList) {
        purchaseTenderProjectBidWinningAffirmHead.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseTenderProjectBidWinningAffirmHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseTenderProjectBidWinningAffirmHead.setStatus(BidWinningAffirmHeadStatusEnum.NEW.getValue());
        purchaseTenderProjectBidWinningAffirmHead.setAffirmNumber(this.invokeBaseRpcService.getNextCode("tenderWinningAffirmNumber", (Object)purchaseTenderProjectBidWinningAffirmHead));
        ((BidWinningAffirmHeadMapper)this.baseMapper).insert((Object)purchaseTenderProjectBidWinningAffirmHead);
        super.setHeadDefaultValue((BaseEntity)purchaseTenderProjectBidWinningAffirmHead);
        this.insertData(purchaseTenderProjectBidWinningAffirmHead, purchaseTenderProjectBidWinningAffirmItemList);
        this.updateTenderProjectSubpackageInfo(purchaseTenderProjectBidWinningAffirmHead, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_EDIT.getValue() + "");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItemList, List<PurchaseAttachmentDTO> attachmentList) {
        int count;
        purchaseTenderProjectBidWinningAffirmHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        purchaseTenderProjectBidWinningAffirmHead.setStatus(BidWinningAffirmHeadStatusEnum.NEW.getValue());
        if (StringUtils.isBlank((CharSequence)purchaseTenderProjectBidWinningAffirmHead.getAffirmNumber())) {
            purchaseTenderProjectBidWinningAffirmHead.setAffirmNumber(this.invokeBaseRpcService.getNextCode("tenderWinningAffirmNumber", (Object)purchaseTenderProjectBidWinningAffirmHead));
        }
        Assert.isTrue(((count = ((BidWinningAffirmHeadMapper)this.baseMapper).updateById((Object)purchaseTenderProjectBidWinningAffirmHead)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.updateData(purchaseTenderProjectBidWinningAffirmHead, purchaseTenderProjectBidWinningAffirmItemList);
        this.updateTenderProjectSubpackageInfo(purchaseTenderProjectBidWinningAffirmHead, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_EDIT.getValue() + "");
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTenderProjectBidWinningAffirmHead.getId());
            attachmentList.parallelStream().forEach(attachment -> attachment.setHeadId(purchaseTenderProjectBidWinningAffirmHead.getId()));
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead) {
        BidWinningAffirmHead bidWinningAffirmHead = (BidWinningAffirmHead)((Object)((BidWinningAffirmHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseTenderProjectBidWinningAffirmHead.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)bidWinningAffirmHead)), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e!"));
        Assert.isTrue((boolean)BidWinningAffirmHeadStatusEnum.NEW.getValue().equals(bidWinningAffirmHead.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4\u5ba1\u6279!"));
        bidWinningAffirmHead.setStatus(BidWinningAffirmHeadStatusEnum.AUDIT.getValue());
        String businessType = "bidWinningAffirm";
        String auditSubject = "\u4e2d\u6807\u5019\u9009\u4eba\u786e\u8ba4\u5355\u53f7:";
        List<BidWinningAffirmItem> bidWinningAffirmItems = this.bidWinningAffirmItemService.selectByMainId(purchaseTenderProjectBidWinningAffirmHead.getId());
        for (BidWinningAffirmItem bidWinningAffirmItem : bidWinningAffirmItems) {
            if (!BidWinningAffirmItemStatusEnum.RECONFIRMATION.getValue().equals(bidWinningAffirmItem.getStatus())) continue;
            businessType = "againBidWinningAffirm";
            auditSubject = "\u4e2d\u6807\u5019\u9009\u4eba\u91cd\u65b0\u786e\u8ba4\u5355\u53f7:";
            break;
        }
        AuditInputParamDTO dto = new AuditInputParamDTO();
        dto.setBusinessId(purchaseTenderProjectBidWinningAffirmHead.getId());
        dto.setBusinessType(businessType);
        dto.setAuditSubject(auditSubject + purchaseTenderProjectBidWinningAffirmHead.getAffirmNumber());
        dto.setParams(JSONObject.toJSONString((Object)((Object)purchaseTenderProjectBidWinningAffirmHead)));
        this.inquiryInvokeWorkFlowRpcService.submit(dto);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(String id, String processInstanceId, String auditStatus, String bpmnType) {
        BidWinningAffirmHead bidWinningAffirmHead = (BidWinningAffirmHead)((Object)this.getById((Serializable)((Object)id)));
        bidWinningAffirmHead.setFlowId(processInstanceId);
        bidWinningAffirmHead.setAuditStatus(auditStatus);
        bidWinningAffirmHead.setWorkFlowType(bpmnType);
        String status = null;
        String subPackageStatus = null;
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            status = BidWinningAffirmHeadStatusEnum.FINISH.getValue();
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_REJECT.getValue() + "";
            status = BidWinningAffirmHeadStatusEnum.NEW.getValue();
            this.updateTenderProjectSubpackageInfo(bidWinningAffirmHead, subPackageStatus);
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            status = BidWinningAffirmHeadStatusEnum.NEW.getValue();
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_EDIT.getValue() + "";
            this.updateTenderProjectSubpackageInfo(bidWinningAffirmHead, subPackageStatus);
        } else {
            status = BidWinningAffirmHeadStatusEnum.AUDIT.getValue();
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_AUDIT.getValue() + "";
            this.updateTenderProjectSubpackageInfo(bidWinningAffirmHead, subPackageStatus);
        }
        bidWinningAffirmHead.setStatus(status);
        this.updateById((Object)bidWinningAffirmHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(BidWinningAffirmHead bidWinningAffirmHead) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)bidWinningAffirmHead)), (String)I18nUtil.translate((String)"i18n_alert_sBSiLRLVHxMKW_8e091838", (String)"\u4e2d\u6807\u5019\u9009\u4eba\u786e\u8ba4\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        BidWinningAffirmHead bidWinningAffirm = (BidWinningAffirmHead)((Object)this.getById((Serializable)((Object)bidWinningAffirmHead.getId())));
        bidWinningAffirm.setStatus(BidWinningAffirmHeadStatusEnum.FINISH.getValue());
        this.updateById((Object)bidWinningAffirm);
        this.bidWinningAffirmItemService.deleteByMainIdAndStatus(bidWinningAffirmHead.getId(), BidWinningAffirmItemStatusEnum.RECONFIRMATION.getValue());
        this.bidWinningAffirmItemService.updateStatus(bidWinningAffirmHead.getId(), BidWinningAffirmItemStatusEnum.CONFIRMED.getValue(), BidWinningAffirmItemStatusEnum.NEW.getValue());
        List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(bidWinningAffirmHead.getId());
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentDTOList)) {
            ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOList, bidWinningAffirmHead.getId(), bidWinningAffirmHead.getSubpackageId(), bidWinningAffirmHead.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.TENDER_WINNING_AFFIRM_PREFIX.getValue());
        }
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmHead, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_AFFIRM_PASS.getValue() + "");
    }

    private void updateTenderProjectSubpackageInfo(BidWinningAffirmHead bidWinningAffirmHead, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)bidWinningAffirmHead).subpackageId(bidWinningAffirmHead.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    private void insertData(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItemList) {
        if (!CollectionUtils.isEmpty(purchaseTenderProjectBidWinningAffirmItemList)) {
            for (BidWinningAffirmItem entity : purchaseTenderProjectBidWinningAffirmItemList) {
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
                entity.setAffirm("1");
                entity.setHeadId(purchaseTenderProjectBidWinningAffirmHead.getId());
                entity.setStatus(BidWinningAffirmItemStatusEnum.NEW.getValue());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderProjectBidWinningAffirmHead);
            }
            this.bidWinningAffirmItemService.saveBatch(purchaseTenderProjectBidWinningAffirmItemList, 2000);
        }
    }

    private void updateData(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItemList) {
        this.bidWinningAffirmItemService.deleteByMainIdAndStatus(purchaseTenderProjectBidWinningAffirmHead.getId(), BidWinningAffirmItemStatusEnum.NEW.getValue());
        this.bidWinningAffirmItemService.updateStatus(purchaseTenderProjectBidWinningAffirmHead.getId(), BidWinningAffirmItemStatusEnum.RECONFIRMATION.getValue(), BidWinningAffirmItemStatusEnum.CONFIRMED.getValue());
        this.insertData(purchaseTenderProjectBidWinningAffirmHead, purchaseTenderProjectBidWinningAffirmItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.bidWinningAffirmItemService.deleteByMainId(id);
        ((BidWinningAffirmHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.bidWinningAffirmItemService.deleteByMainId(serializable.toString());
            ((BidWinningAffirmHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public BidWinningAffirmHeadVO queryBidWinningFinalCandidate(String subpackageId) {
        BidWinningAffirmHeadVO bidWinningAffirmHeadVO = new BidWinningAffirmHeadVO();
        if (StringUtils.isBlank((CharSequence)subpackageId)) {
            return bidWinningAffirmHeadVO;
        }
        List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidateList = this.bidWinningCandidateService.selectBidWinningResultBySubpackageId(subpackageId, null);
        log.info("\u5019\u9009\u4eba\u6570\u636e\uff1a{}", JSON.toJSON(bidWinningCandidateList));
        if (CollectionUtil.isEmpty(bidWinningCandidateList)) {
            return bidWinningAffirmHeadVO;
        }
        List<Object> bidWinningCandidates = bidWinningCandidateList.stream().filter(bidWinningCandidate -> PurchaseTenderProjectBidWinningCandidateStatusEnum.AFFIRM.getValue().equals(bidWinningCandidate.getCandidateStatus())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(bidWinningCandidates)) {
            bidWinningCandidates = bidWinningCandidateList;
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(BidWinningAffirmHead::getSubpackageId, (Object)subpackageId);
        List bidWinningAffirmHeads = this.list((Wrapper)qw);
        List<Object> supplierAccounts = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)bidWinningAffirmHeads)) {
            BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead = (BidWinningAffirmHead)((Object)bidWinningAffirmHeads.get(0));
            BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectBidWinningAffirmHead), (Object)((Object)bidWinningAffirmHeadVO));
            List<BidWinningAffirmItem> purchaseTenderProjectBidWinningAffirmItems = this.bidWinningAffirmItemService.selectByMainId(purchaseTenderProjectBidWinningAffirmHead.getId());
            supplierAccounts = purchaseTenderProjectBidWinningAffirmItems.stream().filter(item -> BidWinningAffirmItemStatusEnum.CONFIRMED.getValue().equals(item.getStatus())).map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(supplierAccounts)) {
                supplierAccounts = purchaseTenderProjectBidWinningAffirmItems.stream().filter(item -> BidWinningAffirmItemStatusEnum.NEW.getValue().equals(item.getStatus())).map(BidWinningAffirmItem::getSupplierAccount).collect(Collectors.toList());
            }
            List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseTenderProjectBidWinningAffirmHead.getId());
            bidWinningAffirmHeadVO.setAttachmentList(purchaseAttachmentDTOList);
        }
        LambdaQueryWrapper bidEvaRegulationResultQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)bidEvaRegulationResultQuery.eq(PurchaseTenderProjectBidEvaRegulationResult::getSubpackageId, (Object)subpackageId)).eq(PurchaseTenderProjectBidEvaRegulationResult::getEvaGroupType, (Object)TenderEvaGroupTypeEnum.PRICE_REVIEW.getValue());
        List bidEvaRegulationResults = this.bidEvaRegulationResultService.list((Wrapper)bidEvaRegulationResultQuery);
        Map<String, List<PurchaseTenderProjectBidEvaRegulationResult>> supplierPriceMap = bidEvaRegulationResults.stream().collect(Collectors.groupingBy(PurchaseTenderProjectBidEvaRegulationResult::getSupplierAccount));
        bidWinningCandidates.sort((o1, o2) -> o2.getTotalScore().intValue() - o1.getTotalScore().intValue());
        ArrayList bidWinningAffirmItems = SysUtil.copyProperties(bidWinningCandidates, BidWinningAffirmItem.class);
        int number = 1;
        for (BidWinningAffirmItem bidWinningAffirmItem : bidWinningAffirmItems) {
            bidWinningAffirmItem.setScopeSort(String.valueOf(number));
            ++number;
            if (supplierAccounts.contains(bidWinningAffirmItem.getSupplierAccount())) {
                bidWinningAffirmItem.setAffirm("1");
            } else {
                bidWinningAffirmItem.setAffirm("0");
            }
            BigDecimal quote = BigDecimal.ZERO;
            BigDecimal evaPrice = BigDecimal.ZERO;
            List<PurchaseTenderProjectBidEvaRegulationResult> supplierPriceList = supplierPriceMap.get(bidWinningAffirmItem.getSupplierAccount());
            if (CollectionUtil.isNotEmpty(supplierPriceList)) {
                quote = supplierPriceList.stream().map(PurchaseTenderProjectBidEvaRegulationResult::getQuote).reduce(quote, BigDecimal::add);
                evaPrice = supplierPriceList.stream().map(PurchaseTenderProjectBidEvaRegulationResult::getEvaPrice).reduce(evaPrice, BigDecimal::add);
            }
            bidWinningAffirmItem.setQuote(quote);
            bidWinningAffirmItem.setEvaPrice(evaPrice);
        }
        bidWinningAffirmHeadVO.setBidWinningAffirmItemList(bidWinningAffirmItems);
        return bidWinningAffirmHeadVO;
    }
}

