/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.archive.enumerate.TenderProjectArchiveAttachmentEnum;
import com.els.modules.tender.archive.utils.ArchiveUtil;
import com.els.modules.tender.clarification.entity.PurchaseTenderClarificationInfo;
import com.els.modules.tender.clarification.enumerate.TenderClarificationStatusEnum;
import com.els.modules.tender.clarification.mapper.PurchaseTenderClarificationInfoMapper;
import com.els.modules.tender.clarification.service.PurchaseTenderClarificationInfoService;
import com.els.modules.tender.clarification.service.SaleTenderClarificationInfoService;
import com.els.modules.tender.clarification.vo.PurchaseTenderClarificationInfoVO;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.DateUtils;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.job.TenderJobUtil;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.vo.PurchaseOpenSettingHeadVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseTenderClarificationInfoServiceImpl
extends BaseServiceImpl<PurchaseTenderClarificationInfoMapper, PurchaseTenderClarificationInfo>
implements PurchaseTenderClarificationInfoService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TenderProjectSupplierService supplierService;
    @Autowired
    @Lazy
    private SaleTenderClarificationInfoService saleTenderClarificationInfoService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectOpenSettingHeadService openSettingHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderClarificationInfo add(PurchaseTenderClarificationInfoVO purchaseTenderClarificationInfo) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(purchaseTenderClarificationInfo.getSubpackageId());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(subpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderClarificationInfo), PurchaseTenderClarificationInfo.class));
        this.invokeBaseRpcService.getNextCode("clarificationNumber", (Object)tenderClarificationInfo);
        tenderClarificationInfo.setStatus(TenderClarificationStatusEnum.NEW.getValue());
        tenderClarificationInfo.setConfirmNumber(0);
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(TenderProjectSupplier::getSubpackageId, (Object)tenderClarificationInfo.getSubpackageId());
        tenderClarificationInfo.setTotal(this.supplierService.count((Wrapper)qw));
        ((PurchaseTenderClarificationInfoMapper)this.baseMapper).insert((Object)tenderClarificationInfo);
        this.insertData(purchaseTenderClarificationInfo.getPurchaseAttachmentList(), tenderClarificationInfo);
        return tenderClarificationInfo;
    }

    private void insertData(List<PurchaseAttachmentDTO> purchaseAttachmentList, PurchaseTenderClarificationInfo tenderClarificationInfo) {
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(tenderClarificationInfo.getId());
        purchaseAttachmentList.parallelStream().forEach(item -> item.setHeadId(tenderClarificationInfo.getId()));
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public PurchaseTenderClarificationInfo edit(PurchaseTenderClarificationInfoVO purchaseTenderClarificationInfo) {
        PurchaseTenderClarificationInfo dbClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.getById((Serializable)((Object)purchaseTenderClarificationInfo.getId())));
        purchaseTenderClarificationInfo.setDataVersion(dbClarificationInfo.getDataVersion());
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderClarificationInfo), PurchaseTenderClarificationInfo.class));
        this.invokeBaseRpcService.getNextCode("clarificationNumber", (Object)tenderClarificationInfo);
        int count = ((PurchaseTenderClarificationInfoMapper)this.baseMapper).updateById((Object)tenderClarificationInfo);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(purchaseTenderClarificationInfo.getPurchaseAttachmentList(), tenderClarificationInfo);
        return tenderClarificationInfo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        ((PurchaseTenderClarificationInfoMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatch(List<String> idList) {
        ((PurchaseTenderClarificationInfoMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public PurchaseTenderClarificationInfoVO queryById(String id) {
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.getById((Serializable)((Object)id)));
        PurchaseTenderClarificationInfoVO purchaseTenderClarificationInfoVO = (PurchaseTenderClarificationInfoVO)((Object)SysUtil.copyProperties((Object)((Object)tenderClarificationInfo), PurchaseTenderClarificationInfoVO.class));
        List attachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseTenderClarificationInfoVO.getId());
        purchaseTenderClarificationInfoVO.setPurchaseAttachmentList(attachmentDTOList);
        return purchaseTenderClarificationInfoVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(PurchaseTenderClarificationInfoVO purchaseTenderClarificationInfo) {
        this.checkParams(purchaseTenderClarificationInfo);
        purchaseTenderClarificationInfo.setStatus(TenderClarificationStatusEnum.TO_BE_SENT.getValue());
        this.edit(purchaseTenderClarificationInfo);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(String id) {
        PurchaseTenderClarificationInfo tenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)this.getById((Serializable)((Object)id)));
        tenderClarificationInfo.setStatus(TenderClarificationStatusEnum.HAS_BEEN_SENT.getValue());
        tenderClarificationInfo.setPublishTime(new Date());
        this.updateById((Object)tenderClarificationInfo);
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(tenderClarificationInfo.getSubpackageId());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(subpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        PushEventUtils.updateSubpackageInfo(TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)tenderClarificationInfo).subpackageId(tenderClarificationInfo.getSubpackageId()).build());
        List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        this.saleTenderClarificationInfoService.batchAdd(tenderClarificationInfo, purchaseAttachmentDTOS);
        PurchaseOpenSettingHeadVO purchaseOpenSettingHeadVO = this.openSettingHeadService.queryBySubpackageId(subpackageInfo.getId());
        if ("1".equals(purchaseOpenSettingHeadVO.getAutoOpenBid())) {
            TenderJobUtil.createOrUpdateOpenBidAlertJob(subpackageInfo, tenderClarificationInfo.getOpenBiddingTime());
        }
        ArchiveUtil.saveArchiveByPurchaseAttachmentDTO(purchaseAttachmentDTOS, tenderClarificationInfo.getId(), tenderClarificationInfo.getSubpackageId(), tenderClarificationInfo.getTenderProjectId(), TenderProjectArchiveAttachmentEnum.CLARIFY_PREFIX.getValue());
    }

    @Override
    public void addConfirmNumber(String id) {
        PurchaseTenderClarificationInfo purchaseTenderClarificationInfo = (PurchaseTenderClarificationInfo)((Object)((PurchaseTenderClarificationInfoMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        int compareResult = purchaseTenderClarificationInfo.getTotal().compareTo(purchaseTenderClarificationInfo.getConfirmNumber());
        Assert.isTrue((compareResult == 1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RLLWBRkLWW_2d5f9bfe", (String)"\u786e\u8ba4\u4eba\u6570\u8d85\u8fc7\u603b\u4eba\u6570\uff01"));
        int count = ((PurchaseTenderClarificationInfoMapper)this.baseMapper).addConfirmNumber(id);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    private void checkParams(PurchaseTenderClarificationInfoVO purchaseTenderClarificationInfo) {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = this.subpackageInfoService.selectById(purchaseTenderClarificationInfo.getSubpackageId());
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue().equals(subpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u5355\u636e\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        boolean hasPreTrial = SubpackageInfoCheckTypeEnum.hasPreTrial(purchaseTenderClarificationInfo.getCheckType());
        Date fileClarificationEndTime = hasPreTrial ? subpackageInfo.getPreFileClarificationEndTime() : subpackageInfo.getFileClarificationEndTime();
        Assert.isTrue((fileClarificationEndTime != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u516c\u544a\u672a\u53d1\u5e03\u4e0d\u53ef\u53d1\u5e03\u6f84\u6e05\uff01"));
        Date currentTime = new Date();
        Assert.isTrue((boolean)currentTime.before(fileClarificationEndTime), (String)I18nUtil.translate((String)"", (String)"\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u53d1\u9001\u6f84\u6e05\uff01"));
        Assert.isTrue((purchaseTenderClarificationInfo.getSubpackageId() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_zsWWxOLVW_7f840617", (String)"\u5206\u5305ID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((purchaseTenderClarificationInfo.getTenderProjectId() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_dIWWxOLVW_25b07d81", (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((purchaseTenderClarificationInfo.getFileClarificationEndTime() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_QILVyRKIxOLVW_bdaf9feb", (String)"\u6587\u4ef6\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((purchaseTenderClarificationInfo.getFileSubmitEndTime() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_QInJyRKIxOLVW_765c493a", (String)"\u6587\u4ef6\u9012\u4ea4\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseTenderClarificationInfo.getTitle()), (String)I18nUtil.translate((String)"i18n_alert_LVBDxOLVW_ce2de7ff", (String)"\u6f84\u6e05\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseTenderClarificationInfo.getContent()), (String)I18nUtil.translate((String)"i18n_alert_LVCcxOLVW_48de447c", (String)"\u6f84\u6e05\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        DateUtils.after(purchaseTenderClarificationInfo.getOpenBiddingTime(), 5);
    }
}

