/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.sale.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.vo.TenderProjectSignUpVO;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSignUpExamine;
import com.els.modules.tender.supplier.service.TenderProjectSignUpRejectService;
import com.els.modules.tender.supplier.service.TenderProjectSignUpService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868"})
@RestController
@RequestMapping(value={"/tender/sale/supplierTenderProjectSignUp"})
public class SaleTenderProjectSignUpController
extends BaseController<TenderProjectSignUp, TenderProjectSignUpService> {
    @Autowired
    private TenderProjectSignUpService tenderProjectSignUpService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private TenderProjectSignUpRejectService tenderProjectSignUpRejectService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(TenderProjectSignUp tenderProjectSignUp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectSignUp), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.tenderProjectSignUpService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u63d0\u4ea4")
    @ApiOperation(value="\u62a5\u540d-\u63d0\u4ea4", notes="\u62a5\u540d-\u63d0\u4ea4")
    @PostMapping(value={"/submit"})
    public Result<?> submit(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.build(tenderProjectSignUp);
        this.tenderProjectSignUpService.saveOrUpdatePublish(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectSignUp));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u65b0\u589e")
    @ApiOperation(value="\u65b0\u589e", notes="\u65b0\u589e")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.build(tenderProjectSignUp);
        this.tenderProjectSignUpService.add(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectSignUp));
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u62a5\u540d\u8868-\u62a5\u540d")
    @ApiOperation(value="\u4fee\u6539", notes="\u4fee\u6539")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#supplierTenderProjectSignUp:edit"})
    public Result<?> edit(@RequestBody TenderProjectSignUpVO supplierTenderProjectSignUpVO) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectSignUpVO), TenderProjectSignUp.class));
        this.build(tenderProjectSignUp);
        this.tenderProjectSignUpService.edit(tenderProjectSignUp, supplierTenderProjectSignUpVO.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectSignUp));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProjectSignUpVO tenderProjectSignUpVO = this.getById(id);
        return Result.ok((Object)((Object)tenderProjectSignUpVO));
    }

    private TenderProjectSignUpVO getById(String id) {
        TenderProjectSignUp tenderProjectSignUp = (TenderProjectSignUp)((Object)this.tenderProjectSignUpService.getById((Serializable)((Object)id)));
        List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        TenderProjectSignUpVO tenderProjectSignUpVO = (TenderProjectSignUpVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectSignUp), TenderProjectSignUpVO.class));
        tenderProjectSignUpVO.setAttachmentList(saleAttachmentDemandDTOS);
        List<TenderProjectSignUpExamine> tenderProjectSignUpRejects = this.tenderProjectSignUpRejectService.selectByMainId(tenderProjectSignUp.getId());
        tenderProjectSignUpVO.setTenderProjectSignUpRejectList(tenderProjectSignUpRejects);
        return tenderProjectSignUpVO;
    }

    @ApiOperation(value="\u67e5\u8be2\u62a5\u540d\u4fe1\u606f", notes="\u67e5\u8be2\u62a5\u540d\u4fe1\u606f")
    @GetMapping(value={"/queryBySubpackageId"})
    public Result<?> queryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        TenderProjectSignUpVO tenderProjectSignUpVO = this.tenderProjectSignUpService.querySignInfo(subpackageId);
        return Result.ok((Object)((Object)tenderProjectSignUpVO));
    }

    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderProjectSignUpService.delete(id);
        return Result.ok();
    }

    private void build(TenderProjectSignUp tenderProjectSignUp) {
        tenderProjectSignUp.setSourceType(TenderProjectSourceTypeEnum.ON_LINE.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        tenderProjectSignUp.setSupplierAccount(loginUser.getElsAccount());
        tenderProjectSignUp.setSupplierName(loginUser.getEnterpriseName());
        tenderProjectSignUp.setSupplierSubAccount(loginUser.getSubAccount());
        tenderProjectSignUp.setElsAccount(tenderProjectSignUp.getSupplierAccount());
    }
}

