/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.AesEncryptUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetter;
import com.els.modules.tender.attachment.service.PurchaseTenderBidLetterService;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.OpenBidRecordLogUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.notice.entity.PurchaseTenderNoticeHead;
import com.els.modules.tender.notice.entity.PurchaseTenderSupplierInvitation;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenInfoRecords;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenSettingHead;
import com.els.modules.tender.openbid.enumerate.PurchaseOpenBidStatusEnum;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenInfoRecordsService;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenSettingHeadService;
import com.els.modules.tender.openbid.websocket.TenderOnlineWebSocket;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.modules.tender.project.vo.PurchaseTenderProjectOpenInfoHeadVO;
import com.els.modules.tender.sale.entity.SaleTenderPriceOpenings;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplieResponseStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSupplierPurchaseBidStatusEnum;
import com.els.modules.tender.sale.service.SaleTenderPriceOpeningsService;
import com.els.modules.tender.sale.service.SaleTenderProjectMarginHeadService;
import com.els.modules.tender.sale.vo.SaleTenderBidLetterVo;
import com.els.modules.tender.sale.vo.TenderProjectSupplierDecrptVO;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.entity.TenderProjectSignUp;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.mapper.TenderProjectSupplierMapper;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import com.els.modules.tender.supplier.vo.TenderProjectSupplierInfoVO;
import com.els.modules.tender.supplier.vo.TenderProjectSupplierMessageVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class TenderProjectSupplierServiceImpl
extends BaseServiceImpl<TenderProjectSupplierMapper, TenderProjectSupplier>
implements TenderProjectSupplierService {
    private static final Logger log = LoggerFactory.getLogger(TenderProjectSupplierServiceImpl.class);
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;
    @Autowired
    private PurchaseTenderProjectOpenSettingHeadService purchaseTenderProjectOpenSettingHeadServiceImpl;
    @Autowired
    @Lazy
    private SaleTenderPriceOpeningsService saleTenderPriceOpeningsServiceImpl;
    @Autowired
    @Lazy
    private PurchaseTenderProjectOpenInfoRecordsService projectOpenInfoRecordsService;
    @Autowired
    @Lazy
    private PurchaseTenderBidLetterService purchaseTenderBidLetterService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleTenderProjectMarginHeadService tenderProjectMarginHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(TenderProjectSupplier tenderProjectSupplier) {
        this.checkParam(tenderProjectSupplier);
        this.builDefaultParam(tenderProjectSupplier);
        ((TenderProjectSupplierMapper)this.baseMapper).insert((Object)tenderProjectSupplier);
        this.tenderProjectMarginHeadService.add(tenderProjectSupplier);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(TenderProjectSupplier tenderProjectSupplier) {
        this.checkParam(tenderProjectSupplier);
        this.builDefaultParam(tenderProjectSupplier);
        int count = ((TenderProjectSupplierMapper)this.baseMapper).alwaysUpdateSomeColumnById((Object)tenderProjectSupplier);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TenderProjectSupplierMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TenderProjectSupplierMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdateBySign(TenderProjectSignUp saleTenderProjectSignUp) {
        TenderProjectSupplier dataSource = new TenderProjectSupplier();
        BeanUtils.copyProperties((Object)((Object)saleTenderProjectSignUp), (Object)((Object)dataSource));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(dataSource.getSubpackageId()).setSupplierAccount(dataSource.getSupplierAccount());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
        if (CollectionUtil.isNotEmpty(tenderProjectSupplierList)) {
            tenderProjectSupplier = tenderProjectSupplierList.get(0);
        }
        this.buildParam(dataSource, tenderProjectSupplier);
        tenderProjectSupplier.setSignUpStatus(saleTenderProjectSignUp.getStatus());
        tenderProjectSupplier.setPurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.NOT_PURCHASE_BID.getValue());
        tenderProjectSupplier.setPrePurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.NOT_PURCHASE_BID.getValue());
        tenderProjectSupplier.setPreResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
        tenderProjectSupplier.setResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
        tenderProjectSupplier.setResultResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
        tenderProjectSupplier.setCombination(saleTenderProjectSignUp.getCombination());
        tenderProjectSupplier.setCombinationName(saleTenderProjectSignUp.getCombinationName());
        if (StringUtils.hasText((String)tenderProjectSupplier.getId())) {
            this.edit(tenderProjectSupplier);
        } else {
            this.add(tenderProjectSupplier);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveOrUpdateByPurchaseBid(TenderProjectPurchaseBid saleTenderProjectPurchaseBid) {
        TenderProjectSupplier dataSource = new TenderProjectSupplier();
        BeanUtils.copyProperties((Object)((Object)saleTenderProjectPurchaseBid), (Object)((Object)dataSource));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(dataSource.getSubpackageId()).setSupplierAccount(dataSource.getSupplierAccount());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
        if (CollectionUtil.isNotEmpty(tenderProjectSupplierList)) {
            tenderProjectSupplier = tenderProjectSupplierList.get(0);
        }
        this.buildParam(dataSource, tenderProjectSupplier);
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(saleTenderProjectPurchaseBid.getCheckType())) {
            tenderProjectSupplier.setPrePurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID.getValue());
            tenderProjectSupplier.setPreResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            tenderProjectSupplier.setPrePurchaseBid("0");
        } else {
            tenderProjectSupplier.setPurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID.getValue());
            tenderProjectSupplier.setResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            tenderProjectSupplier.setPurchaseBid("0");
        }
        if (TenderProjectSourceTypeEnum.OFF_LINE.getValue().equals(saleTenderProjectPurchaseBid.getSourceType())) {
            tenderProjectSupplier.setEffective("1");
        }
        if (StringUtils.hasText((String)tenderProjectSupplier.getId())) {
            this.edit(tenderProjectSupplier);
            return;
        }
        this.add(tenderProjectSupplier);
    }

    @Override
    public List<TenderProjectSupplier> selectBySubpackageId(TenderProjectSupplier querySupplier) {
        return this.selectBySubpackageId(querySupplier, true);
    }

    @Override
    public List<TenderProjectSupplier> selectBySubpackageId(TenderProjectSupplier querySupplier, boolean hasEffective) {
        if (hasEffective) {
            querySupplier.setEffective("1");
        }
        return ((TenderProjectSupplierMapper)this.baseMapper).selectBySubpackageId(querySupplier);
    }

    @Override
    public List<TenderProjectSupplier> getDecryptSupplier(String subpackageId) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        return ((TenderProjectSupplierMapper)this.baseMapper).getDecryptSupplier(subpackageId, tenderCheckType, tenderProcessType, currentStep);
    }

    @Override
    public void join(TenderProjectSupplier saleTenderProjectSupplier) {
        LoginUser sysUser = SysUtil.getLoginUser();
        saleTenderProjectSupplier.setSupplierAccount(sysUser.getElsAccount());
        saleTenderProjectSupplier.setSupplierSubAccount(sysUser.getSubAccount());
        saleTenderProjectSupplier.setSupplierName(sysUser.getEnterpriseName());
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(saleTenderProjectSupplier.getSubpackageId()).setSupplierAccount(saleTenderProjectSupplier.getSupplierAccount());
        List<TenderProjectSupplier> tenderProjectSuppliers = ((TenderProjectSupplierMapper)this.baseMapper).selectBySubpackageId(querySupplier);
        if (tenderProjectSuppliers.isEmpty()) {
            saleTenderProjectSupplier.setSourceType(TenderProjectSourceTypeEnum.ON_LINE.getValue());
            PurchaseTenderProjectHeadVO purchaseTenderProjectHead = this.purchaseTenderProjectHeadService.queryProjectHeadBySubpackageId(saleTenderProjectSupplier.getSubpackageId());
            saleTenderProjectSupplier.setSourceType(TenderProjectSourceTypeEnum.ON_LINE.getValue());
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)purchaseTenderProjectHead)), (String)I18nUtil.translate((String)"i18n_alert_dIxMKW_dfe46939", (String)"\u9879\u76ee\u4e0d\u5b58\u5728!"));
            saleTenderProjectSupplier.setPurchaseEnterpriseAccount(purchaseTenderProjectHead.getElsAccount());
            saleTenderProjectSupplier.setPurchaseEnterpriseName(purchaseTenderProjectHead.getElsRealname());
            saleTenderProjectSupplier.setTenderProjectNumber(purchaseTenderProjectHead.getTenderProjectNumber());
            saleTenderProjectSupplier.setTenderProjectName(purchaseTenderProjectHead.getTenderProjectName());
            saleTenderProjectSupplier.setElsAccount(TenantContext.getTenant());
            saleTenderProjectSupplier.setResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            saleTenderProjectSupplier.setPreResponseStatus(TenderProjectSupplieResponseStatusEnum.PENDING_BID.getValue());
            saleTenderProjectSupplier.setConsortiumBidding(purchaseTenderProjectHead.getSubpackageInfoVOList().get(0).getConsortiumBidding());
            saleTenderProjectSupplier.setEffective("1");
            this.add(saleTenderProjectSupplier);
            return;
        }
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSuppliers.get(0);
        tenderProjectSupplier.setEffective("1");
        this.updateById((Object)tenderProjectSupplier);
    }

    @Override
    public void updateByPurchaseBidApproved(String subpackageId, String toElsAccount) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(toElsAccount);
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(tenderProjectSupplierList), (String)I18nUtil.translate((String)"i18n_alert_RdXdWFxMKW_a3df2a70", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u4e0d\u5b58\u5728!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        if (SubpackageInfoCheckTypeEnum.PRE_TRIAL.getValue().equals(TenderFlagInjectionContext.getTenderCheckType())) {
            tenderProjectSupplier.setPrePurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID_SECCESS.getValue());
            tenderProjectSupplier.setPrePurchaseBid("1");
        } else {
            tenderProjectSupplier.setPurchaseBidStatus(TenderProjectSupplierPurchaseBidStatusEnum.PURCHASE_BID_SECCESS.getValue());
            tenderProjectSupplier.setPurchaseBid("1");
        }
        tenderProjectSupplier.setEffective("1");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
    }

    @Override
    public void updateBySignUpExamine(String subpackageId, String toElsAccount, String signUpStatus) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(toElsAccount);
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier, false);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(tenderProjectSupplierList), (String)I18nUtil.translate((String)"i18n_alert_RdXdWFxMKW_a3df2a70", (String)"\u4f9b\u5e94\u5546\u4e3b\u6570\u636e\u4e0d\u5b58\u5728!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        tenderProjectSupplier.setSignUpStatus(signUpStatus);
        tenderProjectSupplier.setEffective("1");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
    }

    @Override
    public void signIn(TenderProjectSupplier tenderProjectSupplier) {
        long count;
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(tenderProjectSupplier.getSubpackageId()).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tkIHWVXVsKW_58a1a970", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        tenderProjectSupplier = tenderProjectSupplierList.get(0);
        Assert.isTrue((boolean)"0".equals(tenderProjectSupplier.getInvalid()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u5165\u5f00\u6807\u5927\u5385!"));
        String responseStatus = TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "responseStatus");
        Assert.isTrue((boolean)TenderProjectSupplieResponseStatusEnum.RESPONSE_BID.getValue().equals(responseStatus), (String)I18nUtil.translate((String)"i18n_alert_VWHcQInJW_da66025e", (String)"\u8bf7\u5148\u8fdb\u884c\u6587\u4ef6\u9012\u4ea4!"));
        TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "signIn");
        tenderProjectSupplier.setPreSignIn("1");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
        LoginUser loginUser = SysUtil.getLoginUser();
        String msg = "\u6295\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5df2\u7b7e\u5230";
        List<PurchaseTenderProjectOpenInfoRecords> projectOpenInfoRecordsList = this.projectOpenInfoRecordsService.queryOpenInfoRecordsSignMessageBySubpackageId(tenderProjectSupplier.getSubpackageId(), TenantContext.getTenant());
        if (!projectOpenInfoRecordsList.isEmpty() && (count = projectOpenInfoRecordsList.parallelStream().filter(projectOpenInfoRecords -> msg.equals(projectOpenInfoRecords.getContent())).count()) > 0L) {
            return;
        }
        PurchaseTenderProjectOpenInfoHeadVO projectOpenInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(tenderProjectSupplier.getSubpackageId());
        OpenBidRecordLogUtils.saveRecordMsg(projectOpenInfoHeadVO, msg);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void decrypt(TenderProjectSupplierDecrptVO tenderProjectSupplierDecrptVO) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(tenderProjectSupplierDecrptVO.getSubpackageId()).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tkIHWVXVsKW_58a1a970", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(tenderProjectSupplier.getSubpackageId());
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)openInfoHeadVO);
        String filePassword = TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "filePassword");
        this.checkStatus(tenderProjectSupplierDecrptVO, openBidStatus, filePassword);
        TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "decrypt");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
        LoginUser loginUser = SysUtil.getLoginUser();
        OpenBidRecordLogUtils.saveRecordMsg(openInfoHeadVO, "\u6295\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5df2\u89e3\u5bc6");
        TenderOnlineWebSocket webSocket = (TenderOnlineWebSocket)SpringContextUtils.getBean(TenderOnlineWebSocket.class);
        JSONObject messageJson = new JSONObject();
        messageJson.put("type", (Object)"updateOpenBidStatus");
        messageJson.put("result", (Object)openInfoHeadVO);
        webSocket.sendQuoteMessage(tenderProjectSupplierDecrptVO.getSubpackageId(), messageJson.toString());
    }

    private void checkStatus(TenderProjectSupplierDecrptVO tenderProjectSupplierDecrptVO, String openBidStatus, String filePassword) {
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.DECRYPTING.getValue().equals(openBidStatus), (String)I18nUtil.translate((String)"i18n__xiTVBywW_c60f695a", (String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u89e3\u5bc6\uff01"));
        String encryptPassword = AesEncryptUtil.encrypt((String)tenderProjectSupplierDecrptVO.getPassword());
        Assert.isTrue((boolean)StringUtils.hasText((String)encryptPassword), (String)I18nUtil.translate((String)"i18n_alert_SXwoW_cb0bb61e", (String)"\u65e0\u6548\u5bc6\u7801!"));
        Assert.isTrue((boolean)encryptPassword.equals(filePassword), (String)I18nUtil.translate((String)"i18n_alert_QIwoNSWVsKW_13cb602e", (String)"\u6587\u4ef6\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5!"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void signature(String subpackageId) {
        PurchaseTenderProjectSubpackageInfo projectSubpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)subpackageId)));
        Assert.isTrue((boolean)PurchaseOpenBidStatusEnum.SIGNING.equals(projectSubpackageInfo.getOpenBidStatus()), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        String decrypt = TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "decrypt");
        Assert.isTrue((boolean)"1".equals(decrypt), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u89e3\u5bc6\uff0c\u518d\u7b7e\u540d!"));
        TenderOperationFieldUtils.setFieldValue((Object)tenderProjectSupplier, "1", "signature");
        ((TenderProjectSupplierMapper)this.baseMapper).updateById((Object)tenderProjectSupplier);
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchaseTenderProjectOpenInfoHeadVO projectOpenInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(tenderProjectSupplier.getSubpackageId());
        OpenBidRecordLogUtils.saveRecordMsg(projectOpenInfoHeadVO, "\u6295\u6807\u4eba " + loginUser.getEnterpriseName() + " " + loginUser.getRealname() + " \u5df2\u7b7e\u540d");
    }

    @Override
    public List<SaleTenderPriceOpenings> getSalePriceOpeningsBySubpackageId(String subpackageId) {
        List<PurchaseTenderProjectOpenSettingHead> purchaseTenderProjectOpenSettingHeadList = this.purchaseTenderProjectOpenSettingHeadServiceImpl.selectByMainId(subpackageId);
        Assert.isTrue((!CollectionUtil.isEmpty(purchaseTenderProjectOpenSettingHeadList) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vBGRjSWVImW_7865a794", (String)"\u5f00\u6807\u8bbe\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!"));
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId);
        List<TenderProjectSupplier> tenderProjectSuppliers = this.selectBySubpackageId(querySupplier);
        List supplierAccountList = tenderProjectSuppliers.stream().filter(tenderProjectSupplier -> "1".equals(TenderOperationFieldUtils.getFieldStringValue(tenderProjectSupplier, "decrypt"))).map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
        PurchaseTenderProjectOpenSettingHead purchaseTenderProjectOpenSettingHead = purchaseTenderProjectOpenSettingHeadList.get(0);
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getSubpackageId, (Object)subpackageId);
        if ("0".equals(purchaseTenderProjectOpenSettingHead.getAnnoQuote())) {
            lambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        } else if (!supplierAccountList.isEmpty()) {
            lambdaQueryWrapper.in(BaseEntity::getElsAccount, supplierAccountList);
        }
        lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getCheckType, (Object)tenderCheckType);
        if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.ONE_STEP.getValue().equals(processType)) {
            lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getProcessType, (Object)processType);
        } else if (SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue().equals(tenderCheckType) && SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(processType)) {
            lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getProcessType, (Object)processType);
            lambdaQueryWrapper.eq(SaleTenderPriceOpenings::getCurrentStep, (Object)currentStep);
        }
        List tenderPriceOpeningsList = this.saleTenderPriceOpeningsServiceImpl.list((Wrapper)lambdaQueryWrapper);
        return tenderPriceOpeningsList;
    }

    @Override
    public TenderProjectSupplierMessageVO selectProjectSupplierBySubpackageId(String subpackageId) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSuppliers = this.selectBySubpackageId(querySupplier);
        TenderProjectSupplierMessageVO supplierMessageVO = new TenderProjectSupplierMessageVO();
        BeanUtils.copyProperties((Object)((Object)tenderProjectSuppliers.get(0)), (Object)((Object)supplierMessageVO));
        PurchaseTenderProjectOpenInfoHeadVO openInfoHeadVO = this.subpackageInfoService.queryOpenInfoById(subpackageId);
        String openBidStatus = TenderOperationFieldUtils.getOpenBidStatus((Object)openInfoHeadVO);
        TenderOperationFieldUtils.setOpenBidStatus((Object)supplierMessageVO, openBidStatus);
        PurchaseTenderProjectOpenInfoRecordsService projectOpenInfoRecordsService = (PurchaseTenderProjectOpenInfoRecordsService)SpringUtil.getBean(PurchaseTenderProjectOpenInfoRecordsService.class);
        List<PurchaseTenderProjectOpenInfoRecords> recordsList = projectOpenInfoRecordsService.queryOpenInfoRecordsBySubpackageId(subpackageId);
        supplierMessageVO.setOpenInfoRecordsList(recordsList);
        return supplierMessageVO;
    }

    @Override
    public TenderProjectSupplierInfoVO queryInfoById(String id) {
        TenderProjectSupplierInfoVO tenderProjectSupplierInfoVO = new TenderProjectSupplierInfoVO();
        TenderProjectSupplier tenderProjectSupplier = (TenderProjectSupplier)((Object)((TenderProjectSupplierMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)tenderProjectSupplier)), (String)I18nUtil.translate((String)"", (String)"\u6570\u636e\u4e0d\u5b58\u5728!"));
        BeanUtils.copyProperties((Object)((Object)tenderProjectSupplier), (Object)((Object)tenderProjectSupplierInfoVO));
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(tenderProjectSupplier.getId());
        tenderProjectSupplierInfoVO.setAttachmentInfoList(saleAttachmentDTOList);
        List<PurchaseTenderBidLetter> purchaseTenderBidLetters = this.purchaseTenderBidLetterService.queryPurchaseTenderBidLetter(tenderProjectSupplier.getSubpackageId());
        ArrayList saleTenderBidLetterList = SysUtil.copyProperties(purchaseTenderBidLetters, SaleTenderBidLetterVo.class);
        List<String> bidLetterIds = purchaseTenderBidLetters.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleTenderPriceOpenings> saleTenderPriceOpenings = this.saleTenderPriceOpeningsServiceImpl.queryByBidLetterIdIn(bidLetterIds, tenderProjectSupplier.getSupplierAccount());
        if (CollectionUtil.isNotEmpty(saleTenderPriceOpenings)) {
            Map<String, List<SaleTenderPriceOpenings>> saleTenderPriceOpeningsMap = saleTenderPriceOpenings.stream().collect(Collectors.groupingBy(SaleTenderPriceOpenings::getBidLetterId));
            saleTenderBidLetterList.forEach(saleTenderBidLetter -> {
                List tenderPriceOpenings = (List)saleTenderPriceOpeningsMap.get(saleTenderBidLetter.getId());
                saleTenderBidLetter.setPriceOpeningsList(tenderPriceOpenings);
            });
        }
        tenderProjectSupplierInfoVO.setSaleTenderBidLetterList(saleTenderBidLetterList);
        return tenderProjectSupplierInfoVO;
    }

    @Override
    public void updateInvalidStatusByMainId(String subpackageId, List<String> invalidSupplierAccountList) {
        if (invalidSupplierAccountList.isEmpty()) {
            return;
        }
        ((TenderProjectSupplierMapper)this.baseMapper).updateInvalidStatusByMainId(subpackageId, invalidSupplierAccountList);
    }

    @Override
    public void updateShortlistedStatus(String subpackageId, List<String> shortlistedSupplierAccountList) {
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        ((TenderProjectSupplierMapper)this.baseMapper).updateShortListedStatus(subpackageId, tenderCheckType, tenderProcessType, currentStep, shortlistedSupplierAccountList);
    }

    private void checkParam(TenderProjectSupplier tenderProjectSupplier) {
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getPurchaseEnterpriseAccount()), (String)I18nUtil.translate((String)"", (String)"\u62db\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getSupplierAccount()), (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u5355\u4f4d\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getSupplierName()), (String)I18nUtil.translate((String)"", (String)"\u6295\u6807\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getSubpackageId()), (String)I18nUtil.translate((String)"", (String)"\u5206\u5305ID\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getTenderProjectId()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getTenderProjectNumber()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getTenderProjectName()), (String)I18nUtil.translate((String)"", (String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectSupplier.getSourceType()), (String)I18nUtil.translate((String)"", (String)"\u6570\u636e\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    private void buildParam(TenderProjectSupplier dataSource, TenderProjectSupplier dataTarget) {
        if (!StringUtils.hasText((String)dataTarget.getId())) {
            this.builDefaultParam(dataTarget);
        }
        dataTarget.setSupplierAccount(dataSource.getSupplierAccount());
        dataTarget.setSupplierName(dataSource.getSupplierName());
        dataTarget.setSubpackageId(dataSource.getSubpackageId());
        dataTarget.setTenderProjectId(dataSource.getTenderProjectId());
        dataTarget.setPurchaseEnterpriseAccount(dataSource.getPurchaseEnterpriseAccount());
        dataTarget.setPurchaseEnterpriseName(dataSource.getPurchaseEnterpriseName());
        dataTarget.setSourceType(dataSource.getSourceType());
        dataTarget.setTenderProjectNumber(dataSource.getTenderProjectNumber());
        dataTarget.setTenderProjectName(dataSource.getTenderProjectName());
        dataTarget.setElsAccount(dataSource.getSupplierAccount());
        dataTarget.setCombination(dataSource.getCombination());
        dataTarget.setCombinationName(dataSource.getCombinationName());
        dataTarget.setContacts(dataSource.getContacts());
        dataTarget.setContactsPhone(dataSource.getContactsPhone());
        dataTarget.setRemark(dataSource.getRemark());
        dataTarget.setDataVersion(dataSource.getDataVersion());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateResponseById(TenderProjectSupplier tenderProjectSupplier) {
        int count = ((TenderProjectSupplierMapper)this.baseMapper).updateResponseById(tenderProjectSupplier, TenderFlagInjectionContext.getTenderCheckType());
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    private void builDefaultParam(TenderProjectSupplier tenderProjectSupplier) {
        tenderProjectSupplier.setPreSignIn("0");
        tenderProjectSupplier.setPreDecrypt("0");
        tenderProjectSupplier.setSignature("0");
        tenderProjectSupplier.setPreShortlisted("0");
        tenderProjectSupplier.setSignUp("1");
        tenderProjectSupplier.setInvite("0");
        tenderProjectSupplier.setPurchaseBid("0");
        tenderProjectSupplier.setBail("0");
        tenderProjectSupplier.setDecrypt("0");
        tenderProjectSupplier.setResultDecrypt("0");
        tenderProjectSupplier.setWinner("0");
        tenderProjectSupplier.setOpenBidStatus(PurchaseOpenBidStatusEnum.NOT_OPEN_BID.getValue());
        tenderProjectSupplier.setSignature("0");
        tenderProjectSupplier.setSignIn("0");
        tenderProjectSupplier.setDeleted(CommonConstant.DEL_FLAG_0);
        tenderProjectSupplier.setShortlisted("0");
        tenderProjectSupplier.setResultShortlisted("0");
        PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo = this.subpackageInfoService.selectById(tenderProjectSupplier.getSubpackageId());
        tenderProjectSupplier.setCheckType(purchaseTenderProjectSubpackageInfo.getCheckType());
        tenderProjectSupplier.setSubpackageName(purchaseTenderProjectSubpackageInfo.getSubpackageName());
    }

    @Override
    public PurchaseTenderProjectOpenInfoHeadVO openBidPermission(String subpackageId) {
        TenderProjectSupplier querySupplier = new TenderProjectSupplier().setSubpackageId(subpackageId).setSupplierAccount(TenantContext.getTenant());
        List<TenderProjectSupplier> tenderProjectSupplierList = this.selectBySubpackageId(querySupplier);
        Assert.isTrue((!tenderProjectSupplierList.isEmpty() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tkIHWVXVsKW_58a1a970", (String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5!"));
        TenderProjectSupplier tenderProjectSupplier = tenderProjectSupplierList.get(0);
        Assert.isTrue((boolean)"1".equals(TenderOperationFieldUtils.getFieldStringValue((Object)tenderProjectSupplier, "responseStatus")), (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u5141\u8bb8\u8fdb\u5165\u5f00\u6807\u5927\u5385!"));
        return this.subpackageInfoService.queryOpenInfoById(subpackageId);
    }

    @Override
    public void deleteBySubpackageId(String subpackageId) {
        ((TenderProjectSupplierMapper)this.baseMapper).deleteBySubpackageId(subpackageId);
    }

    @Override
    public void addBatch(PurchaseTenderNoticeHead purchaseTenderNoticeHead, PurchaseTenderProjectSubpackageInfo purchaseTenderProjectSubpackageInfo, List<PurchaseTenderSupplierInvitation> purchaseTenderSupplierInvitationList) {
        ArrayList<TenderProjectSupplier> tenderProjectSupplierList = new ArrayList<TenderProjectSupplier>();
        LoginUser loginUser = SysUtil.getLoginUser();
        for (PurchaseTenderSupplierInvitation invitation : purchaseTenderSupplierInvitationList) {
            TenderProjectSupplier tenderProjectSupplier = new TenderProjectSupplier();
            tenderProjectSupplier.setPurchaseEnterpriseAccount(loginUser.getElsAccount());
            tenderProjectSupplier.setPurchaseEnterpriseName(loginUser.getAliasName());
            tenderProjectSupplier.setSupplierSubAccount("1001");
            tenderProjectSupplier.setSupplierAccount(invitation.getSupplierAccount());
            tenderProjectSupplier.setSupplierName(invitation.getSupplierName());
            tenderProjectSupplier.setSubpackageId(purchaseTenderNoticeHead.getSubpackageId());
            tenderProjectSupplier.setSubpackageName(purchaseTenderProjectSubpackageInfo.getSubpackageName());
            tenderProjectSupplier.setTenderProjectId(purchaseTenderNoticeHead.getTenderProjectId());
            tenderProjectSupplier.setTenderProjectName(purchaseTenderProjectSubpackageInfo.getTenderProjectName());
            tenderProjectSupplier.setSourceType("0");
            tenderProjectSupplierList.add(tenderProjectSupplier);
        }
        this.saveBatch(tenderProjectSupplierList);
    }
}

