/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingNotice;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingItemMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingNoticeMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingProjectHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingNoticeService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.vo.PurchaseBiddingProjectHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseBiddingProjectHeadServiceImpl
extends BaseServiceImpl<PurchaseBiddingProjectHeadMapper, PurchaseBiddingProjectHead>
implements PurchaseBiddingProjectHeadService {
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private PurchaseBiddingNoticeService purchaseBiddingNoticeService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Resource
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Resource
    private PurchaseBiddingNoticeMapper purchaseBiddingNoticeMapper;
    @Resource
    private PurchaseBiddingItemMapper purchaseBiddingItemMapper;
    @Resource
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;

    protected void setHeadDefaultValue(PurchaseBiddingHead t) {
        Field[] fields;
        String busAccount;
        Map map = BeanUtil.beanToMap((Object)((Object)t));
        String templateNumber = String.valueOf(map.get("templateNumber"));
        String templateVersion = String.valueOf(map.get("templateVersion"));
        String string = busAccount = map.get("templateAccount") == null ? String.valueOf(map.get("busAccount")) : String.valueOf(map.get("templateAccount"));
        if (StrUtil.isBlank((CharSequence)busAccount)) {
            busAccount = map.get("busAccount") == null ? String.valueOf(map.get("elsAccount")) : String.valueOf(map.get("busAccount"));
        }
        InvokeBaseRpcService invokeBaseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
        Map defaultMap = invokeBaseRpcService.getDefaultVauleMap(busAccount, templateNumber, templateVersion);
        for (Field field : fields = ConvertUtils.getAllFields((Object)((Object)t))) {
            try {
                field.setAccessible(true);
                Object value = field.get((Object)t);
                if (value != null && !StrUtil.isBlank((CharSequence)value.toString()) || !defaultMap.containsKey(field.getName())) continue;
                field.set((Object)t, defaultMap.get(field.getName()));
            }
            catch (Exception e) {
                this.log.error("\u53cd\u5c04\u5f02\u5e38" + e.getMessage());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseBiddingProjectHead purchaseBiddingProjectHead, List<PurchaseBiddingHead> purchaseBiddingHeadList, List<PurchaseBiddingItem> purchaseBiddingItemList, List<PurchaseBiddingNotice> purchaseBiddingNoticeList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<BiddingSupplier> biddingSupplierList) {
        if (StringUtils.isBlank((CharSequence)purchaseBiddingProjectHead.getProjectNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmBiddingProjectNumber", (Object)purchaseBiddingProjectHead);
            purchaseBiddingProjectHead.setProjectNumber(nextCode);
        }
        purchaseBiddingProjectHead.setBusAccount(TenantContext.getTenant());
        ((PurchaseBiddingProjectHeadMapper)this.baseMapper).insert((Object)purchaseBiddingProjectHead);
        super.setHeadDefaultValue((BaseEntity)purchaseBiddingProjectHead);
        this.insertData(purchaseBiddingProjectHead, purchaseBiddingHeadList, purchaseBiddingItemList, purchaseBiddingNoticeList, purchaseBiddingSpecialistList, biddingSupplierList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseBiddingProjectHead purchaseBiddingProjectHead, List<PurchaseBiddingHead> purchaseBiddingHeadList, List<PurchaseBiddingItem> purchaseBiddingItemList, List<PurchaseBiddingNotice> purchaseBiddingNoticeList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<BiddingSupplier> biddingSupplierList) {
        int count;
        if (StringUtils.isBlank((CharSequence)purchaseBiddingProjectHead.getProjectNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmBiddingProjectNumber", (Object)purchaseBiddingProjectHead);
            purchaseBiddingProjectHead.setProjectNumber(nextCode);
        }
        if (StringUtils.isBlank((CharSequence)purchaseBiddingProjectHead.getPublishAudit()) || "0".equals(purchaseBiddingProjectHead.getPublishAudit())) {
            purchaseBiddingProjectHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        Assert.isTrue(((count = ((PurchaseBiddingProjectHeadMapper)this.baseMapper).updateById((Object)purchaseBiddingProjectHead)) != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseBiddingHeadMapper.deleteByProjectId(purchaseBiddingProjectHead.getId());
        this.purchaseBiddingItemMapper.deleteByProjectId(purchaseBiddingProjectHead.getId());
        this.purchaseBiddingSpecialistMapper.deleteByProjectId(purchaseBiddingProjectHead.getId());
        this.biddingSupplierMapper.deleteByProjectId(purchaseBiddingProjectHead.getId());
        this.insertData(purchaseBiddingProjectHead, purchaseBiddingHeadList, purchaseBiddingItemList, purchaseBiddingNoticeList, purchaseBiddingSpecialistList, biddingSupplierList);
    }

    private void insertData(PurchaseBiddingProjectHead purchaseBiddingProjectHead, List<PurchaseBiddingHead> purchaseBiddingHeadList, List<PurchaseBiddingItem> purchaseBiddingItemList, List<PurchaseBiddingNotice> purchaseBiddingNoticeList, List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList, List<BiddingSupplier> biddingSupplierList) {
        Map<Object, Object> stringPurchaseBiddingHeadHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(purchaseBiddingHeadList)) {
            ArrayList<PurchaseBiddingHead> biddingHeads = new ArrayList<PurchaseBiddingHead>();
            for (PurchaseBiddingHead purchaseBiddingHead : purchaseBiddingHeadList) {
                PurchaseBiddingHead purchaseBiddingHead2 = new PurchaseBiddingHead();
                purchaseBiddingHead.setProjectId(purchaseBiddingProjectHead.getId());
                purchaseBiddingHead.setBusAccount(purchaseBiddingProjectHead.getBusAccount());
                SysUtil.setSysParam((BaseEntity)purchaseBiddingHead, (BaseEntity)purchaseBiddingProjectHead);
                BeanUtils.copyProperties((Object)((Object)purchaseBiddingProjectHead), (Object)((Object)purchaseBiddingHead2), (String[])PurchaseBiddingProjectHeadServiceImpl.getNullPropertyNames((Object)((Object)purchaseBiddingProjectHead)));
                BeanUtils.copyProperties((Object)((Object)purchaseBiddingHead), (Object)((Object)purchaseBiddingHead2), (String[])PurchaseBiddingProjectHeadServiceImpl.getNullPropertyNames((Object)((Object)purchaseBiddingHead)));
                purchaseBiddingHead2.setId(null);
                this.setHeadDefaultValue(purchaseBiddingHead2);
                purchaseBiddingHead2.setBiddingNumber(this.invokeBaseRpcService.getNextCode("srmBiddingNumber", (Object)purchaseBiddingHead));
                purchaseBiddingHead2.setCreateType("project");
                biddingHeads.add(purchaseBiddingHead2);
            }
            this.purchaseBiddingHeadService.saveBatch(biddingHeads, 2000);
            stringPurchaseBiddingHeadHashMap = biddingHeads.stream().collect(Collectors.toMap(PurchaseBiddingHead::getBiddingDesc, Function.identity(), (Key1, key2) -> key2));
        }
        HashMap<String, Integer> integerHashMap = new HashMap<String, Integer>();
        if (!CollectionUtils.isEmpty(purchaseBiddingItemList)) {
            for (PurchaseBiddingItem purchaseBiddingItem : purchaseBiddingItemList) {
                purchaseBiddingItem.setProjectId(purchaseBiddingProjectHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseBiddingItem, (BaseEntity)purchaseBiddingProjectHead);
                if (!StringUtils.isNotBlank((CharSequence)purchaseBiddingItem.getHeadName()) || !stringPurchaseBiddingHeadHashMap.containsKey(purchaseBiddingItem.getHeadName())) continue;
                PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)stringPurchaseBiddingHeadHashMap.get(purchaseBiddingItem.getHeadName()));
                purchaseBiddingItem.setHeadId(((PurchaseBiddingHead)((Object)stringPurchaseBiddingHeadHashMap.get(purchaseBiddingItem.getHeadName()))).getId());
                SysUtil.setSysParam((BaseEntity)purchaseBiddingItem, (BaseEntity)((BaseEntity)stringPurchaseBiddingHeadHashMap.get(purchaseBiddingItem.getHeadName())));
                purchaseBiddingItem.setId(null);
                purchaseBiddingItem.setDocumentId(biddingHead.getDocumentId());
                purchaseBiddingItem.setBiddingNumber(biddingHead.getBiddingNumber());
                purchaseBiddingItem.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                purchaseBiddingItem.setItemStatus(BiddingItemStatusEnum.NEW.getValue());
                purchaseBiddingItem.setCurrentRound(1);
                if (integerHashMap.containsKey(biddingHead.getId())) {
                    purchaseBiddingItem.setItemNumber(String.valueOf((Integer)integerHashMap.get(biddingHead.getId()) + 1));
                    integerHashMap.put(biddingHead.getId(), (Integer)integerHashMap.get(biddingHead.getId()) + 1);
                    continue;
                }
                purchaseBiddingItem.setItemNumber("1");
                integerHashMap.put(biddingHead.getId(), 1);
            }
            this.purchaseBiddingItemService.saveBatch(purchaseBiddingItemList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseBiddingNoticeList)) {
            for (PurchaseBiddingNotice purchaseBiddingNotice : purchaseBiddingNoticeList) {
                if (StringUtils.isNotBlank((CharSequence)purchaseBiddingNotice.getHeadName()) && stringPurchaseBiddingHeadHashMap.containsKey(purchaseBiddingNotice.getHeadName())) {
                    purchaseBiddingNotice.setHeadId(((PurchaseBiddingHead)((Object)stringPurchaseBiddingHeadHashMap.get(purchaseBiddingNotice.getHeadName()))).getId());
                }
                purchaseBiddingNotice.setProjectId(purchaseBiddingProjectHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseBiddingNotice, (BaseEntity)purchaseBiddingProjectHead);
            }
            this.purchaseBiddingNoticeService.saveBatch(purchaseBiddingNoticeList, 2000);
        }
        if (!CollectionUtils.isEmpty(purchaseBiddingSpecialistList)) {
            for (PurchaseBiddingSpecialist purchaseBiddingSpecialist : purchaseBiddingSpecialistList) {
                if (StringUtils.isNotBlank((CharSequence)purchaseBiddingSpecialist.getHeadName()) && stringPurchaseBiddingHeadHashMap.containsKey(purchaseBiddingSpecialist.getHeadName())) {
                    purchaseBiddingSpecialist.setHeadId(((PurchaseBiddingHead)((Object)stringPurchaseBiddingHeadHashMap.get(purchaseBiddingSpecialist.getHeadName()))).getId());
                }
                purchaseBiddingSpecialist.setProjectId(purchaseBiddingProjectHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseBiddingSpecialist, (BaseEntity)purchaseBiddingProjectHead);
            }
            this.purchaseBiddingSpecialistService.saveBatch(purchaseBiddingSpecialistList, 2000);
        }
        if (!CollectionUtils.isEmpty(biddingSupplierList)) {
            for (BiddingSupplier biddingSupplier : biddingSupplierList) {
                if (StringUtils.isNotBlank((CharSequence)biddingSupplier.getHeadName()) && stringPurchaseBiddingHeadHashMap.containsKey(biddingSupplier.getHeadName())) {
                    biddingSupplier.setHeadId(((PurchaseBiddingHead)((Object)stringPurchaseBiddingHeadHashMap.get(biddingSupplier.getHeadName()))).getId());
                }
                biddingSupplier.setProjectId(purchaseBiddingProjectHead.getId());
                SysUtil.setSysParam((BaseEntity)biddingSupplier, (BaseEntity)purchaseBiddingProjectHead);
            }
            this.biddingSupplierService.saveBatch(biddingSupplierList, 2000);
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        QueryWrapper purchaseBiddingHeadQueryWrapper = new QueryWrapper();
        purchaseBiddingHeadQueryWrapper.lambda().eq(PurchaseBiddingHead::getProjectId, (Object)id);
        this.purchaseBiddingHeadService.delete((Wrapper<PurchaseBiddingHead>)purchaseBiddingHeadQueryWrapper);
        QueryWrapper purchaseBiddingItemQueryWrapper = new QueryWrapper();
        purchaseBiddingItemQueryWrapper.lambda().eq(PurchaseBiddingItem::getProjectId, (Object)id);
        this.purchaseBiddingItemService.delete((Wrapper<PurchaseBiddingItem>)purchaseBiddingItemQueryWrapper);
        QueryWrapper purchaseBiddingSpecialistQueryWrapper = new QueryWrapper();
        purchaseBiddingSpecialistQueryWrapper.lambda().eq(PurchaseBiddingSpecialist::getProjectId, (Object)id);
        this.purchaseBiddingSpecialistService.delete((Wrapper<PurchaseBiddingSpecialist>)purchaseBiddingSpecialistQueryWrapper);
        QueryWrapper biddingSupplierQueryWrapper = new QueryWrapper();
        biddingSupplierQueryWrapper.lambda().eq(BiddingSupplier::getProjectId, (Object)id);
        this.biddingSupplierService.delete((Wrapper<BiddingSupplier>)biddingSupplierQueryWrapper);
        ((PurchaseBiddingProjectHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void publishBiddingProject(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseBiddingProjectHead::getProjectStatus, (Object)"1")).set(PurchaseBiddingProjectHead::getPublishUser, (Object)this.getLoginSubAndName())).set(PurchaseBiddingProjectHead::getPublishTime, (Object)new Date())).update();
    }

    public static void checkAndSetProjectParam(PurchaseBiddingProjectHeadVO biddingProjectHeadVO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<PurchaseBiddingHead> purchaseBiddingHeadList = biddingProjectHeadVO.getPurchaseBiddingHeadList();
        List<PurchaseBiddingItem> purchaseBiddingItemList = biddingProjectHeadVO.getPurchaseBiddingItemList();
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList = biddingProjectHeadVO.getPurchaseBiddingSpecialistList();
        Map<String, List> biddItemMap = purchaseBiddingItemList.stream().collect(Collectors.toMap(new Function<PurchaseBiddingItem, String>(){

            @Override
            public String apply(PurchaseBiddingItem p) {
                return p.getHeadName();
            }
        }, p -> {
            ArrayList<PurchaseBiddingItem> getNameList = new ArrayList<PurchaseBiddingItem>();
            getNameList.add((PurchaseBiddingItem)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        Map<String, List> biddSpeciaMap = purchaseBiddingSpecialistList.stream().collect(Collectors.toMap(new Function<PurchaseBiddingSpecialist, String>(){

            @Override
            public String apply(PurchaseBiddingSpecialist p) {
                return p.getHeadName();
            }
        }, p -> {
            ArrayList<PurchaseBiddingSpecialist> getNameList = new ArrayList<PurchaseBiddingSpecialist>();
            getNameList.add((PurchaseBiddingSpecialist)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        for (PurchaseBiddingHead head : purchaseBiddingHeadList) {
            head.setBiddingStatus(BiddingStatusEnum.BIDDING.getValue());
            head.setPublishTime(new Date());
            head.setPublishUser(loginUser.getSubAccount());
            head.setCurrentRound(1);
            String needEcho = head.getNeedEcho();
            Date echoEndTime = head.getEchoEndTime();
            Date applyEndTime = head.getApplyEndTime();
            String biddingType = head.getBiddingType();
            Assert.hasText((String)biddingType, (String)I18nUtil.translate((String)"i18n_alert_empty_bid_type_not_empty_bidding", (String)"\u62db\u6807\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            if (!"1".equals(head.getPublishAudit())) {
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            if (!"1".equals(head.getResultAudit())) {
                head.setResultAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            }
            Date bidBeginTime = head.getBidBeginTime();
            Date bidEndTime = head.getBidEndTime();
            String purchasePrincipal = head.getPurchasePrincipal();
            Assert.hasText((String)purchasePrincipal, (String)I18nUtil.translate((String)"i18n_alert_empty_principal", (String)"\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            Assert.notEmpty((Collection)biddItemMap.get(head.getBiddingDesc()), (String)I18nUtil.translate((String)"i18n_alert_oper_must_create_one_row", (String)"\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u884c\u9879\u76ee\uff01"));
            Assert.notEmpty((Collection)biddSpeciaMap.get(head.getBiddingDesc()), (String)I18nUtil.translate((String)"i18n_alert_RRSuImdILj_8b7c328a", (String)"\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u9879\u76ee\u6210\u5458\uff01"));
            Integer participateQuantity = head.getParticipateQuantity();
            Assert.isTrue((participateQuantity != null && participateQuantity > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_parameter_num_must_gt_zero", (String)"\u53c2\u4e0e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01"));
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        QueryWrapper purchaseBiddingHeadQueryWrapper = new QueryWrapper();
        purchaseBiddingHeadQueryWrapper.lambda().in(PurchaseBiddingHead::getProjectId, idList);
        this.purchaseBiddingHeadService.delete((Wrapper<PurchaseBiddingHead>)purchaseBiddingHeadQueryWrapper);
        QueryWrapper purchaseBiddingItemQueryWrapper = new QueryWrapper();
        purchaseBiddingItemQueryWrapper.lambda().in(PurchaseBiddingItem::getProjectId, idList);
        this.purchaseBiddingItemService.delete((Wrapper<PurchaseBiddingItem>)purchaseBiddingItemQueryWrapper);
        QueryWrapper purchaseBiddingSpecialistQueryWrapper = new QueryWrapper();
        purchaseBiddingSpecialistQueryWrapper.lambda().in(PurchaseBiddingSpecialist::getProjectId, idList);
        this.purchaseBiddingSpecialistService.delete((Wrapper<PurchaseBiddingSpecialist>)purchaseBiddingSpecialistQueryWrapper);
        QueryWrapper biddingSupplierQueryWrapper = new QueryWrapper();
        biddingSupplierQueryWrapper.lambda().in(BiddingSupplier::getProjectId, idList);
        this.biddingSupplierService.delete((Wrapper<BiddingSupplier>)biddingSupplierQueryWrapper);
        for (Serializable serializable : idList) {
            ((PurchaseBiddingProjectHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copyData(PurchaseBiddingProjectHeadVO purchaseBiddingProjectHeadVO) {
        List<BiddingSupplier> biddingSupplierList;
        List<PurchaseBiddingSpecialist> purchaseBiddingSpecialistList;
        List<PurchaseBiddingNotice> purchaseBiddingNoticeList;
        List<PurchaseBiddingItem> purchaseBiddingItemList;
        purchaseBiddingProjectHeadVO.setId(null);
        purchaseBiddingProjectHeadVO.setCreateBy(TenantContext.getTenant());
        purchaseBiddingProjectHeadVO.setCreateTime(new Date());
        purchaseBiddingProjectHeadVO.setUpdateBy(null);
        purchaseBiddingProjectHeadVO.setUpdateTime(null);
        purchaseBiddingProjectHeadVO.setProjectNumber(null);
        List<PurchaseBiddingHead> purchaseBiddingHeadList = purchaseBiddingProjectHeadVO.getPurchaseBiddingHeadList();
        if (CollectionUtil.isNotEmpty(purchaseBiddingHeadList)) {
            purchaseBiddingHeadList.parallelStream().forEach(item -> item.setId(null));
        }
        if (CollectionUtil.isNotEmpty(purchaseBiddingItemList = purchaseBiddingProjectHeadVO.getPurchaseBiddingItemList())) {
            purchaseBiddingItemList.parallelStream().forEach(item -> item.setId(null));
        }
        if (CollectionUtil.isNotEmpty(purchaseBiddingNoticeList = purchaseBiddingProjectHeadVO.getPurchaseBiddingNoticeList())) {
            purchaseBiddingNoticeList.parallelStream().forEach(item -> item.setId(null));
        }
        if (CollectionUtil.isNotEmpty(purchaseBiddingSpecialistList = purchaseBiddingProjectHeadVO.getPurchaseBiddingSpecialistList())) {
            purchaseBiddingSpecialistList.parallelStream().forEach(item -> item.setId(null));
        }
        if (CollectionUtil.isNotEmpty(biddingSupplierList = purchaseBiddingProjectHeadVO.getBiddingSupplierList())) {
            biddingSupplierList.parallelStream().forEach(item -> item.setId(null));
        }
        PurchaseBiddingProjectHead purchaseBiddingProjectHead = (PurchaseBiddingProjectHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseBiddingProjectHeadVO), PurchaseBiddingProjectHead.class));
        this.saveMain(purchaseBiddingProjectHead, purchaseBiddingHeadList, purchaseBiddingItemList, purchaseBiddingNoticeList, purchaseBiddingSpecialistList, biddingSupplierList);
    }
}

