/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="purchaseRequestHeadExcelImportServiceImpl")
public class PurchaseRequestHeadExcelImportServiceImpl
implements ExcelImportRpcService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    PurchaseRequestHeadService purchaseRequestHeadService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("purchaseRequest");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"i18n_alert_VWERnRUVESIr_166c6821", (String)"\u8bf7\u5148\u914d\u7f6e\u91c7\u8d2d\u7533\u8bf7\u4e1a\u52a1\u6a21\u677f"));
        Assert.notEmpty((Collection)dataList, (String)I18nUtil.translate((String)"i18n_alert_uNjWFdjdxOOLV_324a56d6", (String)"\u5bfc\u5165\u7684\u6570\u636e\u6240\u6709\u9879\u4e0d\u80fd\u90fd\u4e3a\u7a7a"));
        ArrayList<String> requestNumberList = new ArrayList<String>();
        for (Map data : dataList) {
            PurchaseRequestHead head = (PurchaseRequestHead)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseRequestHead.class));
            if (!StringUtils.isNotEmpty((CharSequence)head.getRequestNumber())) continue;
            requestNumberList.add(head.getRequestNumber());
        }
        if (ObjectUtils.isNotEmpty(requestNumberList)) {
            Map<String, Long> map = requestNumberList.stream().collect(Collectors.groupingBy(number -> number, Collectors.counting()));
            List repeatList = map.keySet().stream().filter(key -> (Long)map.get(key) > 1L).collect(Collectors.toList());
            if (ObjectUtils.isNotEmpty((Object)repeatList)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWMKVBWFWxquN_731fa99e", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7[${0}]\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u4e0d\u53ef\u5bfc\u5165", (String[])new String[]{repeatList.get(0).toString()}));
            }
            List purchaseRequestHeadList = ((LambdaQueryChainWrapper)this.purchaseRequestHeadService.lambdaQuery().in(PurchaseRequestHead::getRequestNumber, requestNumberList)).list();
            if (ObjectUtils.isNotEmpty((Object)purchaseRequestHeadList)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWIKHeMKWxqVBuN_3af2e9e2", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7[${0}]\u5df2\u5728\u7cfb\u7edf\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u5bfc\u5165", (String[])new String[]{((PurchaseRequestHead)((Object)purchaseRequestHeadList.get(0))).getRequestNumber()}));
            }
        }
        ArrayList<PurchaseRequestHead> entityList = new ArrayList<PurchaseRequestHead>();
        for (Map data : dataList) {
            PurchaseRequestHead entity = (PurchaseRequestHead)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), PurchaseRequestHead.class));
            entity.setElsAccount(TenantContext.getTenant());
            entity.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
            entity.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
            entity.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
            entity.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion() + "");
            entity.setApplyDate(new Date());
            entity.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
            entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            if ("0".equals(entity.getAudit())) {
                entity.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
            } else if ("1".equals(entity.getAudit()) && AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(entity.getAuditStatus())) {
                entity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            }
            entityList.add(entity);
        }
        if (CollUtil.isEmpty(entityList)) {
            return dataList;
        }
        PurchaseRequestHead head = (PurchaseRequestHead)((Object)entityList.get(0));
        long size = entityList.stream().map(PurchaseRequestHead::getRequestNumber).filter(CharSequenceUtil::isEmpty).count();
        List nextCodes = this.invokeBaseRpcService.getNextCodes("srmPurchaseRequestNumber", (Object)head, (int)size);
        int codeIndex = 0;
        for (PurchaseRequestHead e : entityList) {
            if (!CharSequenceUtil.isEmpty((CharSequence)e.getRequestNumber())) continue;
            e.setRequestNumber((String)nextCodes.get(codeIndex++));
        }
        this.purchaseRequestHeadService.saveBatch(entityList);
        return dataList;
    }
}

