/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.alert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.service.AlertRpcService;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquiryNotQuoteAlertServiceImpl
implements AlertRpcService {
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    public List<?> getAlertList(JSONObject config) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.RE_QUOTE.getValue()});
        wrapper.gt(PurchaseEnquiryItem::getQuoteEndTime, (Object)LocalDateTime.now());
        return this.purchaseEnquiryItemService.list((Wrapper)wrapper);
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, JSONObject config) {
        String noticeToPrincipal;
        ArrayList<ElsSubAccountDTO> result = new ArrayList<ElsSubAccountDTO>();
        JSONObject object = (JSONObject)JSONObject.toJSON((Object)obj);
        PurchaseEnquiryItem item = (PurchaseEnquiryItem)((Object)JSONObject.toJavaObject((JSON)object, PurchaseEnquiryItem.class));
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)item.getHeadId())));
        String noticePrincipal = config.getString("noticePrincipal");
        if ("1".equals(noticePrincipal)) {
            String purchasePrincipal = head.getPurchasePrincipal();
            String subAccount = StringUtils.isBlank((CharSequence)purchasePrincipal) ? "1001" : purchasePrincipal.split("_")[0];
            ElsSubAccountDTO account = this.invokeAccountRpcService.getAccount(head.getElsAccount(), subAccount);
            result.add(account);
        }
        if ("1".equals(noticeToPrincipal = config.getString("noticeToPrincipal"))) {
            List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(head.getId());
            Map supplierMap = supplierList.stream().collect(Collectors.toMap(EnquirySupplierList::getToElsAccount, Function.identity()));
            EnquirySupplierList dbSupplier = (EnquirySupplierList)((Object)supplierMap.get(item.getToElsAccount()));
            String supplierPrincipal = dbSupplier == null ? "" : dbSupplier.getSupplierPrincipal();
            String subAccount = StringUtils.isBlank((CharSequence)supplierPrincipal) ? "1001" : supplierPrincipal.split("_")[0];
            ElsSubAccountDTO account = this.invokeAccountRpcService.getAccount(head.getElsAccount(), subAccount);
            result.add(account);
        }
        return result;
    }

    public String buildUrlParam(Object obj) {
        JSONObject object = (JSONObject)JSONObject.toJSON((Object)obj);
        PurchaseEnquiryItem item = (PurchaseEnquiryItem)((Object)JSONObject.toJavaObject((JSON)object, PurchaseEnquiryItem.class));
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)item.getHeadId())));
        JSONObject param = new JSONObject();
        object.put("id", (Object)head.getId());
        object.put("templateNumber", (Object)head.getTemplateNumber());
        object.put("templateVersion", (Object)head.getTemplateVersion());
        object.put("busAccount", (Object)head.getBusAccount());
        object.put("supplierTaxRate", (Object)head.getSupplierTaxRate());
        return SysUtil.getUrlParamByJson((JSONObject)param);
    }
}

