/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.rocketMq.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.LoginUserContext;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.vo.PurchaseEnquiryHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class PublishEnquiryConsumer {
    private static final Logger log = LoggerFactory.getLogger(PublishEnquiryConsumer.class);
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @StreamListener(value="inputPublishEnquiry")
    @SrmTransaction
    public void publish(Message<String> message) {
        String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
        String msgStatus = this.invokeBaseRpcService.getMsgStatusById(key);
        if ("1".equals(msgStatus)) {
            log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
            return;
        }
        String errorInfo = "";
        String msgBody = (String)message.getPayload();
        JSONObject body = JSONObject.parseObject((String)msgBody);
        PurchaseEnquiryHeadVO headVO = (PurchaseEnquiryHeadVO)((Object)JSONObject.toJavaObject((JSON)body.getJSONObject("content"), PurchaseEnquiryHeadVO.class));
        try {
            LoginUser user = (LoginUser)JSONObject.toJavaObject((JSON)body.getJSONObject("user"), LoginUser.class);
            String tenant = body.getString("tenant");
            TenantContext.setTenant((String)tenant);
            LoginUserContext.setUser((LoginUser)user);
            PurchaseEnquiryHead head = new PurchaseEnquiryHead();
            head.setId(headVO.getId());
            head.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
            this.purchaseEnquiryHeadService.updateById((Object)head);
            headVO.setEnquiryStatus(EnquiryStatusEnum.QUOTING.getValue());
            this.purchaseEnquiryHeadService.publishEnquiry(headVO, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList(), user.getEnterpriseName(), user.getSubAccount());
            msgStatus = "1";
        }
        catch (Exception e) {
            log.error("PublishEnquiryConsumer_receive_msgBody:" + msgBody, (Throwable)e);
            errorInfo = e.getMessage();
            msgStatus = "2";
            PurchaseEnquiryHead head = new PurchaseEnquiryHead();
            head.setId(headVO.getId());
            head.setEnquiryStatus(EnquiryStatusEnum.PUBLISH_FAILED.getValue());
            this.purchaseEnquiryHeadService.updateById((Object)head);
            this.purchaseEnquiryHeadService.insertData(headVO, headVO.getPurchaseEnquiryItemList(), headVO.getEnquirySupplierListList(), headVO.getPurchaseAttachmentDemandList());
        }
        finally {
            this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
            TenantContext.clear();
            LoginUserContext.clear();
        }
    }
}

