/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.inquiry.api.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.calibration.entity.BidWinningAffirmNotice;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmItemStatusEnum;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmNoticeEnum;
import com.els.modules.tender.calibration.mapper.BidWinningAffirmNoticeMapper;
import com.els.modules.tender.calibration.service.BidWinningAffirmNoticeService;
import com.els.modules.tender.calibration.service.impl.BidWinningAffirmItemServiceImpl;
import com.els.modules.tender.calibration.vo.BidWinningAffirmNoticeVo;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeStatusEnum;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class BidWinningAffirmNoticeServiceImpl
extends BaseServiceImpl<BidWinningAffirmNoticeMapper, BidWinningAffirmNotice>
implements BidWinningAffirmNoticeService {
    @Autowired
    private BidWinningAffirmItemServiceImpl bidWinningAffirmServiceImpl;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(BidWinningAffirmNotice bidWinningAffirmNotice) {
        bidWinningAffirmNotice.setAffirmNoticeNumber(this.invokeBaseRpcService.getNextCode("tenderAffirmNoticeNumber", (Object)bidWinningAffirmNotice));
        ((BidWinningAffirmNoticeMapper)this.baseMapper).insert((Object)bidWinningAffirmNotice);
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_EDIT.getValue() + "");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(BidWinningAffirmNotice bidWinningAffirmNotice) {
        int count = ((BidWinningAffirmNoticeMapper)this.baseMapper).updateById((Object)bidWinningAffirmNotice);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_EDIT.getValue() + "");
    }

    @Override
    public void delete(String id) {
        ((BidWinningAffirmNoticeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((BidWinningAffirmNoticeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public BidWinningAffirmNoticeVo queryBySubpackageId(String subpackageId) {
        BidWinningAffirmNoticeVo vo = new BidWinningAffirmNoticeVo();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BidWinningAffirmNotice::getSubpackageId, (Object)subpackageId);
        List bidWinningAffirmNotice = this.list((Wrapper)queryWrapper);
        if (!bidWinningAffirmNotice.isEmpty()) {
            BeanUtils.copyProperties(bidWinningAffirmNotice.get(0), (Object)((Object)vo));
        }
        List<BidWinningAffirmItem> winningAffirmItemList = this.bidWinningAffirmServiceImpl.queryBidWinningAffirmBySubpackageId(subpackageId);
        vo.setBidWinningAffirmList(winningAffirmItemList);
        return vo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)this.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        bidWinningAffirmNotice.setAuditStatus(outputParamVO.getAuditStatus());
        bidWinningAffirmNotice.setFlowId(outputParamVO.getProcessRootId());
        bidWinningAffirmNotice.setWorkFlowType(outputParamVO.getBpmnType());
        String auditStatus = outputParamVO.getAuditStatus();
        String subPackageStatus = null;
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.ISSUE.getValue());
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_FINISH.getValue() + "";
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.NEW.getValue());
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_REJECT.getValue() + "";
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.NEW.getValue());
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_REJECT.getValue() + "";
        } else {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.NOT_ISSUE.getValue());
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_AUDIT.getValue() + "";
        }
        ((BidWinningAffirmNoticeMapper)this.baseMapper).updateById((Object)bidWinningAffirmNotice);
        this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, subPackageStatus);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus) && "1".equals(bidWinningAffirmNotice.getNotice())) {
            this.publishSysNotice(bidWinningAffirmNotice);
        }
    }

    private void updateTenderProjectSubpackageInfo(BidWinningAffirmNotice attachmentHead, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)attachmentHead).subpackageId(attachmentHead.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(BidWinningAffirmNoticeVo winningAffirmNoticeVo) {
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)((BidWinningAffirmNoticeMapper)this.baseMapper).selectById((Serializable)((Object)winningAffirmNoticeVo.getId())));
        BidWinningAffirmNoticeVo noticeVo = this.queryBySubpackageId(bidWinningAffirmNotice.getSubpackageId());
        this.checkParam(noticeVo);
        if ("1".equals(bidWinningAffirmNotice.getAudit())) {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(winningAffirmNoticeVo.getId());
            dto.setBusinessType("bidWinningAffirmNotice");
            dto.setAuditSubject("\u4e2d\u6807\u516c\u544a\u5ba1\u6279 \u5355\u53f7: " + bidWinningAffirmNotice.getAffirmNoticeNumber());
            dto.setParams(JSONObject.toJSONString((Object)((Object)bidWinningAffirmNotice)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
        } else {
            bidWinningAffirmNotice.setStatus(BidWinningAffirmNoticeEnum.ISSUE.getValue());
            ((BidWinningAffirmNoticeMapper)this.baseMapper).updateById((Object)bidWinningAffirmNotice);
            this.updateTenderProjectSubpackageInfo(bidWinningAffirmNotice, TenderProjectSubpackageStatusEnum.BID_NOTICE_PUBLICITY_FINISH.getValue() + "");
            if ("1".equals(bidWinningAffirmNotice.getNotice())) {
                this.publishSysNotice(bidWinningAffirmNotice);
            }
        }
    }

    @Override
    public void publishSysNotice(BidWinningAffirmNotice bidWinningAffirmNotice) {
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(bidWinningAffirmNotice.getElsAccount());
        notice.setBusinessType(SourceTypeEnum.TENDER_WINBULLETIN.getValue());
        notice.setBusinessId(bidWinningAffirmNotice.getSubpackageId());
        notice.setTemplateNumber(bidWinningAffirmNotice.getTemplateNumber());
        notice.setTemplateVersion(bidWinningAffirmNotice.getTemplateVersion());
        notice.setTemplateAccount(bidWinningAffirmNotice.getTemplateAccount());
        notice.setNoticeTitle(bidWinningAffirmNotice.getNoticeTitle());
        notice.setNoticeContent(bidWinningAffirmNotice.getNoticeContent());
        notice.setNoticeType(PurchaseSysNoticeTypeEnum.CONVENTION_NOTICE.getValue());
        notice.setNoticeStatus(PurchaseSysNoticeStatusEnum.ISSUE.getValue());
        notice.setNoticeScope(bidWinningAffirmNotice.getNoticeRange());
        notice.setTop("1");
        Date newDate = new Date();
        notice.setEffectiveTime(bidWinningAffirmNotice.getNoticeStartTime());
        notice.setPublishTime(newDate);
        Date expiryTime = bidWinningAffirmNotice.getNoticeEndTime();
        notice.setExpiryTime(expiryTime);
        List emptyList = Collections.EMPTY_LIST;
        notice.setElsAccount(bidWinningAffirmNotice.getElsAccount());
        this.inquiryInvokeMessageRpcService.publish(notice, emptyList, emptyList);
    }

    @Override
    public BidWinningAffirmNotice queryById(String id) {
        return (BidWinningAffirmNotice)((Object)((BidWinningAffirmNoticeMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public void checkParam(BidWinningAffirmNoticeVo winningAffirmNoticeVo) {
        List<BidWinningAffirmItem> bidWinningAffirmList = winningAffirmNoticeVo.getBidWinningAffirmList();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(bidWinningAffirmList), (String)I18nUtil.translate((String)"i18n_alert_YBLWFxOLVW_35ac4165", (String)"\u62db\u6807\u4eba\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)winningAffirmNoticeVo.getSubpackageId(), (String)I18nUtil.translate((String)"i18n_alert_zsAyxOLVW_b97c71", (String)"\u5206\u5305\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)winningAffirmNoticeVo.getNotice(), (String)I18nUtil.translate((String)"i18n_alert_KQRKW_c7747d5c", (String)"\u662f\u5426\u516c\u793a!"));
        Assert.isTrue((null != winningAffirmNoticeVo.getNoticeEndTime() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_RxyWKIxOLVW_d2cb09", (String)"\u516c\u544a\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)winningAffirmNoticeVo.getNoticeTitle(), (String)I18nUtil.translate((String)"i18n_alert_RKBDxOLVW_114c4232", (String)"\u516c\u793a\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)winningAffirmNoticeVo.getNoticeRange(), (String)I18nUtil.translate((String)"i18n_alert_RKvLxOLVW_83180b52", (String)"\u516c\u793a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.hasText((String)winningAffirmNoticeVo.getNoticeContent(), (String)I18nUtil.translate((String)"i18n_alert_RKCcxOLVW_8bfc9eaf", (String)"\u516c\u793a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    @Override
    public BidWinningAffirmNoticeVo selectBySubpackageId(String subpackageId) {
        BidWinningAffirmNoticeVo vo = new BidWinningAffirmNoticeVo();
        BidWinningAffirmNotice purchaseTenderProjectBidWinningAffirmNotice = ((BidWinningAffirmNoticeMapper)this.baseMapper).selectBySubpackageId(subpackageId);
        if (purchaseTenderProjectBidWinningAffirmNotice != null) {
            BeanUtils.copyProperties((Object)((Object)purchaseTenderProjectBidWinningAffirmNotice), (Object)((Object)vo));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(BidWinningAffirmItemStatusEnum.CONFIRMED.getValue());
        List<BidWinningAffirmItem> winningAffirmItemList = this.bidWinningAffirmServiceImpl.selectBySubpackageId(subpackageId, list);
        vo.setBidWinningAffirmList(winningAffirmItemList);
        return vo;
    }

    @Override
    public BidWinningAffirmNoticeVo queryInfoById(String id) {
        BidWinningAffirmNoticeVo bidWinningAffirmNoticeVo = new BidWinningAffirmNoticeVo();
        BidWinningAffirmNotice bidWinningAffirmNotice = (BidWinningAffirmNotice)((Object)((BidWinningAffirmNoticeMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (bidWinningAffirmNotice == null) {
            return bidWinningAffirmNoticeVo;
        }
        BeanUtils.copyProperties((Object)((Object)bidWinningAffirmNotice), (Object)((Object)bidWinningAffirmNoticeVo));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(BidWinningAffirmItemStatusEnum.CONFIRMED.getValue());
        List<BidWinningAffirmItem> winningAffirmItemList = this.bidWinningAffirmServiceImpl.selectBySubpackageId(bidWinningAffirmNotice.getSubpackageId(), statusList);
        bidWinningAffirmNoticeVo.setBidWinningAffirmList(winningAffirmItemList);
        return bidWinningAffirmNoticeVo;
    }
}

