/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.inquiry.api.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.tender.calibration.entity.BidWinningCandidatePublicity;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmHeadStatusEnum;
import com.els.modules.tender.calibration.enumerate.BidWinningCandidatePublicityStatusEnum;
import com.els.modules.tender.calibration.mapper.BidWinningCandidatePublicityMapper;
import com.els.modules.tender.calibration.service.BidWinningCandidatePublicityService;
import com.els.modules.tender.calibration.vo.BidWinningCandidatePublicityQueryVO;
import com.els.modules.tender.calibration.vo.BidWinningCandidateVO;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidWinningCandidate;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidWinningCandidateService;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeStatusEnum;
import com.els.modules.tender.notice.enumerate.PurchaseSysNoticeTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class BidWinningCandidatePublicityServiceImpl
extends BaseServiceImpl<BidWinningCandidatePublicityMapper, BidWinningCandidatePublicity>
implements BidWinningCandidatePublicityService {
    @Autowired
    private PurchaseTenderProjectBidWinningCandidateService bidWinningCandidateService;
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void add(BidWinningCandidatePublicity bidWinningCandidatePublicity, List<String> bidWinningCandidateIds) {
        this.checkParam(bidWinningCandidatePublicity, bidWinningCandidateIds);
        bidWinningCandidatePublicity.setDeleted(CommonConstant.DEL_FLAG_0);
        bidWinningCandidatePublicity.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        bidWinningCandidatePublicity.setStatus(BidWinningCandidatePublicityStatusEnum.NEW.getValue());
        bidWinningCandidatePublicity.setPublicityNumber(this.baseRpcService.getNextCode("tenderPublicityNumber", (Object)bidWinningCandidatePublicity));
        this.bidWinningCandidateService.updateBidWinningCandidateStatus(bidWinningCandidateIds, bidWinningCandidatePublicity.getSubpackageId(), BidWinningCandidatePublicityStatusEnum.NEW.getValue());
        ((BidWinningCandidatePublicityMapper)this.baseMapper).insert((Object)bidWinningCandidatePublicity);
        this.updateTenderProjectSubpackageInfo(bidWinningCandidatePublicity, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_PUBLICITY_EDIT.getValue() + "");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void edit(BidWinningCandidatePublicity bidWinningCandidatePublicity, List<String> bidWinningCandidateIds) {
        this.checkParam(bidWinningCandidatePublicity, bidWinningCandidateIds);
        this.bidWinningCandidateService.updateBidWinningCandidateStatus(bidWinningCandidateIds, bidWinningCandidatePublicity.getSubpackageId(), BidWinningCandidatePublicityStatusEnum.NEW.getValue());
        int count = ((BidWinningCandidatePublicityMapper)this.baseMapper).updateById((Object)bidWinningCandidatePublicity);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.updateTenderProjectSubpackageInfo(bidWinningCandidatePublicity, TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_PUBLICITY_EDIT.getValue() + "");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void submit(BidWinningCandidatePublicity bidWinningCandidatePublicity) {
        BidWinningCandidatePublicity publicity = (BidWinningCandidatePublicity)((Object)((BidWinningCandidatePublicityMapper)this.baseMapper).selectById((Serializable)((Object)bidWinningCandidatePublicity.getId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)publicity)), (String)I18nUtil.translate((String)"i18n_alert_VWsMWFW_50306557", (String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e!"));
        Assert.isTrue((boolean)BidWinningCandidatePublicityStatusEnum.NEW.getValue().equals(publicity.getStatus()), (String)I18nUtil.translate((String)"i18n_alert_APzExqDJUzW_9316aa0e", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u63d0\u4ea4\u5ba1\u6279!"));
        publicity.setStatus(BidWinningAffirmHeadStatusEnum.AUDIT.getValue());
        ((BidWinningCandidatePublicityMapper)this.baseMapper).updateById((Object)publicity);
        AuditInputParamDTO dto = new AuditInputParamDTO();
        dto.setBusinessId(bidWinningCandidatePublicity.getId());
        dto.setBusinessType("bidWinningCandidatePublicity");
        dto.setAuditSubject("\u4e2d\u6807\u5019\u9009\u4eba\u516c\u793a\u5355\u53f7:" + bidWinningCandidatePublicity.getPublicityNumber());
        dto.setParams(JSONObject.toJSONString((Object)((Object)bidWinningCandidatePublicity)));
        this.inquiryInvokeWorkFlowRpcService.submit(dto);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateAuditStatus(String id, String processInstanceId, String auditStatus, String bpmnType) {
        BidWinningCandidatePublicity bidWinningCandidatePublicity = (BidWinningCandidatePublicity)((Object)this.getById((Serializable)((Object)id)));
        bidWinningCandidatePublicity.setFlowId(processInstanceId);
        bidWinningCandidatePublicity.setAuditStatus(auditStatus);
        bidWinningCandidatePublicity.setWorkFlowType(bpmnType);
        String subPackageStatus = null;
        String status = null;
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_PUBLICITY_PASS.getValue() + "";
            status = BidWinningCandidatePublicityStatusEnum.FINISH.getValue();
        } else if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_PUBLICITY_REJECT.getValue() + "";
            status = BidWinningCandidatePublicityStatusEnum.NEW.getValue();
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            status = BidWinningCandidatePublicityStatusEnum.NEW.getValue();
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_PUBLICITY_EDIT.getValue() + "";
        } else {
            subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_PUBLICITY_AUDIT.getValue() + "";
            status = BidWinningCandidatePublicityStatusEnum.AUDIT.getValue();
        }
        bidWinningCandidatePublicity.setStatus(status);
        this.updateById((Object)bidWinningCandidatePublicity);
        this.updateTenderProjectSubpackageInfo(bidWinningCandidatePublicity, subPackageStatus);
    }

    @Override
    public BidWinningCandidatePublicityQueryVO queryInfoById(String id) {
        BidWinningCandidatePublicityQueryVO bidWinningCandidatePublicityQueryVO = new BidWinningCandidatePublicityQueryVO();
        BidWinningCandidatePublicity winningCandidatePublicity = (BidWinningCandidatePublicity)((Object)((BidWinningCandidatePublicityMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (winningCandidatePublicity == null) {
            return bidWinningCandidatePublicityQueryVO;
        }
        BeanUtils.copyProperties((Object)((Object)winningCandidatePublicity), (Object)((Object)bidWinningCandidatePublicityQueryVO));
        List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidates = this.bidWinningCandidateService.selectBySubpackageId(winningCandidatePublicity.getSubpackageId(), null);
        ArrayList bidWinningCandidateVOS = SysUtil.copyProperties(bidWinningCandidates, BidWinningCandidateVO.class);
        bidWinningCandidatePublicityQueryVO.setBidWinningCandidateVOList(bidWinningCandidateVOS);
        return bidWinningCandidatePublicityQueryVO;
    }

    @Override
    @SrmTransaction
    public void publish(BidWinningCandidatePublicity bidWinningCandidatePublicity) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)bidWinningCandidatePublicity)), (String)I18nUtil.translate((String)"i18n_alert_sBSiLRKVHxMKW_58f1aa90", (String)"\u4e2d\u6807\u5019\u9009\u4eba\u516c\u793a\u4fe1\u606f\u4e0d\u5b58\u5728!"));
        BidWinningCandidatePublicity winningCandidatePublicity = (BidWinningCandidatePublicity)((Object)((BidWinningCandidatePublicityMapper)this.baseMapper).selectById((Serializable)((Object)bidWinningCandidatePublicity.getId())));
        winningCandidatePublicity.setStatus(BidWinningCandidatePublicityStatusEnum.FINISH.getValue());
        ((BidWinningCandidatePublicityMapper)this.baseMapper).updateById((Object)winningCandidatePublicity);
        this.bidWinningCandidateService.updateBidWinningCandidateStatus(null, bidWinningCandidatePublicity.getSubpackageId(), BidWinningCandidatePublicityStatusEnum.FINISH.getValue());
        String subPackageStatus = TenderProjectSubpackageStatusEnum.BID_WINNING_CANDIDATE_PUBLICITY_FINISH.getValue() + "";
        this.updateTenderProjectSubpackageInfo(bidWinningCandidatePublicity, subPackageStatus);
        this.publishSysNotice(winningCandidatePublicity);
    }

    @Override
    public void delete(String id) {
        ((BidWinningCandidatePublicityMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((BidWinningCandidatePublicityMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public BidWinningCandidatePublicityQueryVO queryBidWinningCandidate(String subpackageId) {
        BidWinningCandidatePublicityQueryVO bidWinningCandidatePublicityQueryVO = new BidWinningCandidatePublicityQueryVO();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)subpackageId)) {
            return bidWinningCandidatePublicityQueryVO;
        }
        List<PurchaseTenderProjectBidWinningCandidate> bidWinningCandidates = this.bidWinningCandidateService.selectBidWinningResultBySubpackageId(subpackageId, null);
        if (CollectionUtil.isEmpty(bidWinningCandidates)) {
            return bidWinningCandidatePublicityQueryVO;
        }
        ArrayList bidWinningCandidateVOS = SysUtil.copyProperties(bidWinningCandidates, BidWinningCandidateVO.class);
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(BidWinningCandidatePublicity::getSubpackageId, (Object)subpackageId);
        List bidWinningCandidatePublicityList = this.list((Wrapper)qw);
        if (CollectionUtil.isNotEmpty((Collection)bidWinningCandidatePublicityList)) {
            BidWinningCandidatePublicity bidWinningCandidatePublicity = (BidWinningCandidatePublicity)((Object)bidWinningCandidatePublicityList.get(0));
            BeanUtils.copyProperties((Object)((Object)bidWinningCandidatePublicity), (Object)((Object)bidWinningCandidatePublicityQueryVO));
        }
        bidWinningCandidatePublicityQueryVO.setBidWinningCandidateVOList(bidWinningCandidateVOS);
        return bidWinningCandidatePublicityQueryVO;
    }

    private void publishSysNotice(BidWinningCandidatePublicity bidWinningCandidatePublicity) {
        PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
        notice.setBusAccount(bidWinningCandidatePublicity.getElsAccount());
        notice.setBusinessType(SourceTypeEnum.TENDER_CANDIDATE.getValue());
        notice.setBusinessId(bidWinningCandidatePublicity.getId());
        notice.setTemplateNumber(bidWinningCandidatePublicity.getTemplateNumber());
        Integer templateVersion = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bidWinningCandidatePublicity.getTemplateVersion()) ? 1 : Integer.parseInt(bidWinningCandidatePublicity.getTemplateVersion());
        notice.setTemplateVersion(templateVersion);
        notice.setTemplateAccount(bidWinningCandidatePublicity.getTemplateAccount());
        notice.setNoticeTitle(bidWinningCandidatePublicity.getPublicityTitle());
        notice.setNoticeContent(bidWinningCandidatePublicity.getPublicityContent());
        notice.setNoticeType(PurchaseSysNoticeTypeEnum.CONVENTION_NOTICE.getValue());
        notice.setNoticeStatus(PurchaseSysNoticeStatusEnum.ISSUE.getValue());
        notice.setNoticeScope(bidWinningCandidatePublicity.getPublicityScope());
        notice.setTop("1");
        Date newDate = new Date();
        notice.setEffectiveTime(newDate);
        notice.setPublishTime(newDate);
        notice.setExpiryTime(bidWinningCandidatePublicity.getPublicityEndTime());
        List emptyList = Collections.EMPTY_LIST;
        notice.setElsAccount(bidWinningCandidatePublicity.getElsAccount());
        this.inquiryInvokeMessageRpcService.publish(notice, emptyList, emptyList);
    }

    private void updateTenderProjectSubpackageInfo(BidWinningCandidatePublicity bidWinningCandidatePublicity, String subPackageStatus) {
        TenderWriteBackSubpackageInfoEventDTO eventDTO = TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)bidWinningCandidatePublicity).subpackageId(bidWinningCandidatePublicity.getSubpackageId()).subpackageStatus(subPackageStatus).build();
        PushEventUtils.updateSubpackageInfo(eventDTO);
    }

    private void checkParam(BidWinningCandidatePublicity bidWinningCandidatePublicity, List<String> bidWinningCandidateIds) {
        Assert.isTrue((boolean)StringUtils.hasText((String)bidWinningCandidatePublicity.getSubpackageId()), (String)I18nUtil.translate((String)"i18n_alert_zsWWxOLVW_b61e1b17", (String)"\u5206\u5305Id\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)bidWinningCandidatePublicity.getTenderProjectId()), (String)I18nUtil.translate((String)"i18n_alert_dIWWxOLVW_5c4a9281", (String)"\u9879\u76eeId\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)bidWinningCandidatePublicity.getPublicity()), (String)I18nUtil.translate((String)"i18n_alert_RKBDxOLVW_114c4232", (String)"\u516c\u793a\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)bidWinningCandidatePublicity.getPublicityScope()), (String)I18nUtil.translate((String)"i18n_alert_RKvLxOLVW_83180b52", (String)"\u516c\u793a\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)bidWinningCandidatePublicity.getPublicityContent()), (String)I18nUtil.translate((String)"i18n_alert_RKCcxOLVW_8bfc9eaf", (String)"\u516c\u793a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)StringUtils.hasText((String)bidWinningCandidatePublicity.getPublicity()), (String)I18nUtil.translate((String)"i18n_alert_ViFKQRKW_6b068985", (String)"\u8bf7\u9009\u62e9\u662f\u5426\u516c\u793a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)bidWinningCandidatePublicity.getPublicityBeginTime()), (String)I18nUtil.translate((String)"i18n_alert_RKvKKIxOLVW_5e47535a", (String)"\u516c\u793a\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)bidWinningCandidatePublicity.getPublicityEndTime()), (String)I18nUtil.translate((String)"i18n_alert_RKyRKIxOLVW_b89ad30d", (String)"\u516c\u793a\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!"));
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(bidWinningCandidateIds), (String)I18nUtil.translate((String)"i18n_alert_ViFsBSiLW_15f85328", (String)"\u8bf7\u9009\u62e9\u4e2d\u6807\u5019\u9009\u4eba!"));
    }
}

