/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.evaluation.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.PurchaseTenderEvaluationGroup;
import com.els.modules.tender.attachment.service.PurchaseTenderEvaluationGroupService;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.event.TenderWriteBackSubpackageInfoEventDTO;
import com.els.modules.tender.common.utils.PushEventUtils;
import com.els.modules.tender.common.utils.TenderOperationFieldUtils;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectBidEvaHead;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaExpertTask;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectEvaSettingHead;
import com.els.modules.tender.evaluation.enumerate.PurchaseTenderProjectBidEvaStatusEnum;
import com.els.modules.tender.evaluation.mapper.PurchaseTenderProjectEvaSettingHeadMapper;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectBidEvaHeadService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaExpertTaskService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectEvaSettingHeadService;
import com.els.modules.tender.evaluation.vo.EvaGroupVO;
import com.els.modules.tender.evaluation.vo.PurchaseTenderProjectEvaSettingHeadVO;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderProjectEvaSettingHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderProjectEvaSettingHeadMapper, PurchaseTenderProjectEvaSettingHead>
implements PurchaseTenderProjectEvaSettingHeadService {
    @Autowired
    private PurchaseTenderProjectEvaExpertTaskService purchaseTenderProjectEvaExpertTaskService;
    @Autowired
    private PurchaseTenderEvaluationGroupService purchaseTenderEvaluationGroupService;
    @Autowired
    private PurchaseTenderProjectBidEvaHeadService purchaseTenderProjectBidEvaHeadService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;

    @Override
    public void deleteBySubpackageId(String subpackageId) {
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        ((PurchaseTenderProjectEvaSettingHeadMapper)this.baseMapper).deleteBySubpackageId(subpackageId, tenderCheckType, tenderProcessType, tenderCurrentStep);
    }

    @Override
    public List<PurchaseTenderProjectEvaSettingHeadVO> queryBySubpackageId(String subpackageId) {
        List<PurchaseTenderProjectEvaSettingHead> evaSettingHeadList = this.selectBySubpackageId(subpackageId);
        ArrayList settingHeadVOS = SysUtil.copyProperties(evaSettingHeadList, PurchaseTenderProjectEvaSettingHeadVO.class);
        List<PurchaseTenderProjectEvaExpertTask> evaSettingItemList = this.purchaseTenderProjectEvaExpertTaskService.selectBySubpackageId(subpackageId);
        if (!evaSettingItemList.isEmpty()) {
            Map<String, List<PurchaseTenderProjectEvaExpertTask>> map = evaSettingItemList.parallelStream().collect(Collectors.groupingBy(PurchaseTenderProjectEvaExpertTask::getEvaSettingId));
            for (PurchaseTenderProjectEvaSettingHeadVO settingHeadVO : settingHeadVOS) {
                List<PurchaseTenderProjectEvaExpertTask> purchaseTenderProjectEvaExpertTasks = map.get(settingHeadVO.getId());
                settingHeadVO.setExpertTaskSettingList(purchaseTenderProjectEvaExpertTasks);
            }
        }
        return settingHeadVOS;
    }

    private List<PurchaseTenderProjectEvaSettingHead> selectBySubpackageId(String subpackageId) {
        String checkType = TenderFlagInjectionContext.getTenderCheckType();
        String processType = TenderFlagInjectionContext.getTenderProcessType();
        String currentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        return ((PurchaseTenderProjectEvaSettingHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId, checkType, processType, currentStep);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void apply(List<PurchaseTenderProjectEvaSettingHeadVO> headVOList) {
        ArrayList<PurchaseTenderProjectEvaSettingHead> evaSettingHeadList = new ArrayList<PurchaseTenderProjectEvaSettingHead>();
        ArrayList<PurchaseTenderProjectEvaExpertTask> evaSettingItemList = new ArrayList<PurchaseTenderProjectEvaExpertTask>();
        ArrayList<PurchaseTenderProjectBidEvaHead> projectBidEvaHeadList = new ArrayList<PurchaseTenderProjectBidEvaHead>();
        String tenderProcessType = TenderFlagInjectionContext.getTenderProcessType();
        String tenderCheckType = TenderFlagInjectionContext.getTenderCheckType();
        String tenderCurrentStep = TenderFlagInjectionContext.getTenderCurrentStep();
        String subpackageId = headVOList.get(0).getSubpackageId();
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(subpackageId);
        List<PurchaseTenderEvaluationGroup> evaluationGroupList = this.purchaseTenderEvaluationGroupService.queryEvaGroupBySubpackageId(subpackageId);
        Map evaGroupMaps = evaluationGroupList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity(), (key1, key2) -> key2));
        for (PurchaseTenderProjectEvaSettingHeadVO purchaseTenderProjectEvaSettingHeadVO : headVOList) {
            PurchaseTenderProjectEvaSettingHead evaSettingHead = (PurchaseTenderProjectEvaSettingHead)((Object)SysUtil.copyProperties((Object)((Object)purchaseTenderProjectEvaSettingHeadVO), PurchaseTenderProjectEvaSettingHead.class));
            evaSettingHead.setHeadStatus("1");
            evaSettingHead.setCheckType(tenderCheckType);
            evaSettingHead.setProcessType(tenderProcessType);
            evaSettingHead.setCurrentStep(tenderCurrentStep);
            evaSettingHeadList.add(evaSettingHead);
            PurchaseTenderProjectBidEvaHead head = new PurchaseTenderProjectBidEvaHead();
            head.setId(IdWorker.getIdStr());
            head.setElsAccount(evaSettingHead.getJudgesElsAccount());
            head.setElsSubAccount(evaSettingHead.getJudgesElsSubAccount());
            head.setSubpackageId(evaSettingHead.getSubpackageId());
            head.setTenderProjectId(evaSettingHead.getTenderProjectId());
            head.setCheckType(tenderCheckType);
            head.setProcessType(tenderProcessType);
            head.setCurrentStep(tenderCurrentStep);
            head.setEvaStatus(PurchaseTenderProjectBidEvaStatusEnum.UNDER_BID_EVA.getValue());
            head.setJudgesGroupLeader(evaSettingHead.getJudgesGroupLeader());
            head.setSubpackageName(purchaseTenderProjectInfoVO.getSubpackageName());
            head.setTenderProjectName(purchaseTenderProjectInfoVO.getTenderProjectName());
            head.setPurchaseEnterpriseName(purchaseTenderProjectInfoVO.getPurchaseEnterpriseName());
            head.setTenderProjectNumber(purchaseTenderProjectInfoVO.getTenderProjectNumber());
            projectBidEvaHeadList.add(head);
            List<PurchaseTenderProjectEvaExpertTask> purchaseTenderProjectEvaExpertTaskList = purchaseTenderProjectEvaSettingHeadVO.getExpertTaskSettingList();
            purchaseTenderProjectEvaExpertTaskList.parallelStream().forEach(item -> {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(purchaseTenderProjectEvaSettingHeadVO.getId());
                item.setElsAccount(evaSettingHead.getJudgesElsAccount());
                item.setSubpackageId(evaSettingHead.getSubpackageId());
                item.setTenderProjectId(evaSettingHead.getTenderProjectId());
                item.setHeadId(head.getId());
                item.setEvaSettingId(evaSettingHead.getId());
                item.setCheckType(tenderCheckType);
                item.setProcessType(tenderProcessType);
                item.setCurrentStep(tenderCurrentStep);
                item.setEvaGroupStatus("0");
                item.setJudgesElsAccount(evaSettingHead.getJudgesElsAccount());
                item.setJudgesElsSubAccount(evaSettingHead.getJudgesElsSubAccount());
                item.setJudgesName(evaSettingHead.getJudgesName());
                item.setJudgesGroupLeader(evaSettingHead.getJudgesGroupLeader());
            });
            evaSettingItemList.addAll(purchaseTenderProjectEvaSettingHeadVO.getExpertTaskSettingList());
        }
        this.updateBatchById(evaSettingHeadList);
        this.purchaseTenderProjectBidEvaHeadService.deleteBySubpackageId(subpackageId);
        this.purchaseTenderProjectEvaExpertTaskService.deleteBySubpackageId(subpackageId);
        this.purchaseTenderProjectEvaExpertTaskService.saveBatch(evaSettingItemList, 10000);
        this.purchaseTenderProjectBidEvaHeadService.saveBatch(projectBidEvaHeadList, 2000);
        PurchaseTenderProjectEvaSettingHeadVO purchaseTenderProjectEvaSettingHeadVO = headVOList.get(0);
        String subpackageStatus = TenderOperationFieldUtils.getEvaBiddingSubpackageStatus() + "";
        PushEventUtils.updateSubpackageInfo(TenderWriteBackSubpackageInfoEventDTO.builder().event((Object)purchaseTenderProjectEvaSettingHeadVO).subpackageId(purchaseTenderProjectEvaSettingHeadVO.getSubpackageId()).subpackageStatus(subpackageStatus).build());
    }

    @Override
    public List<EvaGroupVO> queryEvaGroupBySubpackageId(String subpackageId) {
        List<PurchaseTenderEvaluationGroup> purchaseTenderEvaluationGroupList = this.purchaseTenderEvaluationGroupService.queryEvaGroupBySubpackageId(subpackageId);
        ArrayList<EvaGroupVO> result = new ArrayList<EvaGroupVO>();
        purchaseTenderEvaluationGroupList.stream().sorted(Comparator.comparingInt(PurchaseTenderEvaluationGroup::getOrderBy)).forEach(group -> result.add(EvaGroupVO.builder().id(group.getId()).type(group.getGroupType()).name(group.getGroupName()).checkType(group.getCheckType()).processType(group.getProcessType()).build()));
        return result;
    }
}

