/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.openbid.websocket;

import cn.hutool.core.lang.UUID;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.els.modules.tender.common.aspect.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.openbid.entity.PurchaseTenderProjectOpenInfoRecords;
import com.els.modules.tender.openbid.service.PurchaseTenderProjectOpenInfoRecordsService;
import com.els.modules.tender.openbid.vo.TenderOnlineWebSocketVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/tender/online/{subpackageId}/{elsAccount}")
public class TenderOnlineWebSocket {
    private static final Logger log = LoggerFactory.getLogger(TenderOnlineWebSocket.class);
    private Session session;
    private String subpackageId;
    private String elsAccount;
    private String subElsAccount;
    private String id;
    private static Map<String, List<TenderOnlineWebSocket>> clientMap = new ConcurrentHashMap<String, List<TenderOnlineWebSocket>>();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="subpackageId") String subpackageId, @PathParam(value="elsAccount") String elsAccount) {
        try {
            this.session = session;
            this.subpackageId = subpackageId;
            String[] split = elsAccount.split("_");
            this.elsAccount = split[0];
            this.subElsAccount = split[1];
            this.id = UUID.randomUUID().toString();
            List<Object> clients = clientMap.get(subpackageId) == null ? new ArrayList() : clientMap.get(subpackageId);
            log.info("\u8d26\u53f7{},\u5efa\u7acb\u8fde\u63a5", (Object)elsAccount);
            clients.add(this);
            clientMap.put(subpackageId, clients);
        }
        catch (Exception e) {
            log.error("\u3010TenderOnlineWebSocket\u6d88\u606f\u3011\u5efa\u7acb\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnClose
    public void onClose() {
        try {
            List<TenderOnlineWebSocket> clients = clientMap.get(this.subpackageId);
            if (clients != null) {
                List result = clients.stream().filter(socket -> !this.id.equals(socket.id)).collect(Collectors.toList());
                clientMap.put(this.subpackageId, result);
            }
            log.info("\u3010TenderOnlineWebSocket\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00");
        }
        catch (Exception e) {
            log.error("\u3010TenderOnlineWebSocket\u6d88\u606f\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnMessage
    public void onMessage(String message) {
        try {
            long count;
            if ("heartCheck".equals(message)) {
                log.info("\u6536\u5230{}\u5fc3\u8df3\u4fe1\u606f\uff01", (Object)this.session.getRequestURI().toString());
                this.session.getAsyncRemote().sendText(message);
                return;
            }
            PurchaseTenderProjectOpenInfoRecordsService projectOpenInfoRecordsService = (PurchaseTenderProjectOpenInfoRecordsService)SpringUtil.getBean(PurchaseTenderProjectOpenInfoRecordsService.class);
            TenderOnlineWebSocketVO tenderOnlineWebSocketVO = FastJsonUtils.toBean(message, TenderOnlineWebSocketVO.class);
            TenderFlagInjectionContext.setTenderCurrentStep(tenderOnlineWebSocketVO.getCurrentStep());
            TenderFlagInjectionContext.setTenderCheckType(tenderOnlineWebSocketVO.getCheckType());
            TenderFlagInjectionContext.setTenderProcessType(tenderOnlineWebSocketVO.getProcessType());
            List<PurchaseTenderProjectOpenInfoRecords> projectOpenInfoRecordsList = projectOpenInfoRecordsService.queryOpenInfoRecordsSignMessageBySubpackageId(this.subpackageId, this.elsAccount);
            if (!projectOpenInfoRecordsList.isEmpty() && (count = projectOpenInfoRecordsList.parallelStream().filter(projectOpenInfoRecords -> tenderOnlineWebSocketVO.getMessageContent().equals(projectOpenInfoRecords.getContent())).count()) > 0L) {
                return;
            }
            PurchaseTenderProjectOpenInfoRecords purchaseTenderProjectOpenInfoRecords = new PurchaseTenderProjectOpenInfoRecords();
            purchaseTenderProjectOpenInfoRecords.setElsAccount(this.elsAccount);
            purchaseTenderProjectOpenInfoRecords.setSubpackageId(tenderOnlineWebSocketVO.getSubpackageId());
            purchaseTenderProjectOpenInfoRecords.setContent(tenderOnlineWebSocketVO.getMessageContent());
            purchaseTenderProjectOpenInfoRecords.setCheckType(tenderOnlineWebSocketVO.getCheckType());
            purchaseTenderProjectOpenInfoRecords.setProcessType(tenderOnlineWebSocketVO.getProcessType());
            purchaseTenderProjectOpenInfoRecords.setCurrentStep(tenderOnlineWebSocketVO.getCurrentStep());
            projectOpenInfoRecordsService.save((Object)purchaseTenderProjectOpenInfoRecords);
            this.sendQuoteMessage(this.subpackageId, JSON.toJSONString((Object)((Object)purchaseTenderProjectOpenInfoRecords)));
        }
        finally {
            TenderFlagInjectionContext.clear();
        }
    }

    public void sendQuoteMessage(String subpackageId, String messageContent) {
        List<TenderOnlineWebSocket> clients = clientMap.get(subpackageId);
        if (clients != null && !clients.isEmpty()) {
            for (TenderOnlineWebSocket socket : clients) {
                if (socket.session == null || !socket.session.isOpen()) continue;
                log.info("\u7ed9{}{}-\u53d1\u9001\u6d88\u606f-{}", new Object[]{socket.elsAccount, socket.subElsAccount, messageContent});
                socket.session.getAsyncRemote().sendText(messageContent);
            }
        }
    }
}

