/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginItemStatusEnum;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginHead;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectMarginItem;
import com.els.modules.tender.supplier.entity.PurchaseTenderProjectRefund;
import com.els.modules.tender.supplier.excel.PurchaseTenderProjectRefundExcelExportServiceImpl;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginHeadService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectMarginItemService;
import com.els.modules.tender.supplier.service.PurchaseTenderProjectRefundService;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginHeadVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginItemVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginStatVO;
import com.els.modules.tender.supplier.vo.PurchaseTenderProjectMarginTypeInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/tender/supplier/purchaseTenderProjectMarginHead"})
@Api(tags={"\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u884c\u5934-\u91c7\u8d2d\u5546"})
public class PurchaseTenderProjectMarginHeadController
extends BaseController<PurchaseTenderProjectMarginHead, PurchaseTenderProjectMarginHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderProjectMarginHeadController.class);
    @Autowired
    private PurchaseTenderProjectMarginHeadService purchaseTenderProjectMarginHeadService;
    @Autowired
    private PurchaseTenderProjectMarginItemService purchaseTenderProjectMarginItemService;
    @Autowired
    private PurchaseTenderProjectRefundService purchaseTenderProjectRefundService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectHeadService purchaseTenderProjectHeadService;

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", notes="\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryList"})
    public Result<?> queryList(@RequestParam(name="subpackageId") String subpackageId) {
        List<PurchaseTenderProjectMarginHeadVO> purchaseTenderProjectMarginHeads = this.purchaseTenderProjectMarginHeadService.queryList(subpackageId);
        return Result.ok(purchaseTenderProjectMarginHeads);
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u60c5\u51b5(\u9000\u6b3e\u67e5\u8be2\u4f7f\u7528)", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u60c5\u51b5(\u9000\u6b3e\u67e5\u8be2\u4f7f\u7528)")
    @GetMapping(value={"/queryMarginInfo"})
    public Result<?> queryRefundList(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="refundType") String refundType) {
        List<PurchaseTenderProjectMarginTypeInfoVO> marginTypeInfoVOS = this.purchaseTenderProjectMarginHeadService.queryMarginInfo(subpackageId, refundType);
        return Result.ok(marginTypeInfoVOS);
    }

    @ApiOperation(value="\u7edf\u8ba1\u6c47\u603b\u67e5\u8be2", notes="\u7edf\u8ba1\u6c47\u603b\u67e5\u8be2")
    @GetMapping(value={"/queryStat"})
    public Result<?> queryStat(@RequestParam(name="subpackageId") String subpackageId) {
        PurchaseTenderProjectMarginStatVO purchaseTenderProjectMarginHeads = this.purchaseTenderProjectMarginHeadService.queryStat(subpackageId);
        return Result.ok((Object)purchaseTenderProjectMarginHeads);
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u6dfb\u52a0")
    @PostMapping(value={"/addMargin"})
    public Result<?> addMargin(@RequestBody PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        tenderProjectMarginItemVO.setStatus(TenderProjectMarginItemStatusEnum.UNCONFIRMED.getValue());
        PurchaseTenderProjectMarginItem purchaseTenderProjectMarginItem = this.purchaseTenderProjectMarginHeadService.addMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)purchaseTenderProjectMarginItem));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u4fee\u6539")
    @PostMapping(value={"/editMargin"})
    public Result<?> editMargin(@RequestBody PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        PurchaseTenderProjectMarginItem purchaseTenderProjectMarginItem = this.purchaseTenderProjectMarginHeadService.editMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)purchaseTenderProjectMarginItem));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4", value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4", notes="\u4fdd\u8bc1\u91d1\u8bb0\u5f55\u63d0\u4ea4")
    @PostMapping(value={"/submitMargin"})
    public Result<?> submitMargin(@RequestBody PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO) {
        tenderProjectMarginItemVO.setStatus(TenderProjectMarginItemStatusEnum.CONFIRMED.getValue());
        this.purchaseTenderProjectMarginHeadService.submitMargin(tenderProjectMarginItemVO);
        return Result.ok((Object)((Object)tenderProjectMarginItemVO));
    }

    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u786e\u8ba4", notes="\u4fdd\u8bc1\u91d1\u786e\u8ba4")
    @PostMapping(value={"/confirmMargin"})
    public Result<?> confirmMargin(@RequestBody List<String> ids) {
        this.purchaseTenderProjectMarginHeadService.confirmMargin(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u9000\u56de", notes="\u4fdd\u8bc1\u91d1\u9000\u56de")
    @GetMapping(value={"/reject"})
    public Result<?> reject(@RequestParam(name="id") String id) {
        this.purchaseTenderProjectMarginHeadService.reject(id);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u660e\u7ec6", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u660e\u7ec6")
    @GetMapping(value={"/queryItemById"})
    public Result<?> queryItemById(@RequestParam(name="id") String id) {
        PurchaseTenderProjectMarginItem tenderProjectMarginItem = (PurchaseTenderProjectMarginItem)((Object)this.purchaseTenderProjectMarginItemService.getById((Serializable)((Object)id)));
        if (tenderProjectMarginItem == null) {
            return Result.ok();
        }
        PurchaseTenderProjectMarginItemVO tenderProjectMarginItemVO = (PurchaseTenderProjectMarginItemVO)((Object)SysUtil.copyProperties((Object)((Object)tenderProjectMarginItem), PurchaseTenderProjectMarginItemVO.class));
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.purchaseTenderProjectHeadService.queryProjectInfoBySubpackageId(tenderProjectMarginItem.getSubpackageId());
        tenderProjectMarginItemVO.setSubpackageName(purchaseTenderProjectInfoVO.getSubpackageName());
        tenderProjectMarginItemVO.setTenderProjectName(purchaseTenderProjectInfoVO.getTenderProjectName());
        tenderProjectMarginItemVO.setTenderProjectNumber(purchaseTenderProjectInfoVO.getTenderProjectNumber());
        List attachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(tenderProjectMarginItemVO.getId());
        tenderProjectMarginItemVO.setAttachmentDTOList(attachmentDTOS);
        return Result.ok((Object)((Object)tenderProjectMarginItemVO));
    }

    @AutoLog(busModule="\u4fdd\u8bc1\u91d1\u9000\u6b3e", value="\u4fdd\u8bc1\u91d1\u9000\u6b3e")
    @ApiOperation(value="\u4fdd\u8bc1\u91d1\u9000\u6b3e", notes="\u4fdd\u8bc1\u91d1\u9000\u6b3e")
    @PostMapping(value={"/refund"})
    public Result<?> refund(@RequestBody List<PurchaseTenderProjectRefund> tenderProjectRefunds) {
        this.purchaseTenderProjectMarginHeadService.refund(tenderProjectRefunds);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/queryItem"})
    public Result<?> queryItem(PurchaseTenderProjectMarginItem tenderProjectMarginItem, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectMarginItem), (Map)req.getParameterMap());
        List list = this.purchaseTenderProjectMarginItemService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return Result.ok((Object)Lists.newArrayList());
        }
        ArrayList marginItemVOList = SysUtil.copyProperties((List)list, PurchaseTenderProjectMarginItemVO.class);
        marginItemVOList.forEach(marginItemVO -> {
            List purchaseAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(marginItemVO.getId());
            marginItemVO.setAttachmentDTOList(purchaseAttachmentDTOS);
        });
        return Result.ok((Object)marginItemVOList);
    }

    @ApiOperation(value="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u9000\u6b3e\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u4fdd\u8bc1\u91d1\u9000\u6b3e\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/queryRefund"})
    public Result<?> queryRefund(PurchaseTenderProjectRefund tenderProjectRefund, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)tenderProjectRefund), (Map)req.getParameterMap());
        List list = this.purchaseTenderProjectRefundService.list((Wrapper)queryWrapper);
        return Result.ok((Object)list);
    }

    @ApiOperation(value="\u5bfc\u51fa", notes="\u5bfc\u51fa")
    @GetMapping(value={"/exportRefundXls"})
    public ModelAndView exportRefundXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseTenderProjectRefundExcelExportServiceImpl.class);
    }
}

