/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.alert;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.service.AlertRpcService;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquiryNotQuoteAlertServiceImpl
implements AlertRpcService {
    private static final Logger log = LoggerFactory.getLogger(EnquiryNotQuoteAlertServiceImpl.class);
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private SaleEnquiryHeadService saleEnquiryHeadService;

    public List<?> getAlertList(JSONObject config) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(PurchaseEnquiryItem::getItemStatus, new Object[]{EnquiryStatusEnum.QUOTING.getValue(), EnquiryStatusEnum.RE_QUOTE.getValue()});
        wrapper.gt(PurchaseEnquiryItem::getQuoteEndTime, (Object)LocalDateTime.now());
        return this.purchaseEnquiryItemService.list((Wrapper)wrapper);
    }

    public List<ElsSubAccountDTO> getPrincipalList(Object obj, JSONObject config) {
        ArrayList<ElsSubAccountDTO> result = new ArrayList<ElsSubAccountDTO>();
        JSONObject object = (JSONObject)JSONObject.toJSON((Object)obj);
        PurchaseEnquiryItem item = (PurchaseEnquiryItem)((Object)JSONObject.toJavaObject((JSON)object, PurchaseEnquiryItem.class));
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)item.getHeadId())));
        return result;
    }

    public String buildUrlParam(Object obj) {
        JSONObject object = (JSONObject)JSONObject.toJSON((Object)obj);
        PurchaseEnquiryItem item = (PurchaseEnquiryItem)((Object)JSONObject.toJavaObject((JSON)object, PurchaseEnquiryItem.class));
        List saleEnquiryHeads = this.saleEnquiryHeadService.selectByMainId(item.getHeadId()).stream().filter(saleHead -> saleHead.getElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
        log.info("saleEnquiryHeads:{}", (Object)JSONObject.toJSONString(saleEnquiryHeads));
        if (CollectionUtils.isEmpty(saleEnquiryHeads)) {
            return "";
        }
        SaleEnquiryHead saleEnquiryHead = (SaleEnquiryHead)((Object)saleEnquiryHeads.get(0));
        log.info("saleEnquiryHead:{}", (Object)JSONObject.toJSONString((Object)((Object)saleEnquiryHead)));
        JSONObject param = new JSONObject();
        param.put("id", (Object)saleEnquiryHead.getId());
        param.put("templateNumber", (Object)saleEnquiryHead.getTemplateNumber());
        param.put("templateVersion", (Object)saleEnquiryHead.getTemplateVersion());
        param.put("busAccount", (Object)saleEnquiryHead.getBusAccount());
        param.put("supplierTaxRate", (Object)saleEnquiryHead.getSupplierTaxRate());
        return SysUtil.getUrlParamByJson((JSONObject)param);
    }

    public String buildUrlParamTemplate(Object obj) {
        JSONObject object = (JSONObject)JSONObject.toJSON((Object)obj);
        PurchaseEnquiryItem item = (PurchaseEnquiryItem)((Object)JSONObject.toJavaObject((JSON)object, PurchaseEnquiryItem.class));
        List saleEnquiryHeads = this.saleEnquiryHeadService.selectByMainId(item.getHeadId()).stream().filter(saleHead -> saleHead.getElsAccount().equals(item.getToElsAccount())).collect(Collectors.toList());
        log.info("saleEnquiryHeads:{}", (Object)JSONObject.toJSONString(saleEnquiryHeads));
        if (CollectionUtils.isEmpty(saleEnquiryHeads)) {
            return "";
        }
        SaleEnquiryHead saleEnquiryHead = (SaleEnquiryHead)((Object)saleEnquiryHeads.get(0));
        log.info("saleEnquiryHead:{}", (Object)JSONObject.toJSONString((Object)((Object)saleEnquiryHead)));
        JSONObject param = new JSONObject();
        param.put("id", (Object)saleEnquiryHead.getId());
        param.put("templateNumber", (Object)saleEnquiryHead.getTemplateNumber());
        param.put("templateVersion", (Object)saleEnquiryHead.getTemplateVersion());
        param.put("busAccount", (Object)saleEnquiryHead.getBusAccount());
        param.put("supplierTaxRate", (Object)saleEnquiryHead.getSupplierTaxRate());
        return SysUtil.getUrlParamByJson((JSONObject)param);
    }
}

