/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.enquiry.api.dto.PurchaseInquiryQuotedConfigDTO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.PurchaseInquiryQuotedConfigService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseEnquiryItemExcelServiceImpl")
public class PurchaseEnquiryItemExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEnquiryItemExcelServiceImpl.class);
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private PurchaseEnquiryItemService purchaseEnquiryItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private PurchaseInquiryQuotedConfigService purchaseInquiryQuotedConfigService;
    private String headId;
    private static final List<String> MATER_STRING = Lists.newArrayList((Object[])new String[]{"materialNumber", "materialName", "materialDesc", "materialSpec", "materialGroup", "materialGroupName", "cateCode", "cateName", "minPackQuantity", "minOrderQuantity"});

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        String templateAccount = excelByConfigDTO.getTemplateAccount();
        String templateVersion = excelByConfigDTO.getTemplateVersion();
        String templateNumber = excelByConfigDTO.getTemplateNumber();
        if (StrUtil.isNotBlank((CharSequence)excelByConfigDTO.getHeadId()) && !"undefined".equals(excelByConfigDTO.getHeadId())) {
            this.headId = excelByConfigDTO.getHeadId();
            PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)excelByConfigDTO.getHeadId())));
            templateAccount = StringUtils.isNotBlank((CharSequence)dbHead.getTemplateAccount()) ? dbHead.getTemplateAccount() : dbHead.getElsAccount();
            templateVersion = String.valueOf(dbHead.getTemplateVersion());
            templateNumber = String.valueOf(dbHead.getTemplateNumber());
        }
        return this.invokeBaseRpcService.getTemplateConfig(templateAccount, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        List<PurchaseEnquiryItem> itemList = this.purchaseEnquiryItemService.selectByMainId(excelByConfigDTO.getHeadId());
        return new ArrayList<PurchaseEnquiryItem>(itemList);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        List configItemList = this.getTemplate(excelImportDTO.getExcelByConfigDTO()).getTemplateConfigItemList();
        String[] excludeColumn = new String[]{"materialNumber", "taxCode"};
        List editColumn = configItemList.stream().filter(item -> "1".equals(item.getPurchaseEdit())).map(TemplateConfigItemDTO::getFieldName).collect(Collectors.toList());
        editColumn.addAll(Arrays.asList(excludeColumn));
        editColumn.addAll(MATER_STRING);
        Map taxMap = this.invokeBaseRpcService.getAllTax(TenantContext.getTenant());
        String headId = excelImportDTO.getExcelByConfigDTO().getHeadId();
        PurchaseEnquiryHead head = null;
        PurchaseInquiryQuotedConfigDTO configDTO = new PurchaseInquiryQuotedConfigDTO();
        if (CharSequenceUtil.isNotEmpty((CharSequence)headId) && null != (head = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId))))) {
            configDTO.setCompany(head.getCompany());
            configDTO.setPurchaseOrg(head.getPurchaseOrg());
            configDTO.setFactory(head.getFactory());
        }
        List quotedConfigs = this.purchaseInquiryQuotedConfigService.list();
        ArrayList<String> materialNumberList = new ArrayList<String>();
        Iterator iteratorMap = dataList.iterator();
        while (iteratorMap.hasNext()) {
            Map data = (Map)iteratorMap.next();
            HashMap errorData = new HashMap(data);
            String taxCode = (String)data.get("taxCode");
            if (StringUtils.isNotBlank((CharSequence)taxCode) && !taxMap.containsKey(taxCode)) {
                String msg = I18nUtil.translate((String)"i18n_alert_foWWWWWWWxMK_e919daf8", (String)"\u7a0e\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{taxCode});
                this.errorAdd(excelImportDTO, msg, errorData);
                iteratorMap.remove();
                continue;
            }
            String materialNumber = (String)data.get("materialNumber");
            if (!StringUtils.isNotBlank((CharSequence)materialNumber) || materialNumberList.contains(materialNumber)) continue;
            materialNumberList.add(materialNumber);
        }
        List<Object> materialList = CollectionUtil.isNotEmpty(materialNumberList) ? this.purchaseMaterialHeadLocalRpcService.listByMaterialNumbers(materialNumberList) : Lists.newArrayList();
        Map materialMap = materialList.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity(), (v1, v2) -> v2));
        Field[] fields = ConvertUtils.getAllFields(PurchaseMaterialHeadDTO.class);
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String configJSON;
            String materialNumber;
            Map data = (Map)iterator.next();
            HashMap errorData = new HashMap(data);
            for (String field : data.keySet()) {
                if (editColumn.contains(field)) continue;
                data.put(field, null);
            }
            String taxCode = (String)data.get("taxCode");
            if (StringUtils.isNotBlank((CharSequence)taxCode)) {
                data.put("taxRate", taxMap.get(taxCode));
            }
            if (StringUtils.isNotBlank((CharSequence)(materialNumber = (String)data.get("materialNumber")))) {
                PurchaseMaterialHeadDTO materialHead = (PurchaseMaterialHeadDTO)materialMap.get(materialNumber);
                if (null == materialHead) {
                    String string = I18nUtil.translate((String)"i18n_alert_SLAoWWWWWWWxMK_44822940", (String)"\u7269\u6599\u7f16\u7801\uff1a[${0}]\u4e0d\u5b58\u5728", (String[])new String[]{materialNumber});
                    this.errorAdd(excelImportDTO, string, errorData);
                    iterator.remove();
                    continue;
                }
                data.put("materialId", materialHead.getId());
                for (Field field : fields) {
                    if (!MATER_STRING.contains(field.getName())) continue;
                    try {
                        field.setAccessible(true);
                        data.put(field.getName(), field.get(materialHead));
                    }
                    catch (IllegalAccessException e) {
                        log.error("\u53cd\u5c04\u83b7\u53d6\u503c\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            String quotePriceWay = (String)data.get("quotePriceWay");
            if (null == head || quotedConfigs.isEmpty() || !CharSequenceUtil.isNotEmpty((CharSequence)quotePriceWay) || quotePriceWay.equals(EnquiryQuoteWayEnum.NORMAL.getValue())) continue;
            String string = (String)data.get("factory");
            String materialGroup = (String)data.get("materialGroup");
            String cateCode = (String)data.get("cateCode");
            configDTO.setMaterialNumber(materialNumber);
            configDTO.setMaterialGroup(materialGroup);
            configDTO.setCateCode(cateCode);
            configDTO.setQuotePriceWay(quotePriceWay);
            if (CharSequenceUtil.isNotEmpty((CharSequence)string)) {
                configDTO.setFactory(string);
            }
            if (!CharSequenceUtil.isNotEmpty((CharSequence)(configJSON = this.purchaseInquiryQuotedConfigService.batchLoadOne(configDTO, quotedConfigs)))) continue;
            if (EnquiryQuoteWayEnum.LADDER.getValue().equals(quotePriceWay)) {
                data.put("ladderPriceJson", configJSON);
                continue;
            }
            data.put("costFormJson", configJSON);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

