/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.tender.clarification.entity.PurchaseTenderMentoringHead;
import com.els.modules.tender.clarification.entity.PurchaseTenderMentoringItem;
import com.els.modules.tender.clarification.service.PurchaseTenderMentoringHeadService;
import com.els.modules.tender.clarification.service.PurchaseTenderMentoringItemService;
import com.els.modules.tender.clarification.vo.PurchaseTenderMentoringHeadVO;
import com.els.modules.tender.clarification.vo.PurchaseTenderMentoringItemVO;
import com.els.modules.tender.project.enumerate.PurchaseOrgTypeEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/purchaseTenderMentoringHead"})
@Api(tags={"\u6f84\u6e05\u7b54\u7591\u5934"})
public class PurchaseTenderMentoringHeadController
extends BaseController<PurchaseTenderMentoringHead, PurchaseTenderMentoringHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseTenderMentoringHeadController.class);
    @Autowired
    @Lazy
    private PurchaseTenderMentoringHeadService purchaseTenderMentoringHeadService;
    @Autowired
    private PurchaseTenderProjectHeadService projectHeadService;
    @Autowired
    private PurchaseTenderMentoringItemService purchaseTenderMentoringItemService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(PurchaseTenderMentoringHead purchaseTenderMentoringHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        PurchaseTenderProjectHeadVO purchaseTenderProjectHeadVO = this.projectHeadService.queryProjectHeadBySubpackageId(purchaseTenderMentoringHead.getSubpackageId());
        if (PurchaseOrgTypeEnum.PROXY_PURCHASE.getValue().equals(purchaseTenderProjectHeadVO.getPurchaseOrgType())) {
            TenantContext.setTenant((String)purchaseTenderProjectHeadVO.getElsAccount());
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderMentoringHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseTenderMentoringHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u56de\u590d", notes="\u56de\u590d")
    @PostMapping(value={"/reply"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> reply(@RequestBody PurchaseTenderMentoringItemVO purchaseTenderMentoringItemVO) {
        PurchaseTenderMentoringItem purchaseTenderMentoringItem = this.purchaseTenderMentoringHeadService.purchaseReply(purchaseTenderMentoringItemVO);
        return Result.ok((Object)((Object)purchaseTenderMentoringItem));
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseTenderMentoringHead purchaseTenderMentoringHead = (PurchaseTenderMentoringHead)((Object)this.purchaseTenderMentoringHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseTenderMentoringHeadVO purchaseTenderMentoringHeadVO = new PurchaseTenderMentoringHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseTenderMentoringHead), (Object)((Object)purchaseTenderMentoringHeadVO));
        List<PurchaseTenderMentoringItem> mentoringItemList = this.purchaseTenderMentoringItemService.selectByMainId(id);
        ArrayList mentoringItemVOList = SysUtil.copyProperties(mentoringItemList, PurchaseTenderMentoringItemVO.class);
        purchaseTenderMentoringHeadVO.setPurchaseTenderMentoringItemList(mentoringItemVOList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        if (purchaseAttachmentList != null && purchaseAttachmentList.size() > 0) {
            Map<String, List<PurchaseAttachmentDTO>> purchaseAttachmentListMap = purchaseAttachmentList.parallelStream().filter(purchaseAttachmentDTO -> StringUtils.isNotBlank((CharSequence)purchaseAttachmentDTO.getRelationId())).collect(Collectors.groupingBy(PurchaseAttachmentDTO::getRelationId));
            mentoringItemVOList.parallelStream().forEach(item -> {
                List purchaseAttachmentDTOS = (List)purchaseAttachmentListMap.get(item.getId());
                item.setPurchaseAttachmentList(purchaseAttachmentDTOS);
            });
        }
        return Result.ok((Object)((Object)purchaseTenderMentoringHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u6f84\u6e05\u7b54\u7591\u5934id\u67e5\u8be2\u6f84\u6e05\u7b54\u7591\u884c", notes="\u901a\u8fc7\u6f84\u6e05\u7b54\u7591\u5934id\u67e5\u8be2\u6f84\u6e05\u7b54\u7591\u884c")
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @GetMapping(value={"/queryPurchaseTenderMentoringItemByMainId"})
    public Result<?> queryPurchaseTenderMentoringItemListByMainId(@RequestParam(name="id") String id) {
        List<PurchaseTenderMentoringItem> purchaseTenderMentoringItemList = this.purchaseTenderMentoringItemService.selectByMainId(id);
        return Result.ok(purchaseTenderMentoringItemList);
    }
}

