/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingNotice;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.MemberRoleEnum;
import com.els.modules.bidding.enumerate.MemberTypeEnum;
import com.els.modules.bidding.enumerate.SrmNoticeScopeEnum;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingHeadMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingNoticeMapper;
import com.els.modules.bidding.mapper.PurchaseBiddingSpecialistMapper;
import com.els.modules.bidding.service.PurchaseBiddingNoticeService;
import com.els.modules.inquiry.rpc.service.InquiryInvokeMessageRpcService;
import com.els.modules.message.api.dto.PurchaseNoticeSupplierDTO;
import com.els.modules.notice.api.dto.PurchaseNoticeDTO;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseBiddingNoticeServiceImpl
extends ServiceImpl<PurchaseBiddingNoticeMapper, PurchaseBiddingNotice>
implements PurchaseBiddingNoticeService {
    @Autowired
    private PurchaseBiddingHeadMapper purchaseBiddingHeadMapper;
    @Autowired
    private BiddingSupplierMapper biddingSupplierMapper;
    @Autowired
    private PurchaseBiddingSpecialistMapper purchaseBiddingSpecialistMapper;
    @Resource
    private InquiryInvokeMessageRpcService inquiryInvokeMessageRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void updatePurchaseBiddingNotice(PurchaseBiddingNotice purchaseBiddingNotice) {
        if (StrUtil.isBlank((CharSequence)purchaseBiddingNotice.getHeadId())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_bid_head_id_bidding", (String)"headId \u4e0d\u80fd\u4e3a\u7a7a\uff01\u8be5\u503c\u4e3a\u62db\u6807\u5355\u5934id"));
        }
        if (purchaseBiddingNotice.getBidWinEndTime() == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_publicity_time", (String)"\u516c\u793a\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        this.checkPermission(purchaseBiddingNotice.getHeadId());
        PurchaseBiddingNotice biddingNotice = (PurchaseBiddingNotice)((Object)((PurchaseBiddingNoticeMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"head_id", (Object)purchaseBiddingNotice.getHeadId())).last(" limit 1")));
        if (biddingNotice != null) {
            if ("1".equals(biddingNotice.getNoticeStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_has_publish_not_edit", (String)"\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u518d\u6b21\u7f16\u8f91"));
            }
            purchaseBiddingNotice.setId(biddingNotice.getId());
            int count = ((PurchaseBiddingNoticeMapper)this.baseMapper).updateById((Object)purchaseBiddingNotice);
            if (count == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            }
        } else {
            purchaseBiddingNotice.setNoticeStatus("0");
            ((PurchaseBiddingNoticeMapper)this.baseMapper).insert((Object)purchaseBiddingNotice);
        }
    }

    private void checkPermission(String id) {
        LoginUser user = SysUtil.getLoginUser();
        List specialistList = this.purchaseBiddingSpecialistMapper.selectByMainId(id).stream().filter(o -> MemberTypeEnum.PROJECT.getValue().equals(o.getMemberType())).filter(o -> MemberRoleEnum.BID_PRINCIPAL.getValue().equals(o.getMemberRole())).map(PurchaseBiddingSpecialist::getSubAccount).collect(Collectors.toList());
        if (!specialistList.contains(user.getSubAccount())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_no_bidding_principal_bidding", (String)"\u53ea\u6709\u62db\u6807\u8d1f\u8d23\u4eba\u53ef\u4ee5\u64cd\u4f5c\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishNotice(PurchaseBiddingNotice biddingNotice) {
        String bidFailNotification;
        String bidWinNotification;
        PurchaseBiddingHead biddingHead = (PurchaseBiddingHead)((Object)this.purchaseBiddingHeadMapper.selectById((Serializable)((Object)biddingNotice.getHeadId())));
        if (biddingHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_param_error", (String)"\u53c2\u6570\u5f02\u5e38\uff01"));
        }
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(biddingHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        if (!BiddingStatusEnum.CONFIRM_ED.getValue().equals(biddingHead.getBiddingStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LIBxiThxsBeRWW_51858f9f", (String)"\u672a\u5b9a\u6807\u4e0d\u5141\u8bb8\u53d1\u5e03\u4e2d\u6807\u901a\u77e5\u4e66\uff01"));
        }
        String resultAudit = biddingHead.getResultAudit();
        if ("1".equals(resultAudit) && !"2".equals(biddingHead.getResultAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IByRTPUzWUzLeRxiThdsBeRWW_838b05f2", (String)"\u5b9a\u6807\u7ed3\u679c\u9700\u8981\u5ba1\u6279\uff0c\u5ba1\u6279\u672a\u901a\u8fc7\u4e0d\u5141\u8bb8\u53d1\u9001\u4e2d\u6807\u901a\u77e5\u4e66\uff01"));
        }
        this.checkPermission(biddingNotice.getHeadId());
        LoginUser loginUser = SysUtil.getLoginUser();
        String purchaseName = StrUtil.isBlank((CharSequence)loginUser.getEnterpriseName()) ? "" : loginUser.getEnterpriseName();
        String projectName = StrUtil.isBlank((CharSequence)biddingHead.getProjectName()) ? "" : biddingHead.getProjectName();
        String bidWinNotice = biddingNotice.getBidWinNotice();
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(biddingNotice.getHeadId());
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(biddingNotice.getHeadId());
        List<String> noticeSupplierList = null;
        if (SrmNoticeScopeEnum.SPECIFIED.getValue().equals(biddingNotice.getBidWinScope()) && StrUtil.isNotBlank((CharSequence)biddingNotice.getNoticeSupplier())) {
            noticeSupplierList = Arrays.asList(biddingNotice.getNoticeSupplier().split(","));
        }
        if ("1".equals(bidWinNotice)) {
            PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
            notice.setBusAccount(biddingHead.getBusAccount());
            notice.setNoticeTitle(purchaseName + projectName + "\u4e2d\u6807\u516c\u544a");
            notice.setNoticeType("2");
            notice.setTop("1");
            notice.setEffectiveTime(new Date());
            notice.setExpiryTime(biddingNotice.getBidWinEndTime());
            notice.setBusinessId(biddingHead.getId());
            notice.setBusinessType("winBidNotice");
            notice.setTemplateNumber(biddingHead.getTemplateNumber());
            notice.setTemplateVersion(biddingHead.getTemplateVersion());
            notice.setTemplateAccount(biddingHead.getTemplateAccount());
            String bidWinContent = biddingNotice.getBidWinContent();
            if (StrUtil.isNotBlank((CharSequence)bidWinContent)) {
                HashMap paramsMap = new HashMap();
                BeanUtil.copyProperties((Object)((Object)biddingHead), paramsMap, (String[])new String[0]);
                bidWinContent = TemplateParseUtil.getTemplateText((String)"", (String)bidWinContent, paramsMap);
                notice.setNoticeContent(bidWinContent);
            }
            ArrayList<PurchaseNoticeSupplierDTO> purchaseNoticeSupplierList = new ArrayList<PurchaseNoticeSupplierDTO>();
            for (BiddingSupplier supplier : biddingSupplierList) {
                if (SrmNoticeScopeEnum.SPECIFIED.getValue().equals(biddingNotice.getBidWinScope()) && (noticeSupplierList == null || noticeSupplierList != null && !noticeSupplierList.contains(supplier.getToElsAccount()))) continue;
                PurchaseNoticeSupplierDTO noticeSupplier = new PurchaseNoticeSupplierDTO();
                noticeSupplier.setToElsAccount(supplier.getToElsAccount());
                noticeSupplier.setSupplierCode(supplier.getSupplierCode());
                noticeSupplier.setSupplierName(supplier.getSupplierName());
                purchaseNoticeSupplierList.add(noticeSupplier);
            }
            String bidWinScope = biddingNotice.getBidWinScope();
            String[] scopeArray = bidWinScope.split(",");
            List<PurchaseAttachmentDTO> list = attachmentList.stream().filter(o -> "winBidNotice".equals(o.getBusinessType())).collect(Collectors.toList());
            for (String scope : scopeArray) {
                notice.setNoticeScope(scope);
                this.inquiryInvokeMessageRpcService.publish(notice, purchaseNoticeSupplierList, list);
            }
        }
        if ("1".equals(bidWinNotification = biddingNotice.getBidWinNotification())) {
            PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
            notice.setBusAccount(biddingHead.getBusAccount());
            notice.setNoticeTitle(purchaseName + projectName + "\u4e2d\u6807\u901a\u77e5\u4e66");
            notice.setNoticeType("2");
            notice.setTop("1");
            notice.setEffectiveTime(new Date());
            notice.setExpiryTime((Date)DateUtil.parse((CharSequence)"2099-12-31"));
            notice.setBusinessId(biddingHead.getId());
            notice.setBusinessType("winBidNotification");
            notice.setTemplateNumber(biddingHead.getTemplateNumber());
            notice.setTemplateVersion(biddingHead.getTemplateVersion());
            notice.setTemplateAccount(biddingHead.getTemplateAccount());
            String bidWinNotificationContent = biddingNotice.getBidWinNotificationContent();
            if (StrUtil.isNotBlank((CharSequence)bidWinNotificationContent)) {
                HashMap paramsMap = new HashMap();
                BeanUtil.copyProperties((Object)((Object)biddingHead), paramsMap, (String[])new String[0]);
                bidWinNotificationContent = TemplateParseUtil.getTemplateText((String)"", (String)bidWinNotificationContent, paramsMap);
                notice.setNoticeContent(bidWinNotificationContent);
            }
            List<PurchaseAttachmentDTO> list = attachmentList.stream().filter(o -> "winBidNotification".equals(o.getBusinessType())).collect(Collectors.toList());
            List supplierList = biddingSupplierList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_WIN.getValue().equals(o.getBiddingStatus())).collect(Collectors.toList());
            ArrayList<PurchaseNoticeSupplierDTO> purchaseNoticeSupplierList = new ArrayList<PurchaseNoticeSupplierDTO>();
            for (BiddingSupplier supplier : supplierList) {
                PurchaseNoticeSupplierDTO noticeSupplier = new PurchaseNoticeSupplierDTO();
                noticeSupplier.setToElsAccount(supplier.getToElsAccount());
                noticeSupplier.setSupplierCode(supplier.getSupplierCode());
                noticeSupplier.setSupplierName(supplier.getSupplierName());
                purchaseNoticeSupplierList.add(noticeSupplier);
            }
            notice.setNoticeScope(NoticeScopeEnum.ASSIGN_SUPPLIER.getValue());
            this.inquiryInvokeMessageRpcService.publish(notice, purchaseNoticeSupplierList, list);
        }
        if ("1".equals(bidFailNotification = biddingNotice.getBidFailNotification())) {
            PurchaseNoticeDTO notice = new PurchaseNoticeDTO();
            notice.setBusAccount(biddingHead.getBusAccount());
            notice.setNoticeTitle(purchaseName + projectName + "\u672a\u4e2d\u6807\u901a\u77e5\u4e66");
            notice.setNoticeType("2");
            notice.setTop("1");
            notice.setEffectiveTime(new Date());
            notice.setExpiryTime((Date)DateUtil.parse((CharSequence)"2099-12-31"));
            notice.setBusinessId(biddingHead.getId());
            notice.setBusinessType("failBidNotification");
            notice.setTemplateNumber(biddingHead.getTemplateNumber());
            notice.setTemplateVersion(biddingHead.getTemplateVersion());
            notice.setTemplateAccount(biddingHead.getTemplateAccount());
            String bidFailtificationContent = biddingNotice.getBidFailNotificationContent();
            if (StrUtil.isNotBlank((CharSequence)bidFailtificationContent)) {
                HashMap paramsMap = new HashMap();
                BeanUtil.copyProperties((Object)((Object)biddingHead), paramsMap, (String[])new String[0]);
                bidFailtificationContent = TemplateParseUtil.getTemplateText((String)"", (String)bidFailtificationContent, paramsMap);
                notice.setNoticeContent(bidFailtificationContent);
            }
            List<PurchaseAttachmentDTO> list = attachmentList.stream().filter(o -> "failBidNotification".equals(o.getBusinessType())).collect(Collectors.toList());
            List supplierList = biddingSupplierList.stream().filter(o -> BiddingItemStatusEnum.BIDDING_FAIL.getValue().equals(o.getBiddingStatus())).collect(Collectors.toList());
            ArrayList<PurchaseNoticeSupplierDTO> purchaseNoticeSupplierList = new ArrayList<PurchaseNoticeSupplierDTO>();
            for (BiddingSupplier supplier : supplierList) {
                PurchaseNoticeSupplierDTO noticeSupplier = new PurchaseNoticeSupplierDTO();
                noticeSupplier.setToElsAccount(supplier.getToElsAccount());
                noticeSupplier.setSupplierCode(supplier.getSupplierCode());
                noticeSupplier.setSupplierName(supplier.getSupplierName());
                purchaseNoticeSupplierList.add(noticeSupplier);
            }
            notice.setNoticeScope(NoticeScopeEnum.ASSIGN_SUPPLIER.getValue());
            this.inquiryInvokeMessageRpcService.publish(notice, purchaseNoticeSupplierList, list);
        }
    }
}

