/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.excel.PurchaseEbiddingItemHisExportServiceImpl;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u91c7\u8d2d\u7ade\u4ef7\u884c\u5386\u53f2"})
@RestController
@RequestMapping(value={"/ebidding/purchaseEbiddingItemHis"})
public class PurchaseEbiddingItemHisController
extends BaseController<PurchaseEbiddingItemHis, PurchaseEbiddingItemHisService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingItemHisController.class);
    @Autowired
    private PurchaseEbiddingHeadService purchaseEbiddingHeadService;
    @Resource
    private PurchaseEbiddingItemService purchaseEbiddingItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:list"})
    public Result<?> queryPageList(PurchaseEbiddingItemHis itemHis, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)itemHis), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEbiddingItemHisService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List itemIdList = records.stream().map(PurchaseEbiddingItemHis::getItemId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            queryWrapper1.in(BaseEntity::getId, itemIdList);
            List queryItemlist = this.purchaseEbiddingItemService.list((Wrapper)queryWrapper1);
            log.info("queryItemlist:{}", (Object)queryItemlist.size());
            List collect = queryItemlist.stream().filter(x -> x.getItemStatus().equals(EbiddingItemStatusEnum.BIDDING_END.getValue()) || x.getItemStatus().equals(EbiddingItemStatusEnum.BID_WIN.getValue()) || x.getItemStatus().equals(EbiddingItemStatusEnum.UN_BID_WIN.getValue()) || x.getItemStatus().equals(EbiddingItemStatusEnum.REGRET.getValue())).collect(Collectors.toList());
            List newRecordList = records.stream().filter(a -> collect.stream().map(BaseEntity::getId).anyMatch(id -> Objects.equals(a.getItemId(), id))).collect(Collectors.toList());
            pageList.setRecords(newRecordList);
            log.info("newRecordList:{}", (Object)newRecordList.size());
            log.info("pageList", (Object)JSONObject.toJSONString((Object)pageList));
            return Result.ok((Object)pageList);
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u82f1\u5f0f\u7ade\u4ef7\u5927\u5385\u5386\u53f2\u62a5\u4ef7\u4fe1\u606f", notes="\u82f1\u5f0f\u7ade\u4ef7\u5927\u5385\u5386\u53f2\u62a5\u4ef7\u4fe1\u606f")
    @GetMapping(value={"/queryBidLobbyDetail"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:queryById"})
    public Result<?> queryBidLobbyDetail(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        String purchaseShow = dbHead.getPurchaseShow() == null ? "" : dbHead.getPurchaseShow();
        List<String> statusList = Arrays.asList(EbiddingStatusEnum.NEW.getValue(), EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.BIDDING.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue());
        if (!(!statusList.contains(dbHead.getEbiddingStatus()) || purchaseShow.contains(EbiddingShowEnum.NAME.getValue()) && purchaseShow.contains(EbiddingShowEnum.RANK.getValue()) && purchaseShow.contains(EbiddingShowEnum.PRICE.getValue()))) {
            return Result.ok(null);
        }
        List<PurchaseEbiddingItemHis> list = ((PurchaseEbiddingItemHisService)this.service).queryBidLobbyDetail(dbHead, itemNumber);
        return Result.ok(list);
    }

    @ApiOperation(value="\u65e5\u5f0f/\u8377\u5f0f-\u7ade\u4ef7\u5927\u5385\u67e5\u8be2\u62a5\u4ef7\u8bbe\u7f6e", notes="\u65e5\u5f0f/\u8377\u5f0f-\u7ade\u4ef7\u5927\u5385\u67e5\u8be2\u62a5\u4ef7\u8bbe\u7f6e")
    @GetMapping(value={"/queryQuoteSite"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:queryQuoteSite"})
    public Result<?> queryQuoteSite(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber, @RequestParam(name="toElsAccount") String toElsAccount) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)this.purchaseEbiddingHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<PurchaseEbiddingItemHis> list = ((PurchaseEbiddingItemHisService)this.service).queryQuoteSite(dbHead, itemNumber, toElsAccount);
        return Result.ok(list);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseEbiddingItemHisExportServiceImpl.class);
    }
}

