/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.process.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.tender.process.entity.TenderProcessModelHead;
import com.els.modules.tender.process.service.TenderProcessModelHeadService;
import com.els.modules.tender.process.vo.TenderProcessNodeAuditVO;
import com.els.modules.tender.process.vo.TenderProcessNodeInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/tenderProcessInstance"})
@Api(tags={"\u62db\u6807\u6d41\u7a0b\u5b9e\u4f8b"})
public class TenderProcessInstanceController
extends BaseController<TenderProcessModelHead, TenderProcessModelHeadService> {
    private static final Logger log = LoggerFactory.getLogger(TenderProcessInstanceController.class);
    @Autowired
    private TenderProcessModelHeadService modelHeadService;

    @ApiOperation(value="\u62db\u6807\u6d41\u7a0b\u5b9e\u4f8b", notes="\u62db\u6807\u6d41\u7a0b\u5b9e\u4f8b-\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9")
    @GetMapping(value={"/process/node"})
    @AutoLog(busModule="\u62db\u6807\u6d41\u7a0b\u5b9e\u4f8b", value="\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9")
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryProcessNodeBySubpackageId(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="applyRole") String applyRole) {
        List<TenderProcessNodeInfoVO> nodeVOList = this.modelHeadService.queryProcessNodeBySubpackageId(subpackageId, applyRole);
        return Result.ok(nodeVOList);
    }

    @ApiOperation(value="\u8ddf\u636e\u8282\u70b9\u4fe1\u606f,\u89d2\u8272\u4fe1\u606f\u67e5\u8be2\u5f53\u524d\u8282\u70b9\u662f\u5426\u53ef\u64cd\u4f5c", notes="\u8ddf\u636e\u8282\u70b9\u4fe1\u606f,\u89d2\u8272\u4fe1\u606f\u67e5\u8be2\u5f53\u524d\u8282\u70b9\u662f\u5426\u53ef\u64cd\u4f5c")
    @GetMapping(value={"/process/nodeAduit"})
    @AutoLog(busModule="\u83b7\u53d6\u8282\u70b9\u64cd\u4f5c\u6821\u9a8c", value="\u83b7\u53d6\u8282\u70b9\u64cd\u4f5c\u6821\u9a8c")
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryProcessNodeAuditBySubpackageId(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="nodeId") String nodeId, @RequestParam(name="applyRole") String applyRole) {
        TenderProcessNodeAuditVO nodeAuditVo = this.modelHeadService.queryProcessNodeAuditBySubpackageId(subpackageId, nodeId, applyRole);
        return Result.ok((Object)nodeAuditVo);
    }
}

