/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.JiMuResult;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.excel.PurchaseRequestHeadExportServiceImpl;
import com.els.modules.demand.rpc.BudgetManageLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.PurchaseProductInventoryLocalRpcService;
import com.els.modules.demand.rpc.PurchaseUserCartLocalRpcService;
import com.els.modules.demand.rpc.TemplateLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.demand.vo.RequestMatchInfomationVO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.enumerate.MaterialDeliveryArrangeEnum;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.product.api.dto.PurchaseProductInventoryDTO;
import com.els.modules.product.api.dto.PurchaseUserCartDTO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/demand/purchaseRequestHead"})
@Api(tags={"\u91c7\u8d2d\u7533\u8bf7\u5934"})
@Primary
@BusinessModule(module="purchaseRequest")
public class PurchaseRequestHeadController
extends BaseController<PurchaseRequestHead, PurchaseRequestHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestHeadController.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private BudgetManageLocalRpcService budgetManageRpcService;
    @Resource
    private TemplateLocalRpcService templateHeadService;
    @Resource
    private PurchaseUserCartLocalRpcService purchaseUserCartService;
    @Resource
    private PurchaseProductInventoryLocalRpcService purchaseProductInventoryService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_request_requestToOrder_locker";
    private static final Long LOCK_EXPIRE_TIME = 120000L;

    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> queryPageList(PurchaseRequestHead purchaseRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/queryPageJimuList"})
    @PermissionDataView(businessType="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public JiMuResult<?> queryPageJimuList(PurchaseRequestHead purchaseRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return JiMuResult.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u8f6c\u8ba2\u5355-\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @ApiOperation(value="\u9700\u6c42\u5355\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55", notes="\u9700\u6c42\u5355\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @PostMapping(value={"/requestMatchInfomationRecord"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:requestMatchInfomationRecord"})
    @SrmValidated
    public Result<?> requestMatchInfomationRecord(@RequestBody List<PurchaseRequestItem> requestItemList) {
        Assert.notEmpty(requestItemList, (String)I18nUtil.translate((String)"i18n_alert_empty_toOrderLine", (String)"\u9009\u62e9\u7684\u8f6c\u8ba2\u5355\u7684\u9700\u6c42\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        List requestItemIds = requestItemList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        try {
            Object flag;
            List ids = requestItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            PurchaseRequestItemService purchaseRequestItemService = (PurchaseRequestItemService)SpringContextUtils.getBean(PurchaseRequestItemService.class);
            List dbPurchaseRequestItems = purchaseRequestItemService.listByIds(ids);
            Assert.notEmpty((Collection)dbPurchaseRequestItems, (String)I18nUtil.translate((String)"i18n_alert_HemhxuiFjWFtHWVXVABSsKW_221943", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u9009\u62e9\u7684\u6570\u636e\u8bb0\u5f55,\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5!"));
            if (CollectionUtils.isEmpty((Collection)dbPurchaseRequestItems)) {
                // empty if block
            }
            Map requestItemByNumber = dbPurchaseRequestItems.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            LoginUser loginUser = SysUtil.getLoginUser();
            JSONObject companySet = loginUser.getCompanySet();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("4");
            arrayList.add("5");
            arrayList.add("6");
            boolean allowMultipleSources = false;
            if (companySet != null && "1".equals(flag = companySet.getString("allowMultipleSources"))) {
                allowMultipleSources = true;
            }
            for (PurchaseRequestItem requestItem : requestItemList) {
                PurchaseRequestItem dbRequestItem = (PurchaseRequestItem)((Object)requestItemByNumber.get(requestItem.getId()));
                if (dbRequestItem == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWnRUVEyWWWWWWKHexMKWVXVABSsKW_43435b50", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7[${0}]\u91c7\u8d2d\u7533\u8bf7\u884c\u53f7[${1}]\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
                }
                if (!allowMultipleSources && arrayList.contains(requestItem.getItemStatus())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWhjLML_dfc2f225", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u5bfb\u6e90\u672a\u5b8c\u6210", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
                }
                if (StringUtils.isEmpty((CharSequence)requestItem.getPurchaseUnit())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TVtWWWWWWEyWWWWWWjnRtLLVWVLDSKsItW_91b51903", (String)"\u9700\u6c42\u5355[${0}]\u884c\u53f7[${1}]\u7684\u91c7\u8d2d\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u8f6c\u8ba2\u5355!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
                }
                BigDecimal toOrderQuantity = dbRequestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : dbRequestItem.getToOrderQuantity();
                if (toOrderQuantity.compareTo(dbRequestItem.getQuantity()) < 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TVtWWWWWWEyWWWWWWjIsItWRlTXUTVWRW_fddab5f6", (String)"\u9700\u6c42\u5355[${0}]\u884c\u53f7[${1}]\u7684\u5df2\u8f6c\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            if ("mall".equals(((PurchaseRequestItem)((Object)dbPurchaseRequestItems.get(0))).getSourceType())) {
                this.purchaseRequestHeadService.generatePoolOrder(dbPurchaseRequestItems);
            }
            List<RequestMatchInfomationVO> requestMatchInfomationVOS = this.purchaseRequestHeadService.matchInformationRecords(dbPurchaseRequestItems);
            return Result.ok(requestMatchInfomationVOS);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u751f\u6210\u8ba2\u5355")
    @ApiOperation(value="\u751f\u6210\u8ba2\u5355", notes="\u751f\u6210\u8ba2\u5355")
    @PostMapping(value={"/requestToCreateOrder"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:requestToCreateOrder"})
    @SrmValidated
    @FormCommit
    public Result<?> requestToCreateOrder(@Valid @RequestBody List<RequestMatchInfomationVO> requestMatchInfomationList) {
        List requestItemIds = requestMatchInfomationList.stream().map(RequestMatchInfomationVO::getRequestItemId).distinct().collect(Collectors.toList());
        for (int i = 0; i < requestItemIds.size(); ++i) {
            if (this.redisUtil.tryGetDistributedLock(LOCK_KEY, (String)requestItemIds.get(i), LOCK_EXPIRE_TIME.longValue())) continue;
            if (i > 0) {
                for (int j = 0; j < i; ++j) {
                    this.redisUtil.releaseDistributedLock(LOCK_KEY, (String)requestItemIds.get(j));
                }
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RijTVcWMKiKtkjcWVRSKK_b36f72bb", (String)"\u52fe\u9009\u7684\u9700\u6c42\u884c\uff0c\u5b58\u5728\u6b63\u5728\u64cd\u4f5c\u7684\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
        }
        try {
            List requestItemList = this.purchaseRequestItemService.listByIds(requestItemIds);
            HashMap<String, RequestMatchInfomationVO> key = new HashMap<String, RequestMatchInfomationVO>();
            for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationList) {
                RequestMatchInfomationVO requestMatchInfomationVO1;
                if (key.containsKey(requestMatchInfomationVO.getRequestItemId())) {
                    requestMatchInfomationVO1 = (RequestMatchInfomationVO)((Object)key.get(requestMatchInfomationVO.getRequestItemId()));
                    BigDecimal toOrderQuantity = requestMatchInfomationVO1.getToOrderQuantity().add(requestMatchInfomationVO.getToOrderQuantity());
                    if (requestMatchInfomationVO.getToOrderQuantity().compareTo(BigDecimal.valueOf(0L)) <= 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_sItWRXUWWxObLIt_79df57cd", (String)"\u8f6c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e0\uff0c\u4e0d\u80fd\u751f\u6210\u8ba2\u5355"));
                    }
                    if (toOrderQuantity.compareTo(requestMatchInfomationVO.getQuantity()) > 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_materialCode", (String)"\u7269\u6599\u7f16\u7801") + requestMatchInfomationVO.getMaterialNumber() + I18nUtil.translate((String)"i18n_field_jsItWRxOBRqsItR_848c33d3", (String)"\u7684\u8f6c\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u8f6c\u8ba2\u5355\u91cf"));
                    }
                    requestMatchInfomationVO1.setToOrderQuantity(toOrderQuantity);
                    key.put(requestMatchInfomationVO.getRequestItemId(), requestMatchInfomationVO1);
                } else {
                    if (requestMatchInfomationVO.getToOrderQuantity().compareTo(requestMatchInfomationVO.getQuantity()) > 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_materialCode", (String)"\u7269\u6599\u7f16\u7801") + requestMatchInfomationVO.getMaterialNumber() + I18nUtil.translate((String)"i18n_field_jsItWRxOBRqsItR_848c33d3", (String)"\u7684\u8f6c\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u8f6c\u8ba2\u5355\u91cf"));
                    }
                    if (requestMatchInfomationVO.getToOrderQuantity().compareTo(BigDecimal.valueOf(0L)) <= 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_sItWRXUWWxObLIt_79df57cd", (String)"\u8f6c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e0\uff0c\u4e0d\u80fd\u751f\u6210\u8ba2\u5355"));
                    }
                    requestMatchInfomationVO1 = new RequestMatchInfomationVO();
                    requestMatchInfomationVO1.setRequestNumber(requestMatchInfomationVO.getRequestNumber());
                    requestMatchInfomationVO1.setRequestItemNumber(requestMatchInfomationVO.getRequestItemNumber());
                    requestMatchInfomationVO1.setToOrderQuantity(requestMatchInfomationVO.getToOrderQuantity());
                    key.put(requestMatchInfomationVO.getRequestItemId(), requestMatchInfomationVO1);
                }
                if (SupplierCoordinationWayEnum.SRM_COORDINATIONWAY.getValue().equals(requestMatchInfomationVO.getNeedCoordination()) || MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue().equals(requestMatchInfomationVO.getJit())) continue;
                throw new ELSBootException("\u7269\u6599\u7f16\u7801:" + requestMatchInfomationVO.getMaterialNumber() + "\u4f9b\u5e94\u5546:" + requestMatchInfomationVO.getSupplierName() + "\u4e0d\u652f\u6301\u8be5\u9001\u8d27\u5b89\u6392");
            }
            List<PurchaseOrderHeadDTO> res = this.purchaseRequestHeadService.requestToCreateOrder(requestMatchInfomationList);
            Result result = Result.ok(res);
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            for (String id : requestItemIds) {
                this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
            }
        }
    }

    @ApiOperation(value="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f", notes="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/contractQueryRequest"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> contractQueryRequest(PurchaseRequestItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.notInSql((Object)"item_status", "-1, 0,-2");
        ((QueryWrapper)queryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq((Object)"audit_status", (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        })).orderByDesc(true, (Object[])new String[]{"create_time"});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u89c4\u5212\u6c42\u89e3\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f", notes="\u89c4\u5212\u6c42\u89e3\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/lpSolveQueryRequest"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> lpSolveQueryRequest(PurchaseRequestItem item, @RequestParam String startDateStr, @RequestParam String endDateStr, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        DateTime startDate = DateUtil.parse((CharSequence)startDateStr, (String)"yyyy-MM-dd");
        DateTime endDate = DateUtil.parse((CharSequence)endDateStr, (String)"yyyy-MM-dd");
        queryWrapper.in((Object)"item_status", new Object[]{"2", "7", "8", "9"});
        queryWrapper.and(qw -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)qw.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq((Object)"audit_status", (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        });
        queryWrapper.ge((Object)"delivery_date", (Object)startDate);
        queryWrapper.le((Object)"delivery_date", (Object)endDate);
        queryWrapper.orderByDesc(true, (Object[])new String[]{"create_time"});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5bfc\u5165\u7b26\u5408\u89c4\u5212\u6c42\u89e3\u8981\u6c42\u7684\u7533\u8bf7\u884c\u6570\u636e", notes="\u5bfc\u5165\u7b26\u5408\u89c4\u5212\u6c42\u89e3\u8981\u6c42\u7684\u7533\u8bf7\u884c\u6570\u636e")
    @GetMapping(value={"/lpSolveQueryRequestList"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> lpSolveQueryRequest(PurchaseRequestItem item, @RequestParam String startDateStr, @RequestParam String endDateStr) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        DateTime startDate = DateUtil.parse((CharSequence)startDateStr, (String)"yyyy-MM-dd");
        DateTime endDate = DateUtil.parse((CharSequence)endDateStr, (String)"yyyy-MM-dd");
        queryWrapper.in(PurchaseRequestItem::getItemStatus, new Object[]{"2", "7", "8", "9"});
        queryWrapper.and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(PurchaseRequestItem::getAuditStatus, (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq(PurchaseRequestItem::getAuditStatus, (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        });
        queryWrapper.ge(PurchaseRequestItem::getDeliveryDate, (Object)startDate);
        queryWrapper.le(PurchaseRequestItem::getDeliveryDate, (Object)endDate);
        queryWrapper.orderByDesc(true, (Object[])new SFunction[]{BaseEntity::getCreateTime});
        List requestItemList = this.purchaseRequestItemService.list((Wrapper)queryWrapper);
        return Result.ok((Object)requestItemList);
    }

    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> add(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        PurchaseRequestHeadVO purchaseRequestHead = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHeadPage), (Object)((Object)purchaseRequestHead));
        this.purchaseRequestHeadService.saveMain(purchaseRequestHead, purchaseRequestHeadPage.getPurchaseRequestItemList(), purchaseRequestHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseRequestHead));
    }

    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u7f16\u8f91")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:edit"})
    @SrmValidated
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> edit(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        PurchaseRequestHeadVO purchaseRequestHead = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHeadPage), (Object)((Object)purchaseRequestHead));
        this.purchaseRequestHeadService.updateMain(purchaseRequestHead, purchaseRequestHeadPage.getPurchaseRequestItemList(), purchaseRequestHeadPage.getPurchaseAttachmentList());
        String id = purchaseRequestHead.getId();
        return this.queryById(id);
    }

    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7\u5934-\u4f5c\u5e9f", notes="\u91c7\u8d2d\u7533\u8bf7\u5934-\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u4f5c\u5e9f")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:cancel"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    @SrmValidated
    public Result<?> cancel(@RequestBody PurchaseRequestHeadVO head) {
        head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue());
        this.purchaseRequestHeadService.updateStatus(head);
        return this.commonSuccessResult(7);
    }

    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u63d0\u4ea4")
    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7-\u63d0\u4ea4\u9700\u6c42\u6c60", notes="\u91c7\u8d2d\u7533\u8bf7-\u63d0\u4ea4\u9700\u6c42\u6c60")
    @PostMapping(value={"/toDemandPool"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:toDemandPool"})
    @SrmValidated
    public Result<?> toDemandPool(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        List<PurchaseRequestItem> collect;
        this.edit(purchaseRequestHeadPage);
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemService.selectByMainId(purchaseRequestHeadPage.getId());
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_DJuTVuRRjImcdI_442c1b0e", (String)"\u63d0\u4ea4\u5230\u9700\u6c42\u6c60\u81f3\u5c11\u6709\u4e00\u4e2a\u884c\u9879\u76ee"));
        }
        HashMap itemStatusMap = new HashMap();
        purchaseRequestItems.forEach(item -> {
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_cTVWRlTfUW_49c8866", (String)"\u884c\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getPurchaseOrg()), (String)I18nUtil.translate((String)"i18n_alert_cXjnRVRxOLVWVKItbWsLDWSNVRGRsLDRHIdjRKVRW_306d9a1f", (String)"\u884c\u4e0a\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u4e2d\u7ef4\u62a4,\u6216\u8005\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u5173\u8054\u7ec4\u7ec7!"));
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)item.getCompany()), (String)I18nUtil.translate((String)"i18n_alert_cXjRCooxOLVWVKVRGRsLDRHIdjXtESVRW_c851671b", (String)"\u884c\u4e0a\u7684\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7!"));
            itemStatusMap.put(item.getId(), Integer.parseInt(item.getAuditStatus()));
        });
        List<String> materialNumbers = purchaseRequestItems.stream().map(PurchaseRequestItem::getMaterialNumber).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialNumbers)) {
            Map<String, String> materialItemNumberMap = purchaseRequestItems.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toMap(PurchaseRequestItem::getMaterialNumber, PurchaseRequestItem::getItemNumber, (entity1, entity2) -> entity1));
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOS = this.purchaseMaterialHeadService.listByMaterialNumbers(materialNumbers);
            List blocDelMaterial = purchaseMaterialHeadDTOS.stream().filter(material -> "1".equals(material.getBlocDel())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtils.isEmpty(blocDelMaterial), (String)I18nUtil.translate((String)"", (String)("\u7269\u6599\u7f16\u7801:" + blocDelMaterial.stream().map(p -> p.getMaterialNumber() + "\u3010" + (String)materialItemNumberMap.get(p.getMaterialNumber()) + "\u3011\u884c").collect(Collectors.joining(",")) + "\u7269\u6599\u5df2\u88ab\u5220\u9664")));
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            this.purchaseRequestItemService.toDemandPool(purchaseRequestHeadPage);
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            LambdaUpdateWrapper updateWrapper;
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{BaseEntity::getId, PurchaseRequestItem::getItemStatus, PurchaseRequestItem::getSourceType});
            wrapper.in(BaseEntity::getId, itemStatusMap.keySet());
            List items = this.purchaseRequestItemService.list((Wrapper)wrapper);
            List idsMall = items.stream().filter(item -> "mall".equals(item.getSourceType())).filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(i.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
            List idsOther = items.stream().filter(item -> !"mall".equals(item.getSourceType())).filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus())).map(BaseEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idsOther)) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                updateWrapper.in(BaseEntity::getId, idsOther);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
            if (!CollectionUtils.isEmpty(idsMall)) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getTacticsEntity, null);
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, null);
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                updateWrapper.in(BaseEntity::getId, idsMall);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
        }
        if (!CollectionUtils.isEmpty(collect = purchaseRequestItems.parallelStream().filter(item -> !StringUtils.isBlank((CharSequence)item.getMaterialNumber())).filter(item -> !"mall".equals(item.getSourceType())).collect(Collectors.toList()))) {
            this.purchaseRequestHeadService.matchPrice(collect);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestHeadService.lambdaUpdate().eq(BaseEntity::getId, (Object)purchaseRequestHeadPage.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue())).update((Object)new PurchaseRequestHead());
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(purchaseRequestHeadPage.getElsAccount());
        this.purchaseRequestHeadService.sendMessage(TenantContext.getTenant(), "purchaseRequest", "toDemandPool", purchaseRequestHeadPage.getId(), "purchaseRequestBusinessDataRpcService", toElsAccountList);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:delete"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.budgetManageRpcService.refundOfOccupiedAmount(id);
        this.purchaseRequestHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseRequestHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseRequestHeadVO purchaseRequestHeadVO = this.getData(id);
        return Result.ok((Object)((Object)purchaseRequestHeadVO));
    }

    private PurchaseRequestHeadVO getData(String id) {
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseRequestHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return purchaseRequestHeadVO;
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c")
    @GetMapping(value={"/queryPurchaseRequestItemByMainId"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:view"})
    public Result<?> queryPurchaseRequestItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        return Result.ok(purchaseRequestItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u6587\u4ef6", notes="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u6587\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:view"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id", required=true) String id) {
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        return Result.ok((Object)purchaseAttachmentList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7")
    @ApiOperation(value="\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7", notes="\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7")
    @PostMapping(value={"/createRequestByProduct"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:toProduct"})
    @SrmValidated
    public Result<?> createRequestByProduct(@RequestBody List<PurchaseUserCartDTO> purchaseUserCarts) {
        List<TemplateHeadDTO> templateHeadList = this.templateHeadService.getDefaultTemplateByType("purchaseRequest");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(templateHeadList)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_xMKCLjnRUVIrWVGRCLIr_841b7908", (String)"\u4e0d\u5b58\u5728\u9ed8\u8ba4\u7684\u91c7\u8d2d\u7533\u8bf7\u6a21\u677f\uff0c\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u6a21\u677f"));
        }
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        TemplateHeadDTO templateHead = templateHeadList.get(0);
        purchaseRequestHeadVO.setTemplateNumber(templateHead.getTemplateNumber());
        purchaseRequestHeadVO.setTemplateName(templateHead.getTemplateName());
        purchaseRequestHeadVO.setTemplateAccount(templateHead.getElsAccount());
        purchaseRequestHeadVO.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
        purchaseRequestHeadVO.setElsAccount(this.getTenantId());
        purchaseRequestHeadVO.setCreateBy(this.getCurrentUser().getSubAccount());
        purchaseRequestHeadVO.setCreateTime(new Date());
        purchaseRequestHeadVO.setSourceType("mall");
        purchaseRequestHeadVO.setDeleted(0);
        ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        ArrayList<String> cartIds = new ArrayList<String>();
        for (PurchaseUserCartDTO cart : purchaseUserCarts) {
            PurchaseRequestItem item = new PurchaseRequestItem();
            if (StringUtils.isBlank((CharSequence)cart.getProductInventoryId())) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_GMVHLVWVImW_e432dcbe", (String)"\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            PurchaseProductInventoryDTO purchaseProductInventory = this.purchaseProductInventoryService.getById(cart.getProductInventoryId());
            if (null == purchaseProductInventory) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_GMVHLVWVImW_e432dcbe", (String)"\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            if (StringUtils.isBlank((CharSequence)purchaseProductInventory.getProductMaterialCode())) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_GMVHvLBjRKjSLAoWVImW_ca4120c4", (String)"\u5e93\u5b58\u4fe1\u606f\u91cc\u9762\u6ca1\u6709\u5173\u8054\u7684\u7269\u6599\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            PurchaseMaterialHeadDTO material = this.purchaseMaterialHeadService.getMaterialHeadByNumber(purchaseProductInventory.getProductMaterialCode());
            if (null == material) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_SLxMKWVImW_70a9c704", (String)"\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            item.setRepertoryUnit(material.getRepertoryUnit());
            item.setPurchaseUnit(material.getPurchaseUnit());
            item.setMaterialNumber(material.getMaterialNumber());
            item.setMaterialDesc(material.getMaterialDesc());
            item.setMaterialName(material.getMaterialName());
            item.setCateLevelCode(material.getCateLevelCode());
            item.setMaterialSpec(material.getMaterialSpec());
            item.setMaterialType(material.getMaterialType());
            item.setMaterialTypeName(material.getMaterialTypeName());
            item.setBrand(cart.getBrandName());
            item.setBaseUnit(cart.getBasicUnit());
            item.setNetWeight(material.getNetWeight());
            item.setMaterialGroup(material.getMaterialGroup());
            item.setCateCode(material.getCateCode());
            item.setCateName(material.getCateName());
            item.setFactory(material.getFactory());
            item.setQuantity(cart.getProductCount());
            item.setRepertoryQuantity(cart.getProductCount());
            item.setSubtotalAmount(cart.getProductPrice().multiply(cart.getProductCount()));
            item.setNetPrice(cart.getProductPrice());
            item.setPrice(cart.getProductPrice());
            item.setBudgetPrice(cart.getProductPrice());
            item.setSourceType("mall");
            item.setItemStatus("0");
            item.setDeleted(0);
            item.setExpectSupplierEls(cart.getProductCreateByElesAccount());
            item.setExpectSupplierName(cart.getProductCreateBy());
            purchaseRequestItemList.add(item);
            cartIds.add(cart.getId());
        }
        BigDecimal total = purchaseRequestItemList.stream().filter(p -> p.getSubtotalAmount() != null).map(PurchaseRequestItem::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        purchaseRequestHeadVO.setTotalAmount(total);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        this.purchaseRequestHeadService.saveMain(purchaseRequestHeadVO, purchaseRequestItemList, purchaseRequestHeadVO.getPurchaseAttachmentList());
        this.purchaseUserCartService.delBatchPurchaseUserCart(cartIds);
        return Result.ok((Object)((Object)purchaseRequestHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> queryTabsCount(PurchaseRequestHead purchaseRequestHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"request_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"request_status");
        List list = ((PurchaseRequestHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestStatus, PurchaseRequestHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "requestStatus", null, all));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmRequestStatus", TenantContext.getTenant());
        for (DictDTO status : srmRequestStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "requestStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:export"})
    @PermissionDataView(businessType="purchaseRequest")
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseRequestHeadExportServiceImpl.class);
    }

    @ApiOperation(value="\u4eceERP\u83b7\u53d6\u6570\u636e", notes="\u4eceERP\u83b7\u53d6\u6570\u636e")
    @GetMapping(value={"/getPurchaseRequestByERP"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:getPurchaseRequestByERP"})
    public Result<?> getPurchaseRequestByERP() {
        this.purchaseRequestHeadService.getPurchaseRequestByERP();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushPurchaseRequestData"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:pushPurchaseRequestData"})
    public Result<?> pushPurchaseRequestData(@RequestParam(value="ids") String ids) {
        this.purchaseRequestHeadService.pushPurchaseRequestData(ids);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u590d\u5236\u5355\u636e", notes="\u590d\u5236\u5355\u636e")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:copy"})
    public Result<?> copy(@RequestParam(value="id") String id) {
        PurchaseRequestHeadVO data = this.getData(id);
        this.purchaseRequestHeadService.copy(data);
        return this.commonSuccessResult(3);
    }
}

