/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.bidding.vo.SupplierRelationFindResultVO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.ebidding.entity.ProbeResult;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingItemHis;
import com.els.modules.ebidding.entity.PurchaseEbiddingSupplier;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingItem;
import com.els.modules.ebidding.enumerate.EbiddingItemStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.excel.PurchaseEbiddingHeadExportServiceImpl;
import com.els.modules.ebidding.job.utils.EbiddingJobUtil;
import com.els.modules.ebidding.service.OtherInquiryToEbiddingService;
import com.els.modules.ebidding.service.ProbeResultService;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemHisService;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingSupplierService;
import com.els.modules.ebidding.service.SaleEbiddingHeadService;
import com.els.modules.ebidding.service.SaleEbiddingItemService;
import com.els.modules.ebidding.service.impl.PurchaseEbiddingItemHisServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingHeadServiceImpl;
import com.els.modules.ebidding.service.impl.SaleEbiddingItemServiceImpl;
import com.els.modules.ebidding.utils.EbiddingShowUtil;
import com.els.modules.ebidding.vo.PurchaseAwardOpinionVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingConfirmVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingHeadVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingPrintVO;
import com.els.modules.ebidding.vo.PurchaseEbiddingSupplierVO;
import com.els.modules.ebidding.vo.ToEbiddingVO;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.utils.DefaultValueInitUtil;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.inquiry.enumerate.SourceTypeEnum;
import com.els.modules.inquiry.service.PurchaseAwardOpinionService;
import com.els.modules.searchSourceConfig.service.SearSourMaterValidService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/ebidding/purchaseEbiddingHead"})
@Api(tags={"\u91c7\u8d2d\u7ade\u4ef7\u5934"})
@BusinessModule(module="ebidding")
public class PurchaseEbiddingHeadController
extends BaseController<PurchaseEbiddingHead, PurchaseEbiddingHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingHeadController.class);
    @Autowired
    private PurchaseEbiddingItemService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingSupplierService ebiddingSupplierService;
    @Autowired
    private PurchaseEbiddingConfirmService purchaseEbiddingConfirmService;
    @Autowired
    private SearSourMaterValidService validService;
    @Autowired
    private PurchaseAwardOpinionService purchaseAwardOpinionService;
    @Autowired
    private SaleEbiddingHeadService saleEbiddingHeadService;
    @Autowired
    private RedisUtil redis;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private ProbeResultService probeResultService;
    @Autowired
    private PurchaseEbiddingItemHisService purchaseEbiddingItemHisService;
    @Resource
    private OtherInquiryToEbiddingService otherInquiryToEbiddingService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:list"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> queryPageList(PurchaseEbiddingHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEbiddingHeadService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:list"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> queryTabsCount(PurchaseEbiddingHead head, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"ebidding_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"ebidding_status");
        List list = ((PurchaseEbiddingHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseEbiddingHead::getEbiddingStatus, PurchaseEbiddingHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "ebiddingStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmEbiddingStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"0", "1", "3", "4", "5", "6", "7", "10", "11", "12"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "ebiddingStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5408\u540c\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f", notes="\u5408\u540c\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/contractQueryEbidding"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:list"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> contractQueryEbidding(PurchaseEbiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().in(PurchaseEbiddingItem::getAuditStatus, Arrays.asList(AuditStatusEnum.AUDIT_FINISH.getValue(), AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()))).eq(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BID_WIN.getValue())).orderByDesc(BaseEntity::getCreateTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEbiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u8ba2\u5355\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f", notes="\u8ba2\u5355\u67e5\u8be2\u7ade\u4ef7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/orderQueryEbiddingByDesc"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:list"})
    @PermissionDataView(businessType="ebidding")
    public Result<?> orderQueryEbiddingByDesc(PurchaseEbiddingItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BID_WIN.getValue())).eq(PurchaseEbiddingItem::getMaterialDesc, (Object)item.getMaterialDesc())).and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(PurchaseEbiddingItem::getMaterialNumber)).or()).eq(PurchaseEbiddingItem::getMaterialNumber, (Object)"");
        });
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEbiddingItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u7ade\u4ef7", notes="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u7ade\u4ef7")
    @GetMapping(value={"/supplierPortraitCount"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:list", "supplier_master_data#supplierMasterData:picImage", "supplier_master_data#supplierMasterData:list"}, logical=Logical.OR)
    public Result<?> supplierPortraitCount(@RequestParam(name="toElsAccount") String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEbiddingItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        List allList = this.purchaseEbiddingItemService.list((Wrapper)queryWrapper);
        long participationCount = allList.stream().map(PurchaseEbiddingItem::getHeadId).distinct().count();
        long biddingWinCount = allList.stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).map(PurchaseEbiddingItem::getHeadId).distinct().count();
        HashMap<String, Long> returnMap = new HashMap<String, Long>();
        returnMap.put("participationCount", participationCount);
        returnMap.put("biddingWinCount", biddingWinCount);
        return Result.ok(returnMap);
    }

    @ApiOperation(value="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u7ade\u4ef7-\u5217\u8868\u8df3\u8f6c", notes="\u4f9b\u5e94\u5546\u753b\u50cf\u67e5\u8be2\u7ade\u4ef7-\u5217\u8868\u8df3\u8f6c")
    @GetMapping(value={"/supplierPortraiTotList"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:list"})
    public Result<?> supplierPortraiTotList(@RequestParam(name="toElsAccount") String toElsAccount, @RequestParam(name="type") String type) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(PurchaseEbiddingItem::getToElsAccount, (Object)toElsAccount);
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.eq("1".equals(type), PurchaseEbiddingItem::getItemStatus, (Object)EbiddingItemStatusEnum.BID_WIN.getValue());
        List allList = this.purchaseEbiddingItemService.list((Wrapper)queryWrapper);
        List ids = allList.stream().map(PurchaseEbiddingItem::getHeadId).distinct().collect(Collectors.toList());
        String id = ids.isEmpty() ? "-1" : String.join((CharSequence)",", ids);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("id", id);
        returnMap.put("isMenu", true);
        return Result.ok(returnMap);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u8be2\u4ef7\u8f6c\u7ade\u4ef7")
    @ApiOperation(value="\u8be2\u4ef7\u8f6c\u7ade\u4ef7", notes="\u8be2\u4ef7\u8f6c\u7ade\u4ef7")
    @PostMapping(value={"/enquiryToEbidding"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:enquiryToEbidding"})
    @SrmValidated
    public Result<?> enquiryToEbidding(@RequestBody ToEbiddingVO ebiddingVO) {
        return Result.ok(Arrays.asList(this.otherInquiryToEbiddingService.enquiryToEbidding(ebiddingVO)));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u9700\u6c42\u6c60\u8f6c\u7ade\u4ef7")
    @ApiOperation(value="\u9700\u6c42\u6c60\u8f6c\u7ade\u4ef7", notes="\u9700\u6c42\u6c60\u8f6c\u8be2\u4ef7")
    @PostMapping(value={"/requestToEbidding"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:requestToEbidding"})
    @SrmValidated
    public Result<?> requestToEbidding(@RequestBody PurchaseRequestHeadVO requestHeadVO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        JSONObject companySet = loginUser.getCompanySet() == null ? new JSONObject() : loginUser.getCompanySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1");
        arrayList.add("2");
        boolean allowMultipleSources = "1".equals(companySet.getString("allowMultipleSources"));
        String templateNumber = requestHeadVO.getTemplateNumber();
        String templateVersion = requestHeadVO.getTemplateVersion();
        Assert.hasText((String)templateNumber, (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)templateVersion, (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        head.setTemplateNumber(templateNumber);
        head.setTemplateVersion(Integer.valueOf(templateVersion));
        head.setTemplateName(requestHeadVO.getTemplateName());
        head.setTemplateAccount(requestHeadVO.getTemplateAccount());
        String elsAccount = this.getTenantId();
        head.setElsAccount(elsAccount);
        head.setBusAccount(elsAccount);
        ArrayList<PurchaseEbiddingItem> itemList = new ArrayList<PurchaseEbiddingItem>();
        List<PurchaseRequestItem> requestItemList = requestHeadVO.getPurchaseRequestItemList();
        List requestIdList = requestItemList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        List purchaseRequestItemDb = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(BaseEntity::getId, requestIdList)).list();
        ArrayList<PurchaseRequestItem> purchaseRequestItems = new ArrayList<PurchaseRequestItem>();
        block0: for (PurchaseRequestItem item2 : requestItemList) {
            for (PurchaseRequestItem item1 : purchaseRequestItemDb) {
                if (!Objects.equals(item2.getId(), item1.getId())) continue;
                purchaseRequestItems.add(item1);
                continue block0;
            }
        }
        long sameOrgCount = purchaseRequestItems.stream().map(item -> item.getPurchaseOrg() == null ? "" : item.getPurchaseOrg()).distinct().count();
        Assert.isTrue((sameOrgCount == 1L ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_oper_no_the_same_purchase_organization", (String)"\u76f8\u540c\u91c7\u8d2d\u7ec4\u7ec7\u624d\u53ef\u8f6c\u5355"));
        this.validService.requestPoolValid("1", ((PurchaseRequestItem)((Object)purchaseRequestItems.get(0))).getPurchaseOrg(), purchaseRequestItems);
        List<PurchaseRequestItem> mergeRequestList = this.purchaseRequestItemService.mergeRequest(purchaseRequestItems);
        Map<String, String> itemValueMap = DefaultValueInitUtil.getItemDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        for (PurchaseRequestItem requestItem : mergeRequestList) {
            if (!allowMultipleSources && !arrayList.contains(requestItem.getItemStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWxBnHeiTOmhjER_5462a613", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u4e0d\u7b26\u5408\u7cfb\u7edf\u5141\u8bb8\u591a\u6b21\u5bfb\u6e90\u914d\u7f6e", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            PurchaseEbiddingItem item3 = new PurchaseEbiddingItem();
            BeanUtils.copyProperties((Object)((Object)requestItem), (Object)((Object)item3));
            item3.setRequireQuantity(requestItem.getQuantity());
            item3.setSourceType(SourceTypeEnum.REQUEST.getValue());
            item3.setSourceNumber(requestItem.getRequestNumber());
            item3.setSourceItemNumber(requestItem.getItemNumber());
            item3.setSourceId(requestItem.getHeadId());
            item3.setSourceItemId(requestItem.getId());
            item3.setDocumentParentId(requestItem.getId());
            item3.setDocumentItemId(requestItem.getDocumentItemId());
            item3.setDocumentId(requestItem.getDocumentId());
            item3.setPriceUnit(requestItem.getUnitPrice());
            item3.setRequireQuantity(requestItem.getQuantity());
            String purchaseUnit = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseUnit", requestItem.getPurchaseUnit());
            String purchaseType = DefaultValueInitUtil.getFieldValue(itemValueMap, "purchaseType", requestItem.getPurchaseType());
            item3.setPurchaseUnit(purchaseUnit);
            item3.setPurchaseType(purchaseType);
            item3.setRequireDate(requestItem.getDeliveryDate());
            item3.setPrice(null);
            item3.setNetPrice(null);
            item3.setTotalAmount(null);
            item3.setNetTotalAmount(null);
            item3.setTaxAmount(null);
            item3.setNetAmount(null);
            itemList.add(item3);
        }
        String documentId = requestItemList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getDocumentId())).map(PurchaseRequestItem::getDocumentId).distinct().collect(Collectors.joining(","));
        head.setDocumentId(documentId);
        String documentParentId = requestItemList.stream().filter(i -> StringUtils.isNotBlank((CharSequence)i.getHeadId())).map(PurchaseRequestItem::getHeadId).distinct().collect(Collectors.joining(","));
        head.setDocumentParentId(documentParentId);
        head.setCompany(requestItemList.get(0).getCompany());
        head.setPurchaseOrg(requestItemList.get(0).getPurchaseOrg());
        Map<String, String> headValueMap = DefaultValueInitUtil.getHeadDefaultValue(requestHeadVO.getTemplateAccount(), templateNumber, templateVersion);
        String purchaseGroup = DefaultValueInitUtil.getFieldValue(headValueMap, "purchaseGroup", mergeRequestList.get(0).getPurchaseGroup());
        head.setPurchaseGroup(purchaseGroup);
        if ("person".equals(requestItemList.get(0).getTacticsEntity())) {
            head.setPurchasePrincipal(requestItemList.get(0).getTacticsObject());
        } else {
            LoginUser sysUser = this.getCurrentUser();
            head.setPurchasePrincipal(sysUser.getSubAccount() + "_" + sysUser.getRealname());
        }
        head.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)head));
        ((PurchaseEbiddingHeadService)this.service).saveMain(head, itemList, null, null, null);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_sOuLRWOutyLWWWWWWW_e9f10831", (String)"\u8f6c\u7ade\u4ef7\u6210\u529f,\u7ade\u4ef7\u5355\u53f7\u4e3a:[${0}]", (String[])new String[]{head.getEbiddingNumber()}), Arrays.asList(head));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> add(@RequestBody PurchaseEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        this.checkTime(headVO);
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setElsAccount(super.getTenantId());
        head.setBusAccount(super.getTenantId());
        head.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)head));
        ((PurchaseEbiddingHeadService)this.service).saveMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        return Result.ok((Object)((Object)head));
    }

    private void checkTime(PurchaseEbiddingHeadVO headVO) {
        this.checkNumber(headVO.getBeforeEndMinute());
        this.checkNumber(headVO.getDelayMinute());
        this.checkNumber(headVO.getDelayCount());
    }

    private void checkNumber(Integer object) {
        if (ObjectUtils.isEmpty((Object)object)) {
            return;
        }
        int i = object.compareTo(0);
        Assert.isTrue((i != -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_KISmWxOLBW_ab51fe34", (String)"\u65f6\u95f4\u6216\u6b21\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570"));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:edit"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> edit(@RequestBody PurchaseEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHead head = new PurchaseEbiddingHead();
        this.checkTime(headVO);
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setElsAccount(super.getTenantId());
        head.setBusAccount(super.getTenantId());
        ((PurchaseEbiddingHeadService)this.service).updateMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        String id = head.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:copy"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> copy(@RequestParam(name="id") String id) {
        List dbConfirmList;
        List dbItemList;
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        if (EbiddingStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus())) {
            dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
            dbConfirmList = this.purchaseEbiddingConfirmService.selectByMainId(id);
        } else {
            ElsInitialTableDTO itemInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(id, "item");
            dbItemList = JSON.parseArray((String)itemInitInfo.getBusinessInfoJson(), PurchaseEbiddingItem.class);
            ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(id, "confirm");
            dbConfirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmVO.class);
        }
        List<PurchaseEbiddingSupplier> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        List attachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        dbHead.setGenerateContract("0");
        if (!ObjectUtils.isEmpty((Object)dbHead.getExpiryDate()) && !ObjectUtils.isEmpty((Object)dbHead.getEffectiveDate())) {
            dbItemList.forEach(e -> {
                e.setExpiryDate(dbHead.getExpiryDate());
                e.setEffectiveDate(dbHead.getEffectiveDate());
            });
        }
        ((PurchaseEbiddingHeadService)this.service).copy(dbHead, dbItemList, dbSupplierList, attachmentDemandList, dbConfirmList);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u5220\u9664")
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:delete"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((PurchaseEbiddingHeadService)this.service).delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:publish"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> publish(@RequestBody PurchaseEbiddingHeadVO headVO) {
        this.validService.publishEbidding(headVO.getPurchaseOrg(), headVO.getPurchaseEbiddingItemList());
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        this.checkTime(headVO);
        if (StrUtil.isBlank((CharSequence)headVO.getEbiddingNumber())) {
            headVO.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)headVO));
        }
        String elsAccount = this.getTenantId();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setResultAuditStatus("1".equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        ((PurchaseEbiddingHeadService)this.service).publish(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546")
    @ApiOperation(value="\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546", notes="\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546")
    @PostMapping(value={"/publishNewSupplier"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:publishNewSupplier"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> publishNewSupplier(@RequestBody PurchaseEbiddingHeadVO headVO) {
        String id = headVO.getId();
        Assert.hasText((String)id, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        Assert.isTrue((boolean)"1".equals(dbHead.getPublishNewSupplier()), (String)I18nUtil.translate((String)"i18n_alert_APtFxiThxVRdX_8aeb97e0", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u5141\u8bb8\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        List<String> status = Arrays.asList(EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n__RjodBnoOujtFqtk_597479cc", (String)"\u53ea\u6709\u5f85\u5e94\u6807\u548c\u5f85\u7ade\u4ef7\u7684\u5355\u636e\u53ef\u64cd\u4f5c"));
        List<PurchaseEbiddingSupplier> webSupplierList = headVO.getPurchaseEbiddingSupplierList();
        Assert.notEmpty(webSupplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXxOLV_4ed7d39d", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
        if ("1".equals(dbHead.getNeedEcho())) {
            Assert.isTrue((boolean)dbHead.getEchoEndTime().after(new Date()), (String)I18nUtil.translate((String)"i18n__dByRKIIuShhxVRdX_7e0bede9", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u5230\uff0c\u65e0\u6cd5\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        } else if (EbiddingStatusEnum.BIDDING.getValue().equals(dbHead.getEbiddingStatus())) {
            Assert.isTrue((boolean)dbHead.getBeginTime().after(new Date()), (String)I18nUtil.translate((String)"i18n__OuvKKIRLShhxVRdX_5a9913cf", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u8fc7\u4e86\uff0c\u65e0\u6cd5\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        } else {
            List<PurchaseEbiddingItem> purchaseEbiddingItems = this.purchaseEbiddingItemService.selectByMainId(id);
            List collect = purchaseEbiddingItems.stream().filter(item -> EbiddingItemStatusEnum.BIDDING.getValue().equals(item.getItemStatus()) || EbiddingItemStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtils.isEmpty(collect), (String)I18nUtil.translate((String)"i18n__OuvKKIRLShhxVRdX_5a9913cf", (String)"\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u8fc7\u4e86\uff0c\u65e0\u6cd5\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        }
        ((PurchaseEbiddingHeadService)this.service).publishNewSupplier(dbHead, webSupplierList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u624b\u52a8\u5f00\u542f\u7ade\u4ef7")
    @ApiOperation(value="\u624b\u52a8\u5f00\u542f\u7ade\u4ef7", notes="\u624b\u52a8\u5f00\u542f\u7ade\u4ef7")
    @PostMapping(value={"/manualStartBid"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:manualStartBid"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> manualStartBid(@RequestBody PurchaseEbiddingHeadVO headVO) {
        ((PurchaseEbiddingHeadService)this.service).manualStartBid(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7")
    @ApiOperation(value="\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7", notes="\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7")
    @PostMapping(value={"/manualEndBid"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:manualEndBid"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> manualEndBid(@RequestBody PurchaseEbiddingHeadVO headVO) {
        ((PurchaseEbiddingHeadService)this.service).manualEndBid(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u521b\u5efa\u65b0\u8f6e\u6b21")
    @ApiOperation(value="\u521b\u5efa\u65b0\u8f6e\u6b21", notes="\u521b\u5efa\u65b0\u8f6e\u6b21")
    @PostMapping(value={"/createNewRound"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:createNewRound"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> createNewRound(@RequestBody PurchaseEbiddingHeadVO headVO) {
        ((PurchaseEbiddingHeadService)this.service).createNewRound(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u63d0\u4ea4\u5b9a\u4ef7")
    @ApiOperation(value="\u63d0\u4ea4\u5b9a\u4ef7", notes="\u63d0\u4ea4\u5b9a\u4ef7")
    @PostMapping(value={"/submitPrice"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:confirmBid"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    @SrmValidated
    public Result<?> submitPrice(@RequestBody PurchaseAwardOpinionVO opinionVO) {
        Assert.hasText((String)opinionVO.getAwardOpinion(), (String)I18nUtil.translate((String)"i18n_alert_IuIIxOLV_12e2f27f", (String)"\u5b9a\u4ef7\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)opinionVO.getHeadId())));
        List<String> status = Arrays.asList(EbiddingStatusEnum.BIDDING_END.getValue(), EbiddingStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjOuyWSIMBntFnqIu_b837f2c9", (String)"\u53ea\u6709\u7ade\u4ef7\u7ed3\u675f\u6216\u5df2\u6094\u6807\u7684\u5355\u636e\u624d\u53ef\u5b9a\u4ef7"));
        Assert.isTrue((!AuditStatusEnum.AUDIT_DOING.getValue().equals(dbHead.getResultAuditStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UzsntFxqtk_19b34519", (String)"\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u4e0d\u53ef\u64cd\u4f5c"));
        log.warn("start submitPrice");
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            List<PurchaseEbiddingItemHis> dbItemList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId());
            dbItemList.forEach(item -> {
                if (EbiddingStatusEnum.REGRET.getValue().equals(dbHead.getEbiddingStatus())) {
                    Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_MBAcLVVIujtFnqtk_d961a5f7", (String)"\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
                }
                if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_title_pleaseSupplementMateriaCodeFirst", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
                }
            });
            ((PurchaseEbiddingHeadService)this.service).submitPriceByHis(dbHead, opinionVO, dbItemList);
        } else {
            List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
            dbItemList.forEach(item -> {
                if (EbiddingStatusEnum.REGRET.getValue().equals(dbHead.getEbiddingStatus())) {
                    Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_MBAcLVVIujtFnqtk_d961a5f7", (String)"\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
                }
                if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_title_pleaseSupplementMateriaCodeFirst", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
                }
            });
            ((PurchaseEbiddingHeadService)this.service).submitPrice(dbHead, opinionVO, dbItemList);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:cancel"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<String> status = Arrays.asList(EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjodBSoOujtFqku_c3c77e16", (String)"\u53ea\u6709\u5f85\u5e94\u6807\u6216\u5f85\u7ade\u4ef7\u7684\u5355\u636e\u53ef\u4f5c\u5e9f"));
        ((PurchaseEbiddingHeadService)this.service).cancel(dbHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u8f6c\u5408\u540c")
    @ApiOperation(value="\u751f\u6210\u5408\u540c", notes="\u751f\u6210\u5408\u540c")
    @PostMapping(value={"/generateContract"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:generateContract"})
    public Result<?> generateContract(@RequestBody PurchaseEbiddingHeadVO headVO) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)headVO.getTemplateNumber()), (String)I18nUtil.translate((String)"i18n_alert_ViFvKneIr_c1af30e5", (String)"\u8bf7\u9009\u62e9\u8303\u5f0f\u5408\u540c\u6a21\u677f"));
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)headVO.getId())));
        List<PurchaseContractHeadDTO> strings = EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? ((PurchaseEbiddingHeadService)this.service).generateContractByHis(headVO) : ((PurchaseEbiddingHeadService)this.service).generateContract(headVO);
        if (!strings.isEmpty() && strings.size() == 1) {
            return Result.ok(strings);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (PurchaseContractHeadDTO s : strings) {
            stringBuffer = stringBuffer.append(" " + s.getContractNumber());
        }
        return Result.ok((String)(I18nUtil.translate((String)"i18n_alert_bLneLRLRbLnetW0tyzqL_dd17f85e", (String)"\u751f\u6210\u5408\u540c\u6210\u529f,\u6210\u529f\u751f\u6210\u5408\u540c\u5355\u6570:${0},\u5355\u53f7\u5206\u522b\u4e3a:", (String[])new String[]{String.valueOf(strings.size())}) + stringBuffer));
    }

    @ApiOperation(value="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3", notes="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="ebidding")
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        headVO.setPurchaseEbiddingItemList(SysUtil.copyProperties(dbItemList, PurchaseEbiddingItem.class));
        List<PurchaseEbiddingSupplier> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        headVO.setPurchaseEbiddingSupplierList(dbSupplierList);
        if (EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus()) || CollectionUtil.isEmpty(dbSupplierList)) {
            ArrayList<PurchaseEbiddingSupplierVO> supplierVOList = new ArrayList<PurchaseEbiddingSupplierVO>();
            for (PurchaseEbiddingSupplier supplier : dbSupplierList) {
                PurchaseEbiddingSupplierVO vo = new PurchaseEbiddingSupplierVO();
                BeanUtils.copyProperties((Object)((Object)supplier), (Object)((Object)vo));
                supplierVOList.add(vo);
            }
            headVO.setPurchaseEbiddingSupplierQuoteList(supplierVOList);
        } else {
            List<PurchaseEbiddingItemHis> purchaseEbiddingItemHis = new ArrayList<PurchaseEbiddingItemHis>();
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                purchaseEbiddingItemHis = this.purchaseEbiddingItemHisService.queryAcceptDetail(dbHead);
            }
            headVO.setPurchaseEbiddingSupplierQuoteList(this.getSupplierQuote(dbHead, dbItemList, purchaseEbiddingItemHis, dbSupplierList));
            for (PurchaseEbiddingSupplierVO vo : headVO.getPurchaseEbiddingSupplierQuoteList()) {
                EbiddingShowUtil.purchaseShow(vo.getPurchaseEbiddingItemList(), dbHead, false);
            }
            if (purchaseEbiddingItemHis.size() > 0) {
                EbiddingShowUtil.purchaseShowHis(purchaseEbiddingItemHis, dbHead, false);
                Map<String, List<PurchaseEbiddingItemHis>> hisItemMap = purchaseEbiddingItemHis.stream().collect(Collectors.groupingBy(o -> o.getToElsAccount() + "-" + o.getItemNumber()));
                List<PurchaseEbiddingItem> purchaseEbiddingItemList = headVO.getPurchaseEbiddingItemList();
                for (PurchaseEbiddingItem purchaseEbiddingItem : purchaseEbiddingItemList) {
                    List<PurchaseEbiddingItemHis> hisList = hisItemMap.get(purchaseEbiddingItem.getToElsAccount() + "-" + purchaseEbiddingItem.getItemNumber());
                    purchaseEbiddingItem.setPurchaseEbiddingItemHis(hisList);
                }
            }
        }
        headVO.setPurchaseAwardOpinionList(this.purchaseAwardOpinionService.selectByMainId(id));
        headVO.setPurchaseEbiddingConfirmList(this.purchaseEbiddingConfirmService.selectByMainId(id));
        headVO.setPurchaseAttachmentDemandList(this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id));
        headVO.setPurchaseAttachmentList(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id));
        headVO.setSaleHeadList(this.saleEbiddingHeadService.getByRelationId(id));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"relation_id", (Object)id);
        queryWrapper.eq((Object)"relation_module", (Object)"ebidding");
        List resultList = this.probeResultService.list((Wrapper)queryWrapper);
        headVO.setProbeResultList(resultList);
        return Result.ok((Object)((Object)headVO));
    }

    private List<PurchaseEbiddingSupplierVO> getSupplierQuote(PurchaseEbiddingHead dbHead, List<PurchaseEbiddingItem> dbItemList, List<PurchaseEbiddingItemHis> dbItemHisList, List<PurchaseEbiddingSupplier> dbSupplierList) {
        Map<String, List<PurchaseEbiddingItem>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItem::getToElsAccount));
        Map<String, List<PurchaseEbiddingItemHis>> itemHisMap = dbItemHisList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHis::getToElsAccount));
        ArrayList<PurchaseEbiddingSupplierVO> list = new ArrayList<PurchaseEbiddingSupplierVO>();
        for (PurchaseEbiddingSupplier supplier : dbSupplierList) {
            List<PurchaseEbiddingItemHis> packageHisList;
            List<PurchaseEbiddingItemHis> itemHis;
            List<PurchaseEbiddingItem> packageList;
            PurchaseEbiddingSupplierVO supplierVO = new PurchaseEbiddingSupplierVO();
            BeanUtils.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO));
            if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                packageList = itemMap.get(supplier.getToElsAccount()).stream().limit(1L).collect(Collectors.toList());
                packageList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc()));
                supplierVO.setPurchaseEbiddingItemList(packageList);
                itemHis = itemHisMap.get(supplier.getToElsAccount());
                if (itemHis != null && itemHis.size() > 0) {
                    packageHisList = itemHis.stream().limit(1L).collect(Collectors.toList());
                    packageHisList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc()));
                    supplierVO.setPurchaseEbiddingItemHis(packageHisList);
                }
            } else if (EbiddingWayEnum.BATCH.getValue().equals(dbHead.getEbiddingWay())) {
                packageList = itemMap.get(supplier.getToElsAccount()).stream().limit(1L).collect(Collectors.toList());
                packageList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.BATCH.getDesc()));
                supplierVO.setPurchaseEbiddingItemList(packageList);
                itemHis = itemHisMap.get(supplier.getToElsAccount());
                if (itemHis != null && itemHis.size() > 0) {
                    packageHisList = itemHis.stream().limit(1L).collect(Collectors.toList());
                    packageHisList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.BATCH.getDesc()));
                    supplierVO.setPurchaseEbiddingItemHis(packageHisList);
                }
            } else {
                supplierVO.setPurchaseEbiddingItemList(itemMap.get(supplier.getToElsAccount()));
                supplierVO.setPurchaseEbiddingItemHis(itemHisMap.get(supplier.getToElsAccount()));
            }
            list.add(supplierVO);
        }
        return list;
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u5934,\u7269\u6599\u4fe1\u606f\u67e5\u8be2", notes="\u7ade\u4ef7\u5927\u5385\u5934,\u7269\u6599\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyDetail"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:queryById"})
    public Result<?> queryBidLobbyDetail(@RequestParam(name="id") String id) {
        PurchaseEbiddingHeadVO headVO = new PurchaseEbiddingHeadVO();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        Map itemMap = dbItemList.stream().collect(Collectors.toMap(PurchaseEbiddingItem::getItemNumber, Function.identity(), (newVal, oldVal) -> {
            String newStatus = newVal.getItemStatus();
            String oldStatus = oldVal.getItemStatus();
            if (newStatus.equals(EbiddingItemStatusEnum.BID_WIN.getValue()) || oldStatus.equals(EbiddingItemStatusEnum.BID_WIN.getValue())) {
                oldVal.setItemStatus(EbiddingItemStatusEnum.BID_WIN.getValue());
            } else if (newStatus.equals(EbiddingItemStatusEnum.PUBLISHED.getValue()) || oldStatus.equals(EbiddingItemStatusEnum.PUBLISHED.getValue())) {
                oldVal.setItemStatus(EbiddingItemStatusEnum.PUBLISHED.getValue());
            } else if (newStatus.equals(EbiddingItemStatusEnum.BIDDING.getValue()) || oldStatus.equals(EbiddingItemStatusEnum.BIDDING.getValue())) {
                oldVal.setItemStatus(EbiddingItemStatusEnum.BIDDING.getValue());
            }
            return oldVal;
        }));
        ArrayList distinctList = new ArrayList(itemMap.values());
        List<PurchaseEbiddingItem> purchaseEbiddingItems = distinctList.stream().sorted(Comparator.comparing(PurchaseEbiddingItem::getItemNumber)).collect(Collectors.toList());
        headVO.setPurchaseEbiddingItemList(purchaseEbiddingItems);
        headVO.setServiceTime(new Date());
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u884c\u4fe1\u606f\u67e5\u8be2", notes="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u884c\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyQuote"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:queryById"})
    public Result<?> queryBidLobbyQuote(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<PurchaseEbiddingItem> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id).stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        EbiddingShowUtil.purchaseShow(dbItemList, dbHead, true);
        List<String> statusList = Arrays.asList(EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.NOT_JOINING.getValue(), EbiddingStatusEnum.REPLY_REFUSE.getValue(), EbiddingStatusEnum.ALREADY_REPLY.getValue());
        List joiningAccountList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId()).stream().filter(head -> !statusList.contains(head.getEbiddingStatus())).map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
        List<PurchaseEbiddingItem> webList = dbItemList.stream().filter(item -> joiningAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        PurchaseEbiddingHeadVO purchaseHead = new PurchaseEbiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)purchaseHead));
        purchaseHead.setPurchaseEbiddingItemList(webList);
        return Result.ok((Object)((Object)purchaseHead));
    }

    @ApiOperation(value="\u65e5\u5f0f/\u8377\u5f0f-\u7ade\u4ef7\u5927\u5385\u65b0\u589e\u62a5\u4ef7\u8bbe\u7f6e\u67e5\u8be2", notes="\u65e5\u5f0f/\u8377\u5f0f-\u7ade\u4ef7\u5927\u5385\u65b0\u589e\u62a5\u4ef7\u8bbe\u7f6e\u67e5\u8be2")
    @GetMapping(value={"/queryAddQuoteSite"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:queryById"})
    public Result<?> queryAddQuoteSite(@RequestParam(name="headId") String headId, @RequestParam(name="itemId") String itemId) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)headId)));
        PurchaseEbiddingItem dbItem = (PurchaseEbiddingItem)((Object)this.purchaseEbiddingItemService.getById((Serializable)((Object)itemId)));
        Assert.isTrue((boolean)EbiddingItemStatusEnum.BIDDING.getValue().equals(dbItem.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_Ousncnqsu_646e6470", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u624d\u53ef\u62a5\u4ef7"));
        List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(headId);
        SaleEbiddingHead saleHead = (SaleEbiddingHead)((Object)saleHeadList.stream().filter(head -> head.getElsAccount().equals(dbItem.getToElsAccount())).collect(Collectors.toList()).get(0));
        Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(saleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_mRdXLOuxqsu_cd6812ae", (String)"\u6b64\u4f9b\u5e94\u5546\u672a\u7ade\u4ef7\u4e0d\u53ef\u62a5\u4ef7"));
        PurchaseEbiddingItemHisService purchaseEbiddingItemHisService = (PurchaseEbiddingItemHisService)SpringContextUtils.getBean(PurchaseEbiddingItemHisServiceImpl.class);
        purchaseEbiddingItemHisService.queryAddQuoteSite(dbHead, dbItem);
        return Result.ok((Object)((Object)dbItem));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u62a5\u4ef7")
    @ApiOperation(value="\u62a5\u4ef7", notes="\u62a5\u4ef7")
    @PostMapping(value={"/quote"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:quote"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    @SrmValidated
    public Result<?> quote(@RequestBody PurchaseEbiddingItem quoteItem) {
        String headId = quoteItem.getHeadId();
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)headId)));
        PurchaseEbiddingItem dbItem = (PurchaseEbiddingItem)((Object)this.purchaseEbiddingItemService.getById((Serializable)((Object)quoteItem.getId())));
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
            Assert.isTrue((boolean)EbiddingItemStatusEnum.BIDDING.getValue().equals(dbItem.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_OusncWFnqtk_36ffe5ab", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && !"1".equals(dbHead.getRespectiveQuotations())) {
                Assert.isTrue((boolean)dbHead.getCurrentItemNumber().equals(dbItem.getItemNumber()), (String)I18nUtil.translate((String)"i18n_alert_APSLxqsu_ddfaba1e", (String)"\u5f53\u524d\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            }
            List<SaleEbiddingHead> saleHeadList = this.saleEbiddingHeadService.getByRelationId(headId);
            SaleEbiddingHead saleHead = (SaleEbiddingHead)((Object)saleHeadList.stream().filter(head -> head.getElsAccount().equals(dbItem.getToElsAccount())).collect(Collectors.toList()).get(0));
            Assert.isTrue((boolean)EbiddingStatusEnum.BIDDING.getValue().equals(saleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_mRdXLOuxqsu_cd6812ae", (String)"\u6b64\u4f9b\u5e94\u5546\u672a\u7ade\u4ef7\u4e0d\u53ef\u62a5\u4ef7"));
            ((PurchaseEbiddingHeadService)this.service).quote(dbHead, dbItem, quoteItem);
        } else {
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                Assert.isTrue((boolean)dbHead.getCurrentItemNumber().equals(dbItem.getItemNumber()), (String)I18nUtil.translate((String)"i18n_alert_APSLxqsu_ddfaba1e", (String)"\u5f53\u524d\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            }
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                Assert.isTrue((!"1".equals(dbHead.getQuoteFlag()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APSLmVIsuVEoIIV_94fb2f9f", (String)"\u5f53\u524d\u7269\u6599\u6b64\u8f6e\u5df2\u62a5\u4ef7\uff0c\u8bf7\u7b49\u5f85\u4e0b\u4e00\u8f6e\uff01"));
            }
            List<PurchaseEbiddingItem> purchaseEbiddingItems = this.purchaseEbiddingItemService.selectByMainId(headId);
            List dbItemList = purchaseEbiddingItems.stream().filter(item -> dbItem.getItemNumber().equals(item.getItemNumber())).filter(item -> EbiddingItemStatusEnum.BIDDING.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            Assert.notEmpty(dbItemList, (String)I18nUtil.translate((String)"i18n_alert_OusncWFnqtk_36ffe5ab", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
            List saleHeadList = this.saleEbiddingHeadService.getByRelationId(headId).stream().filter(head -> EbiddingStatusEnum.BIDDING.getValue().equals(head.getEbiddingStatus())).collect(Collectors.toList());
            Assert.notEmpty(saleHeadList, (String)I18nUtil.translate((String)"i18n_alert_djRdXLOuxqsu_3b0939d3", (String)"\u6240\u6709\u4f9b\u5e94\u5546\u672a\u7ade\u4ef7\u4e0d\u53ef\u62a5\u4ef7"));
            List canQuoteAccount = saleHeadList.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
            List needQuoteList = dbItemList.stream().filter(item -> canQuoteAccount.contains(item.getToElsAccount())).collect(Collectors.toList());
            Assert.notEmpty(needQuoteList, (String)I18nUtil.translate((String)"i18n_alert_Bjqsujc_523b9a1", (String)"\u6ca1\u6709\u53ef\u62a5\u4ef7\u7684\u884c"));
            for (PurchaseEbiddingItem item2 : needQuoteList) {
                PurchaseEbiddingItem quote = new PurchaseEbiddingItem();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)quote));
                quote.setPrice(quoteItem.getPrice());
                quote.setNetPrice(quoteItem.getNetPrice());
                quote.setNetTotalAmount(quoteItem.getNetTotalAmount());
                quote.setTotalAmount(quoteItem.getTotalAmount());
                quote.setBidNumber(quoteItem.getBidNumber());
                ((PurchaseEbiddingHeadService)this.service).quote(dbHead, item2, quote);
            }
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    purchaseEbiddingItems = needQuoteList;
                }
                for (PurchaseEbiddingItem item2 : purchaseEbiddingItems) {
                    this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)item2.getId())).set(PurchaseEbiddingItem::getBidNumber, (Object)quoteItem.getBidNumber()));
                    SaleEbiddingItemService saleEbiddingItemService = (SaleEbiddingItemService)SpringContextUtils.getBean(SaleEbiddingItemServiceImpl.class);
                    saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItem::getRelationId, (Object)item2.getId())).set(SaleEbiddingItem::getBidNumber, (Object)quoteItem.getBidNumber()));
                }
                dbHead.setBeginTime(new Date());
                dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                dbHead.setQuoteFlag("1");
                ((PurchaseEbiddingHeadService)this.service).updateById((Object)dbHead);
                EbiddingJobUtil.createDutchQuoteJob(dbHead, dbHead.getEndTime());
                SaleEbiddingHead saleHead = new SaleEbiddingHead();
                saleHead.setQuoteFlag("1");
                saleHead.setBeginTime(dbHead.getBeginTime());
                saleHead.setStartTime(dbHead.getStartTime());
                saleHead.setEndTime(dbHead.getEndTime());
                saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                SaleEbiddingHeadService saleEbiddingHeadService = (SaleEbiddingHeadService)SpringContextUtils.getBean(SaleEbiddingHeadServiceImpl.class);
                saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHead::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHead::getEbiddingStatus, (Object)EbiddingStatusEnum.BIDDING.getValue()));
            }
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u56f4\u6807\u63a2\u6d4b")
    @ApiOperation(value="\u56f4\u6807\u63a2\u6d4b", notes="\u56f4\u6807\u63a2\u6d4b")
    @GetMapping(value={"/probeOld"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:probeOld"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> probeOld(@RequestParam(name="headId") String headId) {
        List<PurchaseEbiddingSupplier> supplierList = this.ebiddingSupplierService.selectByMainId(headId);
        Map<String, PurchaseEbiddingSupplier> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplier::getToElsAccount, Function.identity()));
        List<SupplierRelationFindResultVO> resultList = this.ebiddingSupplierService.probe(supplierMap);
        resultList.addAll(this.purchaseEbiddingItemService.probeIP(headId, supplierMap));
        return Result.ok(resultList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u65b0\u56f4\u6807\u63a2\u6d4b")
    @ApiOperation(value="\u65b0\u56f4\u6807\u63a2\u6d4b", notes="\u65b0\u56f4\u6807\u63a2\u6d4b")
    @GetMapping(value={"/probe"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:probe"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> probe(@RequestParam(name="headId") String headId) {
        List<PurchaseEbiddingSupplier> supplierList = this.ebiddingSupplierService.selectByMainId(headId);
        if (CollectionUtil.isEmpty(supplierList)) {
            return Result.ok(new ArrayList());
        }
        List<String> toElsAccounts = supplierList.stream().filter(Objects::nonNull).map(PurchaseEbiddingSupplier::getToElsAccount).collect(Collectors.toList());
        List<SupplierRelationFindResultVO> resultList = this.ebiddingSupplierService.probeSupplier(toElsAccounts);
        Map<String, PurchaseEbiddingSupplier> supplierMap = supplierList.stream().collect(Collectors.toMap(PurchaseEbiddingSupplier::getToElsAccount, Function.identity()));
        if (supplierList.size() > 1) {
            resultList.addAll(this.purchaseEbiddingItemService.probeIP(headId, supplierMap));
        }
        List supplierNameList = supplierList.stream().filter(Objects::nonNull).map(PurchaseEbiddingSupplier::getSupplierName).collect(Collectors.toList());
        ProbeResult probeResult = new ProbeResult();
        probeResult.setId(IdWorker.getIdStr());
        probeResult.setElsAccount(TenantContext.getTenant());
        probeResult.setSupplierName(StringUtils.join(supplierNameList, (String)","));
        probeResult.setRelationId(headId);
        probeResult.setRelationModule("ebidding");
        probeResult.setProbeResult(this.probeResultService.processProbeResult(resultList));
        probeResult.setDeleted(CommonConstant.DEL_FLAG_0);
        probeResult.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        probeResult.setCreateTime(new Date());
        this.probeResultService.save((Object)probeResult);
        return Result.ok(resultList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @ApiOperation(value="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55", notes="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @GetMapping(value={"/generatePriceRecord"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:generatePriceRecord"})
    public Result<?> generatePriceRecord(@RequestParam(name="headId") String headId) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"i18n_alert_WFxMKSIqQG_3b3ce094", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        Assert.isTrue((!"1".equals(dbHead.getTest()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_iKBShbLumtH_432a746d", (String)"\u6d4b\u8bd5\u6807\u65e0\u6cd5\u751f\u6210\u4ef7\u683c\u8bb0\u5f55"));
        Assert.isTrue((boolean)EbiddingStatusEnum.BID_SUCCESS.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_IIujtFnObLumtH_37deecf9", (String)"\u5df2\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55"));
        Assert.isTrue((!PriceCreateWayEnum.NOT.getValue().equals(dbHead.getPriceCreateWay()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mtFxqbLumVHtH_75f3f2e8", (String)"\u6b64\u5355\u636e\u4e0d\u53ef\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
        Assert.isTrue((boolean)PriceCreateWayEnum.MANUAL.getValue().equals(dbHead.getPriceCreateWay()), (String)I18nUtil.translate((String)"i18n_alert_umbLCKLJObLWxTlObL_6649b670", (String)"\u4ef7\u683c\u751f\u6210\u65b9\u5f0f\u4e3a\u81ea\u52a8\u751f\u6210\uff0c\u4e0d\u9700\u624b\u52a8\u751f\u6210"));
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            List<PurchaseEbiddingItemHis> acceptList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            Assert.notEmpty(acceptList, (String)I18nUtil.translate((String)"i18n_alert_BjqIbLVHtHjcVH_dfb3d5f8", (String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u4fe1\u606f\u8bb0\u5f55\u7684\u884c\u4fe1\u606f"));
            acceptList.forEach(item -> {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLyxObLumtHWVxVSLAy_c134b965", (String)"\u65e0\u6599\u53f7\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff0c\u8bf7\u8865\u5145\u7269\u6599\u7f16\u53f7"));
                Assert.isTrue((!"1".equals(item.getSendStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mtFIObLRVHtHrWxqVBbL_ad6490a8", (String)"\u6b64\u5355\u636e\u5df2\u7ecf\u751f\u6210\u8fc7\u4fe1\u606f\u8bb0\u5f55\u4e86\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210"));
            });
            ((PurchaseEbiddingHeadService)this.service).generatePriceRecordByHis(dbHead, acceptList);
        } else {
            List<PurchaseEbiddingItem> acceptList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            Assert.notEmpty(acceptList, (String)I18nUtil.translate((String)"i18n_alert_BjqIbLVHtHjcVH_dfb3d5f8", (String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u4fe1\u606f\u8bb0\u5f55\u7684\u884c\u4fe1\u606f"));
            acceptList.forEach(item -> {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLyxObLumtHWVxVSLAy_c134b965", (String)"\u65e0\u6599\u53f7\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff0c\u8bf7\u8865\u5145\u7269\u6599\u7f16\u53f7"));
                Assert.isTrue((!"1".equals(item.getSendStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mtFIObLRVHtHrWxqVBbL_ad6490a8", (String)"\u6b64\u5355\u636e\u5df2\u7ecf\u751f\u6210\u8fc7\u4fe1\u606f\u8bb0\u5f55\u4e86\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210"));
                Assert.isTrue((item.getPrice() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_import_SLBjtuxObLumdWF_b116e581", (String)"\u7269\u6599\u6ca1\u6709\u5355\u4ef7\uff0c\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u4e3b\u6570\u636e"));
            });
            ((PurchaseEbiddingHeadService)this.service).generatePriceRecord(dbHead, acceptList);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_umtHbLLR_980a4aaa", (String)"\u4ef7\u683c\u8bb0\u5f55\u751f\u6210\u6210\u529f"));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u6094\u6807")
    @ApiOperation(value="\u6094\u6807", notes="\u6094\u6807")
    @PostMapping(value={"/regret"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:regret"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> regret(@RequestBody PurchaseEbiddingHeadVO headVO) {
        Assert.hasText((String)headVO.getRegretFlag(), (String)I18nUtil.translate((String)"i18n_alert_MBBKxOLV_d46458e2", (String)"\u6094\u6807\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEbiddingHeadService)this.service).regret(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u6d41\u6807")
    @ApiOperation(value="\u6d41\u6807", notes="\u6d41\u6807")
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:failed"})
    @GetMapping(value={"/failed"})
    public Result<?> failed(@RequestParam(value="headId") String headId) {
        PurchaseEbiddingHead dbHead = (PurchaseEbiddingHead)((Object)((PurchaseEbiddingHeadService)this.service).getById((Serializable)((Object)headId)));
        List<String> status = Arrays.asList(EbiddingStatusEnum.WAIT_REPLY.getValue(), EbiddingStatusEnum.BIDDING_END.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_tFzELodBSOuyWnOtk_17fcf498", (String)"\u5355\u636e\u72b6\u6001\u4e3a\u5f85\u5e94\u6807\u6216\u7ade\u4ef7\u7ed3\u675f\u624d\u80fd\u64cd\u4f5c"));
        ((PurchaseEbiddingHeadService)this.service).failed(dbHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u5b9a\u4ef7\u901a\u77e5")
    @ApiOperation(value="\u5b9a\u4ef7\u901a\u77e5", notes="\u5b9a\u4ef7\u901a\u77e5")
    @GetMapping(value={"/pricingNotice"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:pricingNotice"})
    public Result<?> pricingNotice(@RequestParam(value="headId") String headId, @RequestParam(value="pricingNotice") String pricingNotice) {
        ((PurchaseEbiddingHeadService)this.service).pricingNotice(headId, pricingNotice);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u8865\u5145\u7269\u6599")
    @ApiOperation(value="\u8865\u5145\u7269\u6599", notes="\u8865\u5145\u7269\u6599")
    @PostMapping(value={"/replenishMaterialNumber"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:replenishMaterialNumber"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> replenishMaterialNumber(@RequestBody PurchaseEbiddingItem webItem) {
        Assert.notNull((Object)((Object)webItem), (String)I18nUtil.translate((String)"i18n_alert_xVcVHxOLV_dfd1238a", (String)"\u8865\u5145\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        this.purchaseEbiddingItemService.replenishMaterialNumber(webItem);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u7ebf\u4f9b\u5e94\u5546", notes="\u67e5\u8be2\u5728\u7ebf\u4f9b\u5e94\u5546")
    @GetMapping(value={"/queryOnlineAccount"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:queryById"})
    public Result<?> queryOnlineAccount(@RequestParam(value="headId") String headId) {
        List<PurchaseEbiddingSupplier> supplierList = this.ebiddingSupplierService.selectByMainId(headId);
        ArrayList<String> onlineAccount = new ArrayList<String>();
        for (PurchaseEbiddingSupplier supplier : supplierList) {
            String supplierAccount = supplier.getToElsAccount();
            String redisKey = "online:cache:users:" + headId + ":" + supplierAccount;
            if (!this.redis.hasKey(redisKey)) continue;
            onlineAccount.add(supplierAccount);
        }
        return Result.ok((String)String.join((CharSequence)",", onlineAccount));
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:exportXls"})
    @PermissionDataView(businessType="ebidding")
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseEbiddingHeadExportServiceImpl.class);
    }

    @ApiOperation(value="\u6253\u5370", notes="\u6253\u5370")
    @GetMapping(value={"/printEbidding"})
    public Result<?> printEbidding(@RequestParam(name="id") String id) {
        PurchaseEbiddingPrintVO printVO = ((PurchaseEbiddingHeadService)this.service).printById(id);
        return Result.ok((Object)((Object)printVO));
    }
}

