/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItemHis;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.excel.PurchaseEnquiryItemHisExportServiceImpl;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemHisService;
import com.els.modules.enquiry.vo.CurrentQuoteTrendVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u91c7\u8d2d\u8be2\u4ef7\u5386\u53f2\u884c"})
@RestController
@RequestMapping(value={"/enquiry/purchaseEnquiryItemHis"})
public class PurchaseEnquiryItemHisController
extends BaseController<PurchaseEnquiryItemHis, PurchaseEnquiryItemHisService> {
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryHead:hisList"})
    public Result<?> queryPageList(PurchaseEnquiryItemHis purchaseEnquiryItemHis, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEnquiryItemHis), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEnquiryItemHisService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        if (!CollectionUtils.isEmpty((Collection)records)) {
            List headIdList = records.stream().map(PurchaseEnquiryItemHis::getHeadId).distinct().collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper1 = new LambdaQueryWrapper();
            queryWrapper1.in(BaseEntity::getId, headIdList);
            queryWrapper1.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            List dbHeadList = this.purchaseEnquiryHeadService.list((Wrapper)queryWrapper1);
            ArrayList hideHeadIdList = new ArrayList();
            dbHeadList.forEach(dbHead -> {
                boolean showPrice;
                boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
                if (showPrice) {
                    hideHeadIdList.add(dbHead.getId());
                }
            });
            if (CollectionUtils.isEmpty(hideHeadIdList)) {
                Result.ok((Object)pageList);
            }
            List newRecordList = records.stream().filter(item -> hideHeadIdList.contains(item.getHeadId())).collect(Collectors.toList());
            pageList.setRecords(newRecordList);
            return Result.ok((Object)pageList);
        }
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u62a5\u4ef7\u5386\u53f2\u8d8b\u52bf\u56fe\u67e5\u8be2", notes="\u62a5\u4ef7\u5386\u53f2\u8d8b\u52bf\u56fe\u67e5\u8be2")
    @GetMapping(value={"/queryQuoteHisTrend"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryQuoteHisTrend(HttpServletRequest request) {
        CurrentQuoteTrendVO trendVO = ((PurchaseEnquiryItemHisService)this.service).findQuoteHis(request);
        return Result.ok((Object)trendVO);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryCompare"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompare(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String compare = request.getParameter("compare");
        ArrayList<String> compareList = StringUtils.isBlank((CharSequence)compare) ? new ArrayList() : Arrays.asList(compare.split(","));
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StringUtils.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                JSONObject result = new JSONObject();
                result.put("normalList", new ArrayList());
                result.put("ladderList", new ArrayList());
                result.put("costList", new ArrayList());
                result.put("supplierList", new ArrayList());
                return Result.ok((Object)result);
            }
        }
        JSONObject result = ((PurchaseEnquiryItemHisService)this.service).queryCompare(dbHead, compareList, toElsAccountList);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u5e38\u89c4\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareNormalList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareNormalList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StringUtils.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<JSONObject> result = ((PurchaseEnquiryItemHisService)this.service).queryCompareNormalList(dbHead, (Page<PurchaseEnquiryItemHis>)page, toElsAccountList);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u9636\u68af\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u9636\u68af\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareLadderList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareLadderList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StringUtils.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<JSONObject> result = ((PurchaseEnquiryItemHisService)this.service).queryCompareLadderList(dbHead, (Page<PurchaseEnquiryItemHis>)page, toElsAccountList);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6210\u672c\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6210\u672c\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareCostList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareCostList(@RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StringUtils.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<JSONObject> result = ((PurchaseEnquiryItemHisService)this.service).queryCompareCostList(dbHead, (Page<PurchaseEnquiryItemHis>)page, toElsAccountList);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6253\u5305\u6bd4\u4ef7", notes="\u6bd4\u4ef7\u62a5\u8868\u67e5\u8be2-\u6253\u5305\u6bd4\u4ef7")
    @GetMapping(value={"/queryCompareSupplierList"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareCostList(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StringUtils.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                return Result.ok(null);
            }
        }
        List<?> objects = ((PurchaseEnquiryItemHisService)this.service).queryCompareSupplierList(dbHead, toElsAccountList);
        return Result.ok(objects);
    }

    @ApiOperation(value="\u6bd4\u4ef7\u62a5\u8868\u6700\u65b0\u4e00\u6b21\u62a5\u4ef7\u6570\u636e\u67e5\u8be2", notes="\u6bd4\u4ef7\u62a5\u8868\u6700\u65b0\u4e00\u6b21\u62a5\u4ef7\u6570\u636e\u67e5\u8be2")
    @GetMapping(value={"/queryCompareForLast"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public Result<?> queryCompareForLast(HttpServletRequest request) {
        String headId = request.getParameter("headId");
        String compare = request.getParameter("compare");
        ArrayList<String> compareList = StringUtils.isBlank((CharSequence)compare) ? new ArrayList() : Arrays.asList(compare.split(","));
        String toElsAccount = request.getParameter("toElsAccount");
        ArrayList<String> toElsAccountList = StringUtils.isBlank((CharSequence)toElsAccount) ? new ArrayList() : Arrays.asList(toElsAccount.split(","));
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)headId)));
        if (!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus())) {
            boolean showPrice;
            boolean bl = showPrice = "1".equals(dbHead.getSeePrice()) || "1".equals(dbHead.getOpenBidStatus()) || new Date().after(dbHead.getQuoteEndTime());
            if (!showPrice) {
                JSONObject result = new JSONObject();
                result.put("normalList", new ArrayList());
                result.put("ladderList", new ArrayList());
                result.put("costList", new ArrayList());
                result.put("supplierList", new ArrayList());
                return Result.ok((Object)result);
            }
        }
        JSONObject result = ((PurchaseEnquiryItemHisService)this.service).queryCompareForLast(dbHead, compareList, toElsAccountList);
        return Result.ok((Object)result);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"enquiry#purchaseEnquiryItemHis:queryById"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseEnquiryItemHisExportServiceImpl.class);
    }
}

