/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.inquiry.utils;

public class IpV4Util {
    private static final String DEFAULT_SUBNET_MASK_A = "255.0.0.0";
    private static final String DEFAULT_SUBNET_MASK_B = "255.255.0.0";
    private static final String DEFAULT_SUBNET_MASK_C = "255.255.255.0";
    private static final String TYPE_IP_A = "A";
    private static final String TYPE_IP_B = "B";
    private static final String TYPE_IP_C = "C";
    private static final String TYPE_IP_D = "D";
    private static final String TYPE_IP_LOCATE = "locate";

    public static boolean isSameAddress(String resourceIp, String requestIp) {
        if (IpV4Util.getIpType(resourceIp).equals(IpV4Util.getIpType(requestIp))) {
            return IpV4Util.isSameAddress(resourceIp, requestIp, IpV4Util.getIpDefaultMask(IpV4Util.getIpType(resourceIp)));
        }
        return false;
    }

    private static String getIpDefaultMask(String ipType) {
        switch (ipType) {
            case "A": {
                return DEFAULT_SUBNET_MASK_A;
            }
            case "B": {
                return DEFAULT_SUBNET_MASK_B;
            }
            case "C": {
                return DEFAULT_SUBNET_MASK_C;
            }
        }
        throw new IllegalArgumentException("\u6ca1\u6709\u5bf9\u5e94\u7684mask\u5730\u5740");
    }

    private static boolean isSameAddress(String resourceIp, String requestIp, String subnetMask) {
        String resourceAddr = IpV4Util.getAddrIp(resourceIp, subnetMask);
        String subnetMaskAddr = IpV4Util.getAddrIp(requestIp, subnetMask);
        return resourceAddr.equals(subnetMaskAddr);
    }

    private static String getBinaryIp(String data) {
        String[] datas = data.split("\\.");
        StringBuilder binaryIp = new StringBuilder();
        for (String ipStr : datas) {
            long signIp = Long.parseLong(ipStr);
            String binary = Long.toBinaryString(signIp);
            long binaryInt = Long.parseLong(binary);
            binaryIp.append(String.format("%08d", binaryInt));
        }
        return binaryIp.toString();
    }

    private static String getAddrIp(String ip, String subnetMask) {
        StringBuilder addrIp = new StringBuilder();
        String binaryIp = IpV4Util.getBinaryIp(ip);
        String binarySubnetMask = IpV4Util.getBinaryIp(subnetMask);
        for (int i = 0; i < 32; ++i) {
            byte ipByte = Byte.parseByte(String.valueOf(binaryIp.charAt(i)));
            byte subnetMaskByte = Byte.parseByte(String.valueOf(binarySubnetMask.charAt(i)));
            addrIp.append(ipByte & subnetMaskByte);
        }
        return addrIp.toString();
    }

    private static String getIpType(String ip) {
        String binaryIp = IpV4Util.getBinaryIp(ip);
        if (ip.startsWith("127")) {
            return TYPE_IP_LOCATE;
        }
        if (binaryIp.startsWith("0")) {
            return TYPE_IP_A;
        }
        if (binaryIp.startsWith("10")) {
            return TYPE_IP_B;
        }
        if (binaryIp.startsWith("110")) {
            return TYPE_IP_C;
        }
        if (binaryIp.startsWith("1110")) {
            return TYPE_IP_D;
        }
        throw new IllegalArgumentException("\u65e0\u6548ip\u5f02\u5e38");
    }
}

