/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.process.service.impl;

import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.modules.tender.process.entity.TenderProcessModelNode;
import com.els.modules.tender.process.entity.TenderProcessModelNodeInfo;
import com.els.modules.tender.process.entity.TenderProcessNode;
import com.els.modules.tender.process.mapper.TenderProcessModelNodeMapper;
import com.els.modules.tender.process.service.TenderProcessModelNodeService;
import com.els.modules.tender.process.service.TenderProcessNodeService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class TenderProcessModelNodeServiceImpl
extends BaseServiceImpl<TenderProcessModelNodeMapper, TenderProcessModelNode>
implements TenderProcessModelNodeService {
    @Override
    public List<TenderProcessModelNode> selectByMainId(String mainId) {
        return ((TenderProcessModelNodeMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((TenderProcessModelNodeMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public List<TenderProcessModelNodeInfo> selectByMainIds(List<String> tenderProcessModelIdList) {
        TenderProcessNodeService processNodeService = (TenderProcessNodeService)SpringContextUtils.getBean(TenderProcessNodeService.class);
        List<TenderProcessModelNodeInfo> nodeInfoList = ((TenderProcessModelNodeMapper)this.baseMapper).selectNotJoinByMainIds(tenderProcessModelIdList);
        Set nodeIds = nodeInfoList.parallelStream().map(TenderProcessModelNode::getNodeId).collect(Collectors.toSet());
        List<TenderProcessNode> tenderProcessNodeList = processNodeService.selectBatchIds(new ArrayList<String>(nodeIds));
        Map processNodeMap = tenderProcessNodeList.parallelStream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        ArrayList<String> deDuplicateNodeIds = new ArrayList<String>();
        Iterator<TenderProcessModelNodeInfo> iterator = nodeInfoList.iterator();
        while (iterator.hasNext()) {
            TenderProcessModelNodeInfo nodeInfo = iterator.next();
            String key = nodeInfo.getHeadId() + "_" + nodeInfo.getNodeId();
            if (deDuplicateNodeIds.contains(key)) {
                iterator.remove();
                continue;
            }
            deDuplicateNodeIds.add(key);
            TenderProcessNode processNode = (TenderProcessNode)((Object)processNodeMap.get(nodeInfo.getNodeId()));
            if (processNode == null) {
                iterator.remove();
                continue;
            }
            nodeInfo.setNodeCode(processNode.getNodeCode());
            nodeInfo.setApplyRole(processNode.getApplyRole());
            nodeInfo.setSortOrder(processNode.getSortOrder());
            nodeInfo.setDefaultState(processNode.getDefaultState());
            nodeInfo.setMustNode(processNode.getMustNode());
            nodeInfo.setHightLightNode(processNode.getHightLightNode());
            nodeInfo.setDefaultCheckState(processNode.getDefaultCheckState());
            nodeInfo.setOperationCondition(processNode.getOperationCondition());
            nodeInfo.setOperationDescription(processNode.getOperationDescription());
            nodeInfo.setShowCondition(processNode.getShowCondition());
            nodeInfo.setShowDescription(processNode.getShowDescription());
            nodeInfo.setPurchaseLink(processNode.getPurchaseLink());
            nodeInfo.setPurchaseElement(processNode.getPurchaseElement());
            nodeInfo.setSaleLink(processNode.getSaleLink());
            nodeInfo.setSaleElement(processNode.getSaleElement());
            nodeInfo.setExecuterLink(processNode.getExecuterLink());
            nodeInfo.setExecuterElement(processNode.getExecuterElement());
            nodeInfo.setI18nKey(processNode.getI18nKey());
            nodeInfo.setExtend(processNode.getExtend());
        }
        return nodeInfoList;
    }
}

