/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.utils;

import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectMember;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectMemberService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectHeadVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public final class TenderProjectMemberUtils {
    private static String MATERIAL_NUMBER_PREFIX = "tender_";

    private TenderProjectMemberUtils() {
    }

    public static List<ElsSubAccountDTO> getTenderProjectMember(String headId) {
        PurchaseTenderProjectHeadService projectHeadService = (PurchaseTenderProjectHeadService)SpringContextUtils.getBean(PurchaseTenderProjectHeadService.class);
        PurchaseTenderProjectMemberService projectMemberService = (PurchaseTenderProjectMemberService)SpringContextUtils.getBean(PurchaseTenderProjectMemberService.class);
        AccountRpcService accountRpcService = (AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class);
        PurchaseTenderProjectHead tenderProjectHead = (PurchaseTenderProjectHead)((Object)projectHeadService.getById((Serializable)((Object)headId)));
        List<PurchaseTenderProjectMember> purchaseTenderProjectMemberList = projectMemberService.selectByMainId(tenderProjectHead.getId());
        ArrayList<String> searchAccountList = new ArrayList<String>();
        searchAccountList.add(tenderProjectHead.getPurchaseExecutorAccount() + "_" + tenderProjectHead.getPurchaseExecutorSubAccount());
        for (PurchaseTenderProjectMember purchaseTenderProjectMember : purchaseTenderProjectMemberList) {
            searchAccountList.add(purchaseTenderProjectMember.getElsAccount() + "_" + purchaseTenderProjectMember.getSubAccount());
        }
        List accountDTOList = accountRpcService.getAccountListByElsSubAccountWithoutUser(searchAccountList);
        return accountDTOList;
    }

    public static List<ElsSubAccountDTO> getTenderProjectMemberBySubpackageId(String subpackageId) {
        PurchaseTenderProjectHeadService projectHeadService = (PurchaseTenderProjectHeadService)SpringContextUtils.getBean(PurchaseTenderProjectHeadService.class);
        PurchaseTenderProjectMemberService projectMemberService = (PurchaseTenderProjectMemberService)SpringContextUtils.getBean(PurchaseTenderProjectMemberService.class);
        AccountRpcService accountRpcService = (AccountRpcService)SpringContextUtils.getBean(AccountRpcService.class);
        PurchaseTenderProjectHeadVO tenderProjectHead = projectHeadService.queryProjectHeadBySubpackageId(subpackageId);
        List<PurchaseTenderProjectMember> purchaseTenderProjectMemberList = projectMemberService.selectByMainId(tenderProjectHead.getId());
        ArrayList<String> searchAccountList = new ArrayList<String>();
        searchAccountList.add(tenderProjectHead.getPurchaseExecutorAccount() + "_" + tenderProjectHead.getPurchaseExecutorSubAccount());
        for (PurchaseTenderProjectMember purchaseTenderProjectMember : purchaseTenderProjectMemberList) {
            searchAccountList.add(purchaseTenderProjectMember.getElsAccount() + "_" + purchaseTenderProjectMember.getSubAccount());
        }
        List accountDTOList = accountRpcService.getAccountListByElsSubAccountWithoutUser(searchAccountList);
        return accountDTOList;
    }

    public static Queue<String> generatorMaterialNumber(long number) {
        LinkedList<String> materialNumbers = new LinkedList<String>();
        if (number == 0L) {
            return materialNumbers;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (long i = 0L; i < number; ++i) {
            materialNumbers.offer(MATERIAL_NUMBER_PREFIX + (currentTimeMillis + i));
        }
        return materialNumbers;
    }
}

