/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.tender.sale.entity.PurchaseTenderBidWinningServiceFeeHead;
import com.els.modules.tender.sale.enumerate.TenderProjectMarginHeadStatusEnum;
import com.els.modules.tender.sale.service.PurchaseTenderBidWinningServiceFeeHeadService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="tenderBidWinningServiceFeeHeadAdapter")
public class PurchaseTenderBidWinningServiceFeeHeadAdapter
implements AuditOptCallBackService {
    @Resource
    private PurchaseTenderBidWinningServiceFeeHeadService headService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
            PurchaseTenderBidWinningServiceFeeHead bidWinningServiceFeeHead = (PurchaseTenderBidWinningServiceFeeHead)((Object)JSON.parseObject((String)params, PurchaseTenderBidWinningServiceFeeHead.class));
            PurchaseTenderBidWinningServiceFeeHead dbBidWinningServiceFeeHead = (PurchaseTenderBidWinningServiceFeeHead)((Object)this.headService.getById((Serializable)((Object)bidWinningServiceFeeHead.getId())));
            if (TenderProjectMarginHeadStatusEnum.UNPAID.getValue().equals(dbBidWinningServiceFeeHead.getStatus())) {
                bidWinningServiceFeeHead.setStatus(TenderProjectMarginHeadStatusEnum.PAID.getValue());
                this.headService.publish(bidWinningServiceFeeHead);
            }
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
            PurchaseTenderBidWinningServiceFeeHead bidWinningServiceFeeHead = (PurchaseTenderBidWinningServiceFeeHead)((Object)JSON.parseObject((String)params, PurchaseTenderBidWinningServiceFeeHead.class));
            PurchaseTenderBidWinningServiceFeeHead dbBidWinningServiceFeeHead = (PurchaseTenderBidWinningServiceFeeHead)((Object)this.headService.getById((Serializable)((Object)bidWinningServiceFeeHead.getId())));
            if (AuditStatusEnum.AUDIT_DOING.getValue().equals(dbBidWinningServiceFeeHead.getAuditStatus())) {
                bidWinningServiceFeeHead.setStatus(TenderProjectMarginHeadStatusEnum.UNPAID.getValue());
                this.headService.publish(bidWinningServiceFeeHead);
            }
        }
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        PurchaseTenderBidWinningServiceFeeHead bidWinningServiceFeeHead = (PurchaseTenderBidWinningServiceFeeHead)((Object)JSON.parseObject((String)auditInputParamDTO.getParams(), PurchaseTenderBidWinningServiceFeeHead.class));
        PurchaseTenderBidWinningServiceFeeHead dbBidWinningServiceFeeHead = (PurchaseTenderBidWinningServiceFeeHead)((Object)this.headService.getById((Serializable)((Object)bidWinningServiceFeeHead.getId())));
        if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditOutputParamDTO.getAuditStatus()) && AuditStatusEnum.AUDIT_DOING.getValue().equals(dbBidWinningServiceFeeHead.getAuditStatus())) {
            bidWinningServiceFeeHead.setStatus(TenderProjectMarginHeadStatusEnum.UNPAID.getValue());
            this.headService.publish(bidWinningServiceFeeHead);
        }
        this.updateStatus(auditInputParamDTO, auditOutputParamDTO);
    }

    public JSONObject getDataById(String id) {
        PurchaseTenderBidWinningServiceFeeHead head = (PurchaseTenderBidWinningServiceFeeHead)((Object)this.headService.getById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseTenderBidWinningServiceFeeHead winningServiceFeeHead = new PurchaseTenderBidWinningServiceFeeHead();
        winningServiceFeeHead.setId(inputParamVO.getBusinessId());
        winningServiceFeeHead.setAuditStatus(outputParamVO.getAuditStatus());
        winningServiceFeeHead.setFlowId(outputParamVO.getProcessRootId());
        this.headService.updateById((Object)winningServiceFeeHead);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_").length > 1 ? account.split("_")[1] : account.split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

