/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.attachment.entity.PurchaseTenderProjectAttachmentInfo;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentInfoService;
import com.els.modules.tender.sale.enumerate.TenderProjectPurchaseBidStatusEnum;
import com.els.modules.tender.sale.enumerate.TenderProjectSourceTypeEnum;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidOrderInfoVO;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidOrderVO;
import com.els.modules.tender.sale.vo.TenderProjectPurchaseBidVO;
import com.els.modules.tender.supplier.entity.TenderInvoiceInfo;
import com.els.modules.tender.supplier.entity.TenderProjectPurchaseBid;
import com.els.modules.tender.supplier.service.TenderInvoiceInfoService;
import com.els.modules.tender.supplier.service.TenderProjectPurchaseBidService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/purchase/supplierTenderProjectPurchaseBid"})
@Api(tags={"\u91c7\u8d2d\u65b9\u6295\u6807\u9879\u76ee\u8d2d\u6807"})
public class TenderProjectPurchaseBidController
extends BaseController<TenderProjectPurchaseBid, TenderProjectPurchaseBidService> {
    private static final Logger log = LoggerFactory.getLogger(TenderProjectPurchaseBidController.class);
    @Autowired
    private TenderProjectPurchaseBidService tenderProjectPurchaseBidService;
    @Autowired
    private TenderInvoiceInfoService saleTenderInvoiceInfoService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectAttachmentInfoService purchaseTenderProjectAttachmentInfoService;

    @AutoLog(busModule="\u4f9b\u5e94\u5546\u6295\u6807\u9879\u76ee\u8d2d\u6807\u8868", value="\u8d2d\u6807")
    @ApiOperation(value="\u8d2d\u6807", notes="\u8d2d\u6807")
    @PostMapping(value={"/submit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    public Result<?> submit(@RequestBody TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidPage) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = this.tenderProjectPurchaseBidService.queryById(supplierTenderProjectPurchaseBidPage.getId());
        this.buildAndCheckParam(tenderProjectPurchaseBid);
        tenderProjectPurchaseBid.setStatus(TenderProjectPurchaseBidStatusEnum.CONFIRM.getValue());
        this.tenderProjectPurchaseBidService.purchaseSubmit(tenderProjectPurchaseBid, supplierTenderProjectPurchaseBidPage.getSaleTenderInvoiceInfoList(), supplierTenderProjectPurchaseBidPage.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectPurchaseBid));
    }

    @AutoLog(busModule="\u8d2d\u6807-\u65b0\u589e", value="\u8d2d\u6807-\u65b0\u589e")
    @ApiOperation(value="\u8d2d\u6807-\u65b0\u589e", notes="\u8d2d\u6807-\u65b0\u589e")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:add"})
    public Result<?> add(@RequestBody TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidPage) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectPurchaseBidPage), TenderProjectPurchaseBid.class));
        this.buildAndCheckParam(tenderProjectPurchaseBid);
        this.tenderProjectPurchaseBidService.saveMain(tenderProjectPurchaseBid, supplierTenderProjectPurchaseBidPage.getSaleTenderInvoiceInfoList(), supplierTenderProjectPurchaseBidPage.getAttachmentList());
        return Result.ok((Object)((Object)tenderProjectPurchaseBid));
    }

    @AutoLog(busModule="\u8d2d\u6807-\u4fee\u6539", value="\u8d2d\u6807-\u4fee\u6539")
    @ApiOperation(value="\u8d2d\u6807-\u4fee\u6539", notes="\u8d2d\u6807-\u4fee\u6539")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    public Result<?> edit(@RequestBody TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidPage) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)SysUtil.copyProperties((Object)((Object)supplierTenderProjectPurchaseBidPage), TenderProjectPurchaseBid.class));
        this.buildAndCheckParam(tenderProjectPurchaseBid);
        this.tenderProjectPurchaseBidService.updateMain(tenderProjectPurchaseBid, supplierTenderProjectPurchaseBidPage.getSaleTenderInvoiceInfoList(), supplierTenderProjectPurchaseBidPage.getAttachmentList());
        String id = tenderProjectPurchaseBid.getId();
        return this.queryById(id);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderProjectPurchaseBid tenderProjectPurchaseBid = (TenderProjectPurchaseBid)((Object)this.tenderProjectPurchaseBidService.getById((Serializable)((Object)id)));
        Assert.isTrue((tenderProjectPurchaseBid != null && TenantContext.getTenant().equals(tenderProjectPurchaseBid.getPurchaseEnterpriseAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        TenderProjectPurchaseBidVO supplierTenderProjectPurchaseBidVO = new TenderProjectPurchaseBidVO();
        BeanUtils.copyProperties((Object)((Object)tenderProjectPurchaseBid), (Object)((Object)supplierTenderProjectPurchaseBidVO));
        List<TenderInvoiceInfo> saleTenderInvoiceInfoList = this.saleTenderInvoiceInfoService.selectByMainId(id);
        supplierTenderProjectPurchaseBidVO.setSaleTenderInvoiceInfoList(saleTenderInvoiceInfoList);
        List saleAttachmentDemandDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        supplierTenderProjectPurchaseBidVO.setAttachmentList(saleAttachmentDemandDTOS);
        this.tenderProjectPurchaseBidService.selectOrderInfo(supplierTenderProjectPurchaseBidVO);
        supplierTenderProjectPurchaseBidVO.setBusAccount(tenderProjectPurchaseBid.getPurchaseEnterpriseAccount());
        return Result.ok((Object)((Object)supplierTenderProjectPurchaseBidVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u8d2d\u6807\u8ba2\u5355", notes="\u901a\u8fc7subpackageId\u67e5\u8be2")
    @GetMapping(value={"/queryOrder"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryOrder(@RequestParam(name="subpackageId") String subpackageId) {
        Assert.isTrue((boolean)StringUtils.hasText((String)subpackageId), (String)I18nUtil.translate((String)"i18n_alert_zsxOLVW_2edb7bb2", (String)"\u5206\u5305\u4e0d\u80fd\u4e3a\u7a7a!"));
        List<PurchaseTenderProjectAttachmentInfo> projectAttachmentInfos = this.purchaseTenderProjectAttachmentInfoService.selectBySubpackageId(subpackageId);
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(projectAttachmentInfos), (String)I18nUtil.translate((String)"i18n_alert_SMYBQIIHW_7d1fe1d1", (String)"\u83b7\u53d6\u62db\u6807\u6587\u4ef6\u5f02\u5e38!"));
        ArrayList purchaseBidOrderVOList = SysUtil.copyProperties(projectAttachmentInfos, TenderProjectPurchaseBidOrderVO.class);
        TenderProjectPurchaseBidOrderInfoVO tenderProjectPurchaseBidOrderInfoVO = new TenderProjectPurchaseBidOrderInfoVO();
        tenderProjectPurchaseBidOrderInfoVO.setProjectPurchaseBidOrderVOList(purchaseBidOrderVOList);
        return Result.ok((Object)tenderProjectPurchaseBidOrderInfoVO);
    }

    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderProjectPurchaseBidService.delete(id);
        return Result.ok();
    }

    @AutoLog(value="\u8d2d\u6807\u786e\u8ba4")
    @ApiOperation(value="\u8d2d\u6807\u786e\u8ba4", notes="\u8d2d\u6807\u786e\u8ba4")
    @GetMapping(value={"/approved"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    public Result<?> approved(@RequestParam(name="id") String id) {
        this.tenderProjectPurchaseBidService.approved(id);
        return Result.ok();
    }

    private void buildAndCheckParam(TenderProjectPurchaseBid tenderProjectPurchaseBid) {
        Assert.isTrue((boolean)StringUtils.hasText((String)tenderProjectPurchaseBid.getSupplierAccount()), (String)I18nUtil.translate((String)"i18n_alert_RdXeyxOLVW_e6a8e73", (String)"\u4f9b\u5e94\u5546\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a!"));
        tenderProjectPurchaseBid.setSourceType(TenderProjectSourceTypeEnum.OFF_LINE.getValue());
        LoginUser loginUser = SysUtil.getLoginUser();
        tenderProjectPurchaseBid.setElsAccount(loginUser.getElsAccount());
        tenderProjectPurchaseBid.setPurchaseEnterpriseAccount(loginUser.getElsAccount());
        tenderProjectPurchaseBid.setPurchaseEnterpriseName(loginUser.getEnterpriseName());
        tenderProjectPurchaseBid.setSupplierSubAccount("1001");
    }
}

