/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.BaseDTO;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDemandDTO;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.entity.SaleBiddingItem;
import com.els.modules.bidding.enumerate.BiddingItemStatusEnum;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.enumerate.ReplyStatusEnum;
import com.els.modules.bidding.enumerate.StageTypeEnum;
import com.els.modules.bidding.mapper.BiddingSupplierMapper;
import com.els.modules.bidding.mapper.SaleBiddingHeadMapper;
import com.els.modules.bidding.mapper.SaleBiddingItemMapper;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.SaleBiddingHeadService;
import com.els.modules.bidding.service.SaleBiddingItemService;
import com.els.modules.bidding.vo.SaleBiddingHeadVO;
import com.els.modules.inquiry.enumerate.QuoteTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleBiddingHeadServiceImpl
extends BaseServiceImpl<SaleBiddingHeadMapper, SaleBiddingHead>
implements SaleBiddingHeadService {
    private static final Logger log = LoggerFactory.getLogger(SaleBiddingHeadServiceImpl.class);
    @Resource
    private SaleBiddingHeadMapper saleBiddingHeadMapper;
    @Resource
    private SaleBiddingItemMapper saleBiddingItemMapper;
    @Autowired
    private SaleBiddingItemService saleBiddingItemService;
    @Resource
    private BiddingSupplierMapper biddingSupplierMapper;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    @Lazy
    private PurchaseBiddingHeadService purchaseBiddingHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void replyBidding(BiddingSupplier supplier, List<SaleBiddingItem> saleBiddingItemList) {
        String partEcho;
        String headId = supplier.getHeadId();
        SaleBiddingHead head = (SaleBiddingHead)((Object)this.saleBiddingHeadMapper.selectById((Serializable)((Object)headId)));
        Date echoEndTime = head.getEchoEndTime();
        Date currentTime = new Date();
        log.error("\u67e5\u8be2\u51faSaleBiddingHead" + JSONObject.toJSONString((Object)((Object)head)));
        log.error("\u67e5\u8be2\u51fasaleBiddingItemList" + JSONObject.toJSONString(saleBiddingItemList));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(head.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        if (echoEndTime != null) {
            if (currentTime.after(echoEndTime)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_replyBidTimeOut", (String)"\u5e94\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u5e94\u6807\u64cd\u4f5c\uff01"));
            }
        } else {
            Date bidBeginTime = head.getBidBeginTime();
            if (currentTime.after(bidBeginTime)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_replyBidQuoteStart", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u5e94\u6807\u64cd\u4f5c\uff01"));
            }
        }
        BiddingSupplier dbSupplier = (BiddingSupplier)((Object)this.biddingSupplierMapper.selectById((Serializable)((Object)head.getSupplierListId())));
        log.error("\u67e5\u8be2\u51fasupplier" + JSONObject.toJSONString((Object)((Object)dbSupplier)));
        if (!ReplyStatusEnum.WAIT_REPLY.getValue().equals(dbSupplier.getReplyStatus()) && !ReplyStatusEnum.NOT_NEED.getValue().equals(dbSupplier.getReplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_repeat_edit", (String)"\u5df2\u7ecf\u54cd\u5e94\u7684\u5355\u636e\u4e0d\u80fd\u518d\u6b21\u64cd\u4f5c\uff01"));
        }
        int replyCount = 0;
        int itemCount = saleBiddingItemList.size();
        ArrayList<SaleBiddingItem> batchUpdateSaleBiddingItemList = new ArrayList<SaleBiddingItem>();
        for (SaleBiddingItem item : saleBiddingItemList) {
            String replyStatus = item.getReplyStatus();
            if ("1".equals(replyStatus)) {
                ++replyCount;
            }
            SaleBiddingItem updateItem = new SaleBiddingItem();
            updateItem.setId(item.getId());
            updateItem.setReplyStatus(replyStatus);
            batchUpdateSaleBiddingItemList.add(updateItem);
        }
        if (!batchUpdateSaleBiddingItemList.isEmpty()) {
            this.saleBiddingItemService.updateBatchById(batchUpdateSaleBiddingItemList, 2000);
        }
        if (!"1".equals(partEcho = head.getPartEcho()) && replyCount != itemCount && replyCount != 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_partsReply", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u5141\u8bb8\u90e8\u5206\u5e94\u6807\uff01"));
        }
        String replyStatus = ReplyStatusEnum.WAIT_REPLY.getValue();
        replyStatus = replyCount == itemCount ? ReplyStatusEnum.REPLYED.getValue() : (replyCount == 0 ? ReplyStatusEnum.REJECT.getValue() : ReplyStatusEnum.PART_REPLYED.getValue());
        supplier.setReplyStatus(replyStatus);
        supplier.setId(head.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setHeadId(head.getRelationId());
        int count = this.biddingSupplierMapper.updateById((Object)supplier);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        List<BiddingSupplier> biddingSupplierList = this.biddingSupplierMapper.selectByMainId(head.getRelationId());
        long replyAllCount = biddingSupplierList.stream().filter(biddingSupplier -> ReplyStatusEnum.REPLYED.getValue().equals(biddingSupplier.getReplyStatus()) || ReplyStatusEnum.PART_REPLYED.getValue().equals(biddingSupplier.getReplyStatus()) || ReplyStatusEnum.QUOTE_BID.getValue().equals(biddingSupplier.getReplyStatus())).count();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        this.purchaseBiddingHeadService.update((Wrapper)((LambdaUpdateWrapper)updateWrapper.set(PurchaseBiddingHead::getReplyQuantity, (Object)Integer.parseInt("" + replyAllCount))).eq(BaseEntity::getId, (Object)head.getRelationId()));
    }

    @Override
    public void quoteCheck(SaleBiddingHeadVO headVO) {
        String againQuote;
        Date currentTime = new Date();
        Date bidBeginTime = headVO.getBidBeginTime();
        Date bidEndTime = headVO.getBidEndTime();
        if (bidBeginTime.after(currentTime)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidNotStart", (String)"\u6295\u6807\u5f00\u59cb\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        if (currentTime.after(bidEndTime)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidTimeOut", (String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4\u5df2\u8fc7\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        BiddingSupplier supplier = (BiddingSupplier)((Object)this.biddingSupplierMapper.selectById((Serializable)((Object)headVO.getSupplierListId())));
        if ("0".equals(supplier.getBidQuote())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidByNotPermission", (String)"\u6ca1\u6709\u6295\u6807\u6743\u9650\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        if (ReplyStatusEnum.REJECT.getValue().equals(supplier.getReplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidByRefuseReply", (String)"\u5df2\u62d2\u7edd\u5e94\u6807\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        String needEcho = headVO.getNeedEcho();
        if ("1".equals(needEcho) && ReplyStatusEnum.WAIT_REPLY.getValue().equals(supplier.getReplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_quoteBidByNotReply", (String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u5e94\u6807\uff0c\u4e0d\u80fd\u6295\u6807"));
        }
        if (BiddingStatusEnum.TALK_PRICE.getValue().equals(headVO.getBiddingStatus()) && !"1".equals(headVO.getEnableTalkPrice())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u8f6e\u6b21\u5df2\u62a5\u4ef7\uff0c\u4e0d\u53ef\u91cd\u590d\u62a5\u4ef7\uff01"));
        }
        String string = againQuote = StrUtil.isBlank((CharSequence)headVO.getAgainQuote()) ? "0" : headVO.getAgainQuote();
        if (ReplyStatusEnum.QUOTE_BID.getValue().equals(supplier.getReplyStatus()) && !BiddingStatusEnum.TALK_PRICE.getValue().equals(headVO.getBiddingStatus()) && againQuote.equals("0")) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_oper_repeat_offer", (String)"\u5df2\u7ecf\u62a5\u4ef7\uff0c\u4e0d\u53ef\u91cd\u590d\u62a5\u4ef7\uff01"));
        }
        List attachmentDemandList = headVO.getSaleAttachmentDemandList().stream().filter(o -> StageTypeEnum.QUOTE.getValue().equals(o.getStageType())).filter(o -> "1".equals(o.getRequired())).map(SaleAttachmentDemandDTO::getFileType).collect(Collectors.toList());
        List saleAttachmentList = headVO.getSaleAttachmentList().stream().filter(o -> o.getUploadElsAccount().equals(TenantContext.getTenant())).collect(Collectors.toList());
        Map<String, List<SaleAttachmentDTO>> fileMap = saleAttachmentList.stream().collect(Collectors.groupingBy(SaleAttachmentDTO::getFileType));
        for (String fileType : attachmentDemandList) {
            if (fileMap.containsKey(fileType)) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_must_upload_file", (String)"\u8bf7\u6309\u7167\u8981\u6c42\u4e0a\u4f20\u5bf9\u5e94\u7c7b\u578b\u7684\u6587\u4ef6\uff01"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quoteBidding(SaleBiddingHead saleBiddingHead, List<SaleBiddingItem> saleBiddingItemList) {
        Date currentTime = new Date();
        String quoteType = QuoteTypeEnum.TAX_EXCLUDING.getValue();
        if (StrUtil.isNotBlank((CharSequence)saleBiddingHead.getQuoteType())) {
            quoteType = saleBiddingHead.getQuoteType();
        }
        String needEcho = saleBiddingHead.getNeedEcho();
        boolean isTalkPrice = "1".equals(saleBiddingHead.getEnableTalkPrice());
        SaleBiddingHead newSaleHead = (SaleBiddingHead)((Object)this.getById((Serializable)((Object)saleBiddingHead.getId())));
        Map biddingItemMap = this.purchaseBiddingItemService.selectByMainId(newSaleHead.getRelationId()).stream().filter(item -> newSaleHead.getElsAccount().equals(item.getToElsAccount())).collect(Collectors.toMap(PurchaseBiddingItem::getItemNumber, Function.identity(), (o1, o2) -> o1));
        int talkPriceStage = StringUtils.isBlank((CharSequence)newSaleHead.getStage()) ? 1 : Integer.valueOf(newSaleHead.getStage());
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(newSaleHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5355\u636e\u5df2\u4f5c\u5e9f\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"));
        ArrayList<SaleBiddingItem> addSaleBiddingItemList = new ArrayList<SaleBiddingItem>();
        ArrayList<PurchaseBiddingItem> addPurchaseBiddingItemList = new ArrayList<PurchaseBiddingItem>();
        ArrayList<PurchaseBiddingItem> batchUpdatePurchaseBiddingItemList = new ArrayList<PurchaseBiddingItem>();
        for (SaleBiddingItem item2 : saleBiddingItemList) {
            if ("0".equals(item2.getReplyStatus()) && ("1".equals(needEcho) || "1".equals(saleBiddingHead.getPartEcho()))) continue;
            String taxRateStr = item2.getTaxRate();
            if (StrUtil.isBlank((CharSequence)taxRateStr)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notRate", (String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            BigDecimal taxRate = new BigDecimal(taxRateStr);
            if (QuoteTypeEnum.TAX_EXCLUDING.getValue().equals(quoteType)) {
                BigDecimal netPrice = item2.getNetPrice();
                if (netPrice == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notNetPrice", (String)"\u4e0d\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                BigDecimal price = netPrice.multiply(new BigDecimal(1).add(taxRate.divide(new BigDecimal(100))));
                item2.setPrice(price);
            } else {
                BigDecimal price = item2.getPrice();
                if (price == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_empty_notPrice", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
                }
                BigDecimal netPrice = price.divide(new BigDecimal(1).add(taxRate.divide(new BigDecimal(100))), 6, 4);
                item2.setNetPrice(netPrice);
            }
            if (item2.getExpiryDate() == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_title_expiryDateCantBeEmpty", (String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (item2.getEffectiveDate() == null) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_title_effectiveDateCantBeEmpty", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            if (item2.getEffectiveDate().getTime() > item2.getExpiryDate().getTime()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOfUKXBAW_70448216", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff01"));
            }
            BigDecimal quantity = item2.getRequireQuantity() == null ? new BigDecimal(1) : item2.getRequireQuantity();
            item2.setNetAmount(item2.getNetPrice().multiply(quantity));
            item2.setTaxAmount(item2.getPrice().multiply(quantity));
            item2.setItemStatus(BiddingItemStatusEnum.BID_QUOTE.getValue());
            item2.setQuoteIp(IPUtils.getIpAddr());
            item2.setQuoteTime(new Date());
            int quoteCount = 1;
            SaleBiddingItem dbItem = (SaleBiddingItem)((Object)this.saleBiddingItemMapper.selectById((Serializable)((Object)item2.getId())));
            if (dbItem.getQuoteCount() != null) {
                quoteCount = dbItem.getQuoteCount() + 1;
            }
            item2.setQuoteCount(quoteCount);
            item2.setTalkPriceStage(talkPriceStage);
            item2.setFinalPrice("0");
            PurchaseBiddingItem purchaseBiddingItem = new PurchaseBiddingItem();
            BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)purchaseBiddingItem));
            purchaseBiddingItem.setId(item2.getRelationId());
            purchaseBiddingItem.setRelationId(item2.getId());
            purchaseBiddingItem.setHeadId(saleBiddingHead.getRelationId());
            purchaseBiddingItem.setElsAccount(item2.getToElsAccount());
            purchaseBiddingItem.setToElsAccount(item2.getElsAccount());
            purchaseBiddingItem.setExpiryDate(item2.getExpiryDate());
            purchaseBiddingItem.setEffectiveDate(item2.getEffectiveDate());
            PurchaseBiddingItem biddingItem = (PurchaseBiddingItem)((Object)biddingItemMap.get(item2.getItemNumber()));
            purchaseBiddingItem.setHeadItem(biddingItem.getHeadItem());
            purchaseBiddingItem.setProjectId(biddingItem.getProjectId());
            purchaseBiddingItem.setHeadName(biddingItem.getHeadName());
            if (isTalkPrice) {
                SaleBiddingItem saleBiddingItem = (SaleBiddingItem)((Object)SysUtil.copyProperties((Object)((Object)item2), SaleBiddingItem.class));
                saleBiddingItem.setUpdateBy(null);
                saleBiddingItem.setUpdateBy(null);
                saleBiddingItem.setCreateBy(null);
                saleBiddingItem.setCreateTime(null);
                saleBiddingItem.setId(IdWorker.getIdStr());
                saleBiddingItem.setRelationId(IdWorker.getIdStr());
                saleBiddingItem.setTalkPrice("1");
                purchaseBiddingItem.setId(saleBiddingItem.getRelationId());
                purchaseBiddingItem.setRelationId(saleBiddingItem.getId());
                purchaseBiddingItem.setTalkPrice("1");
                purchaseBiddingItem.setUpdateBy(null);
                purchaseBiddingItem.setUpdateBy(null);
                purchaseBiddingItem.setCreateBy(null);
                purchaseBiddingItem.setCreateTime(null);
                addPurchaseBiddingItemList.add(purchaseBiddingItem);
                addSaleBiddingItemList.add(saleBiddingItem);
                continue;
            }
            purchaseBiddingItem.setTalkPrice("0");
            purchaseBiddingItem.setUpdateBy(null);
            purchaseBiddingItem.setUpdateBy(null);
            purchaseBiddingItem.setCreateBy(null);
            purchaseBiddingItem.setCreateTime(null);
            purchaseBiddingItem.setTalkPriceStage(CommonConstant.STATUS_YES);
            item2.setTalkPrice("0");
            item2.setTalkPriceStage(CommonConstant.STATUS_YES);
            item2.setUpdateBy(null);
            item2.setUpdateBy(null);
            item2.setCreateBy(null);
            item2.setCreateTime(null);
            item2.setFinalPrice("1");
            purchaseBiddingItem.setFinalPrice("1");
            batchUpdatePurchaseBiddingItemList.add(purchaseBiddingItem);
            saleBiddingHead.setOpenPrice("1");
            this.updateById((Object)saleBiddingHead);
        }
        if (isTalkPrice) {
            Set<String> headIdSet;
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.set(SaleBiddingHead::getEnableTalkPrice, (Object)"0");
            updateWrapper.eq(BaseEntity::getId, (Object)saleBiddingHead.getId());
            ((SaleBiddingHeadMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
            if (!CollectionUtils.isEmpty(addSaleBiddingItemList)) {
                headIdSet = addSaleBiddingItemList.stream().map(SaleBiddingItem::getHeadId).collect(Collectors.toSet());
                this.saleBiddingItemService.deleteSameTalkPriceStage(talkPriceStage, headIdSet);
                this.saleBiddingItemService.saveBatch(addSaleBiddingItemList);
            }
            if (!CollectionUtils.isEmpty(addPurchaseBiddingItemList)) {
                headIdSet = addPurchaseBiddingItemList.stream().map(PurchaseBiddingItem::getHeadId).collect(Collectors.toSet());
                this.purchaseBiddingItemService.deleteSameTalkPriceStage(TenantContext.getTenant(), talkPriceStage, headIdSet);
                this.purchaseBiddingItemService.saveBatch(addPurchaseBiddingItemList);
            }
        }
        if (!saleBiddingItemList.isEmpty() && !isTalkPrice) {
            this.saleBiddingItemService.updateBatchById(saleBiddingItemList, 2000);
        }
        if (!batchUpdatePurchaseBiddingItemList.isEmpty() && !isTalkPrice) {
            this.purchaseBiddingItemService.updateBatchById(batchUpdatePurchaseBiddingItemList);
        }
        BiddingSupplier updateSupplier = new BiddingSupplier();
        updateSupplier.setId(saleBiddingHead.getSupplierListId());
        updateSupplier.setReplyStatus(ReplyStatusEnum.QUOTE_BID.getValue());
        updateSupplier.setReplyTime(currentTime);
        int count = this.biddingSupplierMapper.updateById((Object)updateSupplier);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
        }
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(saleBiddingHead.getElsAccount());
        sendVO.setHeadId(saleBiddingHead.getId());
        HashMap<String, String> toSend = new HashMap<String, String>();
        toSend.put(saleBiddingHead.getRelationId(), saleBiddingHead.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        List saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(saleBiddingHead.getId());
        List purchaseAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(saleBiddingHead.getRelationId());
        if (CollectionUtil.isEmpty((Collection)saleAttachmentDTOList) && CollectionUtil.isNotEmpty((Collection)purchaseAttachmentDTOList)) {
            List needDeleteList = purchaseAttachmentDTOList.parallelStream().filter(attachment -> saleBiddingHead.getElsAccount().equals(attachment.getUploadElsAccount())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(needDeleteList)) {
                List ids = needDeleteList.stream().map(BaseDTO::getId).distinct().collect(Collectors.toList());
                this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(ids);
            }
        } else if (CollectionUtil.isNotEmpty((Collection)saleAttachmentDTOList) && CollectionUtil.isNotEmpty((Collection)purchaseAttachmentDTOList)) {
            List relationIds = saleAttachmentDTOList.stream().map(SaleAttachmentDTO::getRelationId).distinct().collect(Collectors.toList());
            List needDeleteList = purchaseAttachmentDTOList.parallelStream().filter(attachment -> saleBiddingHead.getElsAccount().equals(attachment.getUploadElsAccount())).filter(attachment -> !relationIds.contains(attachment.getId())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(needDeleteList)) {
                List ids = needDeleteList.stream().map(BaseDTO::getId).distinct().collect(Collectors.toList());
                this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(ids);
            }
        }
        this.sendMsg(saleBiddingHead, saleBiddingHead.getToElsAccount(), "quote");
    }

    private void sendMsg(SaleBiddingHead head, String elsAccount, String operateType) {
        try {
            String url = "id=" + head.getRelationId();
            super.sendMessage(head.getBusAccount(), "bidding", operateType, head.getId(), "biddingBusDataServiceImpl", Arrays.asList(elsAccount));
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }

    @Override
    public List<SaleBiddingHead> selectByMainId(String relationId) {
        return ((SaleBiddingHeadMapper)this.baseMapper).selectByMainId(relationId);
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleBiddingHeadVO purchaseBiddingHeadVO = this.getMessageById(id);
        if (purchaseBiddingHeadVO == null) {
            return null;
        }
        purchaseBiddingHeadVO.setSupplierName(SysUtil.getLoginUser().getRealname());
        Result result = Result.ok((Object)((Object)purchaseBiddingHeadVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private SaleBiddingHeadVO getMessageById(String id) {
        SaleBiddingHead purchaseRequestHead = (SaleBiddingHead)((Object)this.getById((Serializable)((Object)id)));
        if (purchaseRequestHead == null) {
            return null;
        }
        SaleBiddingHeadVO purchaseRequestHeadVO = new SaleBiddingHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<SaleBiddingItem> purchaseRequestItemList = this.saleBiddingItemMapper.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseBiddingItemList(purchaseRequestItemList);
        return purchaseRequestHeadVO;
    }

    @Override
    public SaleBiddingHead selectByAccount(String relationId, String elsAccount) {
        return ((SaleBiddingHeadMapper)this.baseMapper).selectByAccount(relationId, elsAccount);
    }

    @Override
    public int updateByMainId(String relationId, String status) {
        return ((SaleBiddingHeadMapper)this.baseMapper).updateByMainId(relationId, status);
    }
}

