/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.enumerate.EbiddingConfirmStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.logisticspurchase.ebidding.entity.EbiddingConfirmItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingConfirmLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingConfirmLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingConfirmLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.EbiddingConfirmItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingSupplierLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.impl.PurchaseEbiddingHeadLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingConfirmLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingHeadLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingConfirmLpVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseEbiddingConfirmLpServiceImpl
extends BaseServiceImpl<PurchaseEbiddingConfirmLpMapper, PurchaseEbiddingConfirmLp>
implements PurchaseEbiddingConfirmLpService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingConfirmLpServiceImpl.class);
    @Autowired
    private EbiddingConfirmItemLpService ebiddingConfirmItemService;
    @Autowired
    private PurchaseEbiddingSupplierLpService purchaseEbiddingSupplierService;

    @Override
    public void addBatch(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingConfirmLpVO> confirmList) {
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<PurchaseEbiddingConfirmLpVO> insertList = new ArrayList<PurchaseEbiddingConfirmLpVO>();
            ArrayList<EbiddingConfirmItemLp> insertItemList = new ArrayList<EbiddingConfirmItemLp>();
            for (PurchaseEbiddingConfirmLpVO confirm : confirmList) {
                confirm.setId(IdWorker.getIdStr());
                confirm.setHeadId(head.getId());
                confirm.setStatus(EbiddingConfirmStatusEnum.NEW.getValue());
                SysUtil.setSysParam((BaseEntity)confirm, (BaseEntity)head);
                insertList.add(confirm);
                this.insertItemToList(head, confirm, insertItemList);
            }
            this.saveBatch(insertList, 2000);
            if (CollectionUtil.isNotEmpty(insertItemList)) {
                this.ebiddingConfirmItemService.saveBatch(insertItemList, 2000);
            }
        }
    }

    private void insertItemToList(PurchaseEbiddingHeadLp head, PurchaseEbiddingConfirmLpVO confirm, List<EbiddingConfirmItemLp> insertItemList) {
        if (CollectionUtil.isNotEmpty(confirm.getConfirmItemList())) {
            for (EbiddingConfirmItemLp item : confirm.getConfirmItemList()) {
                EbiddingConfirmItemLp insert = new EbiddingConfirmItemLp();
                BeanUtils.copyProperties((Object)((Object)item), (Object)((Object)insert));
                insert.setId(IdWorker.getIdStr());
                insert.setHeadId(confirm.getId());
                SysUtil.setSysParam((BaseEntity)insert, (BaseEntity)head);
                insertItemList.add(insert);
            }
        }
    }

    @Override
    public List<PurchaseEbiddingConfirmLp> publish(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingConfirmLpVO> confirmList, List<PurchaseEbiddingSupplierLp> supplierList) {
        ArrayList<PurchaseEbiddingConfirmLp> insertList = new ArrayList<PurchaseEbiddingConfirmLp>();
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<EbiddingConfirmItemLp> insertItemList = new ArrayList<EbiddingConfirmItemLp>();
            for (PurchaseEbiddingSupplierLp supplier : supplierList) {
                for (PurchaseEbiddingConfirmLpVO confirm : confirmList) {
                    confirm.setId(IdWorker.getIdStr());
                    PurchaseEbiddingConfirmLp insert = new PurchaseEbiddingConfirmLp();
                    BeanUtils.copyProperties((Object)((Object)confirm), (Object)((Object)insert));
                    SysUtil.setSysParam((BaseEntity)insert, (BaseEntity)head);
                    insert.setHeadId(head.getId());
                    insert.setRelationId(IdWorker.getIdStr());
                    insert.setStatus(EbiddingConfirmStatusEnum.WAITE_REPLY.getValue());
                    insert.setToElsAccount(supplier.getToElsAccount());
                    insert.setSupplierCode(supplier.getSupplierCode());
                    insert.setSupplierName(supplier.getSupplierName());
                    insertList.add(insert);
                    this.insertItemToList(head, confirm, insertItemList);
                }
            }
            log.info("confirm->insertList:{}", (Object)JSONObject.toJSONString(insertList));
            this.saveBatch(insertList, 2000);
            if (CollectionUtil.isNotEmpty(insertItemList)) {
                this.ebiddingConfirmItemService.saveBatch(insertItemList, 2000);
            }
        }
        return insertList;
    }

    @Override
    public void deleteByMainId(String mainId) {
        List<PurchaseEbiddingConfirmLp> confirmList = ((PurchaseEbiddingConfirmLpMapper)this.baseMapper).selectByMainId(mainId);
        ((PurchaseEbiddingConfirmLpMapper)this.baseMapper).deleteByMainId(mainId);
        List<String> idList = confirmList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.ebiddingConfirmItemService.deleteByMainId(idList);
    }

    @Override
    public List<PurchaseEbiddingConfirmLpVO> selectByMainId(String mainId) {
        List<PurchaseEbiddingConfirmLp> confirmList = ((PurchaseEbiddingConfirmLpMapper)this.baseMapper).selectByMainId(mainId);
        ArrayList result = SysUtil.copyProperties(confirmList, PurchaseEbiddingConfirmLpVO.class);
        if (CollectionUtil.isNotEmpty(confirmList)) {
            List idList = confirmList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List itemList = this.ebiddingConfirmItemService.list((Wrapper)new LambdaQueryWrapper().in(EbiddingConfirmItemLp::getHeadId, idList));
            Map<String, List<EbiddingConfirmItemLp>> itemMap = itemList.stream().collect(Collectors.groupingBy(EbiddingConfirmItemLp::getHeadId));
            for (PurchaseEbiddingConfirmLpVO vo : result) {
                List<EbiddingConfirmItemLp> list = itemMap.get(vo.getId());
                vo.setConfirmItemList(list);
            }
        }
        return result;
    }

    @Override
    public void confirm(List<PurchaseEbiddingConfirmLp> webConfirmList) {
        List<PurchaseEbiddingConfirmLp> confirmList = this.getOptionList(webConfirmList, EbiddingConfirmStatusEnum.CONFIRM.getValue());
        this.updateBatchById(confirmList);
        this.updateSaleConfirm(confirmList, EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
        SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
        saleEbiddingHeadService.updatePurchaseWaiteEbidding(confirmList.get(0).getHeadId());
        PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpServiceImpl.class);
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)purchaseEbiddingHeadService.getById((Serializable)((Object)confirmList.get(0).getHeadId())));
        List<SaleEbiddingHeadLp> dbSaleHeadList = saleEbiddingHeadService.getByRelationId(confirmList.get(0).getHeadId());
        List<String> toElsAccountList = confirmList.stream().map(PurchaseEbiddingConfirmLp::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)dbHead, this.getReceiveParamMap(dbSaleHeadList, toElsAccountList), "ebidding", "confirmPurchase");
    }

    @Override
    public void refuse(List<PurchaseEbiddingConfirmLp> webConfirmList) {
        List<PurchaseEbiddingConfirmLp> refuseList = this.getOptionList(webConfirmList, EbiddingConfirmStatusEnum.REFUSE.getValue());
        this.updateBatchById(refuseList);
        this.updateSaleConfirm(refuseList, EbiddingLpStatusEnum.REPLY_REFUSE.getValue());
        List<String> toElsAccountList = refuseList.stream().map(PurchaseEbiddingConfirmLp::getToElsAccount).distinct().collect(Collectors.toList());
        this.purchaseEbiddingSupplierService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingSupplierLp::getHeadId, (Object)refuseList.get(0).getHeadId())).in(PurchaseEbiddingSupplierLp::getToElsAccount, toElsAccountList)).set(PurchaseEbiddingSupplierLp::getReplyStatus, (Object)EbiddingReplyStatusEnum.REPLY_REFUSE.getValue()));
        PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpServiceImpl.class);
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)purchaseEbiddingHeadService.getById((Serializable)((Object)refuseList.get(0).getHeadId())));
        SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
        List<SaleEbiddingHeadLp> dbSaleHeadList = saleEbiddingHeadService.getByRelationId(refuseList.get(0).getHeadId());
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)dbHead, this.getReceiveParamMap(dbSaleHeadList, toElsAccountList), "ebidding", "purchaseReject");
    }

    @Override
    public void replyAgain(List<PurchaseEbiddingConfirmLp> webConfirmList) {
        List<PurchaseEbiddingConfirmLp> replyAgainList = this.getOptionList(webConfirmList, EbiddingConfirmStatusEnum.WAITE_REPLY.getValue());
        this.updateBatchById(replyAgainList);
        this.updateSaleConfirm(replyAgainList, EbiddingLpStatusEnum.WAIT_REPLY.getValue());
        PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpServiceImpl.class);
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)purchaseEbiddingHeadService.getById((Serializable)((Object)replyAgainList.get(0).getHeadId())));
        SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
        List<SaleEbiddingHeadLp> dbSaleHeadList = saleEbiddingHeadService.getByRelationId(replyAgainList.get(0).getHeadId());
        List<String> toElsAccountList = replyAgainList.stream().map(PurchaseEbiddingConfirmLp::getToElsAccount).distinct().collect(Collectors.toList());
        super.sendMsg(TenantContext.getTenant(), toElsAccountList, (Object)dbHead, this.getReceiveParamMap(dbSaleHeadList, toElsAccountList), "ebidding", "reply");
    }

    private List<PurchaseEbiddingConfirmLp> getOptionList(List<PurchaseEbiddingConfirmLp> webConfirmList, String status) {
        String headId = webConfirmList.get(0).getHeadId();
        List toElsAccountList = webConfirmList.stream().map(PurchaseEbiddingConfirmLp::getToElsAccount).distinct().collect(Collectors.toList());
        List<PurchaseEbiddingConfirmLp> dbConfirmList = ((PurchaseEbiddingConfirmLpMapper)this.baseMapper).selectByMainId(headId);
        List<PurchaseEbiddingConfirmLp> optionList = dbConfirmList.stream().filter(confirm -> toElsAccountList.contains(confirm.getToElsAccount())).collect(Collectors.toList());
        optionList.forEach(confirm -> {
            Assert.isTrue((boolean)EbiddingConfirmStatusEnum.ALREADY_REPLY.getValue().equals(confirm.getStatus()), (String)I18nUtil.translate((String)"", (String)"\u5df2\u56de\u590d\u7684\u884c\u624d\u53ef\u64cd\u4f5c"));
            confirm.setStatus(status);
        });
        return optionList;
    }

    private void updateSaleConfirm(List<PurchaseEbiddingConfirmLp> optionList, String ebiddingStatus) {
        List relationIdList = optionList.stream().map(PurchaseEbiddingConfirmLp::getRelationId).collect(Collectors.toList());
        SaleEbiddingConfirmLpService saleEbiddingConfirmService = (SaleEbiddingConfirmLpService)SpringContextUtils.getBean(SaleEbiddingConfirmLpServiceImpl.class);
        List saleDbConfirmList = saleEbiddingConfirmService.listByIds(relationIdList);
        List headIdList = saleDbConfirmList.stream().map(SaleEbiddingConfirmLp::getHeadId).distinct().collect(Collectors.toList());
        ArrayList<SaleEbiddingHeadLp> headList = new ArrayList<SaleEbiddingHeadLp>();
        for (String id : headIdList) {
            SaleEbiddingHeadLp head = new SaleEbiddingHeadLp();
            head.setId(id);
            head.setEbiddingStatus(ebiddingStatus);
            headList.add(head);
        }
        SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
        saleEbiddingHeadService.updateBatchById(headList);
        ArrayList<SaleEbiddingConfirmLp> updateList = new ArrayList<SaleEbiddingConfirmLp>();
        for (PurchaseEbiddingConfirmLp confirm : optionList) {
            SaleEbiddingConfirmLp saleConfirm = new SaleEbiddingConfirmLp();
            saleConfirm.setId(confirm.getRelationId());
            saleConfirm.setStatus(confirm.getStatus());
            updateList.add(saleConfirm);
        }
        saleEbiddingConfirmService.updateBatchById(updateList);
    }

    private Map<String, JSONObject> getReceiveParamMap(List<SaleEbiddingHeadLp> dbSaleHeadList, List<String> toElsAccountList) {
        return dbSaleHeadList.stream().filter(head -> toElsAccountList.contains(head.getElsAccount())).collect(Collectors.toMap(BaseEntity::getElsAccount, head -> {
            JSONObject object = new JSONObject();
            object.put("id", (Object)head.getId());
            return object;
        }));
    }
}

