/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.aspect;

import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.TenderPermissionsUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order
public class TenderPermissionsAspect {
    private static final Logger log = LoggerFactory.getLogger(TenderPermissionsAspect.class);

    @Pointcut(value="@annotation(com.els.modules.tender.common.aspect.TenderPermissions)")
    public void validatedPointCut() {
    }

    @Around(value="validatedPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        PurchaseTenderProjectSubpackageInfo subpackageInfo = TenderFlagInjectionContext.getSubpackageInfo();
        if (subpackageInfo != null) {
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            TenderPermissions tenderPermissions = method.getAnnotation(TenderPermissions.class);
            TenderRoleEnum[] roleEnums = tenderPermissions.value();
            boolean result = false;
            for (TenderRoleEnum roleEnum : roleEnums) {
                if (TenderRoleEnum.BIDING_ORG == roleEnum) {
                    result = TenderPermissionsUtils.checkBidingOrgPermission(subpackageInfo.getId());
                } else if (TenderRoleEnum.BIDING_USER == roleEnum || TenderRoleEnum.PURCHASE_EXECUTOR == roleEnum) {
                    result = TenderPermissionsUtils.checkBidingUserAndPurchaseExecutorPermission(subpackageInfo.getId());
                } else if (TenderRoleEnum.JURY_MEMBER == roleEnum) {
                    result = TenderPermissionsUtils.checkJuryMemberPermission(subpackageInfo.getId());
                }
                if (result) break;
            }
            if (!result) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u65e0\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            }
        }
        return point.proceed();
    }
}

