/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.common.utils;

import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryMember;
import com.els.modules.tender.evaluation.entity.PurchaseTenderProjectJuryMemberRecord;
import com.els.modules.tender.evaluation.enumerate.JuryMemberConfirmStatusEnum;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectJuryMemberRecordsService;
import com.els.modules.tender.evaluation.service.PurchaseTenderProjectJuryMemberService;
import com.els.modules.tender.notice.entity.PurchaseTenderSupplierInvitation;
import com.els.modules.tender.notice.service.PurchaseTenderSupplierInvitationService;
import com.els.modules.tender.project.utils.TenderProjectMemberUtils;
import com.els.modules.tender.supplier.entity.TenderProjectSupplier;
import com.els.modules.tender.supplier.service.TenderProjectSupplierService;
import java.util.List;
import java.util.stream.Collectors;

public class TenderPermissionsUtils {
    public static boolean checkBidingUserAndPurchaseExecutorPermission(String subpackageId) {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<ElsSubAccountDTO> accountList = TenderProjectMemberUtils.getTenderProjectMemberBySubpackageId(subpackageId);
        List userAccountList = accountList.stream().map(account -> account.getElsAccount() + "_" + account.getSubAccount()).collect(Collectors.toList());
        return userAccountList.contains(loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
    }

    public static boolean checkBidingOrgPermission(String subpackageId) {
        LoginUser loginUser = SysUtil.getLoginUser();
        TenderProjectSupplierService supplierService = (TenderProjectSupplierService)SpringContextUtils.getBean(TenderProjectSupplierService.class);
        TenderProjectSupplier supplier = new TenderProjectSupplier();
        supplier.setSubpackageId(subpackageId);
        List<TenderProjectSupplier> supplierList = supplierService.selectBySubpackageId(supplier);
        List userAccountList = supplierList.stream().map(TenderProjectSupplier::getSupplierAccount).collect(Collectors.toList());
        if (userAccountList.contains(loginUser.getElsAccount())) {
            return true;
        }
        PurchaseTenderSupplierInvitationService invitationService = (PurchaseTenderSupplierInvitationService)SpringContextUtils.getBean(PurchaseTenderSupplierInvitationService.class);
        List<PurchaseTenderSupplierInvitation> invitationSupplierList = invitationService.selectBySubpackageId(subpackageId);
        userAccountList = invitationSupplierList.stream().map(PurchaseTenderSupplierInvitation::getSupplierAccount).collect(Collectors.toList());
        return userAccountList.contains(loginUser.getElsAccount());
    }

    public static boolean checkJuryMemberPermission(String subpackageId) {
        LoginUser loginUser = SysUtil.getLoginUser();
        PurchaseTenderProjectJuryMemberService juryMemberService = (PurchaseTenderProjectJuryMemberService)SpringContextUtils.getBean(PurchaseTenderProjectJuryMemberService.class);
        List<PurchaseTenderProjectJuryMember> juryMemberList = juryMemberService.queryBySubpackageId(subpackageId);
        List userAccountList = juryMemberList.stream().map(account -> account.getElsAccount() + "_" + account.getElsSubAccount()).collect(Collectors.toList());
        if (userAccountList.contains(loginUser.getElsAccount() + "_" + loginUser.getSubAccount())) {
            return true;
        }
        PurchaseTenderProjectJuryMemberRecordsService juryMemberRecordsService = (PurchaseTenderProjectJuryMemberRecordsService)SpringContextUtils.getBean(PurchaseTenderProjectJuryMemberRecordsService.class);
        List<PurchaseTenderProjectJuryMemberRecord> juryMemberRecordList = juryMemberRecordsService.selectBySubpackageId(subpackageId, JuryMemberConfirmStatusEnum.CONFIRMED.getValue());
        userAccountList = juryMemberRecordList.stream().map(account -> account.getElsAccount() + "_" + account.getElsSubAccount()).collect(Collectors.toList());
        return userAccountList.contains(loginUser.getElsAccount() + "_" + loginUser.getSubAccount());
    }
}

