/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.supplier.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptSourceTypeEnum;
import com.els.modules.tender.sale.enumerate.TenderInvitationSupplierReceiptStatusEnum;
import com.els.modules.tender.sale.vo.TenderInvitationSupplierReceiptVO;
import com.els.modules.tender.supplier.entity.TenderInvitationSupplierReceipt;
import com.els.modules.tender.supplier.service.TenderInvitationSupplierReceiptService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4f9b\u5e94\u5546\u9080\u8bf7\u56de\u6267\u540d\u5355"})
@RestController
@RequestMapping(value={"/tender/purchase/tenderInvitationSupplierReceipt"})
public class TenderInvitationSupplierReceiptController
extends BaseController<TenderInvitationSupplierReceipt, TenderInvitationSupplierReceiptService> {
    @Autowired
    private TenderInvitationSupplierReceiptService tenderInvitationSupplierReceiptService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService purchaseTenderProjectSubpackageInfoService;

    @AutoLog(value="\u4f9b\u5e94\u5546\u9080\u8bf7\u56de\u6267\u540d\u5355-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/addBatch"})
    @RequiresPermissions(value={"tender#tenderProject:add"})
    @SrmValidated
    public Result<?> addBatch(@RequestBody List<TenderInvitationSupplierReceipt> tenderInvitationSupplierReceiptList) {
        tenderInvitationSupplierReceiptList.forEach(tenderInvitationSupplierReceipt -> {
            tenderInvitationSupplierReceipt.setReceiptStatus(TenderInvitationSupplierReceiptStatusEnum.NEW.getValue());
            tenderInvitationSupplierReceipt.setSourceType(TenderInvitationSupplierReceiptSourceTypeEnum.INVITATION.getValue());
        });
        this.tenderInvitationSupplierReceiptService.addBatch(tenderInvitationSupplierReceiptList);
        return Result.ok(tenderInvitationSupplierReceiptList);
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u9080\u8bf7\u56de\u6267\u540d\u5355-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tender#tenderProject:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.tenderInvitationSupplierReceiptService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TenderInvitationSupplierReceiptVO tenderInvitationSupplierReceipt = this.tenderInvitationSupplierReceiptService.queryById(id);
        if (tenderInvitationSupplierReceipt != null) {
            if (!TenderInvitationSupplierReceiptStatusEnum.CONFIRM.getValue().equals(tenderInvitationSupplierReceipt.getReceiptStatus())) {
                tenderInvitationSupplierReceipt.setReceiptPerson(null);
                tenderInvitationSupplierReceipt.setReceiptPhone(null);
                tenderInvitationSupplierReceipt.setRemark(null);
                tenderInvitationSupplierReceipt.setAttachmentDTOList(null);
            }
            PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.purchaseTenderProjectSubpackageInfoService.getById((Serializable)((Object)tenderInvitationSupplierReceipt.getSubpackageId())));
            tenderInvitationSupplierReceipt.setSubpackageNumber(subpackageInfo.getSubpackageNumber());
        }
        return Result.ok((Object)((Object)tenderInvitationSupplierReceipt));
    }

    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @GetMapping(value={"/publish"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    public Result<?> publish(@RequestParam(name="id") String id) {
        this.tenderInvitationSupplierReceiptService.publish(id);
        return Result.ok((Object)3);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryTabsCount() {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        List<CountVO> countVOList = this.tenderInvitationSupplierReceiptService.queryTabsCount(TenantContext.getTenant());
        Map<String, Integer> countMap = countVOList.stream().collect(Collectors.toMap(o -> o.getValue(), o -> o.getTotal()));
        int totalCount = countVOList.stream().mapToInt(CountVO::getTotal).sum();
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "receiptStatus", null, Integer.valueOf(totalCount)));
        List dictDTOList = this.invokeBaseRpcService.queryDictItemsByCode("tenderReceiptStatus", TenantContext.getTenant());
        if (CollectionUtil.isNotEmpty((Collection)dictDTOList)) {
            for (DictDTO status : dictDTOList) {
                Integer count = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
                result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "receiptStatus", status.getValue(), count));
            }
        }
        return Result.ok(result);
    }
}

