/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsInitialTableDTO;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.service.PurchaseEbiddingHeadService;
import com.els.modules.inquiry.enumerate.PriceCreateWayEnum;
import com.els.modules.inquiry.enumerate.RegretFlagEnum;
import com.els.modules.logisticspurchase.base.entity.SubjectFileItem;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingItemLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.excel.PurchaseEbiddingHeadLpExportServiceImpl;
import com.els.modules.logisticspurchase.ebidding.job.utils.LpEbiddingJobUtil;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingSupplierLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingHeadLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.utils.LpEbiddingShowUtil;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseAwardOpinionLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingConfirmLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingHeadLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingPrintLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseEbiddingSupplierLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.PurchaseOverviewSubmitPriceVO;
import com.els.modules.logisticspurchase.enquiry.enumerate.EnquiryLpStatusEnum;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseEnquiryItemLpService;
import com.els.modules.logisticspurchase.enquiry.vo.PurchaseEnquiryHeadLpVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/lpEbidding/purchaseEbiddingHeadLp"})
@Api(tags={"\u91c7\u8d2d\u7ade\u4ef7\u5934"})
public class PurchaseEbiddingHeadLpController
extends BaseController<PurchaseEbiddingHeadLp, PurchaseEbiddingHeadLpService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEbiddingHeadLpController.class);
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;
    @Autowired
    private PurchaseEbiddingSupplierLpService ebiddingSupplierService;
    @Autowired
    private PurchaseEbiddingConfirmLpService purchaseEbiddingConfirmService;
    @Autowired
    private SaleEbiddingHeadLpService saleEbiddingHeadService;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseEbiddingItemHisLpService purchaseEbiddingItemHisService;
    @Autowired
    private SubjectFileItemService subjectFileItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:list"})
    public Result<?> queryPageList(PurchaseEbiddingHeadLp head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)req.getParameterMap());
        queryWrapper.orderByAsc((Object)"subject_number");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((PurchaseEbiddingHeadLpService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/count"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:list"})
    public Result<?> queryTabsCount(PurchaseEbiddingHeadLp head, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        String[] ids = null;
        Map stringMap = req.getParameterMap();
        if (StringUtils.isNotBlank((CharSequence)head.getId())) {
            ids = head.getId().replace(" ", "").split(",");
            head.setId(null);
            stringMap.remove("id");
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)head), (Map)stringMap);
        if (ids != null && ids.length > 0) {
            queryWrapper.in((Object)"id", (Object[])ids);
        }
        queryWrapper.select(new String[]{"ebidding_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"ebidding_status");
        List list = ((PurchaseEbiddingHeadLpService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseEbiddingHeadLp::getEbiddingStatus, PurchaseEbiddingHeadLp::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "ebiddingStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmEbiddingStatusLp", TenantContext.getTenant());
        String[] statuses = new String[]{"0", "1", "3", "4", "5", "6", "8", "9", "10", "11", "12", "13", "14"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "ebiddingStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u8be2\u4ef7\u8f6c\u7ade\u4ef7")
    @ApiOperation(value="\u8be2\u4ef7\u8f6c\u7ade\u4ef7", notes="\u8be2\u4ef7\u8f6c\u7ade\u4ef7")
    @PostMapping(value={"/enquiryToEbidding"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:enquiryToEbidding"})
    public Result<?> enquiryToEbidding(@RequestBody PurchaseEnquiryHeadLpVO enquiryHeadVO) {
        PurchaseEbiddingHeadLp ebiddingHead = ((PurchaseEbiddingHeadLpService)this.service).enquiryToEbidding(enquiryHeadVO);
        return Result.ok((String)("\u8f6c\u7ade\u4ef7\u6210\u529f,\u7ade\u4ef7\u5355\u53f7\u4e3a:[" + ebiddingHead.getEbiddingNumber() + "]"), (Object)((Object)ebiddingHead));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> add(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        this.checkTime(headVO);
        PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setElsAccount(super.getTenantId());
        head.setBusAccount(super.getTenantId());
        head.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)head));
        if ("1".equals(head.getTest())) {
            ((PurchaseEbiddingHeadLpService)this.service).saveTestMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            ((PurchaseEbiddingHeadLpService)this.service).saveMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        return Result.ok((Object)((Object)head));
    }

    private void checkTime(PurchaseEbiddingHeadLpVO headVO) {
        this.checkNumber(headVO.getBeforeEndMinute());
        this.checkNumber(headVO.getDelayMinute());
        this.checkNumber(headVO.getDelayCount());
    }

    private void checkNumber(Integer object) {
        if (ObjectUtils.isEmpty((Object)object)) {
            return;
        }
        int i = object.compareTo(0);
        Assert.isTrue((i != -1 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_KISmWxOLBW_ab51fe34", (String)"\u65f6\u95f4\u6216\u6b21\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570"));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> edit(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
        this.checkTime(headVO);
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setElsAccount(super.getTenantId());
        head.setBusAccount(super.getTenantId());
        if ("1".equals(head.getTest())) {
            ((PurchaseEbiddingHeadLpService)this.service).updateTestMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        } else {
            ((PurchaseEbiddingHeadLpService)this.service).updateMain(head, headVO.getPurchaseEbiddingItemList(), headVO.getPurchaseEbiddingSupplierList(), headVO.getPurchaseAttachmentDemandList(), headVO.getPurchaseEbiddingConfirmList());
        }
        String id = head.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:copy"})
    public Result<?> copy(@RequestParam(name="id") String id) {
        List dbConfirmList;
        List dbItemList;
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)id)));
        if (EbiddingLpStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus())) {
            dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
            dbConfirmList = this.purchaseEbiddingConfirmService.selectByMainId(id);
        } else {
            ElsInitialTableDTO itemInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(id, "itemLp");
            dbItemList = JSON.parseArray((String)itemInitInfo.getBusinessInfoJson(), PurchaseEbiddingItemLp.class);
            ElsInitialTableDTO confirmInitInfo = this.invokeBaseRpcService.selectElsInitialTableOne(id, "confirmLP");
            dbConfirmList = JSON.parseArray((String)confirmInitInfo.getBusinessInfoJson(), PurchaseEbiddingConfirmLpVO.class);
        }
        List<PurchaseEbiddingSupplierLp> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        List attachmentDemandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        dbHead.setGenerateContract("0");
        if (!ObjectUtils.isEmpty((Object)dbHead.getExpiryDate()) && !ObjectUtils.isEmpty((Object)dbHead.getEffectiveDate())) {
            dbItemList.forEach(e -> {
                e.setExpiryDate(dbHead.getExpiryDate());
                e.setEffectiveDate(dbHead.getEffectiveDate());
            });
        }
        ((PurchaseEbiddingHeadLpService)this.service).copy(dbHead, dbItemList, dbSupplierList, attachmentDemandList, dbConfirmList);
        return this.commonSuccessResult(2);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u5220\u9664")
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:delete"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> delete(@RequestParam(name="id") String id) {
        ((PurchaseEbiddingHeadLpService)this.service).delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:publish"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> publish(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        Assert.hasText((String)headVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)headVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        this.checkTime(headVO);
        if (StrUtil.isBlank((CharSequence)headVO.getEbiddingNumber())) {
            headVO.setEbiddingNumber(this.invokeBaseRpcService.getNextCode("srmEbiddingNumber", (Object)headVO));
        }
        String elsAccount = this.getTenantId();
        headVO.setElsAccount(elsAccount);
        headVO.setBusAccount(elsAccount);
        headVO.setAuditStatus("1".equals(headVO.getPublishAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        headVO.setResultAuditStatus("1".equals(headVO.getResultAudit()) ? AuditStatusEnum.AUDIT_NEW.getValue() : AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        if ("1".equals(headVO.getTest())) {
            ((PurchaseEbiddingHeadLpService)this.service).publishTest(headVO);
        } else {
            ((PurchaseEbiddingHeadLpService)this.service).publish(headVO);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546")
    @ApiOperation(value="\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546", notes="\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546")
    @PostMapping(value={"/publishNewSupplier"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:publishNewSupplier"})
    @SrmValidated
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> publishNewSupplier(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        String id = headVO.getId();
        Assert.hasText((String)id, (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)id)));
        Assert.isTrue((boolean)"1".equals(dbHead.getPublishNewSupplier()), (String)I18nUtil.translate((String)"i18n_alert_APtFxiThxVRdX_8aeb97e0", (String)"\u5f53\u524d\u5355\u636e\u4e0d\u5141\u8bb8\u53d1\u5e03\u65b0\u4f9b\u5e94\u5546"));
        List<String> status = Arrays.asList(EbiddingLpStatusEnum.WAIT_REPLY.getValue(), EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n__RjodBnoOujtFqtk_597479cc", (String)"\u53ea\u6709\u5f85\u5e94\u6807\u548c\u5f85\u7ade\u4ef7\u7684\u5355\u636e\u53ef\u64cd\u4f5c"));
        List<PurchaseEbiddingSupplierLp> webSupplierList = headVO.getPurchaseEbiddingSupplierList();
        Assert.notEmpty(webSupplierList, (String)I18nUtil.translate((String)"i18n_alert_RdXxOLV_4ed7d39d", (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEbiddingHeadLpService)this.service).publishNewSupplier(dbHead, webSupplierList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u624b\u52a8\u5f00\u542f\u7ade\u4ef7")
    @ApiOperation(value="\u624b\u52a8\u5f00\u542f\u7ade\u4ef7", notes="\u624b\u52a8\u5f00\u542f\u7ade\u4ef7")
    @PostMapping(value={"/manualStartBid"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:manualStartBid"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> manualStartBid(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        ((PurchaseEbiddingHeadLpService)this.service).manualStartBid(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7")
    @ApiOperation(value="\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7", notes="\u624b\u52a8\u7ed3\u675f\u7ade\u4ef7")
    @PostMapping(value={"/manualEndBid"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:manualEndBid"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> manualEndBid(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        ((PurchaseEbiddingHeadLpService)this.service).manualEndBid(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u521b\u5efa\u65b0\u8f6e\u6b21")
    @ApiOperation(value="\u521b\u5efa\u65b0\u8f6e\u6b21", notes="\u521b\u5efa\u65b0\u8f6e\u6b21")
    @PostMapping(value={"/createNewRound"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:createNewRound"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> createNewRound(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        ((PurchaseEbiddingHeadLpService)this.service).createNewRound(headVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u63d0\u4ea4\u5b9a\u4ef7")
    @ApiOperation(value="\u63d0\u4ea4\u5b9a\u4ef7", notes="\u63d0\u4ea4\u5b9a\u4ef7")
    @PostMapping(value={"/submitPrice"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:confirmBid"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    @SrmValidated
    public Result<?> submitPrice(@RequestBody PurchaseAwardOpinionLpVO opinionVO) {
        Assert.hasText((String)opinionVO.getAwardOpinion(), (String)I18nUtil.translate((String)"i18n_alert_IuIIxOLV_12e2f27f", (String)"\u5b9a\u4ef7\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)opinionVO.getHeadId())));
        List<String> status = Arrays.asList(EbiddingLpStatusEnum.BIDDING_END.getValue(), EbiddingLpStatusEnum.REGRET.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjOuyWSIMBntFnqIu_b837f2c9", (String)"\u53ea\u6709\u7ade\u4ef7\u7ed3\u675f\u6216\u5df2\u6094\u6807\u7684\u5355\u636e\u624d\u53ef\u5b9a\u4ef7"));
        Assert.isTrue((!AuditStatusEnum.AUDIT_DOING.getValue().equals(dbHead.getResultAuditStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_UzsntFxqtk_19b34519", (String)"\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u4e0d\u53ef\u64cd\u4f5c"));
        log.warn("start submitPrice");
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            List<PurchaseEbiddingItemHisLp> dbItemList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId());
            dbItemList.forEach(item -> {
                if (EbiddingLpStatusEnum.REGRET.getValue().equals(dbHead.getEbiddingStatus())) {
                    Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_MBAcLVVIujtFnqtk_d961a5f7", (String)"\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
                }
                if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_title_pleaseSupplementMateriaCodeFirst", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
                }
            });
            ((PurchaseEbiddingHeadLpService)this.service).submitPriceByHis(dbHead, opinionVO, dbItemList);
        } else {
            List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId());
            dbItemList.forEach(item -> {
                if (EbiddingLpStatusEnum.REGRET.getValue().equals(dbHead.getEbiddingStatus())) {
                    Assert.isTrue((boolean)RegretFlagEnum.RE_PRICED.getValue().equals(item.getRegretFlag()), (String)I18nUtil.translate((String)"i18n_alert_MBAcLVVIujtFnqtk_d961a5f7", (String)"\u6094\u6807\u7c7b\u578b\u4e3a\u91cd\u65b0\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u53ef\u64cd\u4f5c"));
                }
                if (PriceCreateWayEnum.AUTO.getValue().equals(dbHead.getPriceCreateWay())) {
                    Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_title_pleaseSupplementMateriaCodeFirst", (String)"\u8bf7\u5148\u8865\u5145\u7269\u6599\u7f16\u7801"));
                }
            });
            ((PurchaseEbiddingHeadLpService)this.service).submitPrice(dbHead, opinionVO, dbItemList);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:cancel"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    public Result<?> cancel(@RequestParam(name="id") String id) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)id)));
        List<String> status = Arrays.asList(EbiddingLpStatusEnum.WAIT_REPLY.getValue(), EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
        Assert.isTrue((boolean)status.contains(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjodBSoOujtFqku_c3c77e16", (String)"\u53ea\u6709\u5f85\u5e94\u6807\u6216\u5f85\u7ade\u4ef7\u7684\u5355\u636e\u53ef\u4f5c\u5e9f"));
        ((PurchaseEbiddingHeadLpService)this.service).cancel(dbHead);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3", notes="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="ebiddingLp")
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)id)));
        PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        headVO.setPurchaseEbiddingItemList(SysUtil.copyProperties(dbItemList, PurchaseEbiddingItemLp.class));
        List<PurchaseEbiddingSupplierLp> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        headVO.setPurchaseEbiddingSupplierList(dbSupplierList);
        if (EnquiryLpStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus()) || CollectionUtil.isEmpty(dbSupplierList)) {
            ArrayList<PurchaseEbiddingSupplierLpVO> supplierVOList = new ArrayList<PurchaseEbiddingSupplierLpVO>();
            for (PurchaseEbiddingSupplierLp supplier : dbSupplierList) {
                PurchaseEbiddingSupplierLpVO vo = new PurchaseEbiddingSupplierLpVO();
                BeanUtils.copyProperties((Object)((Object)supplier), (Object)((Object)vo));
                supplierVOList.add(vo);
            }
            headVO.setPurchaseEbiddingSupplierQuoteList(supplierVOList);
        } else {
            List<PurchaseEbiddingItemHisLp> purchaseEbiddingItemHis = new ArrayList<PurchaseEbiddingItemHisLp>();
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                purchaseEbiddingItemHis = this.purchaseEbiddingItemHisService.queryAcceptDetail(dbHead);
            }
            headVO.setPurchaseEbiddingSupplierQuoteList(this.getSupplierQuote(dbHead, dbItemList, purchaseEbiddingItemHis, dbSupplierList));
            for (PurchaseEbiddingSupplierLpVO vo : headVO.getPurchaseEbiddingSupplierQuoteList()) {
                LpEbiddingShowUtil.purchaseShow(vo.getPurchaseEbiddingItemList(), dbHead, false);
            }
        }
        headVO.setSaleHeadList(this.saleEbiddingHeadService.getByRelationId(id));
        List<SubjectFileItem> subjectFileItemList = this.subjectFileItemService.selectByMainId(dbHead.getSubjectFileHeadId());
        headVO.setSubjectFileItemList(subjectFileItemList);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3", notes="\u8be6\u60c5\u9875\u9762\u67e5\u8be2\u63a5\u53e3")
    @GetMapping(value={"/queryDetailById"})
    @BusinessModule(module="ebiddingLp")
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryDetailById(@RequestParam(name="id") String id) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)id)));
        PurchaseEbiddingHeadLpVO headVO = new PurchaseEbiddingHeadLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)headVO));
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id);
        LoginUser loginUser = SysUtil.getLoginUser();
        if (!ObjectUtils.isEmpty((Object)loginUser) && !"1001".equals(loginUser.getSubAccount())) {
            for (PurchaseEbiddingItemLp item : dbItemList) {
                item.setNetTotalAmount(null);
            }
        }
        headVO.setPurchaseEbiddingItemList(SysUtil.copyProperties(dbItemList, PurchaseEbiddingItemLp.class));
        List<PurchaseEbiddingSupplierLp> dbSupplierList = this.ebiddingSupplierService.selectByMainId(id);
        headVO.setPurchaseEbiddingSupplierList(dbSupplierList);
        if (EnquiryLpStatusEnum.NEW.getValue().equals(dbHead.getEbiddingStatus()) || CollectionUtil.isEmpty(dbSupplierList)) {
            ArrayList<PurchaseEbiddingSupplierLpVO> supplierVOList = new ArrayList<PurchaseEbiddingSupplierLpVO>();
            for (PurchaseEbiddingSupplierLp supplier : dbSupplierList) {
                PurchaseEbiddingSupplierLpVO vo = new PurchaseEbiddingSupplierLpVO();
                BeanUtils.copyProperties((Object)((Object)supplier), (Object)((Object)vo));
                supplierVOList.add(vo);
            }
            headVO.setPurchaseEbiddingSupplierQuoteList(supplierVOList);
        } else {
            List<PurchaseEbiddingItemHisLp> purchaseEbiddingItemHis = new ArrayList<PurchaseEbiddingItemHisLp>();
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                purchaseEbiddingItemHis = this.purchaseEbiddingItemHisService.queryAcceptDetail(dbHead);
            }
            headVO.setPurchaseEbiddingSupplierQuoteList(this.getSupplierQuoteDetail(dbHead, dbItemList, purchaseEbiddingItemHis, dbSupplierList));
            for (PurchaseEbiddingSupplierLpVO vo : headVO.getPurchaseEbiddingSupplierQuoteList()) {
                LpEbiddingShowUtil.purchaseShow(vo.getPurchaseEbiddingItemList(), dbHead, false);
            }
        }
        headVO.setSaleHeadList(this.saleEbiddingHeadService.getByRelationId(id));
        List<SubjectFileItem> subjectFileItemList = this.subjectFileItemService.selectByMainId(dbHead.getSubjectFileHeadId());
        headVO.setSubjectFileItemList(subjectFileItemList);
        return Result.ok((Object)((Object)headVO));
    }

    private List<PurchaseEbiddingSupplierLpVO> getSupplierQuote(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> dbItemList, List<PurchaseEbiddingItemHisLp> dbItemHisList, List<PurchaseEbiddingSupplierLp> dbSupplierList) {
        if (CollUtil.isEmpty(dbSupplierList)) {
            return Lists.newArrayList();
        }
        Map<String, List<PurchaseEbiddingItemLp>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemLp::getToElsAccount));
        Map<String, List<PurchaseEbiddingItemHisLp>> itemHisMap = dbItemHisList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHisLp::getToElsAccount));
        ArrayList<PurchaseEbiddingSupplierLpVO> list = new ArrayList<PurchaseEbiddingSupplierLpVO>();
        for (PurchaseEbiddingSupplierLp supplier : dbSupplierList) {
            PurchaseEbiddingSupplierLpVO supplierVO = new PurchaseEbiddingSupplierLpVO();
            BeanUtils.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO));
            if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                List<PurchaseEbiddingItemHisLp> itemHis;
                if (CollUtil.isNotEmpty((Collection)itemMap.get(supplier.getToElsAccount()))) {
                    packageList = itemMap.get(supplier.getToElsAccount()).stream().limit(1L).collect(Collectors.toList());
                    packageList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc()));
                    supplierVO.setPurchaseEbiddingItemList(packageList);
                }
                if ((itemHis = itemHisMap.get(supplier.getToElsAccount())) != null && itemHis.size() > 0) {
                    List<PurchaseEbiddingItemHisLp> packageHisList = itemHis.stream().limit(1L).collect(Collectors.toList());
                    packageHisList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc()));
                    supplierVO.setPurchaseEbiddingItemHis(packageHisList);
                }
            } else if (EbiddingWayEnum.BATCH.getValue().equals(dbHead.getEbiddingWay())) {
                packageList = itemMap.get(supplier.getToElsAccount()).stream().limit(1L).collect(Collectors.toList());
                packageList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.BATCH.getDesc()));
                supplierVO.setPurchaseEbiddingItemList(packageList);
                List<PurchaseEbiddingItemHisLp> itemHis = itemHisMap.get(supplier.getToElsAccount());
                if (itemHis != null && itemHis.size() > 0) {
                    List<PurchaseEbiddingItemHisLp> packageHisList = itemHis.stream().limit(1L).collect(Collectors.toList());
                    packageHisList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.BATCH.getDesc()));
                    supplierVO.setPurchaseEbiddingItemHis(packageHisList);
                }
            } else {
                supplierVO.setPurchaseEbiddingItemList(itemMap.get(supplier.getToElsAccount()));
                supplierVO.setPurchaseEbiddingItemHis(itemHisMap.get(supplier.getToElsAccount()));
            }
            list.add(supplierVO);
        }
        return list;
    }

    private List<PurchaseEbiddingSupplierLpVO> getSupplierQuoteDetail(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> dbItemList, List<PurchaseEbiddingItemHisLp> dbItemHisList, List<PurchaseEbiddingSupplierLp> dbSupplierList) {
        Map<String, List<PurchaseEbiddingItemLp>> itemMap = dbItemList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemLp::getToElsAccount));
        Map<String, List<PurchaseEbiddingItemHisLp>> itemHisMap = dbItemHisList.stream().collect(Collectors.groupingBy(PurchaseEbiddingItemHisLp::getToElsAccount));
        ArrayList<PurchaseEbiddingSupplierLpVO> list = new ArrayList<PurchaseEbiddingSupplierLpVO>();
        LoginUser loginUser = SysUtil.getLoginUser();
        for (PurchaseEbiddingSupplierLp supplier : dbSupplierList) {
            PurchaseEbiddingSupplierLpVO supplierVO = new PurchaseEbiddingSupplierLpVO();
            BeanUtils.copyProperties((Object)((Object)supplier), (Object)((Object)supplierVO));
            if (EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                packageList = itemMap.get(supplier.getToElsAccount()).stream().limit(1L).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty((Object)loginUser) && !"1001".equals(loginUser.getSubAccount())) {
                    packageList.forEach(item -> {
                        item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc());
                        item.setNetTotalAmount(null);
                    });
                } else {
                    packageList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc()));
                }
                supplierVO.setPurchaseEbiddingItemList(packageList);
                itemHis = itemHisMap.get(supplier.getToElsAccount());
                if (itemHis != null && itemHis.size() > 0) {
                    packageHisList = itemHis.stream().limit(1L).collect(Collectors.toList());
                    packageHisList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc()));
                    supplierVO.setPurchaseEbiddingItemHis(packageHisList);
                }
            } else if (EbiddingWayEnum.BATCH.getValue().equals(dbHead.getEbiddingWay())) {
                packageList = itemMap.get(supplier.getToElsAccount()).stream().limit(1L).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty((Object)loginUser) && !"1001".equals(loginUser.getSubAccount())) {
                    packageList.forEach(item -> {
                        item.setMaterialDesc(EbiddingWayEnum.BATCH.getDesc());
                        item.setNetTotalAmount(null);
                    });
                } else {
                    packageList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.BATCH.getDesc()));
                }
                supplierVO.setPurchaseEbiddingItemList(packageList);
                itemHis = itemHisMap.get(supplier.getToElsAccount());
                if (itemHis != null && itemHis.size() > 0) {
                    packageHisList = itemHis.stream().limit(1L).collect(Collectors.toList());
                    packageHisList.forEach(item -> item.setMaterialDesc(EbiddingWayEnum.BATCH.getDesc()));
                    supplierVO.setPurchaseEbiddingItemHis(packageHisList);
                }
            } else {
                supplierVO.setPurchaseEbiddingItemList(itemMap.get(supplier.getToElsAccount()));
                supplierVO.setPurchaseEbiddingItemHis(itemHisMap.get(supplier.getToElsAccount()));
            }
            list.add(supplierVO);
        }
        return list;
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u5386\u53f2\u62a5\u8868", notes="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u5386\u53f2\u62a5\u8868")
    @GetMapping(value={"/queryQuoteHisByHeadId"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryQuoteHisByHeadId(PurchaseEbiddingItemLp purchaseEbiddingItem) {
        return Result.ok((Object)((PurchaseEbiddingHeadLpService)this.service).queryQuoteHisByHeadId(purchaseEbiddingItem));
    }

    @ApiOperation(value="\u62a5\u4ef7\u5386\u53f2\u62a5\u8868\u5217\u8868", notes="\u62a5\u4ef7\u5386\u53f2\u62a5\u8868\u5217\u8868")
    @GetMapping(value={"/listQuoteHis"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> listQuoteHis(PurchaseEbiddingItemHisLp purchaseEbiddingItemHis, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        return Result.ok(((PurchaseEbiddingHeadLpService)this.service).listQuoteHis(purchaseEbiddingItemHis, pageNo, pageSize));
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u5386\u53f2\u62a5\u8868-\u4f9b\u5e94\u5546\u5217\u8868", notes="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u5386\u53f2\u62a5\u8868-\u4f9b\u5e94\u5546\u5217\u8868")
    @GetMapping(value={"/querySupplierListByHeadId"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> querySupplierListByHeadId(@RequestParam(name="headId") String headId) {
        return Result.ok(((PurchaseEbiddingHeadLpService)this.service).querySupplierListByHeadId(headId));
    }

    @ApiOperation(value="\u5bfc\u51fa\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u5386\u53f2\u62a5\u8868", notes="\u5bfc\u51fa\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u5386\u53f2\u62a5\u8868")
    @PostMapping(value={"/exportQuoteReport"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public void exportQuoteReport(@RequestBody PurchaseEbiddingItemLp purchaseEbiddingItem, HttpServletResponse response) {
        ((PurchaseEbiddingHeadLpService)this.service).exportQuoteReport(purchaseEbiddingItem, response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u7ade\u4ef7\u5386\u53f2\u62a5\u8868", notes="\u5bfc\u51fa\u7ade\u4ef7\u5386\u53f2\u62a5\u8868")
    @PostMapping(value={"/exportQuoteHisReport"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public void exportQuoteHisReport(@RequestBody PurchaseEbiddingItemHisLp purchaseEbiddingItemHis, HttpServletResponse response) {
        ((PurchaseEbiddingHeadLpService)this.service).exportQuoteHisReport(purchaseEbiddingItemHis, response);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/enquiryItemList"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryItemPageList(PurchaseEbiddingHeadLp purchaseEbiddingHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        if (StrUtil.isBlank((CharSequence)purchaseEbiddingHead.getId())) {
            throw new ELSBootException("\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)purchaseEbiddingHead.getId())));
        if (StrUtil.isBlank((CharSequence)dbHead.getEnquiryId())) {
            return Result.ok();
        }
        PurchaseEbiddingSupplierLpService purchaseEbiddingSupplierService = (PurchaseEbiddingSupplierLpService)SpringContextUtils.getBean(PurchaseEbiddingSupplierLpService.class);
        List<PurchaseEbiddingSupplierLp> suppliers = purchaseEbiddingSupplierService.selectByMainId(dbHead.getId());
        List toElsAcocunts = suppliers.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"head_id", (Object)dbHead.getEnquiryId());
        queryWrapper.in(CollUtil.isNotEmpty(toElsAcocunts), (Object)"to_els_account", toElsAcocunts);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        PurchaseEnquiryItemLpService purchaseEnquiryItemService = (PurchaseEnquiryItemLpService)SpringContextUtils.getBean(PurchaseEnquiryItemLpService.class);
        IPage result = purchaseEnquiryItemService.page((IPage)page, (Wrapper)queryWrapper);
        result.getRecords().forEach(record -> record.setCenterPoint("1".equals(record.getCenterPoint()) ? "\u662f" : "\u5426"));
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u884c\u4fe1\u606f\u67e5\u8be2", notes="\u7ade\u4ef7\u5927\u5385\u62a5\u4ef7\u884c\u4fe1\u606f\u67e5\u8be2")
    @GetMapping(value={"/queryBidLobbyQuote"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryBidLobbyQuote(@RequestParam(name="id") String id, @RequestParam(name="itemNumber") String itemNumber) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)id)));
        List<PurchaseEbiddingItemLp> dbItemList = this.purchaseEbiddingItemService.selectByMainId(id).stream().filter(item -> item.getItemNumber().equals(itemNumber)).collect(Collectors.toList());
        LpEbiddingShowUtil.purchaseShow(dbItemList, dbHead, true);
        List<String> statusList = Arrays.asList(EbiddingLpStatusEnum.WAIT_REPLY.getValue(), EbiddingLpStatusEnum.NOT_JOINING.getValue(), EbiddingLpStatusEnum.REPLY_REFUSE.getValue(), EbiddingLpStatusEnum.ALREADY_REPLY.getValue());
        List joiningAccountList = this.saleEbiddingHeadService.getByRelationId(dbHead.getId()).stream().filter(head -> !statusList.contains(head.getEbiddingStatus())).map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
        List<PurchaseEbiddingItemLp> webList = dbItemList.stream().filter(item -> joiningAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
        PurchaseEbiddingHeadLpVO purchaseHead = new PurchaseEbiddingHeadLpVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)purchaseHead));
        purchaseHead.setPurchaseEbiddingItemList(webList);
        return Result.ok((Object)((Object)purchaseHead));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u62a5\u4ef7")
    @ApiOperation(value="\u62a5\u4ef7", notes="\u62a5\u4ef7")
    @PostMapping(value={"/quote"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:quote"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    @SrmValidated
    public Result<?> quote(@RequestBody PurchaseEbiddingItemLp quoteItem) {
        String headId = quoteItem.getHeadId();
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)headId)));
        PurchaseEbiddingItemLp dbItem = (PurchaseEbiddingItemLp)((Object)this.purchaseEbiddingItemService.getById((Serializable)((Object)quoteItem.getId())));
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
            Assert.isTrue((boolean)EbiddingItemLpStatusEnum.BIDDING.getValue().equals(dbItem.getItemStatus()), (String)I18nUtil.translate((String)"i18n_alert_OusncWFnqtk_36ffe5ab", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) && !"1".equals(dbHead.getRespectiveQuotations())) {
                Assert.isTrue((boolean)dbHead.getCurrentItemNumber().equals(dbItem.getItemNumber()), (String)I18nUtil.translate((String)"i18n_alert_APSLxqsu_ddfaba1e", (String)"\u5f53\u524d\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            }
            List<SaleEbiddingHeadLp> saleHeadList = this.saleEbiddingHeadService.getByRelationId(headId);
            SaleEbiddingHeadLp saleHead = (SaleEbiddingHeadLp)((Object)saleHeadList.stream().filter(head -> head.getElsAccount().equals(dbItem.getToElsAccount())).collect(Collectors.toList()).get(0));
            Assert.isTrue((boolean)EbiddingLpStatusEnum.BIDDING.getValue().equals(saleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_mRdXLOuxqsu_cd6812ae", (String)"\u6b64\u4f9b\u5e94\u5546\u672a\u7ade\u4ef7\u4e0d\u53ef\u62a5\u4ef7"));
            ((PurchaseEbiddingHeadLpService)this.service).quote(dbHead, dbItem, quoteItem);
        } else {
            if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                Assert.isTrue((boolean)dbHead.getCurrentItemNumber().equals(dbItem.getItemNumber()), (String)I18nUtil.translate((String)"i18n_alert_APSLxqsu_ddfaba1e", (String)"\u5f53\u524d\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            }
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                Assert.isTrue((!"1".equals(dbHead.getQuoteFlag()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"", (String)"\u5f53\u524d\u7269\u6599\u6b64\u8f6e\u5df2\u62a5\u4ef7\uff0c\u8bf7\u7b49\u5f85\u4e0b\u4e00\u8f6e\uff01"));
            }
            List<PurchaseEbiddingItemLp> purchaseEbiddingItems = this.purchaseEbiddingItemService.selectByMainId(headId);
            List dbItemList = purchaseEbiddingItems.stream().filter(item -> dbItem.getItemNumber().equals(item.getItemNumber())).filter(item -> EbiddingItemLpStatusEnum.BIDDING.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            Assert.notEmpty(dbItemList, (String)I18nUtil.translate((String)"i18n_alert_OusncWFnqtk_36ffe5ab", (String)"\u7ade\u4ef7\u4e2d\u7684\u884c\u6570\u636e\u624d\u53ef\u64cd\u4f5c"));
            List saleHeadList = this.saleEbiddingHeadService.getByRelationId(headId).stream().filter(head -> EbiddingLpStatusEnum.BIDDING.getValue().equals(head.getEbiddingStatus())).collect(Collectors.toList());
            Assert.notEmpty(saleHeadList, (String)I18nUtil.translate((String)"i18n_alert_djRdXLOuxqsu_3b0939d3", (String)"\u6240\u6709\u4f9b\u5e94\u5546\u672a\u7ade\u4ef7\u4e0d\u53ef\u62a5\u4ef7"));
            List canQuoteAccount = saleHeadList.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
            List needQuoteList = dbItemList.stream().filter(item -> canQuoteAccount.contains(item.getToElsAccount())).collect(Collectors.toList());
            Assert.notEmpty(needQuoteList, (String)I18nUtil.translate((String)"i18n_alert_Bjqsujc_523b9a1", (String)"\u6ca1\u6709\u53ef\u62a5\u4ef7\u7684\u884c"));
            for (PurchaseEbiddingItemLp item2 : needQuoteList) {
                PurchaseEbiddingItemLp quote = new PurchaseEbiddingItemLp();
                BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)quote));
                quote.setPrice(quoteItem.getPrice());
                quote.setNetPrice(quoteItem.getNetPrice());
                quote.setNetTotalAmount(quoteItem.getNetTotalAmount());
                quote.setTotalAmount(quoteItem.getTotalAmount());
                quote.setBidNumber(quoteItem.getBidNumber());
                ((PurchaseEbiddingHeadLpService)this.service).quote(dbHead, item2, quote);
            }
            if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
                if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
                    purchaseEbiddingItems = needQuoteList;
                }
                for (PurchaseEbiddingItemLp item2 : purchaseEbiddingItems) {
                    this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)item2.getId())).set(PurchaseEbiddingItemLp::getBidNumber, (Object)quoteItem.getBidNumber()));
                    SaleEbiddingItemLpService saleEbiddingItemService = (SaleEbiddingItemLpService)SpringContextUtils.getBean(SaleEbiddingItemLpService.class);
                    saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItemLp::getRelationId, (Object)item2.getId())).set(SaleEbiddingItemLp::getBidNumber, (Object)quoteItem.getBidNumber()));
                }
                dbHead.setBeginTime(new Date());
                dbHead.setEndTime((Date)DateUtil.offsetSecond((Date)dbHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getKeepMinute(), (int)1)));
                dbHead.setQuoteFlag("1");
                ((PurchaseEbiddingHeadLpService)this.service).updateById((Object)dbHead);
                LpEbiddingJobUtil.createDutchQuoteJob(dbHead, dbHead.getEndTime());
                SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
                saleHead.setQuoteFlag("1");
                saleHead.setBeginTime(dbHead.getBeginTime());
                saleHead.setStartTime(dbHead.getStartTime());
                saleHead.setEndTime(dbHead.getEndTime());
                saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
                SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
                saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
            }
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getId());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @ApiOperation(value="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55", notes="\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @GetMapping(value={"/generatePriceRecord"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:generatePriceRecord"})
    public Result<?> generatePriceRecord(@RequestParam(name="headId") String headId) {
        PurchaseEbiddingHeadLp dbHead = (PurchaseEbiddingHeadLp)((Object)((PurchaseEbiddingHeadLpService)this.service).getById((Serializable)((Object)headId)));
        Assert.notNull((Object)((Object)dbHead), (String)I18nUtil.translate((String)"i18n_alert_WFxMKSIqQG_3b3ce094", (String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664"));
        Assert.isTrue((!"1".equals(dbHead.getTest()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_iKBShbLumtH_432a746d", (String)"\u6d4b\u8bd5\u6807\u65e0\u6cd5\u751f\u6210\u4ef7\u683c\u8bb0\u5f55"));
        Assert.isTrue((boolean)EbiddingLpStatusEnum.BID_SUCCESS.getValue().equals(dbHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_IIujtFnObLumtH_37deecf9", (String)"\u5df2\u5b9a\u4ef7\u7684\u5355\u636e\u624d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55"));
        Assert.isTrue((!PriceCreateWayEnum.NOT.getValue().equals(dbHead.getPriceCreateWay()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mtFxqbLumVHtH_75f3f2e8", (String)"\u6b64\u5355\u636e\u4e0d\u53ef\u751f\u6210\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55"));
        Assert.isTrue((boolean)PriceCreateWayEnum.MANUAL.getValue().equals(dbHead.getPriceCreateWay()), (String)I18nUtil.translate((String)"i18n_alert_umbLCKLJObLWxTlObL_6649b670", (String)"\u4ef7\u683c\u751f\u6210\u65b9\u5f0f\u4e3a\u81ea\u52a8\u751f\u6210\uff0c\u4e0d\u9700\u624b\u52a8\u751f\u6210"));
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod()) && "1".equals(dbHead.getAllowModifyQuantity()) && EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            List<PurchaseEbiddingItemHisLp> acceptList = this.purchaseEbiddingItemHisService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            Assert.notEmpty(acceptList, (String)I18nUtil.translate((String)"i18n_alert_BjqIbLVHtHjcVH_dfb3d5f8", (String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u4fe1\u606f\u8bb0\u5f55\u7684\u884c\u4fe1\u606f"));
            acceptList.forEach(item -> {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLyxObLumtHWVxVSLAy_c134b965", (String)"\u65e0\u6599\u53f7\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff0c\u8bf7\u8865\u5145\u7269\u6599\u7f16\u53f7"));
                Assert.isTrue((!"1".equals(item.getSendStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mtFIObLRVHtHrWxqVBbL_ad6490a8", (String)"\u6b64\u5355\u636e\u5df2\u7ecf\u751f\u6210\u8fc7\u4fe1\u606f\u8bb0\u5f55\u4e86\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210"));
            });
            ((PurchaseEbiddingHeadLpService)this.service).generatePriceRecordByHis(dbHead, acceptList);
        } else {
            List<PurchaseEbiddingItemLp> acceptList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getId()).stream().filter(item -> EbiddingItemLpStatusEnum.BID_WIN.getValue().equals(item.getItemStatus())).collect(Collectors.toList());
            Assert.notEmpty(acceptList, (String)I18nUtil.translate((String)"i18n_alert_BjqIbLVHtHjcVH_dfb3d5f8", (String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u4fe1\u606f\u8bb0\u5f55\u7684\u884c\u4fe1\u606f"));
            acceptList.forEach(item -> {
                Assert.hasText((String)item.getMaterialNumber(), (String)I18nUtil.translate((String)"i18n_alert_SLyxObLumtHWVxVSLAy_c134b965", (String)"\u65e0\u6599\u53f7\u4e0d\u80fd\u751f\u6210\u4ef7\u683c\u8bb0\u5f55\uff0c\u8bf7\u8865\u5145\u7269\u6599\u7f16\u53f7"));
                Assert.isTrue((!"1".equals(item.getSendStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_mtFIObLRVHtHrWxqVBbL_ad6490a8", (String)"\u6b64\u5355\u636e\u5df2\u7ecf\u751f\u6210\u8fc7\u4fe1\u606f\u8bb0\u5f55\u4e86\uff0c\u4e0d\u53ef\u91cd\u590d\u751f\u6210"));
            });
            ((PurchaseEbiddingHeadLpService)this.service).generatePriceRecord(dbHead, acceptList);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_umtHbLLR_980a4aaa", (String)"\u4ef7\u683c\u8bb0\u5f55\u751f\u6210\u6210\u529f"));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u5b9a\u4ef7\u901a\u77e5")
    @ApiOperation(value="\u5b9a\u4ef7\u901a\u77e5", notes="\u5b9a\u4ef7\u901a\u77e5")
    @GetMapping(value={"/pricingNotice"})
    @RequiresPermissions(value={"ebidding#purchaseEbiddingHead:pricingNotice"})
    public Result<?> pricingNotice(@RequestParam(value="headId") String headId, @RequestParam(value="pricingNotice") String pricingNotice) {
        ((PurchaseEbiddingHeadLpService)this.service).pricingNotice(headId, pricingNotice);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u67e5\u8be2\u5728\u7ebf\u4f9b\u5e94\u5546", notes="\u67e5\u8be2\u5728\u7ebf\u4f9b\u5e94\u5546")
    @GetMapping(value={"/queryOnlineAccount"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryOnlineAccount(@RequestParam(value="headId") String headId) {
        List<PurchaseEbiddingSupplierLp> supplierList = this.ebiddingSupplierService.selectByMainId(headId);
        ArrayList<String> onlineAccount = new ArrayList<String>();
        for (PurchaseEbiddingSupplierLp supplier : supplierList) {
            String supplierAccount = supplier.getToElsAccount();
            String redisKey = "online:cache:users:" + headId + ":" + supplierAccount;
            if (!this.redis.hasKey(redisKey)) continue;
            onlineAccount.add(supplierAccount);
        }
        return Result.ok((String)String.join((CharSequence)",", onlineAccount));
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"lpbase#lineDifferenceHead:exportXls"})
    @PermissionDataView(businessType="ebiddingLp")
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseEbiddingHeadLpExportServiceImpl.class);
    }

    @ApiOperation(value="\u6253\u5370", notes="\u6253\u5370")
    @GetMapping(value={"/printEbidding"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:print"})
    public Result<?> printEbidding(@RequestParam(name="id") String id) {
        PurchaseEbiddingPrintLpVO printVO = ((PurchaseEbiddingHeadLpService)this.service).printById(id);
        return Result.ok((Object)((Object)printVO));
    }

    @AutoLog(value="\u8bae\u4ef7\u6392\u540d\u5927\u5385-\u5b9a\u6807")
    @ApiOperation(value="\u5b9a\u6807", notes="\u5b9a\u6807")
    @PostMapping(value={"/overviewSubmitPrice"})
    @RequiresPermissions(value={"lpbase#lineDifferenceHead:overallRanking"})
    @PermissionDataOpt(businessType="ebiddingLp", beanClass=PurchaseEbiddingHeadLpService.class)
    @SrmValidated
    public Result<?> overviewSubmitPrice(@RequestBody PurchaseOverviewSubmitPriceVO submitPriceVO) {
        ((PurchaseEbiddingHeadLpService)this.service).overviewSubmitPrice(submitPriceVO);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7\u7ade\u4ef7\u5355\u5934id\u83b7\u53d6\u8be2\u4ef7\u5355\u6a21\u677f\u7684\u884c\u4fe1\u606f", notes="\u901a\u8fc7\u7ade\u4ef7\u5355\u5934id\u83b7\u53d6\u8be2\u4ef7\u5355\u6a21\u677f\u7684\u884c\u4fe1\u606f")
    @GetMapping(value={"/queryEnquiryItemTemplateByEbiddingId"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryEnquiryItemTemplateByEbiddingId(@RequestParam(name="id") String id) {
        return Result.ok(((PurchaseEbiddingHeadLpService)this.service).queryEnquiryItemTemplateByEbiddingId(id));
    }

    @ApiOperation(value="\u7ade\u4ef7\u5355\u5386\u53f2\u62a5\u8868", notes="\u4e0b\u62c9\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryQuoteHisDictCodeList"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:view"})
    public Result<?> queryQuoteHisDictCodeList(@RequestParam(name="subjectNumber", required=false) String subjectNumber, @RequestParam(name="toElsAccount", required=false) String toElsAccount, @RequestParam(name="subjectYear", required=false) String subjectYear) {
        return Result.ok((Object)((PurchaseEbiddingHeadLpService)this.service).queryQuoteHisDictCodeList(subjectNumber, toElsAccount, subjectYear));
    }

    @AutoLog(value="\u91c7\u8d2d\u7ade\u4ef7-\u6094\u6807")
    @ApiOperation(value="\u6094\u6807", notes="\u6094\u6807")
    @PostMapping(value={"/regret"})
    @RequiresPermissions(value={"lpEbidding#purchaseEbiddingHeadLp:regret"})
    @PermissionDataOpt(businessType="ebidding", beanClass=PurchaseEbiddingHeadService.class)
    public Result<?> regret(@RequestBody PurchaseEbiddingHeadLpVO headVO) {
        Assert.hasText((String)headVO.getRegretFlag(), (String)I18nUtil.translate((String)"i18n_alert_MBBKxOLV_d46458e2", (String)"\u6094\u6807\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.hasText((String)headVO.getId(), (String)I18nUtil.translate((String)"i18n_alert_empty_header_id", (String)"\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a"));
        ((PurchaseEbiddingHeadLpService)this.service).regret(headVO);
        return this.commonSuccessResult(3);
    }
}

