/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.api.dto.PurchaseInquiryQuotedConfigDTO;
import com.els.modules.enquiry.entity.PurchaseInquiryQuotedConfig;
import com.els.modules.enquiry.enumerate.EnquiryQuoteWayEnum;
import com.els.modules.enquiry.enumerate.QuotedConfigConfigItemEnum;
import com.els.modules.enquiry.mapper.PurchaseInquiryQuotedConfigMapper;
import com.els.modules.logisticspurchase.enquiry.service.PurchaseInquiryQuotedConfigLpService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PurchaseInquiryQuotedConfigLpServiceImpl
extends BaseServiceImpl<PurchaseInquiryQuotedConfigMapper, PurchaseInquiryQuotedConfig>
implements PurchaseInquiryQuotedConfigLpService {
    @Override
    public void add(PurchaseInquiryQuotedConfig purchaseInquiryQuotedConfig) {
        this.check(purchaseInquiryQuotedConfig);
        purchaseInquiryQuotedConfig.setElsAccount(TenantContext.getTenant());
        this.save((Object)purchaseInquiryQuotedConfig);
    }

    @Override
    public void edit(PurchaseInquiryQuotedConfig purchaseOrderPermissionConfig) {
        this.check(purchaseOrderPermissionConfig);
        int count = ((PurchaseInquiryQuotedConfigMapper)this.baseMapper).updateById((Object)purchaseOrderPermissionConfig);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public String autoLoadOne(PurchaseInquiryQuotedConfigDTO configDto) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).eq(PurchaseInquiryQuotedConfig::getQuotePriceWay, (Object)configDto.getQuotePriceWay())).eq(CharSequenceUtil.isNotEmpty((CharSequence)configDto.getCompany()), PurchaseInquiryQuotedConfig::getCompany, (Object)configDto.getCompany())).eq(CharSequenceUtil.isNotEmpty((CharSequence)configDto.getFactory()), PurchaseInquiryQuotedConfig::getFactory, (Object)configDto.getFactory())).eq(CharSequenceUtil.isNotEmpty((CharSequence)configDto.getPurchaseOrg()), PurchaseInquiryQuotedConfig::getPurchaseOrg, (Object)configDto.getPurchaseOrg());
        List configs = ((PurchaseInquiryQuotedConfigMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (configs.isEmpty()) {
            return "";
        }
        for (PurchaseInquiryQuotedConfig config : configs) {
            if (QuotedConfigConfigItemEnum.MATERIAL_NUMBER.getValue().equals(config.getConfigItem())) {
                config.setMaterialNumber(config.getConfigValue());
                if (config.getConfigValue().equals(configDto.getMaterialNumber())) {
                    config.setMaterialNumberSort(1);
                    config.setMatching(true);
                }
            }
            if (QuotedConfigConfigItemEnum.MATERIAL_GROUP.getValue().equals(config.getConfigItem())) {
                config.setMaterialGroup(config.getConfigValue());
                if (config.getConfigValue().equals(configDto.getMaterialGroup())) {
                    config.setMaterialGroupSort(1);
                    config.setMatching(true);
                }
            }
            if (!QuotedConfigConfigItemEnum.MATERIAL_CATE.getValue().equals(config.getConfigItem())) continue;
            config.setCateCode(config.getConfigValue());
            if (!config.getConfigValue().equals(configDto.getCateCode())) continue;
            config.setCateCodeSort(1);
            config.setMatching(true);
        }
        if ((configs = configs.stream().filter(PurchaseInquiryQuotedConfig::getMatching).sorted(Comparator.comparingInt(PurchaseInquiryQuotedConfig::getMaterialNumberSort).thenComparingInt(PurchaseInquiryQuotedConfig::getMaterialGroupSort).thenComparingInt(PurchaseInquiryQuotedConfig::getCateCodeSort)).collect(Collectors.toList())).isEmpty()) {
            return "";
        }
        PurchaseInquiryQuotedConfig config = (PurchaseInquiryQuotedConfig)((Object)configs.get(0));
        if (EnquiryQuoteWayEnum.LADDER.getValue().equals(config.getQuotePriceWay())) {
            return config.getLadderPriceJson();
        }
        return config.getCostFormJson();
    }

    @Override
    public String batchLoadOne(PurchaseInquiryQuotedConfigDTO configDto, List<PurchaseInquiryQuotedConfig> configSource) {
        List configs = JSONArray.parseArray((String)JSON.toJSONString(configSource), PurchaseInquiryQuotedConfig.class);
        List<Object> temConfig = new ArrayList();
        for (PurchaseInquiryQuotedConfig config : configs) {
            if (!config.getQuotePriceWay().equals(configDto.getQuotePriceWay())) continue;
            if (QuotedConfigConfigItemEnum.MATERIAL_NUMBER.getValue().equals(config.getConfigItem())) {
                config.setMaterialNumber(config.getConfigValue());
                if (config.getConfigValue().equals(configDto.getMaterialNumber())) {
                    config.setMaterialNumberSort(1);
                    config.setMatching(true);
                }
            }
            if (QuotedConfigConfigItemEnum.MATERIAL_GROUP.getValue().equals(config.getConfigItem())) {
                config.setMaterialGroup(config.getConfigValue());
                if (config.getConfigValue().equals(configDto.getMaterialGroup())) {
                    config.setMaterialGroupSort(1);
                    config.setMatching(true);
                }
            }
            if (QuotedConfigConfigItemEnum.MATERIAL_CATE.getValue().equals(config.getConfigItem())) {
                config.setCateCode(config.getConfigValue());
                if (config.getConfigValue().equals(configDto.getCateCode())) {
                    config.setCateCodeSort(1);
                    config.setMatching(true);
                }
            }
            if (CharSequenceUtil.isEmpty((CharSequence)configDto.getCompany()) && !CharSequenceUtil.equals((CharSequence)config.getCompany(), (CharSequence)configDto.getCompany()) || CharSequenceUtil.isEmpty((CharSequence)configDto.getPurchaseOrg()) && !CharSequenceUtil.equals((CharSequence)config.getPurchaseOrg(), (CharSequence)configDto.getPurchaseOrg()) || CharSequenceUtil.isEmpty((CharSequence)configDto.getFactory()) && !CharSequenceUtil.equals((CharSequence)config.getFactory(), (CharSequence)configDto.getFactory()) || CharSequenceUtil.isNotEmpty((CharSequence)configDto.getCompany()) && CharSequenceUtil.isNotEmpty((CharSequence)config.getCompany()) && !CharSequenceUtil.equals((CharSequence)config.getCompany(), (CharSequence)configDto.getCompany()) || CharSequenceUtil.isNotEmpty((CharSequence)configDto.getPurchaseOrg()) && CharSequenceUtil.isNotEmpty((CharSequence)config.getPurchaseOrg()) && !CharSequenceUtil.equals((CharSequence)config.getPurchaseOrg(), (CharSequence)configDto.getPurchaseOrg()) || CharSequenceUtil.isNotEmpty((CharSequence)configDto.getFactory()) && CharSequenceUtil.isNotEmpty((CharSequence)config.getFactory()) && !CharSequenceUtil.equals((CharSequence)config.getFactory(), (CharSequence)configDto.getFactory())) continue;
            if (CharSequenceUtil.equals((CharSequence)config.getCompany(), (CharSequence)configDto.getCompany())) {
                config.setFcoOrder(config.getFcoOrder() + 1);
            }
            if (CharSequenceUtil.equals((CharSequence)config.getPurchaseOrg(), (CharSequence)configDto.getPurchaseOrg())) {
                config.setFcoOrder(config.getFcoOrder() + 1);
            }
            if (CharSequenceUtil.equals((CharSequence)config.getFactory(), (CharSequence)configDto.getFactory())) {
                config.setFcoOrder(config.getFcoOrder() + 1);
            }
            temConfig.add((Object)config);
        }
        if ((temConfig = temConfig.stream().filter(PurchaseInquiryQuotedConfig::getMatching).sorted(Comparator.comparingInt(PurchaseInquiryQuotedConfig::getMaterialNumberSort).thenComparingInt(PurchaseInquiryQuotedConfig::getMaterialGroupSort).reversed().thenComparingInt(PurchaseInquiryQuotedConfig::getCateCodeSort).reversed().thenComparingInt(PurchaseInquiryQuotedConfig::getFcoOrder).reversed()).collect(Collectors.toList())).isEmpty()) {
            return "";
        }
        PurchaseInquiryQuotedConfig config = (PurchaseInquiryQuotedConfig)((Object)temConfig.get(0));
        if (EnquiryQuoteWayEnum.LADDER.getValue().equals(config.getQuotePriceWay())) {
            return config.getLadderPriceJson();
        }
        return config.getCostFormJson();
    }

    @Override
    public Map<String, String> autoLoadQuotePriceWay(List<PurchaseInquiryQuotedConfigDTO> configDtoList) {
        HashMap<String, String> result = new HashMap<String, String>();
        List quotedConfigs = this.list();
        for (PurchaseInquiryQuotedConfigDTO configDTO : configDtoList) {
            String r = this.batchLoadOne(configDTO, quotedConfigs);
            result.put(configDTO.getMaterialNumber(), r);
        }
        return result;
    }

    private void check(PurchaseInquiryQuotedConfig config) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseInquiryQuotedConfig::getConfigItem, (Object)config.getConfigItem())).eq(PurchaseInquiryQuotedConfig::getConfigValue, (Object)config.getConfigValue())).eq(PurchaseInquiryQuotedConfig::getQuotePriceWay, (Object)config.getQuotePriceWay())).ne(CharSequenceUtil.isNotEmpty((CharSequence)config.getId()), BaseEntity::getId, (Object)config.getId());
        if (CharSequenceUtil.isEmpty((CharSequence)config.getCompany())) {
            wrapper.isNull(PurchaseInquiryQuotedConfig::getCompany);
        } else {
            wrapper.eq(PurchaseInquiryQuotedConfig::getCompany, (Object)config.getCompany());
        }
        if (CharSequenceUtil.isEmpty((CharSequence)config.getFactory())) {
            wrapper.isNull(PurchaseInquiryQuotedConfig::getFactory);
        } else {
            wrapper.eq(PurchaseInquiryQuotedConfig::getFactory, (Object)config.getFactory());
        }
        if (CharSequenceUtil.isEmpty((CharSequence)config.getPurchaseOrg())) {
            wrapper.isNull(PurchaseInquiryQuotedConfig::getPurchaseOrg);
        } else {
            wrapper.eq(PurchaseInquiryQuotedConfig::getPurchaseOrg, (Object)config.getPurchaseOrg());
        }
        int count = this.count((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u914d\u7f6e"));
        }
    }
}

