/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.project.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.inquiry.rpc.service.InquiryInvokeWorkFlowRpcService;
import com.els.modules.tender.common.utils.TenderAuditSubjectUtils;
import com.els.modules.tender.project.entity.PurchaseTenderProjectHead;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.entity.PurchaseTenderSubpackagePriceChange;
import com.els.modules.tender.project.mapper.PurchaseTenderSubpackagePriceChangeMapper;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.service.PurchaseTenderSubpackagePriceChangeService;
import com.els.modules.tender.project.vo.PurchaseTenderSubpackagePriceChangeSubmitVo;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTenderSubpackagePriceChangeServiceImpl
extends BaseServiceImpl<PurchaseTenderSubpackagePriceChangeMapper, PurchaseTenderSubpackagePriceChange>
implements PurchaseTenderSubpackagePriceChangeService {
    @Resource
    private InquiryInvokeWorkFlowRpcService inquiryInvokeWorkFlowRpcService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;
    @Autowired
    private PurchaseTenderProjectHeadService headService;

    @Override
    public List<PurchaseTenderSubpackagePriceChange> selectByMainId(String mainId) {
        return ((PurchaseTenderSubpackagePriceChangeMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseTenderSubpackagePriceChangeMapper)this.baseMapper).deleteByMainId(mainId);
    }

    @Override
    public boolean checkAuditConfig() {
        AuditInputParamDTO dto = new AuditInputParamDTO();
        dto.setBusinessId("1");
        dto.setBusinessType("subpackagePriceChange");
        return this.inquiryInvokeWorkFlowRpcService.checkConfig(dto);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveSubpackagePriceChange(PurchaseTenderSubpackagePriceChange priceChange) {
        this.batchSubpackagePriceChange(Arrays.asList(priceChange));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void batchSubpackagePriceChange(List<PurchaseTenderSubpackagePriceChange> priceChanges) {
        if (CollectionUtil.isEmpty(priceChanges)) {
            return;
        }
        this.checkParamStatus(priceChanges);
        if (this.checkAuditConfig()) {
            this.saveOrUpdateBatch(priceChanges);
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(priceChanges.get(0).getProjectId());
            dto.setBusinessType("subpackagePriceChange");
            PurchaseTenderProjectHead projectHead = (PurchaseTenderProjectHead)((Object)this.headService.getById((Serializable)((Object)priceChanges.get(0).getProjectId())));
            String subject = TenderAuditSubjectUtils.getTenderAuditSubject("subpackagePriceChange", "\u9884\u7b97\u53d8\u66f4", projectHead.getTenderProjectNumber(), projectHead.getTenderProjectName(), null);
            dto.setAuditSubject(subject);
            PurchaseTenderSubpackagePriceChangeSubmitVo submitVo = (PurchaseTenderSubpackagePriceChangeSubmitVo)((Object)SysUtil.copyProperties((Object)((Object)projectHead), PurchaseTenderSubpackagePriceChangeSubmitVo.class));
            submitVo.setSubpackagePriceChanges(priceChanges);
            dto.setParams(JSONObject.toJSONString((Object)((Object)submitVo)));
            this.inquiryInvokeWorkFlowRpcService.submit(dto);
        } else {
            this.updateSubpackageInfoAndChangeInfo(priceChanges);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateSubpackageInfoAndChangeInfo(List<PurchaseTenderSubpackagePriceChange> priceChanges) {
        priceChanges.forEach(price -> {
            price.setSubpackageChangeBudget(price.getPreSubpackageChangeBudget());
            price.setPreSubpackageChangeBudget(null);
        });
        this.saveOrUpdateBatch(priceChanges);
        List subpackageInfoList = priceChanges.stream().map(priceChange -> {
            PurchaseTenderProjectSubpackageInfo subpackageInfo = new PurchaseTenderProjectSubpackageInfo();
            subpackageInfo.setId(priceChange.getSubpackageId());
            subpackageInfo.setBudget(priceChange.getSubpackageChangeBudget());
            subpackageInfo.setChangeDesc(priceChange.getChangeDesc());
            return subpackageInfo;
        }).collect(Collectors.toList());
        this.subpackageInfoService.updateBatchById(subpackageInfoList, 2000);
    }

    private void checkParamStatus(List<PurchaseTenderSubpackagePriceChange> priceChangeList) {
        for (PurchaseTenderSubpackagePriceChange priceChange : priceChangeList) {
            if (!AuditStatusEnum.AUDIT_DOING.getValue().equals(priceChange.getAuditStatus())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APAHjWFsMKiKUzjWFWVIm_35f984c4", (String)"\u5f53\u524d\u53d8\u66f4\u7684\u6570\u636e\u4e2d\u5b58\u5728\u6b63\u5728\u5ba1\u6279\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5"));
        }
    }
}

