/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.ebidding.entity.EbiddingConfirmItem;
import com.els.modules.ebidding.entity.PurchaseEbiddingConfirm;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingConfirm;
import com.els.modules.ebidding.enumerate.EbiddingConfirmStatusEnum;
import com.els.modules.ebidding.mapper.SaleEbiddingConfirmMapper;
import com.els.modules.ebidding.service.EbiddingConfirmItemService;
import com.els.modules.ebidding.service.PurchaseEbiddingConfirmService;
import com.els.modules.ebidding.service.SaleEbiddingConfirmService;
import com.els.modules.ebidding.vo.SaleEbiddingConfirmVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEbiddingConfirmServiceImpl
extends BaseServiceImpl<SaleEbiddingConfirmMapper, SaleEbiddingConfirm>
implements SaleEbiddingConfirmService {
    @Autowired
    private EbiddingConfirmItemService ebiddingConfirmItemService;
    @Autowired
    private PurchaseEbiddingConfirmService purchaseEbiddingConfirmService;

    @Override
    public List<SaleEbiddingConfirmVO> selectByMainId(String mainId) {
        List<SaleEbiddingConfirm> confirmList = ((SaleEbiddingConfirmMapper)this.baseMapper).selectByMainId(mainId);
        ArrayList result = SysUtil.copyProperties(confirmList, SaleEbiddingConfirmVO.class);
        if (CollectionUtil.isNotEmpty(confirmList)) {
            List idList = confirmList.stream().map(SaleEbiddingConfirm::getRelationId).collect(Collectors.toList());
            List itemList = this.ebiddingConfirmItemService.list((Wrapper)new LambdaQueryWrapper().in(EbiddingConfirmItem::getHeadId, idList));
            Map<String, List<EbiddingConfirmItem>> itemMap = itemList.stream().collect(Collectors.groupingBy(EbiddingConfirmItem::getHeadId));
            for (SaleEbiddingConfirmVO vo : result) {
                List<EbiddingConfirmItem> list = itemMap.get(vo.getRelationId());
                vo.setConfirmItemList(list);
            }
        }
        return result;
    }

    @Override
    public void publish(PurchaseEbiddingHead head, List<PurchaseEbiddingConfirm> confirmList, Map<String, String> idMap) {
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<SaleEbiddingConfirm> insertList = new ArrayList<SaleEbiddingConfirm>();
            for (PurchaseEbiddingConfirm confirm : confirmList) {
                SaleEbiddingConfirm insert = new SaleEbiddingConfirm();
                BeanUtils.copyProperties((Object)((Object)confirm), (Object)((Object)insert));
                insert.setId(confirm.getRelationId());
                insert.setElsAccount(confirm.getToElsAccount());
                insert.setRelationId(confirm.getId());
                insert.setHeadId(idMap.get(confirm.getToElsAccount()));
                insert.setToElsAccount(confirm.getElsAccount());
                insertList.add(insert);
            }
            this.saveBatch(insertList, 2000);
        }
    }

    @Override
    public void acceptResponse(List<SaleEbiddingConfirmVO> confirmList) {
        if (CollectionUtil.isNotEmpty(confirmList)) {
            ArrayList<SaleEbiddingConfirm> updateSaleList = new ArrayList<SaleEbiddingConfirm>();
            ArrayList<PurchaseEbiddingConfirm> updatePurchaseList = new ArrayList<PurchaseEbiddingConfirm>();
            for (SaleEbiddingConfirmVO confirmVO : confirmList) {
                SaleEbiddingConfirm saleConfirm = new SaleEbiddingConfirm();
                saleConfirm.setId(confirmVO.getId());
                saleConfirm.setSupplierRemark(confirmVO.getSupplierRemark());
                saleConfirm.setContent(confirmVO.getContent());
                saleConfirm.setStatus(EbiddingConfirmStatusEnum.ALREADY_REPLY.getValue());
                updateSaleList.add(saleConfirm);
                PurchaseEbiddingConfirm purchaseConfirm = new PurchaseEbiddingConfirm();
                purchaseConfirm.setId(confirmVO.getRelationId());
                purchaseConfirm.setSupplierRemark(confirmVO.getSupplierRemark());
                purchaseConfirm.setContent(confirmVO.getContent());
                purchaseConfirm.setStatus(EbiddingConfirmStatusEnum.ALREADY_REPLY.getValue());
                updatePurchaseList.add(purchaseConfirm);
            }
            this.updateBatchById(updateSaleList);
            this.purchaseEbiddingConfirmService.updateBatchById(updatePurchaseList);
        }
    }
}

