/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.searchSourceConfig.enums;

import com.els.common.util.AssertI18nUtil;
import com.els.modules.searchSourceConfig.enums.I18nSearSourEnum;
import com.els.modules.searchSourceConfig.utils.BigDecimalUtil;
import com.els.modules.searchSourceConfig.vo.MaterialAmountDataVo;
import com.els.modules.searchSourceConfig.vo.base.IMaterialAmountValidParam;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AmountThresholdValidEnum {
    MATERIAL("1"){

        @Override
        public void amountThreshValid(IMaterialAmountValidParam validParam) {
            String cateCode = validParam.getCateCode();
            List<MaterialAmountDataVo> dataVos = validParam.getMaterialDataVos();
            BigDecimal total = dataVos.stream().filter(dataVo -> dataVo.getAmount() != null && Objects.equals(cateCode, dataVo.getCateCode())).map(MaterialAmountDataVo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            String amountThreshold = validParam.getAmountThreshold();
            AssertI18nUtil.isTrue((boolean)BigDecimalUtil.bigThan(total, amountThreshold), (Enum)I18nSearSourEnum.BIG_THAN_AMOUNT_THRESHOLD, (String[])new String[]{cateCode, "\u6309\u7269\u6599\u5206\u7c7b\u7edf\u8ba1", amountThreshold});
        }
    }
    ,
    ALL("2"){

        @Override
        public void amountThreshValid(IMaterialAmountValidParam validParam) {
            boolean bool = BigDecimalUtil.bigThan(validParam.getTotalAmount(), validParam.getAmountThreshold());
            AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSearSourEnum.STATISTICAL_TYPE_ALL_BIG);
        }
    };

    private final String statisticalType;
    private static final Map<String, AmountThresholdValidEnum> enumMap;

    public abstract void amountThreshValid(IMaterialAmountValidParam var1);

    public String statisticalType() {
        return this.statisticalType;
    }

    private AmountThresholdValidEnum(String statisticalType) {
        this.statisticalType = statisticalType;
    }

    public static AmountThresholdValidEnum of(String statisticalType) {
        AmountThresholdValidEnum typeEnum = enumMap.get(statisticalType);
        AssertI18nUtil.isTrue((typeEnum == null ? 1 : 0) != 0, (Enum)I18nSearSourEnum.STATISTICAL_TYPE_NOT_FOUND, (String[])new String[]{statisticalType});
        return typeEnum;
    }

    static {
        enumMap = Stream.of(AmountThresholdValidEnum.values()).collect(Collectors.toMap(AmountThresholdValidEnum::statisticalType, e -> e));
    }
}

