/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.enquiry.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.logisticspurchase.enquiry.entity.EnquirySupplierListLp;
import com.els.modules.logisticspurchase.enquiry.mapper.EnquirySupplierListLpMapper;
import com.els.modules.logisticspurchase.enquiry.service.EnquirySupplierListLpService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnquirySupplierListLpServiceImpl
extends ServiceImpl<EnquirySupplierListLpMapper, EnquirySupplierListLp>
implements EnquirySupplierListLpService {
    @Autowired
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;

    @Override
    public List<EnquirySupplierListLp> selectByMainId(String mainId) {
        List<EnquirySupplierListLp> list = ((EnquirySupplierListLpMapper)this.baseMapper).selectByMainId(mainId);
        List<String> toElsAccount = list.stream().map(x -> x.getToElsAccount()).distinct().collect(Collectors.toList());
        List<SupplierMasterDataDTO> supplierMasterDataDTOS = this.inquiryInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccount);
        Map<String, SupplierMasterDataDTO> supplierMasterDataDTOMap = supplierMasterDataDTOS.stream().collect(Collectors.toMap(x -> x.getToElsAccount(), y -> y));
        list.forEach(row -> {
            if (supplierMasterDataDTOMap.containsKey(row.getToElsAccount())) {
                row.setSupplierCode(((SupplierMasterDataDTO)supplierMasterDataDTOMap.get(row.getToElsAccount())).getSupplierCode());
                row.setNeedCoordination(((SupplierMasterDataDTO)supplierMasterDataDTOMap.get(row.getToElsAccount())).getNeedCoordination());
            }
        });
        return list;
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((EnquirySupplierListLpMapper)this.baseMapper).deleteByMainId(mainId);
    }
}

