/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.util.FormulaUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ExcelItemByConfigRpcService;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.system.dto.ExcelByConfigDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="saleCostExcelServiceImpl")
public class SaleCostExcelServiceImpl
extends ErrorExcelHandlerService
implements ExcelItemByConfigRpcService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleEnquiryItemService saleEnquiryItemService;
    private String headId;

    public TemplateHeadDTO getTemplate(ExcelByConfigDTO excelByConfigDTO) {
        this.headId = excelByConfigDTO.getHeadId();
        String[] businessId = excelByConfigDTO.getHeadId().split("_");
        String templateNumber = businessId[0];
        String templateVersion = businessId[1];
        String account = businessId[2];
        return this.invokeBaseRpcService.getTemplateConfig(account, templateNumber, templateVersion);
    }

    public List<Object> getExportData(ExcelByConfigDTO excelByConfigDTO) {
        String data = excelByConfigDTO.getData();
        String itemId = data.split("_")[0];
        String groupCode = data.split("_")[1];
        SaleEnquiryItem item = (SaleEnquiryItem)((Object)this.saleEnquiryItemService.getById((Serializable)((Object)itemId)));
        String costFormJson = item.getCostFormJson();
        JSONObject costJSON = JSONObject.parseObject((String)costFormJson);
        JSONObject costData = costJSON.getJSONObject("data") == null ? new JSONObject() : costJSON.getJSONObject("data");
        return costData.getJSONArray(groupCode) == null ? new JSONArray() : costData.getJSONArray(groupCode);
    }

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<String> computeField = new ArrayList<String>();
        List configItemList = this.getTemplate(excelImportDTO.getExcelByConfigDTO()).getTemplateConfigItemList();
        List formulaList = configItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).collect(Collectors.toList());
        for (TemplateConfigItemDTO item2 : formulaList) {
            Matcher matcher = FormulaUtil.getPattern().matcher(item2.getFormula());
            while (matcher.find()) {
                computeField.add(matcher.group(1));
            }
        }
        Map<String, String> formulaMap = configItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).collect(Collectors.toMap(TemplateConfigItemDTO::getFieldName, TemplateConfigItemDTO::getFormula));
        for (Map data : dataList) {
            for (String field : computeField) {
                FormulaUtil.compute((String)field, formulaMap, (Map)data);
            }
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

