/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.ebidding.enumerate.EbiddingDelayRuleEnum;
import com.els.modules.ebidding.enumerate.EbiddingMethodEnum;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.ebidding.enumerate.EbiddingRangeUnitEnum;
import com.els.modules.ebidding.enumerate.EbiddingReplyStatusEnum;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.ebidding.vo.PurchaseEbiddingMessageVO;
import com.els.modules.inquiry.rpc.service.InquiryInvokeSupplierRpcService;
import com.els.modules.logisticspurchase.base.entity.LineDifferenceHead;
import com.els.modules.logisticspurchase.base.enumerate.LineSourceTypeEnum;
import com.els.modules.logisticspurchase.base.service.LineDifferenceHeadService;
import com.els.modules.logisticspurchase.base.service.SubjectFileItemService;
import com.els.modules.logisticspurchase.ebidding.constant.EbiddingLpConstant;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingConfirmLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingItemLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.EbiddingLpStatusEnum;
import com.els.modules.logisticspurchase.ebidding.enumerate.LpEbiddingTypeHisEnum;
import com.els.modules.logisticspurchase.ebidding.job.utils.LpEbiddingJobUtil;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingHeadLpMapper;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingItemHisLpMapper;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingItemLpMapper;
import com.els.modules.logisticspurchase.ebidding.mapper.SaleEbiddingHeadLpMapper;
import com.els.modules.logisticspurchase.ebidding.mapper.SaleEbiddingItemLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingSupplierLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingConfirmLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingHeadLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemLpService;
import com.els.modules.logisticspurchase.ebidding.service.impl.PurchaseEbiddingHeadLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.PurchaseEbiddingItemHisLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.PurchaseEbiddingItemLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.service.impl.SaleEbiddingItemHisLpServiceImpl;
import com.els.modules.logisticspurchase.ebidding.vo.ReverseRouteUnitPriceVO;
import com.els.modules.logisticspurchase.ebidding.vo.SaleEbiddingConfirmLpVO;
import com.els.modules.logisticspurchase.ebidding.vo.SaleEbiddingHeadLpVO;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.SaleEnquiryItemLp;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryHeadLpService;
import com.els.modules.logisticspurchase.enquiry.service.SaleEnquiryItemLpService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SaleEbiddingHeadLpServiceImpl
extends BaseServiceImpl<SaleEbiddingHeadLpMapper, SaleEbiddingHeadLp>
implements SaleEbiddingHeadLpService {
    private static final Logger log = LoggerFactory.getLogger(SaleEbiddingHeadLpServiceImpl.class);
    @Autowired
    private SaleEbiddingItemLpMapper saleEbiddingItemMapper;
    @Autowired
    private PurchaseEbiddingSupplierLpService purchaseEbiddingSupplierService;
    @Autowired
    private PurchaseEbiddingHeadLpMapper purchaseEbiddingHeadMapper;
    @Autowired
    private PurchaseEbiddingItemLpMapper purchaseEbiddingItemMapper;
    @Autowired
    private SaleEbiddingItemLpService saleEbiddingItemService;
    @Autowired
    private SaleEbiddingConfirmLpService saleEbiddingConfirmService;
    @Autowired
    private PurchaseEbiddingItemLpService purchaseEbiddingItemService;
    @Autowired
    private SaleEbiddingItemHisLpService saleEbiddingItemHisService;
    @Autowired
    private PurchaseEbiddingItemHisLpMapper purchaseEbiddingItemHisMapper;
    @Autowired
    private RedisUtil redis;
    @Autowired
    private ThreadPoolExecutor srmPoolExecutor;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InquiryInvokeSupplierRpcService inquiryInvokeSupplierRpcService;
    @Autowired
    private SubjectFileItemService subjectFileItemService;
    private static final String EBIDDING_QUOTE_RANGE_KEY = "sys:ebidding:quote_range";

    @Override
    public Map<String, String> publish(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList, List<PurchaseEbiddingSupplierLp> supplierList, List<PurchaseEbiddingConfirmLp> confirmList) {
        ArrayList<SaleEbiddingHeadLp> saleHeadList = new ArrayList<SaleEbiddingHeadLp>();
        LoginUser user = SysUtil.getLoginUser();
        SaleEnquiryHeadLpService saleEnquiryHeadService = (SaleEnquiryHeadLpService)SpringContextUtils.getBean(SaleEnquiryHeadLpService.class);
        List<SaleEnquiryHeadLp> dbSaleHeads = saleEnquiryHeadService.selectByMainId(head.getEnquiryId());
        Map<String, SaleEnquiryHeadLp> dbSaleHeadMap = dbSaleHeads.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, s -> s, (o, n) -> o));
        for (PurchaseEbiddingSupplierLp supplier : supplierList) {
            SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleHead));
            SysUtil.setSysParam((BaseEntity)saleHead, (BaseEntity)head);
            saleHead.setId(IdWorker.getIdStr());
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(supplier.getToElsAccount());
            saleHead.setToElsAccount(supplier.getElsAccount());
            saleHead.setPurchaseName(user.getEnterpriseName());
            saleHead.setSupplierListId(supplier.getId());
            BigDecimal targetTotalAmount = "1".equals(head.getSendTargetPrice()) ? head.getTargetTotalAmount() : null;
            saleHead.setTargetTotalAmount(targetTotalAmount);
            String ebiddingStatus = "1".equals(head.getNeedEcho()) ? EbiddingLpStatusEnum.WAIT_REPLY.getValue() : EbiddingLpStatusEnum.WAIT_BIDDING.getValue();
            saleHead.setEbiddingStatus(ebiddingStatus);
            if (CollUtil.isNotEmpty(dbSaleHeadMap) && dbSaleHeadMap.containsKey(supplier.getToElsAccount())) {
                SaleEnquiryHeadLp saleEnquiryHead = dbSaleHeadMap.get(supplier.getToElsAccount());
                saleHead.setEnquiryNumber(saleEnquiryHead.getEnquiryNumber());
                saleHead.setEnquiryId(saleEnquiryHead.getId());
            }
            saleHeadList.add(saleHead);
        }
        this.saveBatch(saleHeadList, 2000);
        Map<String, String> idMap = saleHeadList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, BaseEntity::getId));
        this.saleEbiddingItemService.publish(head, itemList, idMap);
        this.saleEbiddingConfirmService.publish(head, confirmList, idMap);
        return idMap;
    }

    @Override
    public void acceptResponse(SaleEbiddingHeadLpVO webVO) {
        List<SaleEbiddingConfirmLpVO> confirmList = webVO.getSaleEbiddingConfirmList();
        SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
        saleHead.setId(webVO.getId());
        saleHead.setEbiddingStatus(CollectionUtil.isEmpty(confirmList) ? EbiddingLpStatusEnum.WAIT_BIDDING.getValue() : EbiddingLpStatusEnum.ALREADY_REPLY.getValue());
        saleHead.setTaxCode(webVO.getTaxCode());
        saleHead.setTaxRate(webVO.getTaxRate());
        ((SaleEbiddingHeadLpMapper)this.baseMapper).updateById((Object)saleHead);
        PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
        supplier.setId(webVO.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setReplyStatus(EbiddingReplyStatusEnum.HAS_REPLY.getValue());
        this.purchaseEbiddingSupplierService.updateById((Object)supplier);
        PurchaseEbiddingHeadLp dbPurchaseHead = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)webVO.getRelationId())));
        Integer replyQuantity = dbPurchaseHead.getReplyQuantity() == null ? 1 : dbPurchaseHead.getReplyQuantity() + 1;
        dbPurchaseHead.setReplyQuantity(replyQuantity);
        this.purchaseEbiddingHeadMapper.updateById((Object)dbPurchaseHead);
        if (EbiddingLpStatusEnum.WAIT_BIDDING.getValue().equals(saleHead.getEbiddingStatus())) {
            this.updatePurchaseWaiteEbidding(webVO.getRelationId());
        }
        this.saleEbiddingItemService.acceptResponse(webVO);
        this.saleEbiddingConfirmService.acceptResponse(confirmList);
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setHeadId(webVO.getId());
        sendVO.setElsAccount(webVO.getElsAccount());
        ConcurrentHashMap<String, String> toSend = new ConcurrentHashMap<String, String>();
        toSend.put(webVO.getRelationId(), webVO.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
        BeanUtils.copyProperties((Object)((Object)dbPurchaseHead), (Object)((Object)messageVO));
        messageVO.setSupplierName(SysUtil.getLoginUser().getEnterpriseName());
        String purchaseElsAccount = dbPurchaseHead.getElsAccount();
        String url = "id=" + dbPurchaseHead.getId() + "&templateNumber=" + dbPurchaseHead.getTemplateNumber() + "&=templateAccount" + dbPurchaseHead.getTemplateAccount() + "&templateVersion=" + dbPurchaseHead.getTemplateVersion();
        super.sendMsg(purchaseElsAccount, this.getReceiveElsAccountMap(purchaseElsAccount, dbPurchaseHead.getPurchasePrincipal()), (Object)messageVO, url, "ebidding", "acceptResponse");
    }

    private Map<String, List<String>> getReceiveElsAccountMap(String elsAccount, String purchasePrincipal) {
        String subAccount = StringUtils.isBlank((CharSequence)purchasePrincipal) ? "1001" : purchasePrincipal.split("_")[0];
        ArrayList<String> subAccountList = new ArrayList<String>();
        subAccountList.add(subAccount);
        HashMap<String, List<String>> receiveElsAccountMap = new HashMap<String, List<String>>();
        receiveElsAccountMap.put(elsAccount, subAccountList);
        return receiveElsAccountMap;
    }

    @Override
    public void updatePurchaseWaiteEbidding(String purchaseHeadId) {
        List<SaleEbiddingHeadLp> dbHeadList = this.getByRelationId(purchaseHeadId);
        long waiteCount = dbHeadList.stream().filter(head -> EbiddingLpStatusEnum.WAIT_BIDDING.getValue().equals(head.getEbiddingStatus())).count();
        if (waiteCount == (long)dbHeadList.size()) {
            PurchaseEbiddingHeadLp update = new PurchaseEbiddingHeadLp();
            update.setId(purchaseHeadId);
            update.setEbiddingStatus(EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
            this.purchaseEbiddingHeadMapper.updateById((Object)update);
        }
    }

    @Override
    public void refuseResponse(SaleEbiddingHeadLp dbHead) {
        dbHead.setEbiddingStatus(EbiddingLpStatusEnum.NOT_JOINING.getValue());
        ((SaleEbiddingHeadLpMapper)this.baseMapper).updateById((Object)dbHead);
        PurchaseEbiddingSupplierLp supplier = new PurchaseEbiddingSupplierLp();
        supplier.setId(dbHead.getSupplierListId());
        supplier.setReplyTime(new Date());
        supplier.setReplyStatus(EbiddingReplyStatusEnum.REJECT.getValue());
        this.purchaseEbiddingSupplierService.updateById((Object)supplier);
        PurchaseEbiddingMessageVO messageVO = new PurchaseEbiddingMessageVO();
        BeanUtils.copyProperties((Object)((Object)dbHead), (Object)((Object)messageVO));
        messageVO.setSupplierName(SysUtil.getLoginUser().getEnterpriseName());
        String purchaseElsAccount = dbHead.getToElsAccount();
        String url = "id=" + dbHead.getRelationId() + "&templateNumber=" + dbHead.getTemplateNumber() + "&=templateAccount" + dbHead.getTemplateAccount() + "&templateVersion=" + dbHead.getTemplateVersion();
        super.sendMsg(purchaseElsAccount, this.getReceiveElsAccountMap(purchaseElsAccount, dbHead.getPurchasePrincipal()), (Object)messageVO, url, "ebidding", "refuseResponse");
    }

    @Override
    public void startEbidding(PurchaseEbiddingHeadLp dbHead, List<String> itemIdList) {
        SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
        saleHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING.getValue());
        saleHead.setCurrentItemNumber(dbHead.getCurrentItemNumber());
        saleHead.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
        saleHead.setBeginTime(dbHead.getBeginTime());
        saleHead.setStartTime(dbHead.getStartTime());
        saleHead.setEndTime(dbHead.getEndTime());
        saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
        this.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.WAIT_BIDDING.getValue()));
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getRelationId, itemIdList)).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING.getValue()));
    }

    @Override
    public void endEbidding(PurchaseEbiddingHeadLp dbHead, List<String> itemIdList) {
        SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
        saleHead.setEbiddingStatus(dbHead.getEbiddingStatus());
        saleHead.setCurrentItemNumber(dbHead.getCurrentItemNumber());
        saleHead.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
        saleHead.setBeginTime(dbHead.getBeginTime());
        saleHead.setStartTime(dbHead.getStartTime());
        saleHead.setEndTime(dbHead.getEndTime());
        saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
        saleHead.setQuoteFlag(dbHead.getQuoteFlag());
        this.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getRelationId, itemIdList)).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
    }

    private BigDecimal getPrice(String ebiddingType, String ebiddingWay, String quoteType, List<PurchaseEbiddingItemLp> purchaseItemList) {
        BigDecimal resultPrice = null;
        if (EbiddingWayEnum.SINGLE.getValue().equals(ebiddingWay)) {
            if (LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
                for (PurchaseEbiddingItemLp item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                    resultPrice = price;
                }
            } else {
                for (PurchaseEbiddingItemLp item : purchaseItemList) {
                    BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getPrice() : item.getNetPrice();
                    if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                    resultPrice = price;
                }
            }
        } else if (LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(ebiddingType)) {
            for (PurchaseEbiddingItemLp item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) <= 0) continue;
                resultPrice = price;
            }
        } else {
            for (PurchaseEbiddingItemLp item : purchaseItemList) {
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(quoteType) ? item.getTotalAmount() : item.getNetTotalAmount();
                if (price == null || resultPrice != null && price.compareTo(resultPrice) >= 0) continue;
                resultPrice = price;
            }
        }
        return resultPrice;
    }

    private void checkStartPrice(SaleEbiddingHeadLp dbHead, String ebiddingType, BigDecimal startPrice, BigDecimal webPrice) {
        boolean flag;
        if (LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(ebiddingType) && "1".equals(dbHead.getSetStartPrice())) {
            flag = startPrice == null || startPrice.compareTo(BigDecimal.ZERO) == 0 || startPrice.compareTo(webPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_idOuWsulTfUEUAAu_dc6d22a8", (String)"\u6b63\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
        }
        if (LpEbiddingTypeHisEnum.REVERSE_BID.getValue().equals(ebiddingType) && "1".equals(dbHead.getSetStartPrice())) {
            flag = startPrice == null || startPrice.compareTo(BigDecimal.ZERO) == 0 || startPrice.compareTo(webPrice) >= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_vdOuWsulTXUEUAAu_53224de6", (String)"\u53cd\u5411\u7ade\u4ef7\uff0c\u62a5\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u8d77\u62cd\u4ef7"));
        }
    }

    private void checkQuote(SaleEbiddingHeadLp dbSaleHead, List<SaleEbiddingItemLp> quoteList, Map<String, SaleEbiddingItemLp> dbItemMap, Date currentTime, PurchaseEbiddingSupplierLp supplier, Map<String, List<PurchaseEbiddingItemLp>> purchaseMap) {
        BigDecimal dbPrice;
        BigDecimal webPrice;
        String supplierShow;
        Assert.isTrue((boolean)dbSaleHead.getEndTime().after(currentTime), (String)I18nUtil.translate((String)"i18n_alert_OuyWKIIuWxOsuW_f1045134", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u62a5\u4ef7\uff01"));
        Assert.isTrue((boolean)EbiddingLpStatusEnum.BIDDING.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjOuszEnqsu_10a99734", (String)"\u53ea\u6709\u7ade\u4ef7\u4e2d\u72b6\u6001\u624d\u53ef\u62a5\u4ef7"));
        if ("1".equals(dbSaleHead.getNeedEcho())) {
            Assert.isTrue((boolean)EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus()), (String)I18nUtil.translate((String)"i18n_alert_dBSnqsu_7140f4af", (String)"\u5e94\u6807\u540e\u624d\u53ef\u62a5\u4ef7"));
        }
        for (SaleEbiddingItemLp quoteItem : quoteList) {
            if (quoteItem.getExpiryDate() == null || quoteItem.getEffectiveDate() == null || !quoteItem.getEffectiveDate().after(quoteItem.getExpiryDate())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOfUKXBAW_70448216", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff01"));
        }
        String ebiddingType = dbSaleHead.getEbiddingType();
        String string = supplierShow = dbSaleHead.getSupplierShow() == null ? "" : dbSaleHead.getSupplierShow();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            Assert.isTrue((boolean)quoteItem.getItemNumber().equals(dbSaleHead.getCurrentItemNumber()), (String)I18nUtil.translate((String)"i18n_alert_rSLxqsu_4c371469", (String)"\u8be5\u7269\u6599\u4e0d\u53ef\u62a5\u4ef7"));
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getPrice() : quoteItem.getNetPrice();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            this.checkStartPrice(dbSaleHead, ebiddingType, currentItem.getStartPrice(), webPrice);
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.SINGLE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get(quoteItem.getItemNumber())) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getPrice() : currentItem.getNetPrice());
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get("1");
            webPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getTotalAmount() : quoteItem.getNetTotalAmount();
            Assert.notNull((Object)webPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            this.checkStartPrice(dbSaleHead, ebiddingType, dbSaleHead.getStartTotalAmount(), webPrice);
            dbPrice = supplierShow.contains(EbiddingShowEnum.PRICE.getValue()) ? this.getPrice(ebiddingType, EbiddingWayEnum.PACKAGE.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1")) : (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getTotalAmount() : currentItem.getNetTotalAmount());
        } else {
            SaleEbiddingItemLp currentItem = dbItemMap.get("1");
            BigDecimal quotePrice = BigDecimal.ZERO;
            for (SaleEbiddingItemLp quoteItem : quoteList) {
                BigDecimal itemPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? quoteItem.getPrice() : quoteItem.getNetPrice();
                Assert.notNull((Object)itemPrice, (String)I18nUtil.translate((String)"i18n_alert_suxOLV_d2a77c02", (String)"\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
                BigDecimal requireQuantity = quoteItem.getRequireQuantity() == null ? BigDecimal.ONE : quoteItem.getRequireQuantity();
                quotePrice = quotePrice.add(itemPrice.multiply(requireQuantity));
            }
            webPrice = quotePrice;
            this.checkStartPrice(dbSaleHead, ebiddingType, dbSaleHead.getStartTotalAmount(), webPrice);
            if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue())) {
                dbPrice = this.getPrice(ebiddingType, EbiddingWayEnum.BATCH.getValue(), dbSaleHead.getQuoteType(), purchaseMap.get("1"));
            } else {
                BigDecimal bigDecimal = dbPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType()) ? currentItem.getTotalAmount() : currentItem.getNetTotalAmount();
            }
        }
        if (dbPrice != null) {
            BigDecimal changeRange = dbSaleHead.getChangeRange();
            String rangeUnit = dbSaleHead.getRangeUnit();
            if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                changeRange = dbPrice.multiply(changeRange.divide(BigDecimal.valueOf(100L), 6, 4));
            }
            boolean flag = LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRange).compareTo(dbPrice) >= 0 : webPrice.add(changeRange).compareTo(dbPrice) <= 0;
            Assert.isTrue((boolean)flag, (String)I18nUtil.translate((String)"i18n_alert_APsuxBnOuBzWVVVsuW_6e488384", (String)"\u5f53\u524d\u62a5\u4ef7\u4e0d\u7b26\u5408\u7ade\u4ef7\u5e45\u5ea6\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            BigDecimal changeRangeUpper = dbSaleHead.getChangeRangeUpper();
            if (changeRangeUpper != null && changeRangeUpper.compareTo(BigDecimal.ZERO) != 0) {
                if (EbiddingRangeUnitEnum.PERCENT.getValue().equals(rangeUnit)) {
                    changeRangeUpper = dbPrice.multiply(changeRangeUpper.divide(BigDecimal.valueOf(100L), 6, 4));
                }
                boolean upperFlag = LpEbiddingTypeHisEnum.FORWARD_BID.getValue().equals(ebiddingType) ? webPrice.subtract(changeRangeUpper).compareTo(dbPrice) < 0 : webPrice.add(changeRangeUpper).compareTo(dbPrice) > 0;
                Assert.isTrue((boolean)upperFlag, (String)I18nUtil.translate((String)"i18n_alert_APsuBRBzXWWVVVsuW_d9dc1bcc", (String)"\u5f53\u524d\u62a5\u4ef7\u8d85\u8fc7\u5e45\u5ea6\u4e0a\u9650\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\uff01"));
            }
        }
    }

    private void checkQuoteRange(SaleEbiddingHeadLp dbSaleHead, SaleEbiddingItemLp quoteItem, SaleEbiddingItemLp dbItem, Date currentTime, PurchaseEbiddingSupplierLp supplier) {
        boolean isGreaterThanLastEbiddingRange;
        Assert.isTrue((boolean)EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay()), (String)"\u7ade\u4ef7\u65b9\u5f0f\u4e0d\u662f\u6253\u5305\u7ade\u4ef7");
        Assert.isTrue((boolean)dbSaleHead.getEndTime().after(currentTime), (String)I18nUtil.translate((String)"i18n_alert_OuyWKIIuWxOsuW_f1045134", (String)"\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u5df2\u5230\uff0c\u4e0d\u80fd\u62a5\u4ef7\uff01"));
        Assert.isTrue((boolean)EbiddingLpStatusEnum.BIDDING.getValue().equals(dbSaleHead.getEbiddingStatus()), (String)I18nUtil.translate((String)"i18n_alert_RjOuszEnqsu_10a99734", (String)"\u53ea\u6709\u7ade\u4ef7\u4e2d\u72b6\u6001\u624d\u53ef\u62a5\u4ef7"));
        if ("1".equals(dbSaleHead.getNeedEcho())) {
            Assert.isTrue((boolean)EbiddingReplyStatusEnum.HAS_REPLY.getValue().equals(supplier.getReplyStatus()), (String)I18nUtil.translate((String)"i18n_alert_dBSnqsu_7140f4af", (String)"\u5e94\u6807\u540e\u624d\u53ef\u62a5\u4ef7"));
        }
        if (quoteItem.getExpiryDate() != null && quoteItem.getEffectiveDate() != null && quoteItem.getEffectiveDate().after(quoteItem.getExpiryDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bXBAxOfUKXBAW_70448216", (String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\uff01"));
        }
        BigDecimal lastEbiddingRange = (BigDecimal)ObjectUtil.defaultIfNull((Object)dbItem.getEbiddingRange(), (Object)BigDecimal.ZERO);
        BigDecimal currentEbiddingRange = quoteItem.getEbiddingRange();
        boolean isDivisibleByZeroPointFive = currentEbiddingRange.multiply(new BigDecimal(10)).divideAndRemainder(new BigDecimal(5))[1].compareTo(BigDecimal.ZERO) == 0;
        boolean bl = isGreaterThanLastEbiddingRange = currentEbiddingRange.compareTo(lastEbiddingRange) > 0;
        if (!isDivisibleByZeroPointFive || !isGreaterThanLastEbiddingRange) {
            throw new ELSBootException("\u6807\u7684\u3010" + dbItem.getSubjectName() + "\u3011\u5f53\u524d\u62a5\u7684\u5e45\u5ea6\u3010" + currentEbiddingRange + "\u3011\u4e0d\u80fd\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6: 1.\u62a5\u7684\u5e45\u5ea6\u9700\u8981\u662f0.5\u7684\u500d\u6570; 2.\u5f53\u524d\u62a5\u7684\u5e45\u5ea6\u9700\u8981\u5927\u4e8e\u4e0a\u4e00\u6b21\u7684\u62a5\u4ef7\u5e45\u5ea6\u3010" + lastEbiddingRange.setScale(2, 4) + "\u3011;");
        }
    }

    private void autoDelay(SaleEbiddingHeadLp dbSaleHead) {
        String endTimeStr = DateUtil.formatDateTime((Date)dbSaleHead.getEndTime());
        if (!this.redis.tryGetDistributedLock(dbSaleHead.getRelationId(), endTimeStr, 600000L)) {
            return;
        }
        int delayMinute = dbSaleHead.getDelayMinute() == null ? 1 : dbSaleHead.getDelayMinute();
        DateTime endTime = DateUtil.offsetMinute((Date)dbSaleHead.getEndTime(), (int)delayMinute);
        SaleEbiddingHeadLp updateSaleHead = new SaleEbiddingHeadLp();
        updateSaleHead.setEndTime((Date)endTime);
        int currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
        updateSaleHead.setCurrentDelayCount(currentDelayCount + 1);
        ((SaleEbiddingHeadLpMapper)this.baseMapper).update((Object)updateSaleHead, (Wrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbSaleHead.getRelationId()));
        PurchaseEbiddingHeadLp purchaseHead = new PurchaseEbiddingHeadLp();
        purchaseHead.setId(dbSaleHead.getRelationId());
        purchaseHead.setEndTime((Date)endTime);
        purchaseHead.setCurrentDelayCount(updateSaleHead.getCurrentDelayCount());
        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
        LpEbiddingJobUtil.updateEndJob(dbSaleHead, (Date)endTime);
    }

    private void checkDelay(SaleEbiddingHeadLp dbSaleHead, Date currentTime) {
        String delayRule = dbSaleHead.getDelayRule();
        if (!EbiddingDelayRuleEnum.NOT_ALLOW_DELAY.getValue().equals(delayRule)) {
            int beforeEndMinute = dbSaleHead.getBeforeEndMinute() == null ? 1 : dbSaleHead.getBeforeEndMinute();
            Date endTime = dbSaleHead.getEndTime();
            DateTime checkDate = DateUtil.offsetMinute((Date)currentTime, (int)beforeEndMinute);
            if (checkDate.compareTo(endTime) > 0) {
                if (EbiddingDelayRuleEnum.LIMIT_DELAY_COUNT.getValue().equals(delayRule)) {
                    int currentDelayCount;
                    int delayCount = dbSaleHead.getDelayCount() == null ? 1 : dbSaleHead.getDelayCount();
                    int n = currentDelayCount = dbSaleHead.getCurrentDelayCount() == null ? 0 : dbSaleHead.getCurrentDelayCount();
                    if (delayCount > currentDelayCount) {
                        this.autoDelay(dbSaleHead);
                    }
                } else {
                    this.autoDelay(dbSaleHead);
                }
            }
        }
    }

    private void compute(SaleEbiddingHeadLp dbSaleHead, List<SaleEbiddingItemLp> quoteList, Map<String, SaleEbiddingItemLp> dbItemMap, Date currentTime) {
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            BigDecimal requireQuantity;
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            BigDecimal bigDecimal = requireQuantity = currentItem.getRequireQuantity() == null ? BigDecimal.ONE : currentItem.getRequireQuantity();
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                BigDecimal price = quoteItem.getPrice();
                BigDecimal netPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem.getTaxRate(), price);
                quoteItem.setNetPrice(netPrice);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            } else {
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem.getTaxRate(), netPrice);
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
            }
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            quoteItem = quoteList.get(0);
            currentItem = dbItemMap.get(quoteItem.getItemNumber());
            if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                BigDecimal totalAmount = quoteItem.getTotalAmount();
                BigDecimal netTotalAmount = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem.getTaxRate(), totalAmount);
                quoteItem.setNetTotalAmount(netTotalAmount);
            } else {
                BigDecimal netTotalAmount = quoteItem.getNetTotalAmount();
                BigDecimal totalAmount = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem.getTaxRate(), netTotalAmount);
                quoteItem.setTotalAmount(totalAmount);
            }
        } else {
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal netTotalAmount = BigDecimal.ZERO;
            for (SaleEbiddingItemLp quoteItem : quoteList) {
                BigDecimal requireQuantity;
                SaleEbiddingItemLp currentItem = dbItemMap.get(quoteItem.getItemNumber());
                BigDecimal bigDecimal = requireQuantity = currentItem.getRequireQuantity() == null ? BigDecimal.ONE : currentItem.getRequireQuantity();
                if (EbiddingQuoteTypeEnum.TAX_INCLUDING.getValue().equals(dbSaleHead.getQuoteType())) {
                    BigDecimal price = quoteItem.getPrice();
                    BigDecimal netPrice = EbiddingQuoteTypeEnum.TAX_INCLUDING.computeOtherPrice(currentItem.getTaxRate(), price);
                    quoteItem.setNetPrice(netPrice);
                    quoteItem.setTaxAmount(price.multiply(requireQuantity));
                    totalAmount = totalAmount.add(quoteItem.getTaxAmount());
                    quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                    netTotalAmount = netTotalAmount.add(quoteItem.getNetAmount());
                    continue;
                }
                BigDecimal netPrice = quoteItem.getNetPrice();
                BigDecimal price = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(currentItem.getTaxRate(), netPrice);
                quoteItem.setPrice(price);
                quoteItem.setTaxAmount(price.multiply(requireQuantity));
                totalAmount = totalAmount.add(quoteItem.getTaxAmount());
                quoteItem.setNetAmount(netPrice.multiply(requireQuantity));
                netTotalAmount = netTotalAmount.add(quoteItem.getNetAmount());
            }
            for (SaleEbiddingItemLp quoteItem : quoteList) {
                quoteItem.setTotalAmount(totalAmount);
                quoteItem.setNetTotalAmount(netTotalAmount);
            }
        }
        for (SaleEbiddingItemLp quoteItem : quoteList) {
            SaleEbiddingItemLp currentItem = dbItemMap.get(quoteItem.getItemNumber());
            quoteItem.setHeadId(dbSaleHead.getId());
            quoteItem.setQuoteTime(currentTime);
            quoteItem.setQuoteCount(currentItem.getQuoteCount() == null ? 1 : currentItem.getQuoteCount() + 1);
            quoteItem.setQuoteIp(IPUtils.getIpAddr());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void quotePrice(SaleEbiddingHeadLpVO saleHeadVO) {
        Date currentTime = new Date();
        SaleEbiddingHeadLp dbSaleHead = (SaleEbiddingHeadLp)((Object)((SaleEbiddingHeadLpMapper)this.baseMapper).selectById((Serializable)((Object)saleHeadVO.getId())));
        List<SaleEbiddingItemLp> quoteList = saleHeadVO.getSaleEbiddingItemList();
        Map<String, SaleEbiddingItemLp> dbItemMap = this.saleEbiddingItemService.selectByMainId(saleHeadVO.getId()).stream().collect(Collectors.toMap(SaleEbiddingItemLp::getItemNumber, Function.identity(), (newVal, oldVal) -> oldVal));
        PurchaseEbiddingSupplierLp supplier = (PurchaseEbiddingSupplierLp)((Object)this.purchaseEbiddingSupplierService.getById((Serializable)((Object)dbSaleHead.getSupplierListId())));
        Map<String, List<PurchaseEbiddingItemLp>> purchaseMap = this.purchaseEbiddingItemMapper.selectByMainId(dbSaleHead.getRelationId()).stream().collect(Collectors.groupingBy(PurchaseEbiddingItemLp::getItemNumber));
        this.checkQuote(dbSaleHead, quoteList, dbItemMap, currentTime, supplier, purchaseMap);
        this.checkDelay(dbSaleHead, currentTime);
        this.compute(dbSaleHead, quoteList, dbItemMap, currentTime);
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItemLp quoteItem = quoteList.get(0);
            quoteItem.setItemStatus(null);
            int count = this.saleEbiddingItemMapper.updateById((Object)quoteItem);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539"));
            PurchaseEbiddingItemLp purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            purchaseItem.setItemStatus(null);
            this.purchaseEbiddingItemMapper.updateById((Object)purchaseItem);
        } else if (EbiddingWayEnum.PACKAGE.getValue().equals(dbSaleHead.getEbiddingWay())) {
            SaleEbiddingItemLp quoteItem = quoteList.get(0);
            this.saleEbiddingItemMapper.quotePriceByHeadId(quoteItem);
            PurchaseEbiddingItemLp purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        } else {
            ArrayList<PurchaseEbiddingItemLp> purchaseList = new ArrayList<PurchaseEbiddingItemLp>();
            for (SaleEbiddingItemLp quoteItem : quoteList) {
                PurchaseEbiddingItemLp purchaseItem = this.getPurchaseItemByQuote(dbSaleHead, quoteItem);
                purchaseList.add(purchaseItem);
                quoteItem.setItemStatus(null);
                purchaseItem.setItemStatus(null);
            }
            this.saleEbiddingItemService.updateBatchById(quoteList);
            this.purchaseEbiddingItemService.updateBatchById(purchaseList);
        }
        this.saleEbiddingItemHisService.save(dbSaleHead, quoteList, supplier);
        this.redis.publish("quote-price-topic", (Object)dbSaleHead.getRelationId());
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void quoteRange(List<SaleEbiddingItemLp> quoteItems) {
        quoteItems.forEach(quoteItem -> {
            Assert.notNull((Object)quoteItem.getEbiddingRange(), (String)"\u62a5\u4ef7\u5e45\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isTrue((quoteItem.getEbiddingRange().compareTo(new BigDecimal("100")) <= 0 ? 1 : 0) != 0, (String)"\u62a5\u4ef7\u5e45\u5ea6\u4e0d\u80fd\u5927\u4e8e100");
            Assert.isTrue((quoteItem.getEbiddingRange().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u62a5\u4ef7\u5e45\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        });
        Date currentTime = new Date();
        List<String> headIds = quoteItems.stream().map(SaleEbiddingItemLp::getHeadId).collect(Collectors.toList());
        List dbSaleHeads = this.listByIds(headIds);
        if (CollUtil.isEmpty((Collection)dbSaleHeads)) {
            throw new ELSBootException("\u7ade\u4ef7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.redis.tryGetDistributedLock(EBIDDING_QUOTE_RANGE_KEY, ((SaleEbiddingHeadLp)((Object)dbSaleHeads.get(0))).getElsAccount(), 3600000L)) {
            throw new ELSBootException("\u7cfb\u7edf\u6b63\u5728\u5904\u7406\u62a5\u4ef7\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        try {
            Map<String, SaleEbiddingHeadLp> dbSaleHeadMap = dbSaleHeads.stream().collect(Collectors.toMap(BaseEntity::getId, s -> s, (o, n) -> n));
            List<SaleEbiddingItemLp> dbSaleItems = ((LambdaQueryChainWrapper)this.saleEbiddingItemService.lambdaQuery().in(SaleEbiddingItemLp::getHeadId, headIds)).list();
            Map<String, SaleEbiddingItemLp> dbSaleItemMap = dbSaleItems.stream().collect(Collectors.toMap(SaleEbiddingItemLp::getHeadId, s -> s, (o, n) -> n));
            if (CollUtil.isEmpty((Collection)dbSaleItems)) {
                throw new ELSBootException("\u7ade\u4ef7\u884c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List itemIds = dbSaleItems.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Map<String, List<SaleEbiddingItemHisLp>> dbItemHisMap = ((LambdaQueryChainWrapper)this.saleEbiddingItemHisService.lambdaQuery().in(SaleEbiddingItemHisLp::getItemId, itemIds)).list().stream().collect(Collectors.groupingBy(SaleEbiddingItemHisLp::getItemId));
            List supplierListIds = dbSaleHeads.stream().map(SaleEbiddingHeadLp::getSupplierListId).collect(Collectors.toList());
            Map<String, PurchaseEbiddingSupplierLp> supplierMap = this.purchaseEbiddingSupplierService.listByIds(supplierListIds).stream().collect(Collectors.toMap(PurchaseEbiddingSupplierLp::getHeadId, s -> s, (o, n) -> n));
            ArrayList<PurchaseEbiddingItemLp> updatePurchaseItems = new ArrayList<PurchaseEbiddingItemLp>();
            quoteItems.forEach(quoteItem -> {
                BigDecimal ebiddingRange = quoteItem.getEbiddingRange();
                SaleEbiddingHeadLp dbSaleHead = (SaleEbiddingHeadLp)((Object)((Object)dbSaleHeadMap.get(quoteItem.getHeadId())));
                SaleEbiddingItemLp dbSaleItem = (SaleEbiddingItemLp)((Object)((Object)dbSaleItemMap.get(quoteItem.getHeadId())));
                PurchaseEbiddingSupplierLp supplier = (PurchaseEbiddingSupplierLp)((Object)((Object)supplierMap.get(dbSaleHead.getRelationId())));
                BeanUtils.copyProperties((Object)((Object)dbSaleItem), (Object)quoteItem);
                quoteItem.setEbiddingRange(ebiddingRange);
                quoteItem.setQuoteTime(currentTime);
                if (CollUtil.isNotEmpty((Map)dbItemHisMap) && dbItemHisMap.containsKey(quoteItem.getId())) {
                    Integer maxQuoteCount = ((List)dbItemHisMap.get(quoteItem.getId())).stream().map(SaleEbiddingItemHisLp::getQuoteCount).max(Comparator.comparingInt(c -> c)).orElse(0);
                    quoteItem.setQuoteCount(maxQuoteCount + 1);
                } else {
                    quoteItem.setQuoteCount(1);
                }
                this.checkQuoteRange(dbSaleHead, (SaleEbiddingItemLp)((Object)quoteItem), dbSaleItem, currentTime, supplier);
                this.checkDelay(dbSaleHead, currentTime);
                BigDecimal netTotalAmount = dbSaleItem.getStandardPrice().multiply(BigDecimal.ONE.subtract(quoteItem.getEbiddingRange().multiply(new BigDecimal("0.01"))));
                BigDecimal totalAmount = EbiddingQuoteTypeEnum.TAX_EXCLUDING.computeOtherPrice(dbSaleItem.getTaxRate(), netTotalAmount);
                netTotalAmount = netTotalAmount.setScale(2, RoundingMode.HALF_UP);
                totalAmount = totalAmount.setScale(2, RoundingMode.HALF_UP);
                quoteItem.setNetTotalAmount(netTotalAmount);
                quoteItem.setTotalAmount(totalAmount);
                updatePurchaseItems.add(this.getPurchaseItemByQuote(dbSaleHead, (SaleEbiddingItemLp)((Object)quoteItem)));
            });
            this.saleEbiddingItemMapper.batchQuotePriceById(quoteItems);
            this.purchaseEbiddingItemMapper.batchQuotePriceById(updatePurchaseItems);
            this.saleEbiddingItemHisService.save(dbSaleHeadMap, quoteItems, supplierMap);
            dbSaleItems = this.saleEbiddingItemService.selectWithoutElsAccountByHeadId(headIds);
            this.generateNbeLineDifferenceHead(dbSaleItems);
            List<String> relationIds = dbSaleHeads.stream().map(SaleEbiddingHeadLp::getRelationId).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select(new String[]{"DISTINCT to_els_account"});
            queryWrapper.in((Object)"head_id", relationIds);
            List<PurchaseEbiddingSupplierLp> otherSuppliers = ((PurchaseEbiddingSupplierLpService)SpringContextUtils.getBean(PurchaseEbiddingSupplierLpService.class)).selectWithoutElsAccountByHeadIds(relationIds);
            List<String> toElsAccounts = otherSuppliers.stream().map(PurchaseEbiddingSupplierLp::getToElsAccount).collect(Collectors.toList());
            toElsAccounts.forEach(toElsAccount -> this.redis.publish("quote-price-topic", toElsAccount));
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redis.releaseDistributedLock(EBIDDING_QUOTE_RANGE_KEY, ((SaleEbiddingHeadLp)((Object)dbSaleHeads.get(0))).getElsAccount());
        }
    }

    private void generateNbeLineDifferenceHead(List<SaleEbiddingItemLp> saleItems) {
        LineDifferenceHeadService lineDifferenceHeadService = (LineDifferenceHeadService)SpringContextUtils.getBean(LineDifferenceHeadService.class);
        List saleHeadIds = saleItems.stream().map(SaleEbiddingItemLp::getHeadId).collect(Collectors.toList());
        Map<String, LineDifferenceHead> dbDifferenceHeadMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)lineDifferenceHeadService.lambdaQuery().eq(LineDifferenceHead::getSourceType, (Object)LineSourceTypeEnum.EBIDDING_SOURCE.getValue())).in(LineDifferenceHead::getSourceId, saleHeadIds)).list().stream().collect(Collectors.toMap(LineDifferenceHead::getSourceId, n -> n, (o, n) -> n));
        ArrayList differenceHeads = new ArrayList(saleItems.size());
        SupplierMasterDataDTO supplierMasterDataDTO = this.inquiryInvokeSupplierRpcService.getByAccount(saleItems.get(0).getToElsAccount(), saleItems.get(0).getElsAccount());
        saleItems.forEach(saleItem -> {
            LineDifferenceHead differenceHead = new LineDifferenceHead();
            if (supplierMasterDataDTO != null && !ObjectUtils.isEmpty((Object)supplierMasterDataDTO.getSupplierName())) {
                differenceHead.setSupplierName(supplierMasterDataDTO.getSupplierName());
            } else {
                differenceHead.setSupplierName(saleItem.getSupplierName());
            }
            differenceHead.setElsAccount(saleItem.getToElsAccount());
            differenceHead.setSourceId(saleItem.getHeadId());
            differenceHead.setSourceNumber(saleItem.getEbiddingNumber());
            differenceHead.setSourceType(LineSourceTypeEnum.EBIDDING_SOURCE.getValue());
            differenceHead.setToElsAccount(saleItem.getElsAccount());
            differenceHead.setSubjectNumber(saleItem.getSubjectNumber());
            differenceHead.setSubjectName(saleItem.getSubjectName());
            differenceHead.setSubjectFileHeadId(saleItem.getSubjectFileHeadId());
            differenceHead.setTransportType(saleItem.getSubjectType());
            differenceHead.setSubjectYear(saleItem.getSubjectYear());
            differenceHead.setTotalNetAmount(saleItem.getNetTotalAmount().setScale(2, RoundingMode.HALF_UP));
            if (CollUtil.isNotEmpty((Map)dbDifferenceHeadMap) && dbDifferenceHeadMap.containsKey(saleItem.getHeadId())) {
                differenceHead.setId(((LineDifferenceHead)((Object)((Object)dbDifferenceHeadMap.get(saleItem.getHeadId())))).getId());
            }
            differenceHeads.add(differenceHead);
        });
        lineDifferenceHeadService.saveOrUpdateBatch(differenceHeads);
    }

    private PurchaseEbiddingItemLp getPurchaseItemByQuote(SaleEbiddingHeadLp dbSaleHead, SaleEbiddingItemLp quoteItem) {
        PurchaseEbiddingItemLp purchaseItem = new PurchaseEbiddingItemLp();
        BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)purchaseItem));
        purchaseItem.setId(quoteItem.getRelationId());
        purchaseItem.setHeadId(dbSaleHead.getRelationId());
        purchaseItem.setRelationId(quoteItem.getId());
        purchaseItem.setToElsAccount(dbSaleHead.getElsAccount());
        purchaseItem.setElsAccount(dbSaleHead.getToElsAccount());
        return purchaseItem;
    }

    @Override
    public void priced(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> purchaseItemList, List<PurchaseEbiddingSupplierLp> supplierList) {
        ArrayList<SaleEbiddingItemLp> saleItemList = new ArrayList<SaleEbiddingItemLp>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItemLp item : purchaseItemList) {
                saleItem = new SaleEbiddingItemLp();
                saleItem.setId(item.getRelationId());
                saleItem.setItemStatus(item.getItemStatus());
                saleItem.setQuota(item.getQuota());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemService.updateBatchById(saleItemList);
        } else {
            for (PurchaseEbiddingItemLp item : purchaseItemList) {
                saleItem = new SaleEbiddingItemLp();
                saleItem.setEbiddingNumber(dbHead.getEbiddingNumber());
                saleItem.setElsAccount(item.getToElsAccount());
                saleItem.setToElsAccount(item.getElsAccount());
                saleItem.setCurrentRound(item.getCurrentRound());
                saleItem.setQuota(item.getQuota());
                saleItem.setItemStatus(item.getItemStatus());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemMapper.updateBidResultByNumber(saleItemList);
        }
        ArrayList<SaleEbiddingHeadLp> updateHeadList = new ArrayList<SaleEbiddingHeadLp>();
        for (PurchaseEbiddingSupplierLp supplier : supplierList) {
            SaleEbiddingHeadLp head = new SaleEbiddingHeadLp();
            head.setRelationId(dbHead.getId());
            head.setElsAccount(supplier.getToElsAccount());
            head.setEbiddingStatus(supplier.getBiddingStatus());
            updateHeadList.add(head);
        }
        ((SaleEbiddingHeadLpMapper)this.baseMapper).updateBidResultByRelationId(updateHeadList);
    }

    @Override
    public void pricedByHis(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemHisLp> purchaseItemList, List<PurchaseEbiddingSupplierLp> supplierList) {
        ArrayList<SaleEbiddingItemHisLp> saleItemList = new ArrayList<SaleEbiddingItemHisLp>();
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            for (PurchaseEbiddingItemHisLp item : purchaseItemList) {
                saleItem = new SaleEbiddingItemHisLp();
                saleItem.setId(item.getRelationId());
                saleItem.setItemStatus(item.getItemStatus());
                saleItem.setQuota(item.getQuota());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemHisService.updateBatchById(saleItemList);
        } else {
            for (PurchaseEbiddingItemHisLp item : purchaseItemList) {
                saleItem = new SaleEbiddingItemHisLp();
                saleItem.setEbiddingNumber(dbHead.getEbiddingNumber());
                saleItem.setElsAccount(item.getToElsAccount());
                saleItem.setToElsAccount(item.getElsAccount());
                saleItem.setCurrentRound(item.getCurrentRound());
                saleItem.setQuota(item.getQuota());
                saleItem.setItemStatus(item.getItemStatus());
                saleItemList.add(saleItem);
            }
            this.saleEbiddingItemHisService.updateBidResultByNumber(saleItemList);
        }
        ArrayList<SaleEbiddingHeadLp> updateHeadList = new ArrayList<SaleEbiddingHeadLp>();
        for (PurchaseEbiddingSupplierLp supplier : supplierList) {
            SaleEbiddingHeadLp head = new SaleEbiddingHeadLp();
            head.setRelationId(dbHead.getId());
            head.setElsAccount(supplier.getToElsAccount());
            head.setEbiddingStatus(supplier.getBiddingStatus());
            updateHeadList.add(head);
        }
        ((SaleEbiddingHeadLpMapper)this.baseMapper).updateBidResultByRelationId(updateHeadList);
    }

    @Override
    public void regret(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> itemList) {
        List<SaleEbiddingHeadLp> dbHeadList = ((SaleEbiddingHeadLpMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbHeadList.forEach(head -> head.setEbiddingStatus(EbiddingLpStatusEnum.REGRET.getValue()));
        this.updateBatchById(dbHeadList);
        List headIdList = dbHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getHeadId, headIdList)).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.REGRET.getValue()));
    }

    @Override
    public void failed(PurchaseEbiddingHeadLp dbHead) {
        List<SaleEbiddingHeadLp> dbHeadList = ((SaleEbiddingHeadLpMapper)this.baseMapper).selectByMainId(dbHead.getId());
        dbHeadList.forEach(head -> head.setEbiddingStatus(EbiddingLpStatusEnum.BID_FAILED.getValue()));
        this.updateBatchById(dbHeadList);
    }

    @Override
    @SrmTransaction
    public void quoteAccept(SaleEbiddingHeadLp dbHead, SaleEbiddingItemHisLp dbItemHis, SaleEbiddingItemLp quoteItem, BigDecimal acceptPrice) {
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            if (quoteItem.getRemainingQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bUeBWRL0xqsu_bb4735b8", (String)"\u5269\u4f59\u6295\u6807\u6570\u91cf\u4e3a0\uff0c\u4e0d\u53ef\u62a5\u4ef7\uff01"));
            }
            if (quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) < 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_suWRfUbUeBWRVVVHcsu_2caea7b7", (String)"\u62a5\u4ef7\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u6295\u6807\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u62a5\u4ef7\uff01"));
            }
            boolean hasNextQuote = quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) != 0;
            List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<SaleEbiddingItemLp> saleEbiddingItemList = EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()) ? this.saleEbiddingItemService.selectWithoutElsAccountByHeadId(headIdList).stream().filter(i -> dbHead.getCurrentItemNumber().equals(i.getItemNumber())).collect(Collectors.toList()) : this.saleEbiddingItemService.selectWithoutElsAccountByHeadId(headIdList);
            List<String> itemIdList = saleEbiddingItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<PurchaseEbiddingItemLp> purchaseEbiddingItemList = this.purchaseEbiddingItemService.selectWithoutElsAccountByRelationId(itemIdList);
            if (purchaseEbiddingItemList == null || purchaseEbiddingItemList.size() == 0) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMxuIdjnRXjOucVH_c0e7408b", (String)"\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u5546\u7684\u7ade\u4ef7\u884c\u4fe1\u606f\uff01"));
            }
            this.processDataStatus(dbHead, dbItemHis, quoteItem, true);
            this.calculateRemainingQuantity(dbHead, quoteItem, headIdList);
            BigDecimal purchaseBidNumber = purchaseEbiddingItemList.get(0).getBidNumber();
            this.calculateBidNumber(dbHead, quoteItem, headIdList, purchaseEbiddingItemList, purchaseBidNumber);
            if (quoteItem.getBidNumber().compareTo(purchaseBidNumber) > 0) {
                this.srmPoolExecutor.execute(() -> this.updateQuoteSaleBidNumber(dbHead, purchaseBidNumber));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RdXeBWR0fUnRXjeBWR1VVVHcsu_32df13af", (String)"\u4f9b\u5e94\u5546\u6295\u6807\u6570\u91cf${0}\u5927\u4e8e\u91c7\u8d2d\u5546\u7684\u6295\u6807\u6570\u91cf${1}\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u62a5\u4ef7\uff01", (String[])new String[]{String.valueOf(quoteItem.getBidNumber()), String.valueOf(purchaseBidNumber)}));
            }
            if (quoteItem.getBidNumber().compareTo(purchaseBidNumber) == 0) {
                if (hasNextQuote) {
                    this.updateEbiddingHisItemNotAccept(dbHead);
                    this.dutchHasNextQuote(dbHead);
                } else {
                    this.endEbiddingByDutch(dbHead, headIdList);
                }
            } else {
                this.dutchHasNextQuoteByAccept(dbHead);
            }
            this.updateQuoteSaleBidNumber(dbHead, purchaseBidNumber.subtract(quoteItem.getBidNumber()));
            SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
            saleHead.setHasQuote("1");
            ((SaleEbiddingHeadLpMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
            PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
            head.setId(dbHead.getRelationId());
            head.setHasQuote("1");
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
        } else {
            this.processDataStatus(dbHead, dbItemHis, quoteItem, true);
            List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (LpEbiddingTypeHisEnum.REVERSE_BID.getValue().equals(dbHead.getEbiddingType()) && acceptPrice.compareTo(BigDecimal.ZERO) <= 0) {
                this.endEbiddingByJapan(dbHead, quoteItem, headIdList);
            } else if ("1".equals(dbHead.getPurchaseAutoQuote()) && acceptPrice.compareTo(BigDecimal.ZERO) > 0) {
                this.autoQuotePrice(dbHead.getRelationId(), quoteItem.getRelationId());
            }
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getRelationId());
    }

    private void updateQuoteSaleBidNumber(SaleEbiddingHeadLp dbHead, BigDecimal purchaseBidNumber) {
        SaleEbiddingItemHisLpService saleEbiddingItemHisService = (SaleEbiddingItemHisLpService)SpringContextUtils.getBean(SaleEbiddingItemHisLpServiceImpl.class);
        List<SaleEbiddingHeadLp> saleEbiddingHeadList = ((SaleEbiddingHeadLpMapper)this.baseMapper).selectByMainId(dbHead.getRelationId());
        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleEbiddingItemHisLp> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
        if ((saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList())) != null && saleEbiddingItemHisList.size() > 0) {
            for (SaleEbiddingItemHisLp itemHis : saleEbiddingItemHisList) {
                SaleEbiddingItemHisLp his = new SaleEbiddingItemHisLp();
                his.setId(itemHis.getId());
                his.setBidNumber(purchaseBidNumber);
                saleEbiddingItemHisService.updateById((Object)his);
            }
            List itemIdList = saleEbiddingItemHisList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.purchaseEbiddingItemHisMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(PurchaseEbiddingItemHisLp::getRelationId, itemIdList)).set(PurchaseEbiddingItemHisLp::getBidNumber, (Object)purchaseBidNumber));
        }
    }

    private boolean checkQuoteQuantity(SaleEbiddingItemLp quoteItem) {
        if (quoteItem.getRemainingQuantity().compareTo(BigDecimal.ZERO) <= 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bUeBWRL0xqsu_bb4735b8", (String)"\u5269\u4f59\u6295\u6807\u6570\u91cf\u4e3a0\uff0c\u4e0d\u53ef\u62a5\u4ef7\uff01"));
        }
        if (quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_suWRfUbUeBWRVVVHcsu_2caea7b7", (String)"\u62a5\u4ef7\u6570\u91cf\u5927\u4e8e\u5269\u4f59\u6295\u6807\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8fdb\u884c\u62a5\u4ef7\uff01"));
        }
        boolean hasNextQuote = quoteItem.getRemainingQuantity().compareTo(quoteItem.getBidNumber()) != 0;
        return hasNextQuote;
    }

    @Override
    @SrmTransaction
    public void processDataStatus(SaleEbiddingHeadLp dbHead, SaleEbiddingItemHisLp dbItemHis, SaleEbiddingItemLp quoteItem, Boolean isFirst) {
        SaleEbiddingItemHisLpService hisService = (SaleEbiddingItemHisLpService)SpringContextUtils.getBean(SaleEbiddingItemHisLpServiceImpl.class);
        if (isFirst.booleanValue()) {
            hisService.quoteAccept(dbItemHis);
        } else {
            hisService.quoteReject(dbItemHis);
        }
        quoteItem.setQuoteIp(IPUtils.getIpAddr());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            this.saleEbiddingItemService.updateById((Object)quoteItem);
            PurchaseEbiddingItemLp item = this.getPurchaseItemByQuote(dbHead, quoteItem);
            this.purchaseEbiddingItemService.updateById((Object)item);
        } else {
            this.saleEbiddingItemMapper.quotePriceByHeadId(quoteItem);
            PurchaseEbiddingItemLp purchaseItem = this.getPurchaseItemByQuote(dbHead, quoteItem);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        }
    }

    public void calculateRemainingQuantity(SaleEbiddingHeadLp dbHead, SaleEbiddingItemLp quoteItem, List<String> headIdList) {
        BigDecimal remainingQuantity = quoteItem.getRemainingQuantity().subtract(quoteItem.getBidNumber());
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getHeadId, headIdList)).eq(SaleEbiddingItemLp::getItemNumber, (Object)dbHead.getCurrentItemNumber())).set(SaleEbiddingItemLp::getRemainingQuantity, (Object)remainingQuantity));
            PurchaseEbiddingItemLp item = this.getPurchaseItemByQuote(dbHead, quoteItem);
            item.setRemainingQuantity(remainingQuantity);
            List saleEbiddingItemList = this.saleEbiddingItemService.selectWithoutElsAccountByHeadId(headIdList).stream().filter(i -> dbHead.getCurrentItemNumber().equals(i.getItemNumber())).collect(Collectors.toList());
            List itemIdList = saleEbiddingItemList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(PurchaseEbiddingItemLp::getRelationId, itemIdList)).eq(PurchaseEbiddingItemLp::getItemNumber, (Object)dbHead.getCurrentItemNumber())).set(PurchaseEbiddingItemLp::getRemainingQuantity, (Object)remainingQuantity));
        } else {
            SaleEbiddingItemLp saleEbiddingItem = new SaleEbiddingItemLp();
            BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)saleEbiddingItem));
            saleEbiddingItem.setRemainingQuantity(remainingQuantity);
            this.saleEbiddingItemMapper.quotePriceByHeadId(saleEbiddingItem);
            PurchaseEbiddingItemLp purchaseItem = this.getPurchaseItemByQuote(dbHead, saleEbiddingItem);
            purchaseItem.setRemainingQuantity(remainingQuantity);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        }
    }

    private void calculateBidNumber(SaleEbiddingHeadLp dbHead, SaleEbiddingItemLp quoteItem, List<String> headIdList, List<PurchaseEbiddingItemLp> purchaseEbiddingItemList, BigDecimal purchaseBidNumber) {
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getHeadId, headIdList)).eq(SaleEbiddingItemLp::getItemNumber, (Object)dbHead.getCurrentItemNumber())).set(SaleEbiddingItemLp::getBidNumber, (Object)purchaseBidNumber.subtract(quoteItem.getBidNumber())));
            for (PurchaseEbiddingItemLp item : purchaseEbiddingItemList) {
                this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)item.getId())).set(PurchaseEbiddingItemLp::getBidNumber, (Object)purchaseBidNumber.subtract(quoteItem.getBidNumber())));
            }
        } else {
            SaleEbiddingItemLp saleEbiddingItem = new SaleEbiddingItemLp();
            BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)saleEbiddingItem));
            BigDecimal subtract = purchaseBidNumber.subtract(quoteItem.getBidNumber());
            saleEbiddingItem.setBidNumber(subtract);
            this.saleEbiddingItemMapper.quotePriceByHeadId(saleEbiddingItem);
            PurchaseEbiddingItemLp purchaseItem = this.getPurchaseItemByQuote(dbHead, saleEbiddingItem);
            purchaseItem.setBidNumber(subtract);
            this.purchaseEbiddingItemMapper.quotePriceByHeadId(purchaseItem);
        }
    }

    private void endEbiddingByDutch(SaleEbiddingHeadLp dbHead, List<String> headIdList) {
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String currentItemNumber = dbHead.getCurrentItemNumber();
            String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
            SaleEbiddingItemLp nextItem = this.saleEbiddingItemService.selectOneByMainIdAndItemNumber(dbHead.getId(), nextItemNumber);
            String updateItemNumber = nextItem != null ? nextItemNumber : "";
            String updateMaterialDesc = nextItem != null ? nextItem.getMaterialDesc() : "";
            String updateEbiddingStatus = nextItem != null ? EbiddingLpStatusEnum.WAIT_BIDDING.getValue() : EbiddingLpStatusEnum.BIDDING_END.getValue();
            SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
            saleHead.setCurrentItemNumber(updateItemNumber);
            saleHead.setCurrentMaterialDesc(updateMaterialDesc);
            saleHead.setEbiddingStatus(updateEbiddingStatus);
            ((SaleEbiddingHeadLpMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
            PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
            head.setId(dbHead.getRelationId());
            head.setCurrentItemNumber(updateItemNumber);
            head.setCurrentMaterialDesc(updateMaterialDesc);
            head.setEbiddingStatus(updateEbiddingStatus);
            head.setCurrentDelayCount(0);
            head.setEbiddingNumber(dbHead.getEbiddingNumber());
            head.setElsAccount(dbHead.getBusAccount());
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getHeadId, headIdList)).eq(SaleEbiddingItemLp::getItemNumber, (Object)currentItemNumber)).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItemLp::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItemLp::getItemNumber, (Object)currentItemNumber)).set(PurchaseEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
            if (nextItem != null) {
                head.setQuoteFlag("0");
                head.setEbiddingStatus(EbiddingLpStatusEnum.WAIT_BIDDING.getValue());
                head.setBeginTime(new Date());
                head.setEndTime((Date)DateUtil.offsetSecond((Date)head.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)dbHead.getIntervalMinute(), (int)1)));
                this.purchaseEbiddingHeadMapper.updateById((Object)head);
                LpEbiddingJobUtil.createStartJob(head, head.getEndTime());
                saleHead.setQuoteFlag("0");
            }
            LpEbiddingJobUtil.deleteDutchQuoteJob(head);
            saleHead.setBeginTime(head.getBeginTime());
            saleHead.setStartTime(dbHead.getStartTime());
            saleHead.setEndTime(head.getEndTime());
            saleHead.setCurrentDelayCount(dbHead.getCurrentDelayCount());
            ((SaleEbiddingHeadLpMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.WAIT_BIDDING.getValue()));
            this.updateEbiddingHisItemNotAccept(dbHead);
        } else {
            SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
            saleHead.setCurrentMaterialDesc("");
            saleHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
            ((SaleEbiddingHeadLpMapper)this.baseMapper).update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
            PurchaseEbiddingHeadLp head = new PurchaseEbiddingHeadLp();
            head.setId(dbHead.getRelationId());
            head.setCurrentMaterialDesc(dbHead.getCurrentMaterialDesc());
            head.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
            this.purchaseEbiddingHeadMapper.updateById((Object)head);
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getHeadId, headIdList)).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItemLp::getHeadId, (Object)dbHead.getRelationId())).set(PurchaseEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
            head.setEbiddingNumber(dbHead.getEbiddingNumber());
            head.setElsAccount(dbHead.getBusAccount());
            LpEbiddingJobUtil.deleteDutchQuoteJob(head);
        }
    }

    private void updateEbiddingHisItemNotAccept(SaleEbiddingHeadLp dbHead) {
        SaleEbiddingItemHisLpService saleEbiddingItemHisService = (SaleEbiddingItemHisLpService)SpringContextUtils.getBean(SaleEbiddingItemHisLpServiceImpl.class);
        List<SaleEbiddingHeadLp> saleEbiddingHeadList = ((SaleEbiddingHeadLpMapper)this.baseMapper).selectByMainId(dbHead.getRelationId());
        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleEbiddingItemHisLp> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
        saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList());
        for (SaleEbiddingItemHisLp itemHis : saleEbiddingItemHisList) {
            itemHis.setAccept("3");
            saleEbiddingItemHisService.updateById((Object)itemHis);
            PurchaseEbiddingItemHisLp purchaseHis = new PurchaseEbiddingItemHisLp();
            purchaseHis.setId(itemHis.getRelationId());
            purchaseHis.setAccept("3");
            this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
        }
    }

    @Override
    @SrmTransaction
    public void quoteReject(SaleEbiddingHeadLp dbHead, SaleEbiddingItemHisLp dbItemHis, SaleEbiddingItemLp quoteItem) {
        BigDecimal price;
        SaleEbiddingItemHisLpService hisService = (SaleEbiddingItemHisLpService)SpringContextUtils.getBean(SaleEbiddingItemHisLpServiceImpl.class);
        long rejectCount = hisService.quoteReject(dbItemHis);
        BigDecimal bigDecimal = price = dbHead.getEbiddingWay().equals(EbiddingWayEnum.PACKAGE.getValue()) ? dbItemHis.getTotalAmount() : dbItemHis.getPrice();
        if (EbiddingMethodEnum.JAPAN.getValue().equals(dbHead.getEbiddingMethod())) {
            int quoteRejections;
            int n = quoteRejections = dbHead.getQuoteRejections() == null ? 5 : dbHead.getQuoteRejections();
            if ((long)quoteRejections <= rejectCount || BigDecimal.ZERO.compareTo(price) >= 0) {
                List<String> headIdList = this.getByRelationId(dbHead.getRelationId()).stream().map(BaseEntity::getId).collect(Collectors.toList());
                this.endEbiddingByJapan(dbHead, quoteItem, headIdList);
            } else if ("1".equals(dbHead.getPurchaseAutoQuote())) {
                this.autoQuotePrice(dbHead.getRelationId(), quoteItem.getRelationId());
            }
        } else if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            this.dutchHasNextQuoteByAccept(dbHead);
        }
        this.redis.publish("quote-price-topic", (Object)dbHead.getRelationId());
    }

    private void dutchHasNextQuoteByAccept(SaleEbiddingHeadLp dbHead) {
        SaleEbiddingItemHisLpService saleEbiddingItemHisService = (SaleEbiddingItemHisLpService)SpringContextUtils.getBean(SaleEbiddingItemHisLpServiceImpl.class);
        List<SaleEbiddingHeadLp> saleEbiddingHeadList = ((SaleEbiddingHeadLpMapper)this.baseMapper).selectByMainId(dbHead.getRelationId());
        List<String> saleHeadIdList = saleEbiddingHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<SaleEbiddingItemHisLp> saleEbiddingItemHisList = saleEbiddingItemHisService.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
        if ((saleEbiddingItemHisList = saleEbiddingItemHisList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getAccept())).collect(Collectors.toList())).isEmpty()) {
            this.dutchHasNextQuote(dbHead);
        }
    }

    private void dutchHasNextQuote(SaleEbiddingHeadLp dbHead) {
        PurchaseEbiddingHeadLp purchaseEbiddingHead = this.purchaseEbiddingHeadMapper.selectWithoutElsAccountById(dbHead.getRelationId());
        LpEbiddingJobUtil.deleteDutchQuoteJob(purchaseEbiddingHead);
        purchaseEbiddingHead.setQuoteFlag("0");
        purchaseEbiddingHead.setBeginTime(new Date());
        purchaseEbiddingHead.setEndTime((Date)DateUtil.offsetSecond((Date)purchaseEbiddingHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)purchaseEbiddingHead.getKeepMinute(), (int)1)));
        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseEbiddingHead);
        SaleEbiddingHeadLp saleHead = new SaleEbiddingHeadLp();
        saleHead.setBeginTime(purchaseEbiddingHead.getBeginTime());
        saleHead.setStartTime(purchaseEbiddingHead.getStartTime());
        saleHead.setEndTime(purchaseEbiddingHead.getEndTime());
        saleHead.setCurrentDelayCount(purchaseEbiddingHead.getCurrentDelayCount());
        saleHead.setQuoteFlag("0");
        SaleEbiddingHeadLpService saleEbiddingHeadService = (SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpServiceImpl.class);
        saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)purchaseEbiddingHead.getId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
        if ("1".equals(purchaseEbiddingHead.getPurchaseAutoQuote())) {
            PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpServiceImpl.class);
            PurchaseEbiddingItemLpService purchaseEbiddingItemService = (PurchaseEbiddingItemLpService)SpringContextUtils.getBean(PurchaseEbiddingItemLpService.class);
            List<PurchaseEbiddingItemLp> dbItemList = purchaseEbiddingItemService.selectByMainId(purchaseEbiddingHead.getId());
            String itemNumber = StrUtil.isNotBlank((CharSequence)purchaseEbiddingHead.getCurrentItemNumber()) ? purchaseEbiddingHead.getCurrentItemNumber() : "1";
            List<PurchaseEbiddingItemLp> quoteList = dbItemList.stream().filter(item -> itemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
            boolean successQuotePrice = purchaseEbiddingHeadService.autoQuotePricePublic(purchaseEbiddingHead, quoteList);
            if (successQuotePrice) {
                purchaseEbiddingHead.setBeginTime(new Date());
                purchaseEbiddingHead.setEndTime((Date)DateUtil.offsetSecond((Date)purchaseEbiddingHead.getBeginTime(), (int)SysUtil.minuteToSecond((BigDecimal)purchaseEbiddingHead.getKeepMinute(), (int)1)));
                purchaseEbiddingHead.setQuoteFlag("1");
                purchaseEbiddingHeadService.updateById((Object)purchaseEbiddingHead);
                LpEbiddingJobUtil.createDutchQuoteJob(purchaseEbiddingHead, purchaseEbiddingHead.getEndTime());
                saleHead.setBeginTime(purchaseEbiddingHead.getBeginTime());
                saleHead.setStartTime(purchaseEbiddingHead.getStartTime());
                saleHead.setEndTime(purchaseEbiddingHead.getEndTime());
                saleHead.setCurrentDelayCount(purchaseEbiddingHead.getCurrentDelayCount());
                saleHead.setQuoteFlag("1");
                saleEbiddingHeadService.update((Object)saleHead, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)purchaseEbiddingHead.getId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue()));
                purchaseEbiddingHeadService.autoSetBindnumber(purchaseEbiddingHead, dbItemList, quoteList);
            }
        }
    }

    private void endEbiddingByJapan(SaleEbiddingHeadLp dbHead, SaleEbiddingItemLp quoteItem, List<String> headIdList) {
        PurchaseEbiddingHeadLp purchaseHead = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)dbHead.getRelationId())));
        List<String> notJoiningStatusList = EbiddingLpConstant.NOT_JOINING_STATUS_LIST;
        if (EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay())) {
            String saleItemId = quoteItem.getId();
            String purchaseItemId = quoteItem.getRelationId();
            SaleEbiddingItemLp saleItem = new SaleEbiddingItemLp();
            saleItem.setId(saleItemId);
            saleItem.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue());
            this.saleEbiddingItemService.updateById((Object)saleItem);
            PurchaseEbiddingItemLp purchaseItem = new PurchaseEbiddingItemLp();
            purchaseItem.setId(purchaseItemId);
            purchaseItem.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue());
            this.purchaseEbiddingItemMapper.updateById((Object)purchaseItem);
            if ("1".equals(purchaseHead.getRespectiveQuotations())) {
                List<SaleEbiddingItemLp> dbSaleItemList;
                long endItemCount;
                List<SaleEbiddingHeadLp> dbHeadList = this.getByRelationId(dbHead.getRelationId());
                List needEndList = dbHeadList.stream().filter(head -> notJoiningStatusList.contains(head.getEbiddingStatus())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(needEndList)) {
                    List endAccountList = needEndList.stream().map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
                    List<PurchaseEbiddingItemLp> endItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> endAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
                    endItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
                    List endItemIdList = endItemList.stream().map(PurchaseEbiddingItemLp::getRelationId).collect(Collectors.toList());
                    this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue())).in(BaseEntity::getId, endItemIdList));
                    this.purchaseEbiddingItemService.updateBatchById(endItemList);
                }
                if ((endItemCount = (dbSaleItemList = this.saleEbiddingItemService.selectByMainId(dbHead.getId())).stream().filter(item -> EbiddingItemLpStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).count()) == (long)dbSaleItemList.size()) {
                    dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
                    dbHead.setEndTime(new Date());
                    this.updateById((Object)dbHead);
                    List<SaleEbiddingHeadLp> nowDbHeadList = this.getByRelationId(dbHead.getRelationId());
                    List<String> endCountStatusList = EbiddingLpConstant.END_STATUS_LIST;
                    long endHeadCount = nowDbHeadList.stream().filter(head -> endCountStatusList.contains(head.getEbiddingStatus())).count();
                    if (endHeadCount == (long)nowDbHeadList.size()) {
                        purchaseHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
                        purchaseHead.setEndTime(new Date());
                        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
                    }
                }
            } else {
                String currentItemNumber = dbHead.getCurrentItemNumber() == null ? "1" : dbHead.getCurrentItemNumber();
                List<SaleEbiddingHeadLp> dbHeadList = this.getByRelationId(dbHead.getRelationId());
                List endAccountList = dbHeadList.stream().filter(head -> notJoiningStatusList.contains(head.getEbiddingStatus())).map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(endAccountList)) {
                    List<PurchaseEbiddingItemLp> endItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> endAccountList.contains(item.getToElsAccount())).filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                    endItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
                    List endItemIdList = endItemList.stream().map(PurchaseEbiddingItemLp::getRelationId).collect(Collectors.toList());
                    this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue())).in(BaseEntity::getId, endItemIdList));
                    this.purchaseEbiddingItemService.updateBatchById(endItemList);
                }
                String nextItemNumber = String.valueOf(Integer.parseInt(currentItemNumber) + 1);
                SaleEbiddingItemLp nextItem = this.saleEbiddingItemService.selectOneByMainIdAndItemNumber(dbHead.getId(), nextItemNumber);
                if (nextItem == null) {
                    dbHead.setCurrentItemNumber("");
                    dbHead.setCurrentMaterialDesc("");
                    dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
                    dbHead.setEndTime(new Date());
                    this.updateById((Object)dbHead);
                    List<SaleEbiddingHeadLp> newDbHeadList = this.getByRelationId(dbHead.getRelationId());
                    List<String> endCountStatusList = EbiddingLpConstant.END_STATUS_LIST;
                    long endHeadCount = newDbHeadList.stream().filter(head -> endCountStatusList.contains(head.getEbiddingStatus())).count();
                    if (endHeadCount == (long)newDbHeadList.size()) {
                        purchaseHead.setCurrentItemNumber("");
                        purchaseHead.setCurrentMaterialDesc("");
                        purchaseHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
                        purchaseHead.setEndTime(new Date());
                        this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
                    }
                } else {
                    dbHead.setEndTime(new Date());
                    this.updateById((Object)dbHead);
                    List currentItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> currentItemNumber.equals(item.getItemNumber())).collect(Collectors.toList());
                    long endCount = currentItemList.stream().filter(item -> EbiddingItemLpStatusEnum.BIDDING_END.getValue().equals(item.getItemStatus())).count();
                    if (endCount == (long)currentItemList.size()) {
                        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingHeadLp::getRelationId, (Object)dbHead.getRelationId())).eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue())).set(SaleEbiddingHeadLp::getCurrentItemNumber, (Object)nextItemNumber)).set(SaleEbiddingHeadLp::getCurrentMaterialDesc, (Object)nextItem.getMaterialDesc()));
                        PurchaseEbiddingHeadLp head2 = new PurchaseEbiddingHeadLp();
                        head2.setId(dbHead.getRelationId());
                        head2.setCurrentItemNumber(nextItemNumber);
                        head2.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                        head2.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING.getValue());
                        head2.setEndTime(new Date());
                        this.purchaseEbiddingHeadMapper.updateById((Object)head2);
                        this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(SaleEbiddingItemLp::getHeadId, headIdList)).eq(SaleEbiddingItemLp::getItemNumber, (Object)nextItemNumber)).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING.getValue()));
                        this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItemLp::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItemLp::getItemNumber, (Object)nextItemNumber)).set(PurchaseEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING.getValue()));
                        if ("1".equals(dbHead.getPurchaseAutoQuote())) {
                            List<String> purchaseItemIdList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> item.getItemNumber().equals(nextItemNumber)).map(BaseEntity::getId).collect(Collectors.toList());
                            this.autoQuotePrice(dbHead.getRelationId(), purchaseItemIdList);
                        }
                    } else {
                        dbHead.setCurrentItemNumber(nextItemNumber);
                        dbHead.setCurrentMaterialDesc(nextItem.getMaterialDesc());
                        this.updateById((Object)dbHead);
                    }
                }
            }
        } else {
            List<SaleEbiddingHeadLp> dbHeadList = this.getByRelationId(dbHead.getRelationId());
            List endAccountList = dbHeadList.stream().filter(head -> notJoiningStatusList.contains(head.getEbiddingStatus())).map(BaseEntity::getElsAccount).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(endAccountList)) {
                List<PurchaseEbiddingItemLp> endItemList = this.purchaseEbiddingItemService.selectByMainId(dbHead.getRelationId()).stream().filter(item -> endAccountList.contains(item.getToElsAccount())).collect(Collectors.toList());
                endItemList.forEach(item -> item.setItemStatus(EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
                List endItemIdList = endItemList.stream().map(PurchaseEbiddingItemLp::getRelationId).collect(Collectors.toList());
                this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue())).in(BaseEntity::getId, endItemIdList));
                this.purchaseEbiddingItemService.updateBatchById(endItemList);
            }
            this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItemLp::getHeadId, (Object)dbHead.getId())).set(SaleEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
            this.purchaseEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseEbiddingItemLp::getHeadId, (Object)dbHead.getRelationId())).eq(PurchaseEbiddingItemLp::getToElsAccount, (Object)dbHead.getElsAccount())).set(PurchaseEbiddingItemLp::getItemStatus, (Object)EbiddingItemLpStatusEnum.BIDDING_END.getValue()));
            dbHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
            dbHead.setEndTime(new Date());
            this.updateById((Object)dbHead);
            List<SaleEbiddingHeadLp> newDbHeadList = this.getByRelationId(dbHead.getRelationId());
            List<String> endCountStatusList = EbiddingLpConstant.END_STATUS_LIST;
            long endHeadCount = newDbHeadList.stream().filter(head -> endCountStatusList.contains(head.getEbiddingStatus())).count();
            if (endHeadCount == (long)newDbHeadList.size()) {
                purchaseHead.setEbiddingStatus(EbiddingLpStatusEnum.BIDDING_END.getValue());
                purchaseHead.setEndTime(new Date());
                this.purchaseEbiddingHeadMapper.updateById((Object)purchaseHead);
            }
        }
    }

    private void autoQuotePrice(PurchaseEbiddingHeadLp purchaseDbHead, String purchaseItemId) {
        BigDecimal quotePrice;
        PurchaseEbiddingItemLpService purchaseEbiddingItemService = (PurchaseEbiddingItemLpService)SpringContextUtils.getBean(PurchaseEbiddingItemLpServiceImpl.class);
        PurchaseEbiddingItemLp dbItem = (PurchaseEbiddingItemLp)((Object)purchaseEbiddingItemService.getById((Serializable)((Object)purchaseItemId)));
        PurchaseEbiddingItemHisLpService purchaseEbiddingItemHisService = (PurchaseEbiddingItemHisLpService)SpringContextUtils.getBean(PurchaseEbiddingItemHisLpServiceImpl.class);
        PurchaseEbiddingItemLp quoteItem = new PurchaseEbiddingItemLp();
        BeanUtils.copyProperties((Object)((Object)dbItem), (Object)((Object)quoteItem));
        purchaseEbiddingItemHisService.queryAddQuoteSite(purchaseDbHead, quoteItem);
        if (EbiddingWayEnum.SINGLE.getValue().equals(purchaseDbHead.getEbiddingWay())) {
            quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(purchaseDbHead.getQuoteType()) ? quoteItem.getNetPrice() : quoteItem.getPrice();
        } else {
            BigDecimal bigDecimal = quotePrice = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(purchaseDbHead.getQuoteType()) ? quoteItem.getNetTotalAmount() : quoteItem.getTotalAmount();
        }
        if (quotePrice != null) {
            PurchaseEbiddingHeadLpService purchaseEbiddingHeadService = (PurchaseEbiddingHeadLpService)SpringContextUtils.getBean(PurchaseEbiddingHeadLpServiceImpl.class);
            purchaseEbiddingHeadService.quote(purchaseDbHead, dbItem, quoteItem);
        }
    }

    private void autoQuotePrice(String purchaseHeadId, List<String> purchaseItemIdList) {
        PurchaseEbiddingHeadLp purchaseDbHead = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)purchaseHeadId)));
        for (String purchaseItemId : purchaseItemIdList) {
            this.autoQuotePrice(purchaseDbHead, purchaseItemId);
        }
    }

    private void autoQuotePrice(String purchaseHeadId, String purchaseItemId) {
        PurchaseEbiddingHeadLp purchaseDbHead = (PurchaseEbiddingHeadLp)((Object)this.purchaseEbiddingHeadMapper.selectById((Serializable)((Object)purchaseHeadId)));
        this.autoQuotePrice(purchaseDbHead, purchaseItemId);
    }

    @Override
    public List<SaleEbiddingHeadLp> getByRelationId(String relationId) {
        return ((SaleEbiddingHeadLpMapper)this.baseMapper).selectByMainId(relationId);
    }

    @Override
    public SaleEbiddingHeadLp selectByAccount(String relationId, String elsAccount) {
        return ((SaleEbiddingHeadLpMapper)this.baseMapper).selectByElsAccount(relationId, elsAccount);
    }

    @Override
    public void processRemainingQuantity(PurchaseEbiddingHeadLp dbHead, List<PurchaseEbiddingItemLp> dbItemList) {
        if (EbiddingMethodEnum.DUTCH.getValue().equals(dbHead.getEbiddingMethod())) {
            for (PurchaseEbiddingItemLp item : dbItemList) {
                if (!EbiddingWayEnum.PACKAGE.getValue().equals(dbHead.getEbiddingWay())) {
                    this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItemLp::getRelationId, (Object)item.getId())).set(SaleEbiddingItemLp::getRemainingQuantity, (Object)item.getRequireQuantity()));
                    continue;
                }
                this.saleEbiddingItemService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SaleEbiddingItemLp::getRelationId, (Object)item.getId())).set(SaleEbiddingItemLp::getRemainingQuantity, (Object)1));
            }
        }
    }

    @Override
    public ReverseRouteUnitPriceVO reverseRouteUnitPrice(SaleEbiddingItemLp saleEbiddingItem, Integer pageNo, Integer pageSize) {
        ReverseRouteUnitPriceVO reverseRouteUnitPriceVO = new ReverseRouteUnitPriceVO();
        SaleEbiddingItemLp dbSaleEbiddingItem = (SaleEbiddingItemLp)((Object)this.saleEbiddingItemService.getById((Serializable)((Object)saleEbiddingItem.getId())));
        if (ObjectUtil.isEmpty((Object)((Object)dbSaleEbiddingItem))) {
            return reverseRouteUnitPriceVO;
        }
        SaleEbiddingHeadLp dbSaleEbiddingHead = (SaleEbiddingHeadLp)((Object)((SaleEbiddingHeadLpService)SpringContextUtils.getBean(SaleEbiddingHeadLpService.class)).getById((Serializable)((Object)dbSaleEbiddingItem.getHeadId())));
        if (ObjectUtil.isEmpty((Object)((Object)dbSaleEbiddingHead)) || StrUtil.isBlank((CharSequence)dbSaleEbiddingHead.getEnquiryId())) {
            return reverseRouteUnitPriceVO;
        }
        SaleEnquiryItemLpService saleEnquiryItemService = (SaleEnquiryItemLpService)SpringContextUtils.getBean(SaleEnquiryItemLpService.class);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{SaleEnquiryItemLp::getHeadId, SaleEnquiryItemLp::getItemNumber, SaleEnquiryItemLp::getEnquiryNumber, SaleEnquiryItemLp::getPurchaseName, SaleEnquiryItemLp::getItemStatus, SaleEnquiryItemLp::getTaxCode, SaleEnquiryItemLp::getTaxRate, SaleEnquiryItemLp::getQuoteTime, SaleEnquiryItemLp::getCenterPoint, SaleEnquiryItemLp::getSectionNumber, SaleEnquiryItemLp::getSectionName, SaleEnquiryItemLp::getStartProvince, SaleEnquiryItemLp::getStartCity, SaleEnquiryItemLp::getStartCounty, SaleEnquiryItemLp::getArriveProvince, SaleEnquiryItemLp::getArriveCity, SaleEnquiryItemLp::getArriveCounty, SaleEnquiryItemLp::getIntervalRatioPrice1, SaleEnquiryItemLp::getIntervalRatioPrice2, SaleEnquiryItemLp::getIntervalRatioPrice3, SaleEnquiryItemLp::getIntervalRatioPrice4, SaleEnquiryItemLp::getToDoorDate, SaleEnquiryItemLp::getToDoorPrice, SaleEnquiryItemLp::getArriveCityStation, SaleEnquiryItemLp::getToDoorTonsPrice, SaleEnquiryItemLp::getToDoorTonsDate, SaleEnquiryItemLp::getToStationPrice, SaleEnquiryItemLp::getToSta}).eq(SaleEnquiryItemLp::getHeadId, (Object)dbSaleEbiddingHead.getEnquiryId())).eq(StrUtil.isNotBlank((CharSequence)saleEbiddingItem.getSectionNumber()), SaleEnquiryItemLp::getSectionNumber, (Object)saleEbiddingItem.getSectionNumber());
        IPage pageResult = saleEnquiryItemService.page((IPage)page, (Wrapper)wrapper);
        pageResult.getRecords().forEach(p -> p.setCenterPoint("1".equals(p.getCenterPoint()) ? "\u662f" : "\u5426"));
        if (((BigDecimal)ObjectUtil.defaultIfNull((Object)dbSaleEbiddingItem.getEbiddingRange(), (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal ebiddingRange = dbSaleEbiddingItem.getEbiddingRange();
            pageResult.getRecords().forEach(p -> this.reversePrice((SaleEnquiryItemLp)((Object)p), ebiddingRange));
        }
        reverseRouteUnitPriceVO.setPageResult((IPage<SaleEnquiryItemLp>)pageResult);
        return reverseRouteUnitPriceVO;
    }

    @Override
    public List<SaleEbiddingItemLp> overallRanking(String subjectType) {
        List<SaleEbiddingItemLp> allSaleEbiddingItemList;
        List<String> headIds;
        Date currentTime = new Date();
        if (!ObjectUtils.isEmpty((Object)subjectType) && "0".equals(subjectType)) {
            subjectType = null;
        }
        if (CollUtil.isEmpty(headIds = (allSaleEbiddingItemList = this.saleEbiddingItemService.selectWithoutElsAccountByItemStatus(EbiddingItemLpStatusEnum.BIDDING.getValue(), subjectType)).stream().map(SaleEbiddingItemLp::getHeadId).distinct().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList()))) {
            return new ArrayList<SaleEbiddingItemLp>();
        }
        List<SaleEbiddingHeadLp> dbSaleHeads = this.selectWithoutElsAccountByHeadId(headIds);
        if (CollUtil.isEmpty(dbSaleHeads)) {
            return new ArrayList<SaleEbiddingItemLp>();
        }
        if (CollUtil.isEmpty(dbSaleHeads = dbSaleHeads.stream().filter(s -> EbiddingLpStatusEnum.BIDDING.getValue().equals(s.getEbiddingStatus())).filter(s -> s.getEndTime().after(currentTime)).collect(Collectors.toList()))) {
            return new ArrayList<SaleEbiddingItemLp>();
        }
        List dbHeadIds = dbSaleHeads.stream().map(BaseEntity::getId).collect(Collectors.toList());
        allSaleEbiddingItemList = allSaleEbiddingItemList.stream().filter(i -> dbHeadIds.contains(i.getHeadId())).collect(Collectors.toList());
        String elsAccount = TenantContext.getTenant();
        ArrayList<SaleEbiddingItemLp> rankSaleEbiddingItemList = new ArrayList<SaleEbiddingItemLp>();
        if (CollectionUtils.isEmpty(allSaleEbiddingItemList)) {
            return rankSaleEbiddingItemList;
        }
        Map<String, List<SaleEbiddingItemLp>> saleEbiddingItemMap = allSaleEbiddingItemList.stream().collect(Collectors.groupingBy(item -> item.getEbiddingNumber() + "_" + item.getItemNumber()));
        for (Map.Entry<String, List<SaleEbiddingItemLp>> saleEbiddingItemEntry : saleEbiddingItemMap.entrySet()) {
            List<SaleEbiddingItemLp> saleEbiddingItems = saleEbiddingItemEntry.getValue();
            List tempSaleEbiddingItemList = saleEbiddingItems.stream().sorted(Comparator.comparing(SaleEbiddingItemLp::getNetTotalAmount)).collect(Collectors.toList());
            int i2 = 1;
            ArrayList<SaleEbiddingItemLp> tempRankSaleEbiddingItemList = new ArrayList<SaleEbiddingItemLp>();
            for (SaleEbiddingItemLp saleEbiddingItem : tempSaleEbiddingItemList) {
                saleEbiddingItem.setFbk1(String.valueOf(i2));
                if (!ObjectUtils.isEmpty((Object)saleEbiddingItem.getEbiddingRange())) {
                    saleEbiddingItem.setEbiddingRange(saleEbiddingItem.getEbiddingRange().setScale(2, 4));
                }
                tempRankSaleEbiddingItemList.add(saleEbiddingItem);
                ++i2;
            }
            List saleEbiddingItemList = tempRankSaleEbiddingItemList.stream().filter(item -> item.getElsAccount().equals(elsAccount)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(saleEbiddingItemList)) continue;
            rankSaleEbiddingItemList.add((SaleEbiddingItemLp)((Object)saleEbiddingItemList.get(0)));
        }
        rankSaleEbiddingItemList.sort(Comparator.comparing(SaleEbiddingItemLp::getSubjectNumber, (subjectNumber1, subjectNumber2) -> {
            String subjectNumber1Split = ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber1, (CharSequence)"")).split("\u6807").length > 1 ? ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber1, (CharSequence)"")).split("\u6807")[1] : "0";
            String subjectNumber2Split = ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber2, (CharSequence)"")).split("\u6807").length > 1 ? ((String)ObjectUtil.defaultIfEmpty((CharSequence)subjectNumber2, (CharSequence)"")).split("\u6807")[1] : "0";
            Long s1 = NumberUtil.isNumber((CharSequence)subjectNumber1Split) ? Long.parseLong(subjectNumber1Split) : 0L;
            Long s2 = NumberUtil.isNumber((CharSequence)subjectNumber2Split) ? Long.parseLong(subjectNumber2Split) : 0L;
            return s1.compareTo(s2);
        }));
        return rankSaleEbiddingItemList;
    }

    @Override
    public List<SaleEbiddingHeadLp> selectWithoutElsAccountByHeadId(List<String> headIds) {
        return ((SaleEbiddingHeadLpMapper)this.baseMapper).selectWithoutElsAccountByHeadId(headIds);
    }

    private void reversePrice(SaleEnquiryItemLp enquiryItem, BigDecimal ebiddingRange) {
        enquiryItem.setNetPrice(this.reversePirce(enquiryItem.getNetPrice(), ebiddingRange));
        enquiryItem.setPrice(this.reversePirce(enquiryItem.getPrice(), ebiddingRange));
        enquiryItem.setTaxAmount(this.reversePirce(enquiryItem.getTaxAmount(), ebiddingRange));
        enquiryItem.setNetAmount(this.reversePirce(enquiryItem.getNetAmount(), ebiddingRange));
        enquiryItem.setToDoorPrice(this.reversePirce(enquiryItem.getToDoorPrice(), ebiddingRange));
        enquiryItem.setToDoorNetPrice(this.reversePirce(enquiryItem.getToDoorNetPrice(), ebiddingRange));
        enquiryItem.setToStationPrice(this.reversePirce(enquiryItem.getToStationPrice(), ebiddingRange));
        enquiryItem.setToStationNetPrice(this.reversePirce(enquiryItem.getToStationNetPrice(), ebiddingRange));
        enquiryItem.setToDoorTonsPrice(this.reversePirce(enquiryItem.getToDoorTonsPrice(), ebiddingRange));
        enquiryItem.setToDoorTonsNetPrice(this.reversePirce(enquiryItem.getToDoorTonsNetPrice(), ebiddingRange));
        enquiryItem.setIntervalRatioPrice1(this.reversePirce(enquiryItem.getIntervalRatioPrice1(), ebiddingRange));
        enquiryItem.setIntervalRatioPrice2(this.reversePirce(enquiryItem.getIntervalRatioPrice2(), ebiddingRange));
        enquiryItem.setIntervalRatioPrice3(this.reversePirce(enquiryItem.getIntervalRatioPrice3(), ebiddingRange));
        enquiryItem.setIntervalRatioPrice4(this.reversePirce(enquiryItem.getIntervalRatioPrice4(), ebiddingRange));
        enquiryItem.setIntervalRatioNetPrice1(this.reversePirce(enquiryItem.getIntervalRatioNetPrice1(), ebiddingRange));
        enquiryItem.setIntervalRatioNetPrice2(this.reversePirce(enquiryItem.getIntervalRatioNetPrice2(), ebiddingRange));
        enquiryItem.setIntervalRatioNetPrice3(this.reversePirce(enquiryItem.getIntervalRatioNetPrice3(), ebiddingRange));
        enquiryItem.setIntervalRatioNetPrice4(this.reversePirce(enquiryItem.getIntervalRatioNetPrice4(), ebiddingRange));
    }

    private BigDecimal reversePirce(BigDecimal price, BigDecimal ebiddingRange) {
        if (((BigDecimal)ObjectUtil.defaultIfNull((Object)price, (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return price.subtract(price.multiply(ebiddingRange.multiply(new BigDecimal("0.01")))).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public List<TemplateConfigItemDTO> queryEnquiryItemTemplateByEbiddingHeadId(String headId) {
        SaleEbiddingHeadLp dbSaleHead = (SaleEbiddingHeadLp)((Object)this.getById((Serializable)((Object)headId)));
        if (ObjectUtil.isEmpty((Object)((Object)dbSaleHead))) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        if (StrUtil.isBlank((CharSequence)dbSaleHead.getEnquiryNumber()) || StrUtil.isBlank((CharSequence)dbSaleHead.getEnquiryId())) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        SaleEnquiryHeadLpService saleEnquiryHeadService = (SaleEnquiryHeadLpService)SpringContextUtils.getBean(SaleEnquiryHeadLpService.class);
        SaleEnquiryHeadLp dbSaleEnquiryHead = (SaleEnquiryHeadLp)((Object)saleEnquiryHeadService.getById((Serializable)((Object)dbSaleHead.getEnquiryId())));
        if (ObjectUtil.isEmpty((Object)((Object)dbSaleEnquiryHead))) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        TemplateHeadDTO templateHead = this.invokeBaseRpcService.getTemplateConfig(dbSaleEnquiryHead.getToElsAccount(), dbSaleEnquiryHead.getTemplateNumber(), String.valueOf(dbSaleEnquiryHead.getTemplateVersion()));
        if (ObjectUtil.isEmpty((Object)templateHead)) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        List<TemplateConfigItemDTO> itemConfigs = templateHead.getTemplateConfigItemList();
        itemConfigs = itemConfigs.stream().filter(item -> "1".equals(item.getSaleShow())).filter(item -> !"subjectFileItemList".equals(item.getGroupCode())).collect(Collectors.toList());
        TemplateConfigItemDTO configItemDTO = new TemplateConfigItemDTO();
        configItemDTO.setFieldLabel("\u8be2\u4ef7\u5355\u53f7");
        configItemDTO.setFieldName("enquiryNumber");
        itemConfigs.add(1, configItemDTO);
        return itemConfigs;
    }

    @Override
    public List<TemplateConfigItemDTO> queryEnquiryItemTemplateByEbiddingId(String headId) {
        SaleEbiddingHeadLp dbSaleHead = (SaleEbiddingHeadLp)((Object)this.getById((Serializable)((Object)headId)));
        if (ObjectUtil.isEmpty((Object)((Object)dbSaleHead))) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        if (StrUtil.isBlank((CharSequence)dbSaleHead.getEnquiryNumber()) || StrUtil.isBlank((CharSequence)dbSaleHead.getEnquiryId())) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        SaleEnquiryHeadLpService saleEnquiryHeadService = (SaleEnquiryHeadLpService)SpringContextUtils.getBean(SaleEnquiryHeadLpService.class);
        SaleEnquiryHeadLp dbSaleEnquiryHead = (SaleEnquiryHeadLp)((Object)saleEnquiryHeadService.getById((Serializable)((Object)dbSaleHead.getEnquiryId())));
        if (ObjectUtil.isEmpty((Object)((Object)dbSaleEnquiryHead))) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        TemplateHeadDTO templateHead = this.invokeBaseRpcService.getTemplateConfig(dbSaleEnquiryHead.getToElsAccount(), dbSaleEnquiryHead.getTemplateNumber(), String.valueOf(dbSaleEnquiryHead.getTemplateVersion()));
        if (ObjectUtil.isEmpty((Object)templateHead)) {
            return new ArrayList<TemplateConfigItemDTO>();
        }
        List<TemplateConfigItemDTO> itemConfigs = templateHead.getTemplateConfigItemList();
        itemConfigs = itemConfigs.stream().filter(item -> "1".equals(item.getSaleShow())).filter(item -> !"subjectFileItemList".equals(item.getGroupCode())).collect(Collectors.toList());
        return itemConfigs;
    }

    @Override
    public SaleEbiddingHeadLp getFirstEbiddingEndTime() {
        List saleEbiddingHeads = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SaleEbiddingHeadLp::getEbiddingStatus, (Object)EbiddingLpStatusEnum.BIDDING.getValue())).ge(SaleEbiddingHeadLp::getEndTime, (Object)new Date())).ne(SaleEbiddingHeadLp::getTest, (Object)"1")).last("LIMIT 1")).list();
        if (CollUtil.isEmpty((Collection)saleEbiddingHeads)) {
            return null;
        }
        SaleEbiddingHeadLp saleEbiddingHead = (SaleEbiddingHeadLp)((Object)saleEbiddingHeads.get(0));
        Date currentDateTime = new Date();
        Date endTime = saleEbiddingHead.getEndTime();
        long deadline = DateUtil.between((Date)currentDateTime, (Date)endTime, (DateUnit)DateUnit.MS);
        saleEbiddingHead.setSysTime(currentDateTime);
        return saleEbiddingHead;
    }
}

