/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.socket.service;

import com.corundumstudio.socketio.SocketIOClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SocketIOService {
    private static final Logger log = LoggerFactory.getLogger(SocketIOService.class);
    public static Map<String, SocketIOClient> clientMap = new ConcurrentHashMap<String, SocketIOClient>();
    private static final String E_BIDDING_EVENT = "ebidding_event";

    public void sendMessageToAllUsers(String message) {
        if (clientMap.isEmpty()) {
            return;
        }
        for (String key : clientMap.keySet()) {
            SocketIOClient socketIOClient = clientMap.get(key);
            socketIOClient.sendEvent(E_BIDDING_EVENT, new Object[]{message});
        }
    }

    public void sendQuoteMessage(String purchaseHeadId) {
        if (clientMap.isEmpty()) {
            return;
        }
        if (clientMap.containsKey("ebidding_" + purchaseHeadId)) {
            SocketIOClient socketIOClient = clientMap.get("ebidding_" + purchaseHeadId);
            socketIOClient.sendEvent(E_BIDDING_EVENT, new Object[]{purchaseHeadId});
        }
    }
}

