/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.job.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.ebidding.entity.PurchaseEbiddingHead;
import com.els.modules.ebidding.entity.SaleEbiddingHead;
import com.els.modules.inquiry.rpc.service.InquriyInvokeJobRpcService;
import com.els.modules.job.api.dto.QuartzJobDTO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbiddingJobUtil {
    private static final Logger log = LoggerFactory.getLogger(EbiddingJobUtil.class);
    private static InquriyInvokeJobRpcService inquriyInvokeJobRpcService = (InquriyInvokeJobRpcService)SpringContextUtils.getBean(InquriyInvokeJobRpcService.class);
    private static final String BIDDING_START_JOB = "srmEbiddingBeginJobServiceImpl";
    private static final String BIDDING_FAILED_JOB = "srmEbiddingFailedJobServiceImpl";
    private static final String BIDDING_END_JOB = "srmEbiddingEndJobServiceImpl";
    private static final String BIDDING_DUTCH_QUOTE_JOB = "srmEbiddingDutchQuoteJobServiceImpl";

    private static void createJob(PurchaseEbiddingHead purchaseHead, Date time, String jobName) {
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        if (BIDDING_DUTCH_QUOTE_JOB.equals(jobName)) {
            job.setJobNameKey(jobName + "_" + purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount());
        } else {
            job.setJobNameKey(jobName + "_" + purchaseHead.getEbiddingNumber() + "_" + elsAccount);
        }
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)purchaseHead.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        paramObj.put("jobImplName", (Object)jobName);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            inquriyInvokeJobRpcService.createJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static void createStartJob(PurchaseEbiddingHead purchaseHead, Date time) {
        EbiddingJobUtil.createJob(purchaseHead, time, BIDDING_START_JOB);
    }

    public static void createFailedJob(PurchaseEbiddingHead purchaseHead, Date time) {
        EbiddingJobUtil.createJob(purchaseHead, time, BIDDING_FAILED_JOB);
    }

    public static void createEndJob(PurchaseEbiddingHead purchaseHead, Date time) {
        Date addTime = EbiddingJobUtil.getAddTime(time);
        EbiddingJobUtil.createJob(purchaseHead, addTime, BIDDING_END_JOB);
    }

    public static void createDutchQuoteJob(PurchaseEbiddingHead purchaseHead, Date endTime) {
        DateTime addTime = DateUtil.offsetSecond((Date)endTime, (int)10);
        EbiddingJobUtil.createJob(purchaseHead, (Date)addTime, BIDDING_DUTCH_QUOTE_JOB);
    }

    public static void updateEndJob(SaleEbiddingHead dbSaleHead, Date endTime) {
        Date addTime = EbiddingJobUtil.getAddTime(endTime);
        String elsAccount = dbSaleHead.getToElsAccount();
        String cron = DateUtils.formatDate((Date)addTime, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey("srmEbiddingEndJobServiceImpl_" + dbSaleHead.getEbiddingNumber() + "_" + elsAccount);
        try {
            List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(job.getJobNameKey());
            if (!jobList.isEmpty()) {
                job.setId(jobList.get(0).getId());
                job.setParameter(jobList.get(0).getParameter());
            }
            inquriyInvokeJobRpcService.updateJob(job);
        }
        catch (Exception e) {
            log.error("ebidding_updateEndJob_failed:", (Throwable)e);
            throw new ELSBootException((Throwable)e);
        }
    }

    public static void deleteDutchQuoteJob(PurchaseEbiddingHead purchaseHead) {
        String jobKey = "srmEbiddingDutchQuoteJobServiceImpl_" + purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount();
        EbiddingJobUtil.deleteJob(jobKey);
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = inquriyInvokeJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            inquriyInvokeJobRpcService.deleteJob(jobList.get(0));
        }
        EbiddingJobUtil.physicallyDeleteJob(jobKey);
    }

    private static void physicallyDeleteJob(String jobKey) {
        inquriyInvokeJobRpcService.deleteByJobNameKey(jobKey);
    }

    public static void deleteAllJob(PurchaseEbiddingHead purchaseHead) {
        String key = purchaseHead.getEbiddingNumber() + "_" + purchaseHead.getElsAccount();
        EbiddingJobUtil.deleteJob("srmEbiddingBeginJobServiceImpl_" + key);
        EbiddingJobUtil.deleteJob("srmEbiddingFailedJobServiceImpl_" + key);
        EbiddingJobUtil.deleteJob("srmEbiddingEndJobServiceImpl_" + key);
    }

    private static Date getAddTime(Date time) {
        return DateUtil.offsetSecond((Date)time, (int)3);
    }
}

