/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.abnormal.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.tender.abnormal.entity.PurchaseTenderSubpackageTerminateHead;
import com.els.modules.tender.abnormal.enumerate.SubpackageTerminateHeadStatusEnum;
import com.els.modules.tender.abnormal.service.PurchaseTenderSubpackageTerminateHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="tenderSubpackageTerminateAdapter")
public class TenderSubpackageTerminateAdapter
implements AuditOptCallBackService {
    @Resource
    private PurchaseTenderSubpackageTerminateHeadService terminateHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            Object operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                Object operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO auditInputParamDTO, AuditOutputParamDTO auditOutputParamDTO) {
        this.updateStatus(auditInputParamDTO, auditOutputParamDTO);
    }

    public JSONObject getDataById(String id) {
        PurchaseTenderSubpackageTerminateHead head = (PurchaseTenderSubpackageTerminateHead)((Object)this.terminateHeadService.getBaseMapper().selectById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    public void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseTenderSubpackageTerminateHead terminateHead = (PurchaseTenderSubpackageTerminateHead)((Object)this.terminateHeadService.getBaseMapper().selectById((Serializable)((Object)inputParamVO.getBusinessId())));
        terminateHead.setFlowId(outputParamVO.getProcessRootId());
        terminateHead.setWorkFlowType(outputParamVO.getBpmnType());
        String auditStatus = outputParamVO.getAuditStatus();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            this.terminateHeadService.publish(terminateHead);
            return;
        }
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(auditStatus)) {
            terminateHead.setStatus(SubpackageTerminateHeadStatusEnum.NEW.getValue());
        } else if (AuditStatusEnum.AUDIT_NEW.getValue().equals(auditStatus)) {
            terminateHead.setStatus(SubpackageTerminateHeadStatusEnum.NEW.getValue());
        } else {
            terminateHead.setStatus(SubpackageTerminateHeadStatusEnum.AUDIT.getValue());
        }
        terminateHead.setAuditStatus(auditStatus);
        this.terminateHeadService.updateById((Object)terminateHead);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_").length > 1 ? account.split("_")[1] : account.split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

