/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.service.impl;

import com.els.modules.bidding.entity.PurchaseClarificationInfo;
import com.els.modules.bidding.entity.PurchaseMentoringHead;
import com.els.modules.bidding.service.SendToSupplierService;
import com.els.modules.enquiry.entity.EnquirySupplierList;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EnquirySendToSupplierServiceImpl
implements SendToSupplierService {
    @Autowired
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Autowired
    private EnquirySupplierListService enquirySupplierListService;

    @Override
    public Map<String, String> handleSupplier(PurchaseClarificationInfo purchaseClarificationInfo) {
        HashMap<String, String> suppliers = null;
        PurchaseEnquiryHead enquiryHead = (PurchaseEnquiryHead)((Object)this.purchaseEnquiryHeadService.getById((Serializable)((Object)purchaseClarificationInfo.getBusinessId())));
        if (enquiryHead == null) {
            return null;
        }
        suppliers = new HashMap<String, String>();
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(enquiryHead.getId());
        for (EnquirySupplierList enquirySupplierList : supplierList) {
            suppliers.put(enquirySupplierList.getToElsAccount(), enquirySupplierList.getSupplierName());
        }
        return suppliers;
    }

    @Override
    public Map<String, String> handleSupplier(PurchaseMentoringHead head) {
        HashMap<String, String> suppliers = null;
        List<EnquirySupplierList> supplierList = this.enquirySupplierListService.selectByMainId(head.getBusinessId());
        suppliers = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(supplierList)) {
            return suppliers;
        }
        for (EnquirySupplierList enquirySupplierList : supplierList) {
            suppliers.put(enquirySupplierList.getToElsAccount(), enquirySupplierList.getSupplierName());
        }
        return suppliers;
    }
}

