/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.ebidding.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.ebidding.enumerate.EbiddingShowEnum;
import com.els.modules.ebidding.enumerate.EbiddingWayEnum;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingSupplierLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemHisLp;
import com.els.modules.logisticspurchase.ebidding.entity.SaleEbiddingItemLp;
import com.els.modules.logisticspurchase.ebidding.mapper.PurchaseEbiddingItemHisLpMapper;
import com.els.modules.logisticspurchase.ebidding.mapper.SaleEbiddingItemHisLpMapper;
import com.els.modules.logisticspurchase.ebidding.service.PurchaseEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemHisLpService;
import com.els.modules.logisticspurchase.ebidding.service.SaleEbiddingItemLpService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEbiddingItemHisLpServiceImpl
extends ServiceImpl<SaleEbiddingItemHisLpMapper, SaleEbiddingItemHisLp>
implements SaleEbiddingItemHisLpService {
    private static final Logger log = LoggerFactory.getLogger(SaleEbiddingItemHisLpServiceImpl.class);
    @Autowired
    private PurchaseEbiddingItemHisLpMapper purchaseEbiddingItemHisMapper;
    @Autowired
    private SaleEbiddingItemHisLpMapper saleEbiddingItemHisMapper;
    @Autowired
    private SaleEbiddingItemLpService saleEbiddingItemService;

    @Override
    public List<SaleEbiddingItemHisLp> queryBidLobbyDetail(SaleEbiddingHeadLp head) {
        List resultList;
        String supplierShow;
        String string = supplierShow = head.getSupplierShow() == null ? "" : head.getSupplierShow();
        if (supplierShow.contains(EbiddingShowEnum.PRICE.getValue())) {
            List purchaseList = this.purchaseEbiddingItemHisMapper.selectByMainId(head.getRelationId()).stream().filter(itemHis -> {
                if (!EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
                    return itemHis.getItemNumber().equals(head.getCurrentItemNumber());
                }
                return true;
            }).collect(Collectors.toList());
            resultList = SysUtil.copyProperties(purchaseList, SaleEbiddingItemHisLp.class);
            for (SaleEbiddingItemHisLp itemHis2 : resultList) {
                String elsAccount = itemHis2.getElsAccount();
                itemHis2.setElsAccount(itemHis2.getToElsAccount());
                itemHis2.setToElsAccount(elsAccount);
            }
        } else {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (!EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
                queryWrapper.eq(SaleEbiddingItemHisLp::getItemNumber, (Object)head.getCurrentItemNumber());
            }
            queryWrapper.eq(SaleEbiddingItemHisLp::getHeadId, (Object)head.getId());
            queryWrapper.orderByDesc(SaleEbiddingItemHisLp::getQuoteTime);
            resultList = this.list((Wrapper)queryWrapper);
        }
        return resultList;
    }

    @Override
    public List<SaleEbiddingItemHisLp> queryQuoteDetail(SaleEbiddingHeadLp dbHead, String itemNumber) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHisLp::getHeadId, (Object)dbHead.getId())).eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), SaleEbiddingItemHisLp::getItemNumber, (Object)itemNumber)).orderByAsc(SaleEbiddingItemHisLp::getQuoteTime));
    }

    @Override
    public void save(SaleEbiddingHeadLp head, List<SaleEbiddingItemLp> quoteList, PurchaseEbiddingSupplierLp supplier) {
        LoginUser sysUser = SysUtil.getLoginUser();
        Executor executor = (Executor)SpringContextUtils.getBean((String)"asyncExecutor", Executor.class);
        executor.execute(() -> {
            List itemIdList = quoteList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            SaleEbiddingItemHisLp updateSale = new SaleEbiddingItemHisLp();
            updateSale.setLastQuote("0");
            ((SaleEbiddingItemHisLpMapper)this.baseMapper).update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().in(SaleEbiddingItemHisLp::getItemId, itemIdList));
            List purchaseItemIdList = quoteList.stream().map(SaleEbiddingItemLp::getRelationId).collect(Collectors.toList());
            PurchaseEbiddingItemHisLp updatePurchase = new PurchaseEbiddingItemHisLp();
            updatePurchase.setLastQuote("0");
            this.purchaseEbiddingItemHisMapper.update((Object)updatePurchase, (Wrapper)new LambdaQueryWrapper().in(PurchaseEbiddingItemHisLp::getItemId, purchaseItemIdList));
            for (SaleEbiddingItemLp quoteItem : quoteList) {
                SaleEbiddingItemHisLp his = new SaleEbiddingItemHisLp();
                BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)his));
                his.setId(null);
                his.setItemId(quoteItem.getId());
                his.setHeadId(head.getId());
                his.setLastQuote("1");
                his.setQuoteType(head.getQuoteType());
                his.setEbiddingWay(head.getEbiddingWay());
                his.setQuoteSubAccount(sysUser.getSubAccount());
                his.setQuoteUser(sysUser.getRealname());
                if (EbiddingWayEnum.PACKAGE.getValue().equals(head.getEbiddingWay())) {
                    List<SaleEbiddingItemLp> itemList = this.saleEbiddingItemService.selectByMainId(head.getId());
                    String materialNumber = itemList.stream().map(SaleEbiddingItemLp::getMaterialNumber).distinct().collect(Collectors.joining(","));
                    his.setMaterialNumber(materialNumber);
                    his.setMaterialDesc(EbiddingWayEnum.PACKAGE.getDesc());
                }
                ((SaleEbiddingItemHisLpMapper)this.baseMapper).insert((Object)his);
                PurchaseEbiddingItemHisLp purchaseHis = new PurchaseEbiddingItemHisLp();
                BeanUtils.copyProperties((Object)((Object)his), (Object)((Object)purchaseHis));
                purchaseHis.setId(null);
                purchaseHis.setRelationId(his.getId());
                purchaseHis.setHeadId(head.getRelationId());
                purchaseHis.setItemId(quoteItem.getRelationId());
                purchaseHis.setElsAccount(head.getToElsAccount());
                purchaseHis.setToElsAccount(head.getElsAccount());
                purchaseHis.setSupplierName(supplier.getSupplierName());
                this.purchaseEbiddingItemHisMapper.insert((Object)purchaseHis);
            }
        });
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void save(Map<String, SaleEbiddingHeadLp> headMap, List<SaleEbiddingItemLp> quoteList, Map<String, PurchaseEbiddingSupplierLp> supplierMap) {
        LoginUser sysUser = SysUtil.getLoginUser();
        List itemIdList = quoteList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        SaleEbiddingItemHisLp updateSale = new SaleEbiddingItemHisLp();
        updateSale.setLastQuote("0");
        ((SaleEbiddingItemHisLpMapper)this.baseMapper).update((Object)updateSale, (Wrapper)new LambdaQueryWrapper().in(SaleEbiddingItemHisLp::getItemId, itemIdList));
        List purchaseItemIdList = quoteList.stream().map(SaleEbiddingItemLp::getRelationId).collect(Collectors.toList());
        PurchaseEbiddingItemHisLp updatePurchase = new PurchaseEbiddingItemHisLp();
        updatePurchase.setLastQuote("0");
        this.purchaseEbiddingItemHisMapper.update((Object)updatePurchase, (Wrapper)new LambdaQueryWrapper().in(PurchaseEbiddingItemHisLp::getItemId, purchaseItemIdList));
        ArrayList<SaleEbiddingItemHisLp> saleHisList = new ArrayList<SaleEbiddingItemHisLp>();
        ArrayList purchaseHisList = new ArrayList();
        for (SaleEbiddingItemLp quoteItem : quoteList) {
            SaleEbiddingHeadLp head = headMap.get(quoteItem.getHeadId());
            PurchaseEbiddingSupplierLp supplier = supplierMap.get(quoteItem.getHeadId());
            SaleEbiddingItemHisLp his = new SaleEbiddingItemHisLp();
            BeanUtils.copyProperties((Object)((Object)quoteItem), (Object)((Object)his));
            his.setId(null);
            his.setItemId(quoteItem.getId());
            his.setHeadId(head.getId());
            his.setLastQuote("1");
            his.setQuoteType(head.getQuoteType());
            his.setEbiddingWay(head.getEbiddingWay());
            his.setQuoteSubAccount(sysUser.getSubAccount());
            his.setQuoteUser(sysUser.getRealname());
            saleHisList.add(his);
        }
        this.saveBatch(saleHisList);
        saleHisList.forEach(saleHis -> {
            SaleEbiddingHeadLp head = (SaleEbiddingHeadLp)((Object)((Object)headMap.get(saleHis.getHeadId())));
            PurchaseEbiddingSupplierLp supplier = (PurchaseEbiddingSupplierLp)((Object)((Object)supplierMap.get(head.getRelationId())));
            PurchaseEbiddingItemHisLp purchaseHis = new PurchaseEbiddingItemHisLp();
            BeanUtils.copyProperties((Object)saleHis, (Object)((Object)purchaseHis));
            purchaseHis.setId(null);
            purchaseHis.setRelationId(saleHis.getId());
            purchaseHis.setHeadId(head.getRelationId());
            purchaseHis.setItemId(saleHis.getRelationId());
            purchaseHis.setElsAccount(head.getToElsAccount());
            purchaseHis.setToElsAccount(head.getElsAccount());
            purchaseHis.setSupplierName(supplier.getSupplierName());
            purchaseHisList.add(purchaseHis);
        });
        PurchaseEbiddingItemHisLpService purchaseEbiddingItemHisService = (PurchaseEbiddingItemHisLpService)SpringContextUtils.getBean(PurchaseEbiddingItemHisLpService.class);
        purchaseEbiddingItemHisService.saveBatch(purchaseHisList);
    }

    @Override
    public void quoteAccept(SaleEbiddingItemHisLp dbItemHis) {
        dbItemHis.setAccept("1");
        this.updateById((Object)dbItemHis);
        PurchaseEbiddingItemHisLp purchaseHis = new PurchaseEbiddingItemHisLp();
        purchaseHis.setId(dbItemHis.getRelationId());
        purchaseHis.setAccept("1");
        purchaseHis.setBidNumber(dbItemHis.getBidNumber());
        this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
    }

    @Override
    public long quoteReject(SaleEbiddingItemHisLp dbItemHis) {
        dbItemHis.setAccept("0");
        this.updateById((Object)dbItemHis);
        PurchaseEbiddingItemHisLp purchaseHis = new PurchaseEbiddingItemHisLp();
        purchaseHis.setId(dbItemHis.getRelationId());
        purchaseHis.setAccept("0");
        this.purchaseEbiddingItemHisMapper.updateById((Object)purchaseHis);
        List dbList = ((SaleEbiddingItemHisLpMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHisLp::getItemId, (Object)dbItemHis.getItemId()));
        return dbList.stream().filter(his -> "0".equals(his.getAccept())).count();
    }

    @Override
    public List<SaleEbiddingItemHisLp> selectWithoutElsAccountNotAccept(String ebiddingNumber) {
        return this.saleEbiddingItemHisMapper.selectWithoutElsAccountNotAccept(ebiddingNumber);
    }

    @Override
    public List<SaleEbiddingItemHisLp> selectWithoutElsAccountByHeadIdNotAccept(List<String> saleHeadIdList) {
        return this.saleEbiddingItemHisMapper.selectWithoutElsAccountByHeadIdNotAccept(saleHeadIdList);
    }

    @Override
    public List<SaleEbiddingItemHisLp> queryAcceptDetail(SaleEbiddingHeadLp dbHead) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SaleEbiddingItemHisLp::getHeadId, (Object)dbHead.getId())).eq(EbiddingWayEnum.SINGLE.getValue().equals(dbHead.getEbiddingWay()), SaleEbiddingItemHisLp::getAccept, (Object)"1")).orderByAsc(SaleEbiddingItemHisLp::getQuoteTime));
    }

    @Override
    public void updateBidResultByNumber(List<SaleEbiddingItemHisLp> saleItemList) {
        this.saleEbiddingItemHisMapper.updateBidResultByNumber(saleItemList);
    }
}

