/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.calibration.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.attachment.vo.TenderFieldCategoryPriceVo;
import com.els.modules.tender.calibration.entity.BidWinningAffirmHead;
import com.els.modules.tender.calibration.entity.BidWinningAffirmItem;
import com.els.modules.tender.calibration.enumerate.BidWinningAffirmHeadStatusEnum;
import com.els.modules.tender.calibration.service.BidWinningAffirmHeadService;
import com.els.modules.tender.calibration.vo.BidWinningAffirmHeadVO;
import com.els.modules.tender.calibration.vo.BidWinningAffirmPriceItemVo;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.common.aspect.ValidatedTenderStatus;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/calibration/purchaseTenderProjectBidWinningAffirmHead"})
@Api(tags={"\u4e2d\u6807\u4eba\u786e\u8ba4\u8868\u5934"})
public class BidWinningAffirmHeadController
extends BaseController<BidWinningAffirmHead, BidWinningAffirmHeadService> {
    private static final Logger log = LoggerFactory.getLogger(BidWinningAffirmHeadController.class);
    @Autowired
    private BidWinningAffirmHeadService bidWinningAffirmHeadService;
    @Autowired
    private PurchaseTenderProjectHeadService projectHeadService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    public Result<?> queryPageList(BidWinningAffirmHead purchaseTenderProjectBidWinningAffirmHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseTenderProjectBidWinningAffirmHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.bidWinningAffirmHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(busModule="\u4e2d\u6807\u4eba\u786e\u8ba4\u8868\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tender#tenderProject:edit"})
    @SrmValidated
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> add(@RequestBody BidWinningAffirmHeadVO bidWinningAffirmHeadVo) {
        BidWinningAffirmHead bidWinningAffirmHead = new BidWinningAffirmHead();
        BeanUtils.copyProperties((Object)((Object)bidWinningAffirmHeadVo), (Object)((Object)bidWinningAffirmHead));
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmPriceItemVoList = bidWinningAffirmHeadVo.getBidWinningAffirmPriceItemVoList();
        ArrayList bidWinningAffirmItemList = SysUtil.copyProperties(bidWinningAffirmPriceItemVoList, BidWinningAffirmItem.class);
        this.bidWinningAffirmHeadService.saveMain(bidWinningAffirmHead, bidWinningAffirmItemList, bidWinningAffirmHeadVo.getWinningAffirmMaterialList(), bidWinningAffirmHeadVo.getAttachmentList());
        return Result.ok((Object)((Object)this.bidWinningAffirmHeadService.queryBidWinningConfirmInfo(bidWinningAffirmHead, bidWinningAffirmHead.getAffirmType())));
    }

    @AutoLog(busModule="\u4e2d\u6807\u4eba\u786e\u8ba4\u8868\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> edit(@RequestBody BidWinningAffirmHeadVO bidWinningAffirmHeadVo) {
        BidWinningAffirmHead bidWinningAffirmHead = new BidWinningAffirmHead();
        BeanUtils.copyProperties((Object)((Object)bidWinningAffirmHeadVo), (Object)((Object)bidWinningAffirmHead));
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmPriceItemVoList = bidWinningAffirmHeadVo.getBidWinningAffirmPriceItemVoList();
        ArrayList bidWinningAffirmItemList = SysUtil.copyProperties(bidWinningAffirmPriceItemVoList, BidWinningAffirmItem.class);
        this.bidWinningAffirmHeadService.updateMain(bidWinningAffirmHead, bidWinningAffirmItemList, bidWinningAffirmHeadVo.getWinningAffirmMaterialList(), bidWinningAffirmHeadVo.getAttachmentList());
        return Result.ok((Object)((Object)this.bidWinningAffirmHeadService.queryBidWinningConfirmInfo(bidWinningAffirmHead, bidWinningAffirmHead.getAffirmType())));
    }

    @AutoLog(busModule="\u63d0\u4ea4\u53d1\u5e03", value="\u63d0\u4ea4\u53d1\u5e03")
    @ApiOperation(value="\u63d0\u4ea4\u53d1\u5e03", notes="\u63d0\u4ea4\u53d1\u5e03")
    @PostMapping(value={"/submit"})
    @RequiresPermissions(value={"tender#tenderProject:publish"})
    @SrmValidated
    @ValidatedTenderStatus(value={TenderProjectSubpackageStatusEnum.BIDDING_HAS_ENDED})
    public Result<?> submit(@RequestBody BidWinningAffirmHeadVO winningAffirmHeadVO) {
        BidWinningAffirmHead bidWinningAffirmHead = new BidWinningAffirmHead();
        BeanUtils.copyProperties((Object)((Object)winningAffirmHeadVO), (Object)((Object)bidWinningAffirmHead));
        bidWinningAffirmHead.setAudit("1");
        List<BidWinningAffirmPriceItemVo> bidWinningAffirmPriceItemVoList = winningAffirmHeadVO.getBidWinningAffirmPriceItemVoList();
        ArrayList bidWinningAffirmItemList = SysUtil.copyProperties(bidWinningAffirmPriceItemVoList, BidWinningAffirmItem.class);
        Assert.isTrue((StringUtils.isBlank((CharSequence)bidWinningAffirmHead.getStatus()) || BidWinningAffirmHeadStatusEnum.NEW.getValue().equals(bidWinningAffirmHead.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APtFIhxWxiTVBhxW_dc989d26", (String)"\u5f53\u524d\u5355\u636e\u5df2\u53d1\u5e03\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u53d1\u5e03!"));
        this.bidWinningAffirmHeadService.saveOrUpdate(bidWinningAffirmHead, bidWinningAffirmItemList, winningAffirmHeadVO.getWinningAffirmMaterialList(), winningAffirmHeadVO.getAttachmentList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        BidWinningAffirmHead bidWinningAffirmHead = (BidWinningAffirmHead)((Object)this.bidWinningAffirmHeadService.getById((Serializable)((Object)id)));
        Assert.isTrue((bidWinningAffirmHead != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tHxMK_c2373c29", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        PurchaseTenderProjectInfoVO purchaseTenderProjectInfoVO = this.projectHeadService.queryProjectInfoBySubpackageId(bidWinningAffirmHead.getSubpackageId());
        String elsAccount = TenantContext.getTenant();
        Assert.isTrue((elsAccount.equals(purchaseTenderProjectInfoVO.getPurchaseExecutorAccount()) || elsAccount.equals(purchaseTenderProjectInfoVO.getPurchaseEnterpriseAccount()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_tHxMK_c2373c29", (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01"));
        BidWinningAffirmHeadVO headVO = this.bidWinningAffirmHeadService.queryBidWinningConfirmInfo(bidWinningAffirmHead, bidWinningAffirmHead.getAffirmType());
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u83b7\u53d6\u91cd\u65b0\u786e\u8ba4\u4e2d\u6807\u5217\u8868", notes="\u83b7\u53d6\u91cd\u65b0\u4e2d\u6807\u5217\u8868")
    @GetMapping(value={"/queryBidWinningListBySubpackageAndAffirmType"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryBidWinningListBySubpackageAndAffirmType(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="affirmType", defaultValue="1") String affirmType) {
        List<BidWinningAffirmHead> bidWinningAffirmHeadList = this.bidWinningAffirmHeadService.queryBidWinningBySubpackageAndAffirmType(subpackageId, affirmType);
        return Result.ok(bidWinningAffirmHeadList);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2d\u6807\u786e\u8ba4\u8be6\u60c5", notes="\u83b7\u53d6\u4e2d\u6807\u786e\u8ba4\u8be6\u60c5")
    @GetMapping(value={"/queryBidWinningConfirmInfoBySubpackage"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryBidWinningConfirmInfoBySubpackage(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="affirmType", defaultValue="0") String affirmType) {
        List<BidWinningAffirmHead> bidWinningAffirmHeadList = this.bidWinningAffirmHeadService.queryBidWinningBySubpackageAndAffirmType(subpackageId, affirmType);
        BidWinningAffirmHead bidWinningAffirmHead = new BidWinningAffirmHead();
        bidWinningAffirmHead.setSubpackageId(subpackageId);
        bidWinningAffirmHead.setAffirmType(affirmType);
        if (CollectionUtil.isNotEmpty(bidWinningAffirmHeadList)) {
            bidWinningAffirmHead = bidWinningAffirmHeadList.get(0);
        }
        BidWinningAffirmHeadVO headVO = this.bidWinningAffirmHeadService.queryBidWinningConfirmInfo(bidWinningAffirmHead, affirmType);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e2d\u6807\u786e\u8ba4\u521d\u59cb\u4fe1\u606f", notes="\u83b7\u53d6\u4e2d\u6807\u786e\u8ba4\u521d\u59cb\u4fe1\u606f")
    @GetMapping(value={"/queryBidWinningConfirmInitInfoBySubpackage"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryBidWinningConfirmInitInfoBySubpackage(@RequestParam(name="subpackageId") String subpackageId, @RequestParam(name="affirmType", defaultValue="0") String affirmType) {
        BidWinningAffirmHead bidWinningAffirmHead = new BidWinningAffirmHead();
        bidWinningAffirmHead.setSubpackageId(subpackageId);
        bidWinningAffirmHead.setAffirmType(affirmType);
        BidWinningAffirmHeadVO headVO = this.bidWinningAffirmHeadService.queryBidWinningConfirmInitInfoBySubpackageId(bidWinningAffirmHead, affirmType);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u83b7\u53d6\u6295\u6807\u51fd\u4e0b\u6240\u6709\u7684\u62a5\u4ef7\u5217", notes="\u83b7\u53d6\u6295\u6807\u51fd\u4e0b\u6240\u6709\u7684\u62a5\u4ef7\u5217")
    @GetMapping(value={"/queryFieldCategoryBySubpackageId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.PURCHASE_EXECUTOR, TenderRoleEnum.BIDING_USER})
    public Result<?> queryFieldCategoryBySubpackageId(@RequestParam(name="subpackageId") String subpackageId) {
        List<TenderFieldCategoryPriceVo> quoteColumnMaps = this.bidWinningAffirmHeadService.queryFieldCategoryBySubpackageId(subpackageId);
        return Result.ok(quoteColumnMaps);
    }
}

