/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.tender.clarification.entity.PurchaseTenderEvaClarificationRecord;
import com.els.modules.tender.clarification.entity.SaleTenderEvaClarificationHead;
import com.els.modules.tender.clarification.entity.SaleTenderEvaClarificationItem;
import com.els.modules.tender.clarification.enumerate.SaleTenderEvaClarificationItemStatusEnum;
import com.els.modules.tender.clarification.service.PurchaseTenderEvaClarificationRecordService;
import com.els.modules.tender.clarification.service.SaleTenderEvaClarificationHeadService;
import com.els.modules.tender.clarification.service.SaleTenderEvaClarificationItemService;
import com.els.modules.tender.clarification.vo.SaleTenderEvaClarificationHeadVO;
import com.els.modules.tender.clarification.vo.SaleTenderEvaClarificationItemVO;
import com.els.modules.tender.common.aspect.TenderPermissions;
import com.els.modules.tender.project.enumerate.TenderRoleEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tender/clarification/saleTenderEvaClarificationHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u8bc4\u6807\u6f84\u6e05\u5934"})
public class SaleTenderEvaClarificationHeadController
extends BaseController<SaleTenderEvaClarificationHead, SaleTenderEvaClarificationHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleTenderEvaClarificationHeadController.class);
    @Autowired
    private SaleTenderEvaClarificationHeadService saleTenderEvaClarificationHeadService;
    @Autowired
    private SaleTenderEvaClarificationItemService saleTenderEvaClarificationItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseTenderEvaClarificationRecordService purchaseTenderEvaClarificationRecordService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tender#tenderProject:list"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryList(SaleTenderEvaClarificationHead saleTenderEvaClarificationHead, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleTenderEvaClarificationHead), (Map)req.getParameterMap());
        List list = this.saleTenderEvaClarificationHeadService.list((Wrapper)queryWrapper);
        list = list.stream().sorted(Comparator.comparing(SaleTenderEvaClarificationHead::getStatus).thenComparing(SaleTenderEvaClarificationHead::getFileClarificationEndTime).reversed()).collect(Collectors.toList());
        Page saleTenderEvaClarificationHeadIPage = new Page();
        saleTenderEvaClarificationHeadIPage.setRecords(list);
        saleTenderEvaClarificationHeadIPage.setTotal((long)list.size());
        return Result.ok((Object)saleTenderEvaClarificationHeadIPage);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleTenderEvaClarificationHead saleTenderEvaClarificationHead = (SaleTenderEvaClarificationHead)((Object)this.saleTenderEvaClarificationHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleTenderEvaClarificationHeadVO saleTenderEvaClarificationHeadVO = new SaleTenderEvaClarificationHeadVO();
        BeanUtils.copyProperties((Object)((Object)saleTenderEvaClarificationHead), (Object)((Object)saleTenderEvaClarificationHeadVO));
        List<SaleTenderEvaClarificationItem> saleTenderEvaClarificationItemList = this.saleTenderEvaClarificationItemService.selectByMainId(id);
        ArrayList saleTenderEvaClarificationItemVOS = SysUtil.copyProperties(saleTenderEvaClarificationItemList, SaleTenderEvaClarificationItemVO.class);
        if (CollectionUtil.isNotEmpty((Collection)saleTenderEvaClarificationItemVOS)) {
            SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItem = (SaleTenderEvaClarificationItemVO)((Object)saleTenderEvaClarificationItemVOS.get(0));
            List itemAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(saleTenderEvaClarificationItem.getId());
            saleTenderEvaClarificationItem.setAttachmentList(itemAttachmentDTOS);
        }
        saleTenderEvaClarificationHeadVO.setPurchaseTenderEvaClarificationItemList(saleTenderEvaClarificationItemVOS);
        List saleAttachmentDTOS = this.invokeBaseRpcService.selectSaleAttachmentByMainId(saleTenderEvaClarificationHeadVO.getId());
        saleTenderEvaClarificationHeadVO.setAttachmentList(saleAttachmentDTOS);
        saleTenderEvaClarificationHeadVO.setBusAccount(saleTenderEvaClarificationHead.getPurchaseEnterpriseAccount());
        return Result.ok((Object)((Object)saleTenderEvaClarificationHeadVO));
    }

    @ApiOperation(value="\u56de\u590d\u6dfb\u52a0", notes="\u56de\u590d\u6dfb\u52a0")
    @PostMapping(value={"/replyAdd"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> replyAdd(@RequestBody SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = this.saleTenderEvaClarificationHeadService.replyAdd(saleTenderEvaClarificationItemVO);
        return Result.ok((Object)((Object)saleTenderEvaClarificationItem));
    }

    @ApiOperation(value="\u56de\u590d\u4fee\u6539", notes="\u56de\u590d\u4fee\u6539")
    @PostMapping(value={"/replyEdit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> replyEdit(@RequestBody SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        saleTenderEvaClarificationItemVO.setStatus(SaleTenderEvaClarificationItemStatusEnum.NEW.getValue());
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem = this.saleTenderEvaClarificationHeadService.replyEdit(saleTenderEvaClarificationItemVO);
        return Result.ok((Object)((Object)saleTenderEvaClarificationItem));
    }

    @ApiOperation(value="\u56de\u590d\u63d0\u4ea4", notes="\u56de\u590d\u63d0\u4ea4")
    @PostMapping(value={"/replySubmit"})
    @RequiresPermissions(value={"tender#biddingHall:operational"})
    @SrmValidated
    public Result<?> replySubmit(@RequestBody SaleTenderEvaClarificationItemVO saleTenderEvaClarificationItemVO) {
        SaleTenderEvaClarificationItem saleTenderEvaClarificationItem;
        if (StringUtils.isBlank((CharSequence)saleTenderEvaClarificationItemVO.getId())) {
            saleTenderEvaClarificationItem = this.saleTenderEvaClarificationHeadService.replyAdd(saleTenderEvaClarificationItemVO);
            saleTenderEvaClarificationItemVO.setId(saleTenderEvaClarificationItem.getId());
        } else {
            saleTenderEvaClarificationItemVO.setStatus(SaleTenderEvaClarificationItemStatusEnum.NEW.getValue());
            this.saleTenderEvaClarificationHeadService.replyEdit(saleTenderEvaClarificationItemVO);
        }
        saleTenderEvaClarificationItem = this.saleTenderEvaClarificationHeadService.replySubmit(saleTenderEvaClarificationItemVO);
        return Result.ok((Object)((Object)saleTenderEvaClarificationItem));
    }

    @ApiOperation(value="\u53d8\u66f4\u5217\u8868", notes="\u53d8\u66f4\u5217\u8868")
    @GetMapping(value={"/queryRecordByEvaClarificationId"})
    @RequiresPermissions(value={"tender#tenderProject:queryById"})
    @TenderPermissions(value={TenderRoleEnum.BIDING_ORG})
    public Result<?> queryList(@RequestParam(name="evaClarificationId") String evaClarificationId) {
        List<PurchaseTenderEvaClarificationRecord> purchaseTenderEvaClarificationRecords = this.purchaseTenderEvaClarificationRecordService.selectByMainId(evaClarificationId);
        return Result.ok(purchaseTenderEvaClarificationRecords);
    }
}

